/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexSlot;
import org.apache.calcite.sql.fun.SqlCountAggFunction;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.NativeQueryRealization;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.fileseg.FileSegments;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableMap;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.cube.cuboid.NLookupCandidate;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.realization.HybridRealization;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.query.relnode.OlapAggregateRel;
import org.apache.kylin.query.relnode.OlapContext;
import org.apache.kylin.query.relnode.OlapFilterRel;
import org.apache.kylin.query.relnode.OlapJoinRel;
import org.apache.kylin.query.relnode.OlapNonEquiJoinRel;
import org.apache.kylin.query.relnode.OlapProjectRel;
import org.apache.kylin.query.relnode.OlapRel;
import org.apache.kylin.query.relnode.OlapTableScan;
import org.apache.kylin.query.relnode.OlapValuesRel;
import org.apache.kylin.query.relnode.OlapWindowRel;
import org.apache.kylin.query.util.RexUtils;
import org.apache.kylin.util.CalciteSystemProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextUtil {
    static final ThreadLocal<OlapRel> _inputRel = new ThreadLocal();
    static final ThreadLocal<RelDataType> _resultType = new ThreadLocal();
    static final ThreadLocal<Map<String, String>> _localParameters = new ThreadLocal();
    static final ThreadLocal<Map<Integer, OlapContext>> _localContexts = new ThreadLocal();
    static final Map<NLookupCandidate.Policy, String> TYPE_MAPPING = ImmutableMap.of((Object)NLookupCandidate.Policy.SNAPSHOT, (Object)"Table Snapshot", (Object)NLookupCandidate.Policy.INTERNAL_TABLE, (Object)"Internal Table");
    private static final Logger log = LoggerFactory.getLogger(ContextUtil.class);

    private ContextUtil() {
    }

    public static void setOlapRel(OlapRel olapRel) {
        _inputRel.set(olapRel);
    }

    public static void setRowType(RelDataType relDataType) {
        _resultType.set(relDataType);
    }

    public static void clean() {
        _inputRel.remove();
        _resultType.remove();
    }

    public static void amendAllColsIfNoAgg(RelNode rel) {
        if (rel == null || ((OlapRel)rel).getContext() == null || rel instanceof OlapTableScan) {
            return;
        }
        OlapContext context = ((OlapRel)rel).getContext();
        if (rel instanceof OlapProjectRel && !((OlapProjectRel)rel).isMerelyPermutation()) {
            ((OlapRel)rel).getColumnRowType().getSourceColumns().stream().flatMap(Collection::stream).filter(context::isOriginAndBelongToCtxTables).forEach(context.getAllColumns()::add);
        } else if (rel instanceof OlapValuesRel) {
            ((OlapRel)rel).getColumnRowType().getAllColumns().stream().filter(context::isOriginAndBelongToCtxTables).forEach(context.getAllColumns()::add);
        } else if (rel instanceof OlapWindowRel) {
            OlapWindowRel olapWindowRel = (OlapWindowRel)rel;
            olapWindowRel.getGroupingColumns().stream().filter(context::isOriginAndBelongToCtxTables).forEach(context.getAllColumns()::add);
            if (!olapWindowRel.isExistParentProjectNeedPushInfo()) {
                ContextUtil.amendAllColsIfNoAgg(olapWindowRel.getInput());
            }
        } else if (rel instanceof OlapJoinRel) {
            ContextUtil.amendAllColsIfNoAgg(rel.getInput(0));
            ContextUtil.amendAllColsIfNoAgg(rel.getInput(1));
        } else {
            ContextUtil.amendAllColsIfNoAgg(rel.getInput(0));
        }
    }

    public static Set<OlapContext> collectSubContext(RelNode subRel) {
        HashSet subContexts = Sets.newHashSet();
        if (subRel == null) {
            return subContexts;
        }
        subContexts.addAll(((OlapRel)subRel).getSubContexts());
        if (((OlapRel)subRel).getContext() != null) {
            subContexts.add(((OlapRel)subRel).getContext());
        }
        return subContexts;
    }

    public static void setSubContexts(RelNode relNode) {
        HashSet subContexts = Sets.newHashSet();
        if (relNode == null) {
            return;
        }
        for (RelNode inputNode : relNode.getInputs()) {
            ContextUtil.setSubContexts(inputNode);
            subContexts.addAll(ContextUtil.collectSubContext(inputNode));
        }
        ((OlapRel)relNode).setSubContexts(subContexts);
    }

    public static void setParameters(Map<String, String> parameters) {
        _localParameters.set(parameters);
    }

    public static void clearParameter() {
        _localParameters.remove();
    }

    public static void registerContext(OlapContext ctx) {
        if (_localContexts.get() == null) {
            HashMap contextMap = new HashMap();
            _localContexts.set(contextMap);
        }
        _localContexts.get().put(ctx.getId(), ctx);
    }

    public static Collection<OlapContext> getThreadLocalContexts() {
        Map<Integer, OlapContext> map = _localContexts.get();
        return map == null ? Collections.emptyList() : map.values();
    }

    public static List<OlapContext> listContexts() {
        return Lists.newArrayList(ContextUtil.getThreadLocalContexts());
    }

    public static OlapContext getThreadLocalContextById(int id) {
        Map<Integer, OlapContext> map = _localContexts.get();
        return map.get(id);
    }

    public static void clearThreadLocalContexts() {
        _localContexts.remove();
    }

    public static void clearThreadLocalContextById(int id) {
        Map<Integer, OlapContext> map = _localContexts.get();
        map.remove(id);
        _localContexts.set(map);
    }

    public static List<NativeQueryRealization> getNativeRealizations() {
        ArrayList realizations = Lists.newArrayList();
        Collection<OlapContext> threadLocalContexts = ContextUtil.getThreadLocalContexts();
        for (OlapContext ctx : threadLocalContexts) {
            HashMap<String, NLookupCandidate.Policy> lookupTables = new HashMap<String, NLookupCandidate.Policy>();
            String realizationType = ContextUtil.detectType(ctx, lookupTables);
            IRealization realization = ctx.getRealization();
            if (realization != null) {
                String modelId = realization.getModel().getUuid();
                String modelAlias = realization.getModel().getFusionModelAlias();
                if (!ctx.getStorageContext().getStreamCandidate().isEmpty()) {
                    realizations.add(ContextUtil.streamRlz(ctx, realizationType, modelId, modelAlias, lookupTables));
                    if (realization instanceof HybridRealization) {
                        HybridRealization batchRealization = (HybridRealization)realization;
                        String batchModelId = batchRealization.getBatchRealization().getUuid();
                        realizations.add(ContextUtil.batchRlz(ctx, realizationType, batchModelId, modelAlias, lookupTables));
                    }
                } else {
                    realizations.add(ContextUtil.batchRlz(ctx, realizationType, modelId, modelAlias, lookupTables));
                }
            }
            if (lookupTables.isEmpty()) continue;
            lookupTables.forEach((lookup, type) -> {
                String lookupRealizationType = TYPE_MAPPING.get(type);
                NativeQueryRealization lookupRealization = new NativeQueryRealization(lookup, lookupRealizationType);
                lookupRealization.setLookupTables((List)Lists.newArrayList((Object[])new String[]{lookup}));
                realizations.add(lookupRealization);
            });
        }
        return realizations;
    }

    private static String detectType(OlapContext ctx, Map<String, NLookupCandidate.Policy> lookupMap) {
        String realizationType;
        if (ctx.getStorageContext().isDataSkipped()) {
            realizationType = ctx.getStorageContext().isFilterCondAlwaysFalse() ? "Filter Conflict" : null;
        } else if (ctx.getStorageContext().getLookupCandidate() != null) {
            realizationType = "Table Snapshot";
            lookupMap.put(ctx.getFirstTableIdentity(), ctx.getStorageContext().getLookupCandidate().getPolicy());
        } else {
            realizationType = ctx.getStorageContext().getBatchCandidate().isTableIndex() ? "Table Index" : "Agg Index";
        }
        return realizationType;
    }

    private static NativeQueryRealization streamRlz(OlapContext ctx, String realizationType, String modelId, String modelAlias, Map<String, NLookupCandidate.Policy> lookupTables) {
        NativeQueryRealization streamingRealization = new NativeQueryRealization(modelId, modelAlias, Long.valueOf(ctx.getStorageContext().getStreamCandidate().getLayoutId()), realizationType, ctx.getStorageContext().isPartialMatch());
        streamingRealization.setStreamingLayout(true);
        log.debug(lookupTables.toString());
        return streamingRealization;
    }

    private static NativeQueryRealization batchRlz(OlapContext ctx, String realizationType, String modelId, String modelAlias, Map<String, NLookupCandidate.Policy> lookupTables) {
        NativeQueryRealization realization = new NativeQueryRealization(modelId, modelAlias, Long.valueOf(ctx.getStorageContext().getBatchCandidate().getLayoutId()), realizationType, ctx.getStorageContext().isPartialMatch());
        if (ctx.getRealization() instanceof NDataflow) {
            NDataflow df = (NDataflow)ctx.getRealization();
            realization.setStorageType(df.getStorageType());
            NLookupCandidate.Policy policy = NLookupCandidate.getDerivedPolicy((KylinConfig)df.getConfig());
            for (String derivedLookup : ctx.getStorageContext().getBatchCandidate().getDerivedLookups()) {
                lookupTables.put(derivedLookup, policy);
            }
            if (df.getModel().isFilePartitioned()) {
                boolean isLoadingData = df.getSegments().stream().anyMatch(seg -> seg.getStatus() == SegmentStatusEnum.NEW);
                realization.setLoadingData(isLoadingData);
                realization.setBuildingIndex(FileSegments.guessIsBuildingIndex((NDataflow)df));
                realization.setLastDataRefreshTime(df.getLastDataRefreshTime());
            }
        }
        return realization;
    }

    public static RexInputRef createUniqueInputRefAmongTables(OlapTableScan table, int columnIdx, Collection<OlapTableScan> tables) {
        ArrayList<OlapTableScan> sorted = new ArrayList<OlapTableScan>(tables);
        sorted.sort(Comparator.comparingInt(AbstractRelNode::getId));
        int offset = 0;
        for (TableScan tableScan : sorted) {
            if (tableScan == table) {
                return new RexInputRef(table.getTableName() + "." + ((RelDataTypeField)table.getRowType().getFieldList().get(columnIdx)).getName(), offset + columnIdx, ((RelDataTypeField)table.getRowType().getFieldList().get(columnIdx)).getType());
            }
            offset += tableScan.getRowType().getFieldCount();
        }
        return null;
    }

    public static List<OlapContext> listContextsHavingScan() {
        ArrayList result = Lists.newArrayList();
        for (OlapContext ctx : ContextUtil.getThreadLocalContexts()) {
            if (ctx.getFirstTableScan() == null) continue;
            result.add(ctx);
        }
        return result;
    }

    public static boolean qualifiedForAggInfoPushDown(RelNode currentRel, OlapContext subContext) {
        return (subContext.getParentOfTopNode() instanceof OlapJoinRel || subContext.getParentOfTopNode() instanceof OlapNonEquiJoinRel) && !(subContext.getTopNode() instanceof OlapAggregateRel) && ContextUtil.areSubJoinRelsSameType(currentRel, subContext, null, null) && ContextUtil.derivedFromSameContext(new HashSet<Integer>(), currentRel, subContext, false);
    }

    public static void dumpCalcitePlan(String msg, RelNode relNode, Logger logger) {
        if (Boolean.TRUE.equals(CalciteSystemProperty.DEBUG.value()) && logger.isDebugEnabled()) {
            logger.debug("{} :{}{}", new Object[]{msg, System.lineSeparator(), RelOptUtil.toString((RelNode)relNode)});
        }
        if (QueryContext.current().isDryRun() && msg.contains("FIRST ROUND")) {
            QueryContext.current().setLastUsedRelNode(RelOptUtil.toString((RelNode)relNode));
        }
    }

    private static boolean derivedFromSameContext(Collection<Integer> indexOfInputCols, RelNode currentNode, OlapContext subContext, boolean hasCountConstant) {
        if (currentNode instanceof OlapAggregateRel) {
            hasCountConstant = ContextUtil.hasCountConstant((OlapAggregateRel)currentNode);
            Set<Integer> inputColsIndex = ContextUtil.collectAggInputIndex((OlapAggregateRel)currentNode);
            return ContextUtil.derivedFromSameContext(inputColsIndex, ((OlapAggregateRel)currentNode).getInput(), subContext, hasCountConstant);
        }
        if (currentNode instanceof OlapProjectRel) {
            Set rexLiterals = indexOfInputCols.stream().map(index -> ((OlapProjectRel)currentNode).getRewriteProjects().get((int)index)).filter(RexLiteral.class::isInstance).collect(Collectors.toSet());
            Set<Integer> indexOfInputRel = indexOfInputCols.stream().map(index -> ((OlapProjectRel)currentNode).getRewriteProjects().get((int)index)).flatMap(rex -> RexUtils.getAllInputRefs(rex).stream()).map(RexSlot::getIndex).collect(Collectors.toSet());
            if (!indexOfInputCols.isEmpty() && indexOfInputRel.isEmpty() && rexLiterals.isEmpty()) {
                throw new IllegalStateException("Error on collection index, index " + indexOfInputCols + " child index " + indexOfInputRel);
            }
            return ContextUtil.derivedFromSameContext(indexOfInputRel, ((OlapProjectRel)currentNode).getInput(), subContext, hasCountConstant);
        }
        if (currentNode instanceof OlapJoinRel || currentNode instanceof OlapNonEquiJoinRel) {
            return ContextUtil.isJoinFromSameContext(indexOfInputCols, (Join)currentNode, subContext, hasCountConstant);
        }
        if (currentNode instanceof OlapFilterRel) {
            RexNode condition = ((OlapFilterRel)currentNode).getCondition();
            if (condition instanceof RexCall) {
                indexOfInputCols.addAll(ContextUtil.collectColsFromFilterRel((RexCall)condition));
            }
            return ContextUtil.derivedFromSameContext(indexOfInputCols, ((OlapFilterRel)currentNode).getInput(), subContext, hasCountConstant);
        }
        return false;
    }

    private static boolean hasCountConstant(OlapAggregateRel aggRel) {
        return aggRel.getAggregateCalls().stream().anyMatch(func -> !func.isDistinct() && func.getArgList().isEmpty() && func.getAggregation() instanceof SqlCountAggFunction);
    }

    private static Set<Integer> collectAggInputIndex(OlapAggregateRel aggRel) {
        HashSet inputColsIndex = Sets.newHashSet();
        for (AggregateCall aggregateCall : aggRel.getAggregateCalls()) {
            if (aggregateCall.getArgList() == null) continue;
            inputColsIndex.addAll(aggregateCall.getArgList());
        }
        inputColsIndex.addAll(aggRel.getRewriteGroupKeys());
        return inputColsIndex;
    }

    private static boolean isJoinFromSameContext(Collection<Integer> indexOfInputCols, Join joinRel, OlapContext subContext, boolean hasCountConstant) {
        int leftLength;
        if (joinRel.getJoinType() == JoinRelType.LEFT && hasCountConstant) {
            return false;
        }
        if (indexOfInputCols.isEmpty()) {
            return true;
        }
        int maxIndex = Collections.max(indexOfInputCols);
        if (maxIndex < (leftLength = joinRel.getLeft().getRowType().getFieldList().size())) {
            return ContextUtil.isLeftJoinFromSameContext(indexOfInputCols, joinRel, subContext, hasCountConstant);
        }
        int minIndex = Collections.min(indexOfInputCols);
        if (minIndex >= leftLength) {
            return ContextUtil.isRightJoinFromSameContext(indexOfInputCols, joinRel, subContext, hasCountConstant, leftLength);
        }
        return false;
    }

    private static boolean isLeftJoinFromSameContext(Collection<Integer> indexOfInputCols, Join joinRel, OlapContext subContext, boolean hasCountConstant) {
        OlapRel potentialSubRel = (OlapRel)joinRel.getLeft();
        if (subContext == potentialSubRel.getContext()) {
            return true;
        }
        if (potentialSubRel.getContext() != null) {
            return false;
        }
        if (potentialSubRel instanceof OlapProjectRel) {
            if (joinRel instanceof OlapJoinRel) {
                ((OlapJoinRel)joinRel).getLeftKeys().forEach(leftKey -> {
                    RexNode leftCol = ((OlapProjectRel)potentialSubRel).getProjects().get((int)leftKey);
                    if (leftCol instanceof RexCall) {
                        indexOfInputCols.add((Integer)leftKey);
                    }
                });
            } else {
                OlapNonEquiJoinRel nonEquivJoinRel = (OlapNonEquiJoinRel)joinRel;
                if (!nonEquivJoinRel.isScd2Rel()) {
                    return false;
                }
            }
        }
        return ContextUtil.derivedFromSameContext(indexOfInputCols, potentialSubRel, subContext, hasCountConstant);
    }

    private static boolean isRightJoinFromSameContext(Collection<Integer> indexOfInputCols, Join joinRel, OlapContext subContext, boolean hasCountConstant, int leftLength) {
        OlapRel potentialSubRel = (OlapRel)joinRel.getRight();
        if (subContext == potentialSubRel.getContext()) {
            return true;
        }
        if (potentialSubRel.getContext() != null) {
            return false;
        }
        HashSet indexOfInputRel = Sets.newHashSet();
        for (Integer indexOfInputCol : indexOfInputCols) {
            indexOfInputRel.add(indexOfInputCol - leftLength);
        }
        return ContextUtil.derivedFromSameContext(indexOfInputRel, potentialSubRel, subContext, hasCountConstant);
    }

    private static boolean areSubJoinRelsSameType(RelNode olapRel, OlapContext subContext, JoinRelType expectedJoinType, Class<?> joinCondClz) {
        OlapContext ctx = ((OlapRel)olapRel).getContext();
        if (ctx != null && ctx != subContext) {
            return false;
        }
        if (olapRel instanceof Join) {
            Join joinRel = (Join)olapRel;
            if (joinCondClz == null) {
                joinCondClz = joinRel.getCondition().getClass();
            }
            if (expectedJoinType == null) {
                expectedJoinType = joinRel.getJoinType();
            }
            if (joinRel.getJoinType() == expectedJoinType && joinRel.getCondition().getClass().equals(joinCondClz)) {
                if (joinRel.getJoinType() == JoinRelType.INNER) {
                    return olapRel == subContext.getParentOfTopNode() || ContextUtil.areSubJoinRelsSameType(joinRel.getLeft(), subContext, expectedJoinType, joinCondClz) || ContextUtil.areSubJoinRelsSameType(joinRel.getRight(), subContext, expectedJoinType, joinCondClz);
                }
                if (joinRel.getJoinType() == JoinRelType.LEFT) {
                    return ContextUtil.areSubJoinRelsSameType(joinRel.getLeft(), subContext, expectedJoinType, joinCondClz);
                }
            }
            return false;
        }
        return olapRel.getInputs().isEmpty() || ContextUtil.areSubJoinRelsSameType(olapRel.getInput(0), subContext, expectedJoinType, joinCondClz);
    }

    private static Set<Integer> collectColsFromFilterRel(RexCall filterCondition) {
        return RexUtils.getAllInputRefs((RexNode)filterCondition).stream().map(RexSlot::getIndex).collect(Collectors.toSet());
    }

    public static void updateSubContexts(Collection<TblColRef> colRefs, Set<OlapContext> subContexts) {
        colRefs.forEach(colRef -> {
            for (OlapContext context : subContexts) {
                if (colRef == null || !context.belongToContextTables((TblColRef)colRef)) continue;
                context.getAllColumns().add((TblColRef)colRef);
            }
        });
    }
}

