/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlAsOperator;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDynamicParam;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.fun.SqlCase;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.util.Litmus;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.StringHelper;
import org.apache.kylin.common.util.ThreadUtil;
import org.apache.kylin.guava30.shaded.common.base.Function;
import org.apache.kylin.guava30.shaded.common.cache.CacheBuilder;
import org.apache.kylin.guava30.shaded.common.cache.CacheLoader;
import org.apache.kylin.guava30.shaded.common.cache.LoadingCache;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableSet;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Ordering;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.model.ComputedColumnDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.alias.AliasDeduce;
import org.apache.kylin.metadata.model.alias.AliasMapping;
import org.apache.kylin.metadata.model.alias.ExpressionComparator;
import org.apache.kylin.metadata.model.tool.CalciteParser;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.query.IQueryTransformer;
import org.apache.kylin.query.util.AliasDeduceImpl;
import org.apache.kylin.query.util.ModelViewSqlNodeComparator;
import org.apache.kylin.query.util.QueryAliasMatchInfo;
import org.apache.kylin.query.util.QueryAliasMatcher;
import org.apache.kylin.query.util.QueryUtil;
import org.apache.kylin.query.util.SqlFunctionUtil;
import org.apache.kylin.query.util.SqlSubqueryFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertToComputedColumn
implements IQueryTransformer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConvertToComputedColumn.class);
    private static final String CONVERT_TO_CC_ERROR_MSG = "Something unexpected while ConvertToComputedColumn transforming the query, return original query.";
    private static final LoadingCache<String, String> transformExpressions = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, String>(){

        public String load(@Nonnull String cc) {
            return QueryUtil.adaptCalciteSyntax(cc);
        }
    });

    private static String transformExpr(String expression) {
        return (String)transformExpressions.get((Object)expression);
    }

    private static List<SqlNode> collectInputNodes(SqlSelect select) {
        LinkedList<SqlNode> inputNodes = new LinkedList<SqlNode>();
        inputNodes.addAll(ConvertToComputedColumn.collectCandidateInputNodes(select.getSelectList(), select.getGroup()));
        inputNodes.addAll(ConvertToComputedColumn.collectCandidateInputNodes(select.getOrderList(), select.getGroup()));
        if (select.getFrom() instanceof SqlJoin) {
            SqlJoin join = (SqlJoin)select.getFrom();
            ConvertToComputedColumn.collectJoinNodes(inputNodes, join);
        }
        inputNodes.addAll(ConvertToComputedColumn.collectCandidateInputNode(select.getHaving(), select.getGroup()));
        inputNodes.addAll(ConvertToComputedColumn.getInputTreeNodes(select.getWhere()));
        inputNodes.addAll(ConvertToComputedColumn.getInputTreeNodes((SqlNode)select.getGroup()));
        return inputNodes;
    }

    private static void collectJoinNodes(List<SqlNode> inputNodes, SqlJoin join) {
        SqlNode condition;
        if (join.getLeft() instanceof SqlJoin) {
            ConvertToComputedColumn.collectJoinNodes(inputNodes, (SqlJoin)join.getLeft());
        }
        if ((condition = join.getCondition()) != null && condition.isA(SqlKind.BINARY_COMPARISON)) {
            SqlBasicCall call = (SqlBasicCall)condition;
            call.getOperandList().stream().filter(node -> !ConvertToComputedColumn.isSimpleExpression(node)).forEach(inputNodes::add);
        }
        if (join.getRight() instanceof SqlJoin) {
            ConvertToComputedColumn.collectJoinNodes(inputNodes, (SqlJoin)join.getRight());
        }
    }

    private static List<SqlNode> collectInputNodes(SqlOrderBy sqlOrderBy) {
        LinkedList<SqlNode> inputNodes = new LinkedList<SqlNode>();
        if (sqlOrderBy.orderList != null && sqlOrderBy.query instanceof SqlSelect && ((SqlSelect)sqlOrderBy.query).getGroup() != null) {
            inputNodes.addAll(ConvertToComputedColumn.collectCandidateInputNodes(sqlOrderBy.orderList, ((SqlSelect)sqlOrderBy.query).getGroup()));
        } else if (sqlOrderBy.orderList != null) {
            inputNodes.addAll(ConvertToComputedColumn.getInputTreeNodes((SqlNode)sqlOrderBy.orderList));
        }
        return inputNodes;
    }

    private static List<SqlNode> collectCandidateInputNodes(SqlNodeList sqlNodeList, SqlNodeList groupSet) {
        LinkedList<SqlNode> inputNodes = new LinkedList<SqlNode>();
        if (sqlNodeList == null) {
            return inputNodes;
        }
        for (SqlNode sqlNode : sqlNodeList) {
            inputNodes.addAll(ConvertToComputedColumn.collectCandidateInputNode(sqlNode, groupSet));
        }
        return inputNodes;
    }

    private static List<SqlNode> collectCandidateInputNode(SqlNode node, SqlNodeList groupSet) {
        LinkedList<SqlNode> inputNodes = new LinkedList<SqlNode>();
        if (node == null) {
            return inputNodes;
        }
        if (node instanceof SqlCall && ((SqlCall)node).getOperator().kind == SqlKind.AS) {
            node = (SqlNode)((SqlCall)node).getOperandList().get(0);
        }
        for (SqlNode sqlNode : ConvertToComputedColumn.getSelectNodesToReplace(node, groupSet)) {
            if (ConvertToComputedColumn.isSimpleExpression(sqlNode)) continue;
            inputNodes.addAll(ConvertToComputedColumn.getInputTreeNodes(sqlNode));
        }
        return inputNodes;
    }

    static boolean isSimpleExpression(SqlNode sqlNode) {
        return sqlNode == null || sqlNode instanceof SqlLiteral || sqlNode instanceof SqlIdentifier;
    }

    private static List<SqlNode> getSelectNodesToReplace(SqlNode selectExp, SqlNodeList groupKeys) {
        for (SqlNode groupNode : groupKeys) {
            if (!selectExp.equalsDeep(groupNode, Litmus.IGNORE)) continue;
            return Collections.singletonList(selectExp);
        }
        if (selectExp instanceof SqlCall) {
            SqlCall call = SqlFunctionUtil.resolveCallIfNeed((SqlNode)selectExp);
            if (call.getOperator() instanceof SqlAggFunction) {
                return Collections.singletonList(selectExp);
            }
            return call.getOperandList().stream().filter(Objects::nonNull).map(node -> ConvertToComputedColumn.getSelectNodesToReplace(node, groupKeys)).flatMap(Collection::stream).collect(Collectors.toList());
        }
        if (selectExp instanceof SqlNodeList) {
            return ((SqlNodeList)selectExp).getList().stream().filter(Objects::nonNull).map(node -> ConvertToComputedColumn.getSelectNodesToReplace(node, groupKeys)).flatMap(Collection::stream).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static List<SqlNode> getInputTreeNodes(SqlNode sqlNode) {
        if (sqlNode == null) {
            return Collections.emptyList();
        }
        SqlTreeVisitor stv = new SqlTreeVisitor();
        sqlNode.accept((SqlVisitor)stv);
        return stv.getSqlNodes();
    }

    static List<ComputedColumnDesc> getCCListSortByLength(List<ComputedColumnDesc> computedColumns) {
        if (computedColumns == null || computedColumns.isEmpty()) {
            return Lists.newArrayList();
        }
        Ordering ordering = Ordering.from(Comparator.comparingInt(String::length)).reverse().nullsLast().onResultOf((Function)new Function<ComputedColumnDesc, String>(){

            @Nullable
            public String apply(@Nullable ComputedColumnDesc input) {
                return input == null ? null : input.getExpression();
            }
        });
        return ordering.immutableSortedCopy(computedColumns);
    }

    @Override
    public String transform(String originSql, String project, String defaultSchema) {
        try {
            return this.transformImpl(originSql, project, defaultSchema);
        }
        catch (Exception e) {
            log.warn("{}, critical stackTrace:\n{}", (Object)CONVERT_TO_CC_ERROR_MSG, (Object)ThreadUtil.getKylinStackTrace());
            return originSql;
        }
    }

    public String transformImpl(String originSql, String project, String defaultSchema) throws SqlParseException {
        List<NDataModel> models;
        KylinConfig projectConfig = NProjectManager.getProjectConfig((String)project);
        String sql = originSql;
        if (project != null && sql != null && projectConfig.isConvertExpressionToCcEnabled() && !(models = NDataflowManager.getInstance((KylinConfig)projectConfig, (String)project).listOnlineDataModels().stream().filter(m -> !m.getComputedColumnDescs().isEmpty()).collect(Collectors.toList())).isEmpty()) {
            QueryAliasMatcher queryAliasMatcher = new QueryAliasMatcher(project, defaultSchema);
            int maxRecursionTimes = projectConfig.getConvertCcMaxIterations();
            for (int i = 0; i < maxRecursionTimes; ++i) {
                Pair<String, Boolean> replacedSqlAndState = this.transformImplRecursive(sql, queryAliasMatcher, models);
                sql = (String)replacedSqlAndState.getFirst();
                if (Boolean.TRUE.equals(replacedSqlAndState.getSecond())) break;
            }
        }
        return sql;
    }

    private Pair<String, Boolean> transformImplRecursive(String sql, QueryAliasMatcher queryAliasMatcher, List<NDataModel> models) throws SqlParseException {
        boolean recursionCompleted = true;
        List<SqlCall> selectOrOrderbys = SqlSubqueryFinder.getSubqueries(sql);
        Pair<String, Integer> choiceOfSubQuery = null;
        for (int i = 0; i < selectOrOrderbys.size(); ++i) {
            if (choiceOfSubQuery != null) {
                selectOrOrderbys = SqlSubqueryFinder.getSubqueries(sql);
            }
            SqlCall selectOrOrderBy = selectOrOrderbys.get(i);
            ComputedColumnReplacer ccReplacer = new ComputedColumnReplacer(queryAliasMatcher, models, recursionCompleted, selectOrOrderBy);
            ccReplacer.replace(sql);
            recursionCompleted = ccReplacer.isRecursionCompleted();
            choiceOfSubQuery = ccReplacer.getChoiceForSubQuery();
            if (choiceOfSubQuery == null) continue;
            sql = (String)choiceOfSubQuery.getFirst();
        }
        return Pair.newPair((Object)sql, (Object)recursionCompleted);
    }

    Pair<String, Integer> replaceComputedColumns(String inputSql, List<SqlNode> toMatchExpressions, List<ComputedColumnDesc> computedColumns, QueryAliasMatchInfo queryAliasMatchInfo) {
        List<Pair<ComputedColumnDesc, Pair<Integer, Integer>>> toBeReplacedExp;
        if (CollectionUtils.isEmpty(computedColumns)) {
            return Pair.newPair((Object)inputSql, (Object)0);
        }
        String result = inputSql;
        try {
            toBeReplacedExp = this.matchCcPosition(inputSql, toMatchExpressions, computedColumns, queryAliasMatchInfo);
        }
        catch (Exception e) {
            log.debug("Convert to computedColumn Fail,parse sql fail ", (Throwable)e);
            return Pair.newPair((Object)inputSql, (Object)0);
        }
        for (Pair<ComputedColumnDesc, Pair<Integer, Integer>> toBeReplaced : toBeReplacedExp) {
            Pair startEndPos = (Pair)toBeReplaced.getSecond();
            int start = (Integer)startEndPos.getFirst();
            int end = (Integer)startEndPos.getSecond();
            ComputedColumnDesc cc = (ComputedColumnDesc)toBeReplaced.getFirst();
            String alias = queryAliasMatchInfo.isModelView() ? (String)queryAliasMatchInfo.getAliasMap().inverse().get((Object)queryAliasMatchInfo.getModel().getAlias()) : (String)queryAliasMatchInfo.getAliasMap().inverse().get((Object)cc.getTableAlias());
            if (alias == null) {
                throw new IllegalStateException(cc.getExpression() + " expression of cc " + cc.getFullName() + " is found in query but its table ref " + cc.getTableAlias() + " is missing in query");
            }
            log.debug("Computed column: {} matching {} at [{},{}] using alias in query: {}", new Object[]{cc.getColumnName(), inputSql.substring(start, end), start, end, alias});
            String aliasCcName = StringHelper.doubleQuote((String)alias) + "." + StringHelper.doubleQuote((String)cc.getColumnName());
            result = result.substring(0, start) + aliasCcName + result.substring(end);
        }
        try {
            SqlNode inputNodes = CalciteParser.parse((String)inputSql);
            int cntNodesBefore = ConvertToComputedColumn.getInputTreeNodes(inputNodes).size();
            SqlNode resultNodes = CalciteParser.parse((String)result);
            int cntNodesAfter = ConvertToComputedColumn.getInputTreeNodes(resultNodes).size();
            return Pair.newPair((Object)result, (Object)(cntNodesBefore - cntNodesAfter));
        }
        catch (SqlParseException e) {
            log.debug("Convert to computedColumn Fail, parse result sql fail: {}", (Object)result, (Object)e);
            return Pair.newPair((Object)inputSql, (Object)0);
        }
    }

    private List<Pair<ComputedColumnDesc, Pair<Integer, Integer>>> matchCcPosition(String inputSql, List<SqlNode> toMatchExpressions, List<ComputedColumnDesc> computedColumns, QueryAliasMatchInfo aliasMatchInfo) {
        ArrayList<Pair<ComputedColumnDesc, Pair<Integer, Integer>>> toBeReplacedExp = new ArrayList<Pair<ComputedColumnDesc, Pair<Integer, Integer>>>();
        for (ComputedColumnDesc cc : computedColumns) {
            if (StringUtils.isBlank((CharSequence)cc.getExpression())) continue;
            ArrayList matchedExpList = Lists.newArrayList();
            SqlNode ccExpNode = CalciteParser.getExpNode((String)cc.getExpression());
            toMatchExpressions.stream().filter(inputNode -> this.isNodesEqual(aliasMatchInfo, ccExpNode, (SqlNode)inputNode)).forEach(matchedExpList::add);
            if (StringUtils.isNotBlank((CharSequence)cc.getInnerExpression())) {
                String innerCcExp = ConvertToComputedColumn.transformExpr(cc.getInnerExpression());
                if (!Objects.equals(cc.getExpression(), innerCcExp)) {
                    SqlNode transformedNode = CalciteParser.getReadonlyExpNode((String)innerCcExp);
                    toMatchExpressions.stream().filter(inputNode -> this.isNodesEqual(aliasMatchInfo, transformedNode, (SqlNode)inputNode)).forEach(matchedExpList::add);
                }
            }
            for (SqlNode node : matchedExpList) {
                Pair startEndPos = CalciteParser.getReplacePos((SqlNode)node, (String)inputSql);
                int start = (Integer)startEndPos.getFirst();
                int end = (Integer)startEndPos.getSecond();
                boolean conflict = toBeReplacedExp.stream().map(Pair::getSecond).anyMatch(replaced -> (Integer)replaced.getFirst() < end && (Integer)replaced.getSecond() > start);
                if (conflict) continue;
                toBeReplacedExp.add((Pair<ComputedColumnDesc, Pair<Integer, Integer>>)Pair.newPair((Object)cc, (Object)Pair.newPair((Object)start, (Object)end)));
            }
        }
        toBeReplacedExp.sort((o1, o2) -> ((Integer)((Pair)o2.getSecond()).getFirst()).compareTo((Integer)((Pair)o1.getSecond()).getFirst()));
        return toBeReplacedExp;
    }

    List<SqlNode> collectLatentCcExpList(SqlCall selectOrOrderBy) {
        List<Object> inputNodes = new LinkedList();
        if ("LENIENT".equals(KylinConfig.getInstanceFromEnv().getCalciteConformance())) {
            inputNodes = ConvertToComputedColumn.getInputTreeNodes((SqlNode)selectOrOrderBy);
        } else if (selectOrOrderBy instanceof SqlSelect && ((SqlSelect)selectOrOrderBy).getGroup() != null) {
            inputNodes.addAll(ConvertToComputedColumn.collectInputNodes((SqlSelect)selectOrOrderBy));
        } else if (selectOrOrderBy instanceof SqlOrderBy) {
            SqlOrderBy sqlOrderBy = (SqlOrderBy)selectOrOrderBy;
            inputNodes.addAll(ConvertToComputedColumn.collectInputNodes(sqlOrderBy));
            if (sqlOrderBy.query instanceof SqlCall) {
                inputNodes.addAll(this.collectLatentCcExpList((SqlCall)sqlOrderBy.query));
            } else {
                inputNodes.addAll(ConvertToComputedColumn.getInputTreeNodes(sqlOrderBy.query));
            }
        } else {
            inputNodes = ConvertToComputedColumn.getInputTreeNodes((SqlNode)selectOrOrderBy);
        }
        return inputNodes;
    }

    private boolean isNodesEqual(QueryAliasMatchInfo matchInfo, SqlNode ccExpressionNode, SqlNode inputNode) {
        if (matchInfo.isModelView()) {
            return ExpressionComparator.isNodeEqual((SqlNode)inputNode, (SqlNode)ccExpressionNode, (ExpressionComparator.SqlNodeComparator)new ModelViewSqlNodeComparator(matchInfo.getModel()));
        }
        return ExpressionComparator.isNodeEqual((SqlNode)inputNode, (SqlNode)ccExpressionNode, (AliasMapping)matchInfo, (AliasDeduce)new AliasDeduceImpl(matchInfo));
    }

    private class ComputedColumnReplacer {
        private final QueryAliasMatcher queryAliasMatcher;
        private final List<NDataModel> dataModels;
        private boolean recursionCompleted;
        private Pair<String, Integer> choiceForSubQuery;
        private final SqlSelect sqlSelect;
        private final List<SqlNode> toMatchExpressions;

        ComputedColumnReplacer(QueryAliasMatcher queryAliasMatcher, List<NDataModel> dataModels, boolean recursionCompleted, SqlCall selectOrOrderBy) {
            this.queryAliasMatcher = queryAliasMatcher;
            this.dataModels = dataModels;
            this.recursionCompleted = recursionCompleted;
            this.sqlSelect = QueryUtil.extractSqlSelect(selectOrOrderBy);
            this.toMatchExpressions = ConvertToComputedColumn.this.collectLatentCcExpList(selectOrOrderBy);
        }

        public void replace(String sql) {
            if (this.sqlSelect == null) {
                return;
            }
            for (NDataModel model : this.dataModels) {
                QueryAliasMatchInfo info = this.queryAliasMatcher.match(model, this.sqlSelect);
                if (info == null) continue;
                List<ComputedColumnDesc> computedColumns = this.getSortedComputedColumnWithModel(model);
                Pair<String, Integer> ret = ConvertToComputedColumn.this.replaceComputedColumns(sql, this.toMatchExpressions, computedColumns, info);
                if (!sql.equals(ret.getFirst())) {
                    this.choiceForSubQuery = ret;
                    continue;
                }
                if ((Integer)ret.getSecond() == 0 || this.choiceForSubQuery != null && (Integer)ret.getSecond() <= (Integer)this.choiceForSubQuery.getSecond()) continue;
                this.choiceForSubQuery = ret;
                this.recursionCompleted = false;
            }
        }

        private List<ComputedColumnDesc> getSortedComputedColumnWithModel(NDataModel model) {
            List ccList = model.getComputedColumnDescs();
            KylinConfig projectConfig = NProjectManager.getProjectConfig((String)model.getProject());
            if (projectConfig.onlyReuseUserDefinedCC()) {
                ccList = ccList.stream().filter(cc -> !cc.isAutoCC()).collect(Collectors.toList());
            }
            return ConvertToComputedColumn.getCCListSortByLength(ccList);
        }

        @Generated
        public boolean isRecursionCompleted() {
            return this.recursionCompleted;
        }

        @Generated
        public Pair<String, Integer> getChoiceForSubQuery() {
            return this.choiceForSubQuery;
        }
    }

    static class SqlTreeVisitor
    implements SqlVisitor<SqlNode> {
        private static final Set<String> AGG_FUNCTION_SET = ImmutableSet.of((Object)"COUNT", (Object)"SUM", (Object)"MIN", (Object)"MAX", (Object)"AVG", (Object)"CORR", (Object[])new String[0]);
        private final List<SqlNode> sqlNodes = new ArrayList<SqlNode>();

        SqlTreeVisitor() {
        }

        List<SqlNode> getSqlNodes() {
            return this.sqlNodes;
        }

        public SqlNode visit(SqlNodeList nodeList) {
            for (SqlNode node : nodeList) {
                node.accept((SqlVisitor)this);
            }
            return null;
        }

        public SqlNode visit(SqlLiteral literal) {
            return null;
        }

        public SqlNode visit(SqlCall call) {
            if ((call instanceof SqlBasicCall || call instanceof SqlCase) && !AGG_FUNCTION_SET.contains(call.getOperator().getName())) {
                this.sqlNodes.add((SqlNode)call);
            }
            if (call.getOperator() instanceof SqlAsOperator) {
                call.getOperator().acceptCall((SqlVisitor)this, call, true, SqlBasicVisitor.ArgHandlerImpl.instance());
            } else {
                for (SqlNode operand : call.getOperandList()) {
                    if (ConvertToComputedColumn.isSimpleExpression(operand)) continue;
                    operand.accept((SqlVisitor)this);
                }
            }
            return null;
        }

        public SqlNode visit(SqlIdentifier id) {
            return null;
        }

        public SqlNode visit(SqlDataTypeSpec type) {
            return null;
        }

        public SqlNode visit(SqlDynamicParam param) {
            return null;
        }

        public SqlNode visit(SqlIntervalQualifier intervalQualifier) {
            return null;
        }
    }
}

