/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.querymeta.SelectedColumnMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncQueryUtil {
    public static final String ASYNC_QUERY_JOB_ID_PRE = "ASYNC-QUERY-";
    private static final Logger logger = LoggerFactory.getLogger(AsyncQueryUtil.class);

    private AsyncQueryUtil() {
    }

    public static FileSystem getFileSystem() {
        return HadoopUtil.getWorkingFileSystem();
    }

    public static void saveMetaDataAndFileInfo(QueryContext queryContext, List<SelectedColumnMeta> columnMetas) {
        try {
            AsyncQueryUtil.saveMetaData(queryContext.getProject(), columnMetas, queryContext.getQueryId());
            AsyncQueryUtil.saveFileInfo(queryContext.getProject(), queryContext.getQueryTagInfo().getFileFormat(), queryContext.getQueryTagInfo().getFileEncode(), queryContext.getQueryTagInfo().getFileName(), queryContext.getQueryId(), queryContext.getQueryTagInfo().getSeparator());
        }
        catch (IOException e) {
            logger.error("save async query column metadata or file info failed.", (Throwable)e);
        }
    }

    public static void saveMetaData(String project, List<SelectedColumnMeta> columnMetas, String queryId) throws IOException {
        block26: {
            Path asyncQueryResultDir;
            ArrayList dataTypes = Lists.newArrayList();
            ArrayList columnNames = Lists.newArrayList();
            for (SelectedColumnMeta selectedColumnMeta : columnMetas) {
                dataTypes.add(selectedColumnMeta.getColumnTypeName());
                columnNames.add(selectedColumnMeta.getName());
            }
            FileSystem fileSystem = AsyncQueryUtil.getFileSystem();
            if (fileSystem.exists(asyncQueryResultDir = AsyncQueryUtil.getAsyncQueryResultDir(project, queryId))) {
                try (FSDataOutputStream os = AsyncQueryUtil.getFileSystem().create(new Path(asyncQueryResultDir, AsyncQueryUtil.getMetaDataFileName()));
                     OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os, Charset.defaultCharset());){
                    String metaString = StringUtils.join((Iterable)columnNames, (String)",") + "\n" + StringUtils.join((Iterable)dataTypes, (String)",");
                    osw.write(metaString);
                    break block26;
                }
            }
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.ASYNC_QUERY_RESULT_NOT_FOUND, new Object[0]);
        }
    }

    public static void saveFileInfo(String project, String format, String encode, String fileName, String queryId, String separator) throws IOException {
        block25: {
            Path asyncQueryResultDir;
            FileSystem fileSystem = AsyncQueryUtil.getFileSystem();
            if (fileSystem.exists(asyncQueryResultDir = AsyncQueryUtil.getAsyncQueryResultDir(project, queryId))) {
                try (FSDataOutputStream os = AsyncQueryUtil.getFileSystem().create(new Path(asyncQueryResultDir, AsyncQueryUtil.getFileInfo()));
                     OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os, Charset.defaultCharset());){
                    osw.write(format + "\n");
                    osw.write(encode + "\n");
                    osw.write(fileName + "\n");
                    osw.write(separator);
                    break block25;
                }
            }
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.ASYNC_QUERY_RESULT_NOT_FOUND, new Object[0]);
        }
    }

    public static void createErrorFlag(String project, String queryId, String errorMessage) throws IOException {
        Path asyncQueryResultDir;
        FileSystem fileSystem = AsyncQueryUtil.getFileSystem();
        if (!fileSystem.exists(asyncQueryResultDir = AsyncQueryUtil.getAsyncQueryResultDir(project, queryId))) {
            fileSystem.mkdirs(asyncQueryResultDir);
        }
        try (FSDataOutputStream os = fileSystem.create(new Path(asyncQueryResultDir, AsyncQueryUtil.getFailureFlagFileName()));
             OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os, Charset.defaultCharset());){
            if (errorMessage != null) {
                osw.write(errorMessage);
                os.hflush();
            }
        }
    }

    public static void createSuccessFlag(String project, String queryId) throws IOException {
        FileSystem fileSystem = AsyncQueryUtil.getFileSystem();
        Path asyncQueryResultDir = AsyncQueryUtil.getAsyncQueryResultDir(project, queryId);
        try (FSDataOutputStream os = fileSystem.create(new Path(asyncQueryResultDir, AsyncQueryUtil.getSuccessFlagFileName()));){
            os.hflush();
        }
    }

    public static void createSuccessFlagWithContent(String project, String queryId, SuccessFileContent content) throws IOException {
        FileSystem fileSystem = AsyncQueryUtil.getFileSystem();
        Path asyncQueryResultDir = AsyncQueryUtil.getAsyncQueryResultDir(project, queryId);
        try (FSDataOutputStream os = fileSystem.create(new Path(asyncQueryResultDir, AsyncQueryUtil.getSuccessFlagFileName()));){
            if (content != null) {
                os.writeUTF(JsonUtil.writeValueAsString((Object)content));
            }
            os.hflush();
        }
    }

    public static SuccessFileContent getSuccessFileContent(String project, String queryId) throws IOException {
        Path asyncQueryResultDir;
        Path successFilePath;
        FileSystem fileSystem = AsyncQueryUtil.getFileSystem();
        FileStatus successFileStatus = fileSystem.getFileStatus(successFilePath = new Path(asyncQueryResultDir = AsyncQueryUtil.getAsyncQueryResultDir(project, queryId), AsyncQueryUtil.getSuccessFlagFileName()));
        if (successFileStatus.getLen() == 0L) {
            return null;
        }
        try (FSDataInputStream in = fileSystem.open(successFilePath);){
            String content = in.readUTF();
            if (StringUtils.isNotBlank((CharSequence)content)) {
                SuccessFileContent successFileContent = (SuccessFileContent)JsonUtil.readValue((String)content, SuccessFileContent.class);
                return successFileContent;
            }
        }
        return null;
    }

    public static Path getAsyncQueryResultDir(String project, String queryId) {
        return new Path(KapConfig.getInstanceFromEnv().getAsyncResultBaseDir(project), queryId);
    }

    public static String getSuccessFlagFileName() {
        return "_SUCCESS";
    }

    public static String getFailureFlagFileName() {
        return "_FAILED";
    }

    public static String getMetaDataFileName() {
        return "_METADATA";
    }

    public static String getUserFileName() {
        return "_USER";
    }

    public static String getFileInfo() {
        return "_FILEINFO";
    }

    public static class SuccessFileContent {
        private String code;

        @Generated
        public String getCode() {
            return this.code;
        }

        @Generated
        public void setCode(String code) {
            this.code = code;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SuccessFileContent)) {
                return false;
            }
            SuccessFileContent other = (SuccessFileContent)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$code = this.getCode();
            String other$code = other.getCode();
            return !(this$code == null ? other$code != null : !this$code.equals(other$code));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SuccessFileContent;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : $code.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AsyncQueryUtil.SuccessFileContent(code=" + this.getCode() + ")";
        }

        @Generated
        public SuccessFileContent() {
        }

        @Generated
        public SuccessFileContent(String code) {
            this.code = code;
        }
    }
}

