/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableUnion;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.SetOp;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.query.relnode.ColumnRowType;
import org.apache.kylin.query.relnode.ContextUtil;
import org.apache.kylin.query.relnode.OlapContext;
import org.apache.kylin.query.relnode.OlapRel;
import org.apache.kylin.query.util.ICutContextStrategy;

public class OlapUnionRel
extends Union
implements OlapRel {
    private final boolean localAll;
    private ColumnRowType columnRowType;
    private OlapContext context = null;
    private Set<OlapContext> subContexts = Sets.newHashSet();

    public OlapUnionRel(RelOptCluster cluster, RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
        super(cluster, traitSet, inputs, all);
        Preconditions.checkArgument((this.getConvention() == CONVENTION ? 1 : 0) != 0);
        for (RelNode child : inputs) {
            Preconditions.checkArgument((this.getConvention() == child.getConvention() ? 1 : 0) != 0);
        }
        this.localAll = all;
    }

    public SetOp copy(RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
        return new OlapUnionRel(this.getCluster(), traitSet, inputs, all);
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(0.05);
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("ctx", (Object)this.displayCtxId(this.context)).itemIf("all", (Object)this.all, true);
    }

    @Override
    public void implementOlap(OlapRel.OlapImpl olapImpl) {
        for (RelNode input : this.getInputs()) {
            olapImpl.visitChild(input, this);
        }
        this.columnRowType = this.buildColumnRowType();
        if (this.context != null && this == this.context.getTopNode() && !this.context.isHasAgg()) {
            ContextUtil.amendAllColsIfNoAgg(this);
        }
    }

    private ColumnRowType buildColumnRowType() {
        ColumnRowType inputColumnRowType = ((OlapRel)this.getInput(0)).getColumnRowType();
        ArrayList<TblColRef> columns = new ArrayList<TblColRef>();
        for (TblColRef tblColRef : inputColumnRowType.getAllColumns()) {
            columns.add(TblColRef.newInnerColumn((String)tblColRef.getName(), (TblColRef.InnerDataTypeEnum)TblColRef.InnerDataTypeEnum.LITERAL));
        }
        return new ColumnRowType(columns, inputColumnRowType.getSourceColumns());
    }

    @Override
    public void implementRewrite(OlapRel.RewriteImpl rewriteImpl) {
        for (RelNode child : this.getInputs()) {
            rewriteImpl.visitChild(this, child);
        }
        if (this.context != null) {
            this.rowType = this.deriveRowType();
        }
    }

    @Override
    public EnumerableRel implementEnumerable(List<EnumerableRel> inputs) {
        ArrayList<EnumerableRel> relInputs = new ArrayList<EnumerableRel>(inputs.size());
        for (EnumerableRel input : inputs) {
            if (input instanceof OlapRel) {
                ((OlapRel)input).replaceTraitSet((RelTrait)EnumerableConvention.INSTANCE);
            }
            relInputs.add(input);
        }
        return new EnumerableUnion(this.getCluster(), this.traitSet.replace((RelTrait)EnumerableConvention.INSTANCE), relInputs, this.localAll);
    }

    @Override
    public boolean hasSubQuery() {
        for (RelNode child : this.getInputs()) {
            if (!((OlapRel)child).hasSubQuery()) continue;
            return true;
        }
        return false;
    }

    @Override
    public RelTraitSet replaceTraitSet(RelTrait trait) {
        RelTraitSet oldTraitSet = this.traitSet;
        this.traitSet = this.traitSet.replace(trait);
        return oldTraitSet;
    }

    @Override
    public void implementCutContext(ICutContextStrategy.ContextCutImpl contextCutImpl) {
        throw new KylinRuntimeException("Union rel should not be re-cut from outside");
    }

    @Override
    public void setContext(OlapContext context) {
        if (QueryContext.current().getQueryTagInfo().isConstantQuery()) {
            return;
        }
        throw new KylinRuntimeException("Union should not be set context from outside");
    }

    @Override
    public boolean pushRelInfoToContext(OlapContext context) {
        return context == this.context;
    }

    @Override
    public void implementContext(OlapRel.ContextImpl contextImpl, OlapRel.ContextVisitorState state) {
        OlapRel.ContextVisitorState accumulateState = OlapRel.ContextVisitorState.init();
        for (int i = 0; i < this.getInputs().size(); ++i) {
            contextImpl.fixSharedOlapTableScanAt(this, i);
            OlapRel.ContextVisitorState tempState = OlapRel.ContextVisitorState.init();
            RelNode input = this.getInput(i);
            contextImpl.visitChild(input, this, tempState);
            if (tempState.hasFreeTable()) {
                contextImpl.allocateContext((OlapRel)input, this);
            }
            tempState.setHasFreeTable(false);
            accumulateState.merge(tempState);
        }
        state.merge(accumulateState);
        for (RelNode subRel : this.getInputs()) {
            this.subContexts.addAll(ContextUtil.collectSubContext(subRel));
        }
    }

    @Override
    @Generated
    public ColumnRowType getColumnRowType() {
        return this.columnRowType;
    }

    @Override
    @Generated
    public OlapContext getContext() {
        return this.context;
    }

    @Override
    @Generated
    public Set<OlapContext> getSubContexts() {
        return this.subContexts;
    }

    @Generated
    private boolean isLocalAll() {
        return this.localAll;
    }

    @Override
    @Generated
    public void setSubContexts(Set<OlapContext> subContexts) {
        this.subContexts = subContexts;
    }
}

