/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableSet;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.query.util.EscapeDialect;
import org.apache.kylin.query.util.ParseException;
import org.apache.kylin.query.util.SimpleCharStream;
import org.apache.kylin.query.util.Token;
import org.apache.kylin.query.util.WhiteSpaceParserConstants;
import org.apache.kylin.query.util.WhiteSpaceParserTokenManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WhiteSpaceParser
implements WhiteSpaceParserConstants {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WhiteSpaceParser.class);
    private static final String CEIL_FLOOR_EXCEPTION_MSG = "%s(exp to timeunit) encounters timeunit %s, but only supports %s";
    private static final String EXTRACT_FROM_EXCEPTION_MSG = "extract(timeunit from exp) encounters timeunit %s, but only supports %s";
    private static final String TIMESTAMP_DIFF_ADD_EXCEPTION_MSG = "%s(timeunit, exp1, exp2) encounters timeunit %s, but only supports %s";
    private static final String COMMA_STR = ",";
    private static final String SPACE_STR = " ";
    private static final char SPACE_CHAR = ' ';
    private static final String QUOTE_STR = "'";
    private static final Set<String> OPERATORS = new HashSet<String>(Arrays.asList("+", "-", "*", "/", "%", "=", ">=", "<=", "!=", "<>", "||"));
    private EscapeDialect dialect = EscapeDialect.DEFAULT;
    public WhiteSpaceParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[80];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private final JJCalls[] jj_2_rtns = new JJCalls[2];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public static void main(String[] args) throws Exception {
        String sql = "select  *          col1    ,\ncol2,col3  from \n tableA  \\r   a left \t\n table\rb     (  select *      from  t) ";
        WhiteSpaceParser whiteSpaceParser = new WhiteSpaceParser(new StringReader(sql));
        System.out.println("transformed sql is \uff1a" + whiteSpaceParser.parse());
    }

    private static String normalize(String str) {
        if (str.equals(COMMA_STR)) {
            str = str + SPACE_STR;
        } else if (OPERATORS.contains(str)) {
            str = SPACE_STR + str + SPACE_STR;
        }
        return str;
    }

    public WhiteSpaceParser(EscapeDialect newDialect, String SQL) {
        this(new StringReader(SQL));
        this.dialect = newDialect;
    }

    private static boolean needDropPreSpace(String str) {
        return COMMA_STR.equals(str) || OPERATORS.contains(str) || StringUtils.isBlank((CharSequence)str) && !SPACE_STR.equals(str);
    }

    private static boolean skipSpace(String str) {
        return COMMA_STR.equals(str) || OPERATORS.contains(str);
    }

    private static void appendExpression(StringBuilder sb, String innerString) {
        int last;
        if (sb.length() != 0 && sb.charAt(last = sb.length() - 1) != ' ' && innerString.startsWith(QUOTE_STR)) {
            sb.append(SPACE_STR);
        }
        int len = sb.length();
        if (!SPACE_STR.equals(innerString) || len != 0 && sb.charAt(len - 1) != ' ') {
            String tmp = WhiteSpaceParser.normalize(innerString);
            if (WhiteSpaceParser.skipSpace(innerString)) {
                sb.append(tmp);
            } else {
                sb.append(tmp).append(SPACE_STR);
            }
        }
    }

    public final String parse() throws ParseException {
        StringBuilder transformedStr = new StringBuilder();
        do {
            int lastIndex;
            String inner = this.Expression();
            if (transformedStr.length() != 0 && transformedStr.charAt(lastIndex = transformedStr.length() - 1) == ' ' && WhiteSpaceParser.needDropPreSpace(inner)) {
                transformedStr.deleteCharAt(lastIndex);
            }
            WhiteSpaceParser.appendExpression(transformedStr, inner);
        } while (this.jj_2_1(2));
        this.jj_consume_token(0);
        return transformedStr.toString();
    }

    public final String Expression() throws ParseException {
        String innerString = "";
        if (Thread.currentThread().isInterrupted()) {
            throw new ParseException("EscapeParser is interrupted");
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 3: {
                innerString = this.EscapeExpress();
                break;
            }
            case 29: 
            case 30: {
                innerString = this.SubstringExpression();
                break;
            }
            case 38: {
                innerString = this.OverlayExpression();
                break;
            }
            case 40: {
                innerString = this.GroupingSetsExpression();
                break;
            }
            case 35: 
            case 36: {
                innerString = this.TsDiffOrAddExpression();
                break;
            }
            case 17: {
                innerString = this.Hint();
                break;
            }
            case 18: {
                innerString = this.CubePriority();
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                innerString = this.Numeric();
                break;
            }
            case 33: {
                innerString = this.CastExpression();
                break;
            }
            case 37: {
                innerString = this.ExtractExpression();
                break;
            }
            case 24: 
            case 27: {
                innerString = this.CeilFloorExpress();
                break;
            }
            case 25: 
            case 26: {
                innerString = this.CeilFloorDatetimeExpress();
                break;
            }
            case 6: {
                innerString = this.ParenExpress();
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                innerString = this.QuotedString();
                break;
            }
            case 16: {
                innerString = this.DoubleQuotedString();
                break;
            }
            case 52: {
                innerString = this.BangEqual();
                break;
            }
            case 7: {
                innerString = this.Comma();
                break;
            }
            case 8: {
                innerString = this.Space();
                break;
            }
            case 42: {
                innerString = this.PiFunction();
                break;
            }
            case 23: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                innerString = this.Punctuation();
                break;
            }
            case 31: {
                innerString = this.From();
                break;
            }
            case 32: {
                innerString = this.For();
                break;
            }
            case 28: {
                innerString = this.To();
                break;
            }
            case 34: {
                innerString = this.As();
                break;
            }
            case 43: {
                innerString = this.Any();
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return innerString;
    }

    public final String Comma() throws ParseException {
        this.jj_consume_token(7);
        log.trace("meet token <COMMA>");
        return this.getToken((int)0).image;
    }

    public final String Space() throws ParseException {
        this.jj_consume_token(8);
        log.trace("meet token <SPACE>");
        return SPACE_STR;
    }

    public final String Punctuation() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 23: {
                this.jj_consume_token(23);
                break;
            }
            case 49: {
                this.jj_consume_token(49);
                break;
            }
            case 50: {
                this.jj_consume_token(50);
                break;
            }
            case 51: {
                this.jj_consume_token(51);
                break;
            }
            case 52: {
                this.jj_consume_token(52);
                break;
            }
            case 44: {
                this.jj_consume_token(44);
                break;
            }
            case 45: {
                this.jj_consume_token(45);
                break;
            }
            case 46: {
                this.jj_consume_token(46);
                break;
            }
            case 53: {
                this.jj_consume_token(53);
                break;
            }
            case 47: {
                this.jj_consume_token(47);
                break;
            }
            case 48: {
                this.jj_consume_token(48);
                break;
            }
            case 54: {
                this.jj_consume_token(54);
                break;
            }
            case 55: {
                this.jj_consume_token(55);
                break;
            }
            case 56: {
                this.jj_consume_token(56);
                break;
            }
            case 57: {
                this.jj_consume_token(57);
                break;
            }
            case 58: {
                this.jj_consume_token(58);
                break;
            }
            case 59: {
                this.jj_consume_token(59);
                break;
            }
            case 61: {
                this.jj_consume_token(61);
                break;
            }
            case 62: {
                this.jj_consume_token(62);
                break;
            }
            case 60: {
                this.jj_consume_token(60);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        log.trace("meet token {}", (Object)this.getToken(0).toString());
        return this.getToken((int)0).image;
    }

    public final String From() throws ParseException {
        this.jj_consume_token(31);
        log.trace("met token <FROM>");
        return this.getToken((int)0).image;
    }

    public final String For() throws ParseException {
        this.jj_consume_token(32);
        log.trace("met token <FOR>");
        return this.getToken((int)0).image;
    }

    public final String To() throws ParseException {
        this.jj_consume_token(28);
        log.trace("met token <TO>");
        return this.getToken((int)0).image;
    }

    public final String As() throws ParseException {
        this.jj_consume_token(34);
        log.trace("met token <AS>");
        return this.getToken((int)0).image;
    }

    public final String DoubleQuotedString() throws ParseException {
        this.jj_consume_token(16);
        return this.dialect.transformDoubleQuoteString(this.getToken((int)0).image);
    }

    public final String QuotedString() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: {
                this.jj_consume_token(10);
                log.trace("meet token in <BINARY_STRING_LITERAL>: " + this.getToken((int)0).image);
                return this.getToken((int)0).image;
            }
            case 11: {
                this.jj_consume_token(11);
                log.trace("meet token in <QUOTED_STRING>: " + this.getToken((int)0).image);
                return this.getToken((int)0).image;
            }
            case 12: {
                this.jj_consume_token(12);
                log.trace("meet token in <PREFIXED_STRING_LITERAL>: " + this.getToken((int)0).image);
                return this.getToken((int)0).image;
            }
            case 13: {
                this.jj_consume_token(13);
                log.trace("meet token in <UNICODE_STRING_LITERAL>: " + this.getToken((int)0).image);
                return this.getToken((int)0).image;
            }
        }
        this.jj_la1[2] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String Any() throws ParseException {
        this.jj_consume_token(43);
        log.trace("meet token in <ANY>: " + this.getToken((int)0).image);
        return this.getToken((int)0).image;
    }

    public final String ParenExpress() throws ParseException {
        StringBuilder transformed = new StringBuilder();
        this.jj_consume_token(6);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 3: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 40: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: {
                    break;
                }
                default: {
                    this.jj_la1[3] = this.jj_gen;
                    break block3;
                }
            }
            String innerString = this.Expression();
            if (transformed.length() != 0) {
                int lastIndex = transformed.length() - 1;
                if (transformed.charAt(lastIndex) == ' ' && WhiteSpaceParser.needDropPreSpace(innerString)) {
                    transformed.deleteCharAt(lastIndex);
                }
                innerString = WhiteSpaceParser.normalize(innerString);
            }
            WhiteSpaceParser.appendExpression(transformed, innerString);
        }
        this.jj_consume_token(5);
        return "(" + transformed.toString() + ")";
    }

    public final String EscapeExpress() throws ParseException {
        String innerString;
        this.jj_consume_token(3);
        block12: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    break block12;
                }
            }
            this.jj_consume_token(8);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 63: {
                innerString = this.EscapeFunction();
                break;
            }
            case 64: {
                innerString = this.EscapeTimestamp();
                break;
            }
            case 65: 
            case 66: {
                innerString = this.EscapeDate();
                break;
            }
            case 67: 
            case 68: {
                innerString = this.EscapeTime();
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block13: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                    break block13;
                }
            }
            this.jj_consume_token(8);
        }
        this.jj_consume_token(4);
        return innerString;
    }

    public final String CastExpression() throws ParseException {
        ArrayList parameters = Lists.newArrayList();
        this.jj_consume_token(33);
        String function = this.getToken((int)0).image;
        block15: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    break block15;
                }
            }
            this.jj_consume_token(8);
        }
        this.jj_consume_token(6);
        block16: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                    break block16;
                }
            }
            this.jj_consume_token(8);
        }
        parameters.add(this.ParameterExpression().trim());
        block17: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[9] = this.jj_gen;
                    break block17;
                }
            }
            this.jj_consume_token(8);
        }
        this.jj_consume_token(34);
        parameters.add(this.getToken((int)0).image);
        block18: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                    break block18;
                }
            }
            this.jj_consume_token(8);
        }
        String type = this.dialect.transformDataType(this.ParameterExpression().trim());
        parameters.add(type);
        block19: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[11] = this.jj_gen;
                    break block19;
                }
            }
            this.jj_consume_token(8);
        }
        this.jj_consume_token(5);
        return String.format(Locale.ROOT, "%s(%s)", function, String.join((CharSequence)SPACE_STR, parameters));
    }

    public final String ExtractExpression() throws ParseException {
        ImmutableSet timeunitSet = ImmutableSet.of((Object)"YEAR", (Object)"QUARTER", (Object)"MONTH", (Object)"WEEK", (Object)"DAY", (Object)"HOUR", (Object[])new String[]{"MINUTE", "SECOND", "DOW", "DOY", "EPOCH"});
        this.jj_consume_token(37);
        block15: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[12] = this.jj_gen;
                    break block15;
                }
            }
            this.jj_consume_token(8);
        }
        this.jj_consume_token(6);
        block16: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[13] = this.jj_gen;
                    break block16;
                }
            }
            this.jj_consume_token(8);
        }
        String functionName = this.ParameterExpression().trim();
        if (!timeunitSet.contains((Object)functionName.toUpperCase(Locale.ROOT))) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, EXTRACT_FROM_EXCEPTION_MSG, functionName, String.join((CharSequence)", ", (Iterable<? extends CharSequence>)timeunitSet)));
        }
        if (functionName.equalsIgnoreCase("DAY")) {
            functionName = "DAYOFMONTH";
        } else if (functionName.equalsIgnoreCase("DOW")) {
            functionName = "DAYOFWEEK";
        } else if (functionName.equalsIgnoreCase("DOY")) {
            functionName = "DAYOFYEAR";
        }
        block17: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[14] = this.jj_gen;
                    break block17;
                }
            }
            this.jj_consume_token(8);
        }
        this.jj_consume_token(31);
        block18: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    break block18;
                }
            }
            this.jj_consume_token(8);
        }
        String parameter = this.ParameterExpression().trim();
        block19: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[16] = this.jj_gen;
                    break block19;
                }
            }
            this.jj_consume_token(8);
        }
        this.jj_consume_token(5);
        return this.dialect.transformFN(functionName, new String[]{parameter});
    }

    public final String TsDiffOrAddExpression() throws ParseException {
        ArrayList parameters = Lists.newArrayList();
        ImmutableSet timeunitSet = ImmutableSet.of((Object)"YEAR", (Object)"QUARTER", (Object)"MONTH", (Object)"WEEK", (Object)"DAY", (Object)"HOUR", (Object[])new String[]{"MINUTE", "SECOND", "SQL_TSI_SECOND", "SQL_TSI_MINUTE", "SQL_TSI_HOUR", "SQL_TSI_DAY", "SQL_TSI_WEEK", "SQL_TSI_MONTH", "SQL_TSI_QUARTER", "SQL_TSI_YEAR"});
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 36: {
                this.jj_consume_token(36);
                break;
            }
            case 35: {
                this.jj_consume_token(35);
                break;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        String functionName = this.getToken((int)0).image;
        block25: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[18] = this.jj_gen;
                    break block25;
                }
            }
            this.jj_consume_token(8);
        }
        this.jj_consume_token(6);
        block26: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[19] = this.jj_gen;
                    break block26;
                }
            }
            this.jj_consume_token(8);
        }
        String timeunit = this.ParameterExpression().trim();
        if (timeunit.startsWith(QUOTE_STR) && timeunit.endsWith(QUOTE_STR) && timeunit.length() > 2) {
            timeunit = timeunit.substring(1, timeunit.length() - 1);
        }
        if (!timeunitSet.contains((Object)timeunit.toUpperCase(Locale.ROOT))) {
            throw new IllegalStateException(String.format(Locale.ROOT, TIMESTAMP_DIFF_ADD_EXCEPTION_MSG, functionName, timeunit, String.join((CharSequence)", ", (Iterable<? extends CharSequence>)timeunitSet)));
        }
        if (timeunit.toUpperCase(Locale.ROOT).startsWith("SQL_TSI_")) {
            timeunit = timeunit.toUpperCase(Locale.ROOT).replace("SQL_TSI_", "");
        }
        parameters.add(this.dialect.transformTimeunitOfTimestampDiffOrAdd(timeunit));
        block27: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[20] = this.jj_gen;
                    break block27;
                }
            }
            this.jj_consume_token(8);
        }
        this.jj_consume_token(7);
        block28: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[21] = this.jj_gen;
                    break block28;
                }
            }
            this.jj_consume_token(8);
        }
        parameters.add(this.ParameterExpression().trim());
        block29: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[22] = this.jj_gen;
                    break block29;
                }
            }
            this.jj_consume_token(8);
        }
        this.jj_consume_token(7);
        block30: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[23] = this.jj_gen;
                    break block30;
                }
            }
            this.jj_consume_token(8);
        }
        parameters.add(this.ParameterExpression().trim());
        block31: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[24] = this.jj_gen;
                    break block31;
                }
            }
            this.jj_consume_token(8);
        }
        this.jj_consume_token(5);
        return this.dialect.transformFN(functionName, parameters.toArray(new String[0]));
    }

    public final String SubstringExpression() throws ParseException {
        ArrayList parameters = Lists.newArrayList();
        ArrayList params = Lists.newArrayList();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: {
                this.jj_consume_token(30);
                break;
            }
            case 29: {
                this.jj_consume_token(29);
                break;
            }
            default: {
                this.jj_la1[25] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        String functionName = this.getToken((int)0).image;
        block36: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[26] = this.jj_gen;
                    break block36;
                }
            }
            this.jj_consume_token(8);
        }
        this.jj_consume_token(6);
        block37: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[27] = this.jj_gen;
                    break block37;
                }
            }
            this.jj_consume_token(8);
        }
        parameters.add(this.ParameterExpression().trim());
        block38: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[28] = this.jj_gen;
                    break block38;
                }
            }
            this.jj_consume_token(8);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 31: {
                this.jj_consume_token(31);
                break;
            }
            case 7: {
                this.jj_consume_token(7);
                break;
            }
            default: {
                this.jj_la1[29] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block39: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[30] = this.jj_gen;
                    break block39;
                }
            }
            this.jj_consume_token(8);
        }
        parameters.add(this.ParameterExpression().trim());
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: 
            case 8: 
            case 32: {
                block40: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 8: {
                            break;
                        }
                        default: {
                            this.jj_la1[31] = this.jj_gen;
                            break block40;
                        }
                    }
                    this.jj_consume_token(8);
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 32: {
                        this.jj_consume_token(32);
                        break;
                    }
                    case 7: {
                        this.jj_consume_token(7);
                        break;
                    }
                    default: {
                        this.jj_la1[32] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                block41: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 8: {
                            break;
                        }
                        default: {
                            this.jj_la1[33] = this.jj_gen;
                            break block41;
                        }
                    }
                    this.jj_consume_token(8);
                }
                parameters.add(this.ParameterExpression().trim());
                break;
            }
            default: {
                this.jj_la1[34] = this.jj_gen;
            }
        }
        block42: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[35] = this.jj_gen;
                    break block42;
                }
            }
            this.jj_consume_token(8);
        }
        this.jj_consume_token(5);
        return this.dialect.transformFN(functionName, parameters.toArray(new String[0]));
    }

    public final String OverlayExpression() throws ParseException {
        ArrayList parameters = Lists.newArrayList();
        ArrayList params = Lists.newArrayList();
        this.jj_consume_token(38);
        String functionName = this.getToken((int)0).image;
        block38: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[36] = this.jj_gen;
                    break block38;
                }
            }
            this.jj_consume_token(8);
        }
        this.jj_consume_token(6);
        block39: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[37] = this.jj_gen;
                    break block39;
                }
            }
            this.jj_consume_token(8);
        }
        parameters.add(this.ParameterExpression().trim());
        block40: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[38] = this.jj_gen;
                    break block40;
                }
            }
            this.jj_consume_token(8);
        }
        this.jj_consume_token(39);
        block41: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[39] = this.jj_gen;
                    break block41;
                }
            }
            this.jj_consume_token(8);
        }
        parameters.add(this.ParameterExpression().trim());
        block42: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[40] = this.jj_gen;
                    break block42;
                }
            }
            this.jj_consume_token(8);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 31: {
                this.jj_consume_token(31);
                break;
            }
            case 7: {
                this.jj_consume_token(7);
                break;
            }
            default: {
                this.jj_la1[41] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block43: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[42] = this.jj_gen;
                    break block43;
                }
            }
            this.jj_consume_token(8);
        }
        parameters.add(this.ParameterExpression().trim());
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: 
            case 8: 
            case 32: {
                block44: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 8: {
                            break;
                        }
                        default: {
                            this.jj_la1[43] = this.jj_gen;
                            break block44;
                        }
                    }
                    this.jj_consume_token(8);
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 32: {
                        this.jj_consume_token(32);
                        break;
                    }
                    case 7: {
                        this.jj_consume_token(7);
                        break;
                    }
                    default: {
                        this.jj_la1[44] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                block45: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 8: {
                            break;
                        }
                        default: {
                            this.jj_la1[45] = this.jj_gen;
                            break block45;
                        }
                    }
                    this.jj_consume_token(8);
                }
                parameters.add(this.ParameterExpression().trim());
                break;
            }
            default: {
                this.jj_la1[46] = this.jj_gen;
            }
        }
        block46: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[47] = this.jj_gen;
                    break block46;
                }
            }
            this.jj_consume_token(8);
        }
        this.jj_consume_token(5);
        return this.dialect.transformFN(functionName, parameters.toArray(new String[0]));
    }

    public final String GroupingSetsExpression() throws ParseException {
        ArrayList parameters = Lists.newArrayList();
        this.jj_consume_token(40);
        String function = this.getToken((int)0).image;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: 
            case 41: {
                block24: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 8: {
                            break;
                        }
                        default: {
                            this.jj_la1[48] = this.jj_gen;
                            break block24;
                        }
                    }
                    this.jj_consume_token(8);
                }
                this.jj_consume_token(41);
                log.trace("recognized grouping sets");
                function = this.getToken((int)0).image;
                break;
            }
            default: {
                this.jj_la1[49] = this.jj_gen;
            }
        }
        log.trace("recognized grouping function");
        block25: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[50] = this.jj_gen;
                    break block25;
                }
            }
            this.jj_consume_token(8);
        }
        this.jj_consume_token(6);
        block26: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[51] = this.jj_gen;
                    break block26;
                }
            }
            this.jj_consume_token(8);
        }
        parameters.add(this.ParameterExpression().trim());
        block27: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 7: 
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[52] = this.jj_gen;
                    break block27;
                }
            }
            block28: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 8: {
                        break;
                    }
                    default: {
                        this.jj_la1[53] = this.jj_gen;
                        break block28;
                    }
                }
                this.jj_consume_token(8);
            }
            this.jj_consume_token(7);
            block29: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 8: {
                        break;
                    }
                    default: {
                        this.jj_la1[54] = this.jj_gen;
                        break block29;
                    }
                }
                this.jj_consume_token(8);
            }
            parameters.add(this.ParameterExpression().trim());
        }
        block30: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[55] = this.jj_gen;
                    break block30;
                }
            }
            this.jj_consume_token(8);
        }
        this.jj_consume_token(5);
        return this.dialect.transformFN(function, parameters.toArray(new String[0]));
    }

    public final String CeilFloorExpress() throws ParseException {
        ArrayList parameters = Lists.newArrayList();
        ImmutableSet timeunitSet = ImmutableSet.of((Object)"YEAR", (Object)"QUARTER", (Object)"MONTH", (Object)"WEEK", (Object)"DAY", (Object)"HOUR", (Object[])new String[]{"MINUTE", "SECOND"});
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 24: {
                this.jj_consume_token(24);
                break;
            }
            case 27: {
                this.jj_consume_token(27);
                break;
            }
            default: {
                this.jj_la1[56] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        String functionName = this.getToken((int)0).image;
        block22: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[57] = this.jj_gen;
                    break block22;
                }
            }
            this.jj_consume_token(8);
        }
        this.jj_consume_token(6);
        block23: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[58] = this.jj_gen;
                    break block23;
                }
            }
            this.jj_consume_token(8);
        }
        parameters.add(this.ParameterExpression().trim());
        block24: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[59] = this.jj_gen;
                    break block24;
                }
            }
            this.jj_consume_token(8);
        }
        block13 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 28: {
                this.jj_consume_token(28);
                block25: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 8: {
                            break;
                        }
                        default: {
                            this.jj_la1[60] = this.jj_gen;
                            break block25;
                        }
                    }
                    this.jj_consume_token(8);
                }
                String timeUnit = this.ParameterExpression().trim();
                if (!timeunitSet.contains((Object)timeUnit.toUpperCase(Locale.ROOT))) {
                    throw new IllegalStateException(String.format(Locale.ROOT, CEIL_FLOOR_EXCEPTION_MSG, functionName, timeUnit, String.join((CharSequence)", ", (Iterable<? extends CharSequence>)timeunitSet)));
                }
                parameters.add(timeUnit);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 8: {
                            break;
                        }
                        default: {
                            this.jj_la1[61] = this.jj_gen;
                            break block13;
                        }
                    }
                    this.jj_consume_token(8);
                }
            }
            default: {
                this.jj_la1[62] = this.jj_gen;
            }
        }
        this.jj_consume_token(5);
        return this.dialect.transformFN(functionName, parameters.toArray(new String[0]));
    }

    public final String CeilFloorDatetimeExpress() throws ParseException {
        ArrayList parameters = Lists.newArrayList();
        ImmutableSet timeunitSet = ImmutableSet.of((Object)"YEAR", (Object)"QUARTER", (Object)"MONTH", (Object)"WEEK", (Object)"DAY", (Object)"HOUR", (Object[])new String[]{"MINUTE", "SECOND"});
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 25: {
                this.jj_consume_token(25);
                break;
            }
            case 26: {
                this.jj_consume_token(26);
                break;
            }
            default: {
                this.jj_la1[63] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        String functionName = this.getToken((int)0).image;
        block22: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[64] = this.jj_gen;
                    break block22;
                }
            }
            this.jj_consume_token(8);
        }
        this.jj_consume_token(6);
        block23: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[65] = this.jj_gen;
                    break block23;
                }
            }
            this.jj_consume_token(8);
        }
        parameters.add(this.ParameterExpression().trim());
        block24: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[66] = this.jj_gen;
                    break block24;
                }
            }
            this.jj_consume_token(8);
        }
        block13 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                this.jj_consume_token(7);
                block25: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 8: {
                            break;
                        }
                        default: {
                            this.jj_la1[67] = this.jj_gen;
                            break block25;
                        }
                    }
                    this.jj_consume_token(8);
                }
                String timeUnit = StringUtils.trim((String)this.ParameterExpression());
                String unitToValidate = StringUtils.remove((String)timeUnit, (char)'\'');
                if (!timeunitSet.contains((Object)StringUtils.upperCase((String)unitToValidate))) {
                    throw new IllegalStateException(String.format(Locale.ROOT, CEIL_FLOOR_EXCEPTION_MSG, functionName, unitToValidate, String.join((CharSequence)", ", (Iterable<? extends CharSequence>)timeunitSet)));
                }
                parameters.add(timeUnit);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 8: {
                            break;
                        }
                        default: {
                            this.jj_la1[68] = this.jj_gen;
                            break block13;
                        }
                    }
                    this.jj_consume_token(8);
                }
            }
            default: {
                this.jj_la1[69] = this.jj_gen;
            }
        }
        this.jj_consume_token(5);
        return this.dialect.transformFN(functionName, parameters.toArray(new String[0]));
    }

    public final String PiFunction() throws ParseException {
        this.jj_consume_token(42);
        return this.dialect.transformNiladicFunction("PI");
    }

    public final String Hint() throws ParseException {
        this.jj_consume_token(17);
        log.trace("meet token <HINT>");
        return this.getToken((int)0).image;
    }

    public final String CubePriority() throws ParseException {
        this.jj_consume_token(18);
        log.trace("meet token <CubePriority>");
        return this.getToken((int)0).image;
    }

    public final String Numeric() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 19: {
                this.jj_consume_token(19);
                break;
            }
            case 21: {
                this.jj_consume_token(21);
                break;
            }
            case 20: {
                this.jj_consume_token(20);
                break;
            }
            default: {
                this.jj_la1[70] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        log.trace("meet token <APPROX_NUMERIC_LITERAL>");
        return this.getToken((int)0).image;
    }

    public final String EscapeFunction() throws ParseException {
        ArrayList parameters = Lists.newArrayList();
        ImmutableSet tsFunctions = ImmutableSet.of((Object)"TIMESTAMPDIFF", (Object)"TIMESTAMPADD");
        this.jj_consume_token(63);
        this.jj_consume_token(69);
        String functionName = this.getToken((int)0).image;
        this.jj_consume_token(6);
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[71] = this.jj_gen;
                    break block9;
                }
            }
            this.jj_consume_token(8);
        }
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                String param = this.ParameterExpression();
                if (tsFunctions.contains((Object)functionName.trim().toUpperCase(Locale.ROOT))) {
                    if (param.toUpperCase(Locale.ROOT).startsWith("SQL_TSI_")) {
                        param = param.toUpperCase(Locale.ROOT).replace("SQL_TSI_", "");
                    }
                    parameters.add(this.dialect.transformTimeunitOfTimestampDiffOrAdd(param));
                } else {
                    parameters.add(param);
                }
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 7: {
                            break;
                        }
                        default: {
                            this.jj_la1[72] = this.jj_gen;
                            break block3;
                        }
                    }
                    this.jj_consume_token(7);
                    this.EscapeFunctionParameter(parameters);
                }
            }
            default: {
                this.jj_la1[73] = this.jj_gen;
            }
        }
        this.jj_consume_token(5);
        return this.dialect.transformFN(functionName, parameters.toArray(new String[0]));
    }

    public final void EscapeFunctionParameter(List<String> paramCollection) throws ParseException {
        String parameter = "";
        parameter = this.ParameterExpression();
        paramCollection.add(parameter.trim());
    }

    public final String ParameterExpression() throws ParseException {
        String innerString = "";
        String nextString = "";
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 3: {
                innerString = this.EscapeExpress();
                break;
            }
            case 29: 
            case 30: {
                innerString = this.SubstringExpression();
                break;
            }
            case 38: {
                innerString = this.OverlayExpression();
                break;
            }
            case 40: {
                innerString = this.GroupingSetsExpression();
                break;
            }
            case 33: {
                innerString = this.CastExpression();
                break;
            }
            case 35: 
            case 36: {
                innerString = this.TsDiffOrAddExpression();
                break;
            }
            case 37: {
                innerString = this.ExtractExpression();
                break;
            }
            case 24: 
            case 27: {
                innerString = this.CeilFloorExpress();
                break;
            }
            case 25: 
            case 26: {
                innerString = this.CeilFloorDatetimeExpress();
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                innerString = this.Numeric();
                break;
            }
            case 17: {
                innerString = this.Hint();
                break;
            }
            case 18: {
                innerString = this.CubePriority();
                break;
            }
            case 6: {
                innerString = this.ParenExpress();
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                innerString = this.QuotedString();
                break;
            }
            case 16: {
                innerString = this.DoubleQuotedString();
                break;
            }
            case 8: {
                innerString = this.Space();
                break;
            }
            case 42: {
                innerString = this.PiFunction();
                break;
            }
            case 23: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                innerString = this.Punctuation();
                break;
            }
            case 43: {
                innerString = this.Any();
                break;
            }
            default: {
                this.jj_la1[74] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (this.jj_2_2(2)) {
            nextString = this.ParameterExpression();
        }
        return innerString + nextString;
    }

    public final String EscapeTimestamp() throws ParseException {
        this.jj_consume_token(64);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[75] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(8);
        }
        String timestampExpr = this.QuotedString();
        return "TIMESTAMP " + timestampExpr;
    }

    public final String EscapeDate() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 66: {
                this.jj_consume_token(66);
                break;
            }
            case 65: {
                this.jj_consume_token(65);
                break;
            }
            default: {
                this.jj_la1[76] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[77] = this.jj_gen;
                    break block7;
                }
            }
            this.jj_consume_token(8);
        }
        String timestampExpr = this.QuotedString();
        return "DATE " + timestampExpr;
    }

    public final String EscapeTime() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 67: {
                this.jj_consume_token(67);
                break;
            }
            case 68: {
                this.jj_consume_token(68);
                break;
            }
            default: {
                this.jj_la1[78] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[79] = this.jj_gen;
                    break block7;
                }
            }
            this.jj_consume_token(8);
        }
        String timestampExpr = this.QuotedString();
        return "TIME " + timestampExpr;
    }

    public final String BangEqual() throws ParseException {
        this.jj_consume_token(52);
        return "<>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    private boolean jj_3R_141() {
        return this.jj_scan_token(63);
    }

    private boolean jj_3R_140() {
        return this.jj_scan_token(13);
    }

    private boolean jj_3R_139() {
        return this.jj_scan_token(12);
    }

    private boolean jj_3R_113() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(19)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(21)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(20)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_138() {
        return this.jj_scan_token(11);
    }

    private boolean jj_3R_137() {
        return this.jj_scan_token(10);
    }

    private boolean jj_3R_119() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_137()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_138()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_139()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_140()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_107() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(30)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(29)) {
                return true;
            }
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(8));
        this.jj_scanpos = xsp;
        return this.jj_scan_token(6);
    }

    private boolean jj_3R_112() {
        return this.jj_scan_token(18);
    }

    private boolean jj_3R_120() {
        return this.jj_scan_token(16);
    }

    private boolean jj_3R_111() {
        return this.jj_scan_token(17);
    }

    private boolean jj_3R_124() {
        return this.jj_scan_token(42);
    }

    private boolean jj_3R_129() {
        return this.jj_scan_token(34);
    }

    private boolean jj_3R_128() {
        return this.jj_scan_token(28);
    }

    private boolean jj_3R_127() {
        return this.jj_scan_token(32);
    }

    private boolean jj_3R_110() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(36)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(35)) {
                return true;
            }
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(8));
        this.jj_scanpos = xsp;
        return this.jj_scan_token(6);
    }

    private boolean jj_3R_121() {
        return this.jj_scan_token(52);
    }

    private boolean jj_3R_126() {
        return this.jj_scan_token(31);
    }

    private boolean jj_3R_117() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(25)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(26)) {
                return true;
            }
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(8));
        this.jj_scanpos = xsp;
        return this.jj_scan_token(6);
    }

    private boolean jj_3R_144() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(67)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(68)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_125() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(23)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(49)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(50)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(51)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(52)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(44)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(45)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(46)) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_scan_token(53)) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_scan_token(47)) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_scan_token(48)) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_scan_token(54)) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_scan_token(55)) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_scan_token(56)) {
                                                                this.jj_scanpos = xsp;
                                                                if (this.jj_scan_token(57)) {
                                                                    this.jj_scanpos = xsp;
                                                                    if (this.jj_scan_token(58)) {
                                                                        this.jj_scanpos = xsp;
                                                                        if (this.jj_scan_token(59)) {
                                                                            this.jj_scanpos = xsp;
                                                                            if (this.jj_scan_token(61)) {
                                                                                this.jj_scanpos = xsp;
                                                                                if (this.jj_scan_token(62)) {
                                                                                    this.jj_scanpos = xsp;
                                                                                    if (this.jj_scan_token(60)) {
                                                                                        return true;
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_143() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(66)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(65)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_123() {
        return this.jj_scan_token(8);
    }

    private boolean jj_3R_115() {
        Token xsp;
        if (this.jj_scan_token(37)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(8));
        this.jj_scanpos = xsp;
        return this.jj_scan_token(6);
    }

    private boolean jj_3R_122() {
        return this.jj_scan_token(7);
    }

    private boolean jj_3R_142() {
        return this.jj_scan_token(64);
    }

    private boolean jj_3R_116() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(24)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(27)) {
                return true;
            }
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(8));
        this.jj_scanpos = xsp;
        return this.jj_scan_token(6);
    }

    private boolean jj_3R_86() {
        return this.jj_3R_130();
    }

    private boolean jj_3R_85() {
        return this.jj_3R_129();
    }

    private boolean jj_3R_84() {
        return this.jj_3R_128();
    }

    private boolean jj_3R_83() {
        return this.jj_3R_127();
    }

    private boolean jj_3R_82() {
        return this.jj_3R_126();
    }

    private boolean jj_3R_81() {
        return this.jj_3R_125();
    }

    private boolean jj_3R_80() {
        return this.jj_3R_124();
    }

    private boolean jj_3_2() {
        return this.jj_3R_61();
    }

    private boolean jj_3R_79() {
        return this.jj_3R_123();
    }

    private boolean jj_3R_78() {
        return this.jj_3R_122();
    }

    private boolean jj_3R_77() {
        return this.jj_3R_121();
    }

    private boolean jj_3R_76() {
        return this.jj_3R_120();
    }

    private boolean jj_3R_75() {
        return this.jj_3R_119();
    }

    private boolean jj_3R_105() {
        return this.jj_3R_130();
    }

    private boolean jj_3R_74() {
        return this.jj_3R_118();
    }

    private boolean jj_3R_104() {
        return this.jj_3R_125();
    }

    private boolean jj_3R_73() {
        return this.jj_3R_117();
    }

    private boolean jj_3R_103() {
        return this.jj_3R_124();
    }

    private boolean jj_3R_72() {
        return this.jj_3R_116();
    }

    private boolean jj_3R_102() {
        return this.jj_3R_123();
    }

    private boolean jj_3R_71() {
        return this.jj_3R_115();
    }

    private boolean jj_3R_101() {
        return this.jj_3R_120();
    }

    private boolean jj_3R_70() {
        return this.jj_3R_114();
    }

    private boolean jj_3R_100() {
        return this.jj_3R_119();
    }

    private boolean jj_3R_69() {
        return this.jj_3R_113();
    }

    private boolean jj_3R_99() {
        return this.jj_3R_118();
    }

    private boolean jj_3R_68() {
        return this.jj_3R_112();
    }

    private boolean jj_3R_114() {
        Token xsp;
        if (this.jj_scan_token(33)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(8));
        this.jj_scanpos = xsp;
        return this.jj_scan_token(6);
    }

    private boolean jj_3R_98() {
        return this.jj_3R_112();
    }

    private boolean jj_3R_67() {
        return this.jj_3R_111();
    }

    private boolean jj_3R_97() {
        return this.jj_3R_111();
    }

    private boolean jj_3R_66() {
        return this.jj_3R_110();
    }

    private boolean jj_3R_96() {
        return this.jj_3R_113();
    }

    private boolean jj_3R_65() {
        return this.jj_3R_109();
    }

    private boolean jj_3R_95() {
        return this.jj_3R_117();
    }

    private boolean jj_3R_64() {
        return this.jj_3R_108();
    }

    private boolean jj_3R_94() {
        return this.jj_3R_116();
    }

    private boolean jj_3R_63() {
        return this.jj_3R_107();
    }

    private boolean jj_3R_93() {
        return this.jj_3R_115();
    }

    private boolean jj_3R_92() {
        return this.jj_3R_110();
    }

    private boolean jj_3R_91() {
        return this.jj_3R_114();
    }

    private boolean jj_3R_62() {
        return this.jj_3R_106();
    }

    private boolean jj_3R_90() {
        return this.jj_3R_109();
    }

    private boolean jj_3R_89() {
        return this.jj_3R_108();
    }

    private boolean jj_3R_87() {
        return this.jj_3R_106();
    }

    private boolean jj_3R_88() {
        return this.jj_3R_107();
    }

    private boolean jj_3R_135() {
        Token xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(8));
        this.jj_scanpos = xsp;
        return this.jj_scan_token(41);
    }

    private boolean jj_3R_134() {
        return this.jj_3R_144();
    }

    private boolean jj_3R_133() {
        return this.jj_3R_143();
    }

    private boolean jj_3R_132() {
        return this.jj_3R_142();
    }

    private boolean jj_3R_131() {
        return this.jj_3R_141();
    }

    private boolean jj_3R_60() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_62()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_63()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_64()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_65()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_66()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_67()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_68()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_69()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_70()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3R_71()) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_3R_72()) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_3R_73()) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_3R_74()) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_3R_75()) {
                                                                this.jj_scanpos = xsp;
                                                                if (this.jj_3R_76()) {
                                                                    this.jj_scanpos = xsp;
                                                                    if (this.jj_3R_77()) {
                                                                        this.jj_scanpos = xsp;
                                                                        if (this.jj_3R_78()) {
                                                                            this.jj_scanpos = xsp;
                                                                            if (this.jj_3R_79()) {
                                                                                this.jj_scanpos = xsp;
                                                                                if (this.jj_3R_80()) {
                                                                                    this.jj_scanpos = xsp;
                                                                                    if (this.jj_3R_81()) {
                                                                                        this.jj_scanpos = xsp;
                                                                                        if (this.jj_3R_82()) {
                                                                                            this.jj_scanpos = xsp;
                                                                                            if (this.jj_3R_83()) {
                                                                                                this.jj_scanpos = xsp;
                                                                                                if (this.jj_3R_84()) {
                                                                                                    this.jj_scanpos = xsp;
                                                                                                    if (this.jj_3R_85()) {
                                                                                                        this.jj_scanpos = xsp;
                                                                                                        if (this.jj_3R_86()) {
                                                                                                            return true;
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_61() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_87()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_88()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_89()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_90()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_91()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_92()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_93()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_94()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_95()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3R_96()) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_3R_97()) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_3R_98()) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_3R_99()) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_3R_100()) {
                                                                this.jj_scanpos = xsp;
                                                                if (this.jj_3R_101()) {
                                                                    this.jj_scanpos = xsp;
                                                                    if (this.jj_3R_102()) {
                                                                        this.jj_scanpos = xsp;
                                                                        if (this.jj_3R_103()) {
                                                                            this.jj_scanpos = xsp;
                                                                            if (this.jj_3R_104()) {
                                                                                this.jj_scanpos = xsp;
                                                                                if (this.jj_3R_105()) {
                                                                                    return true;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_2()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_109() {
        if (this.jj_scan_token(40)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_135()) {
            this.jj_scanpos = xsp;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(8));
        this.jj_scanpos = xsp;
        return this.jj_scan_token(6);
    }

    private boolean jj_3R_106() {
        Token xsp;
        if (this.jj_scan_token(3)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(8));
        xsp = this.jj_scanpos = xsp;
        if (this.jj_3R_131()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_132()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_133()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_134()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_1() {
        return this.jj_3R_60();
    }

    private boolean jj_3R_136() {
        return this.jj_3R_60();
    }

    private boolean jj_3R_118() {
        Token xsp;
        if (this.jj_scan_token(6)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_136());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(5);
    }

    private boolean jj_3R_108() {
        Token xsp;
        if (this.jj_scan_token(38)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(8));
        this.jj_scanpos = xsp;
        return this.jj_scan_token(6);
    }

    private boolean jj_3R_130() {
        return this.jj_scan_token(43);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{-4244024, 0x800000, 15360, -4244024, 256, 0, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 0, 256, 256, 256, 256, 256, 256, 256, 0x60000000, 256, 256, 256, -2147483520, 256, 256, 128, 256, 384, 256, 256, 256, 256, 256, 256, -2147483520, 256, 256, 128, 256, 384, 256, 256, 256, 256, 256, 384, 256, 256, 256, 0x9000000, 256, 256, 256, 256, 256, 0x10000000, 0x6000000, 256, 256, 256, 256, 256, 128, 0x380000, 256, 128, 1874804040, 1874804040, 256, 0, 256, 0, 256};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0x7FFFFD7F, 0x7FFFF000, 0, 0x7FFFFD7F, 0, Integer.MIN_VALUE, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 512, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2147483002, 2147483002, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, 0, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 24, 0};
    }

    public WhiteSpaceParser(InputStream stream) {
        this(stream, null);
    }

    public WhiteSpaceParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new WhiteSpaceParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 80; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 80; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public WhiteSpaceParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new WhiteSpaceParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 80; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 80; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public WhiteSpaceParser(WhiteSpaceParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 80; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(WhiteSpaceParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 80; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[70];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 80; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) == 0) continue;
                la1tokens[64 + j] = true;
            }
        }
        for (i = 0; i < 70; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 2; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        WhiteSpaceParser.jj_la1_init_0();
        WhiteSpaceParser.jj_la1_init_1();
        WhiteSpaceParser.jj_la1_init_2();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

