/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.query.relnode.OlapJoinRel;
import org.apache.kylin.query.relnode.OlapRel;

public class RelAggPushDownUtil {
    private static final Pattern CTX_REMOVER = Pattern.compile(", ctx=\\[(.*?)]");

    private RelAggPushDownUtil() {
    }

    public static void clearUnmatchedJoinDigest() {
        QueryContext.current().getUnmatchedJoinDigest().clear();
    }

    public static boolean canRelAnsweredBySnapshot(String project, RelNode relNode) {
        List rightRelOptTableList = RelOptUtil.findAllTables((RelNode)relNode);
        if (rightRelOptTableList.size() != 1) {
            return false;
        }
        RelOptTable relOptTable = (RelOptTable)rightRelOptTableList.get(0);
        List qualifiedNameList = relOptTable.getQualifiedName();
        String identity = StringUtils.join((Iterable)qualifiedNameList, (String)".");
        TableDesc table = NTableMetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project).getTableDesc(identity);
        return table != null && StringUtils.isNotEmpty((CharSequence)table.getLastSnapshotPath());
    }

    public static void registerUnmatchedJoinDigest(RelNode relNode) {
        OlapJoinRel joinRel = RelAggPushDownUtil.collectFirstJoinRel(relNode);
        if (joinRel != null) {
            QueryContext.current().getUnmatchedJoinDigest().put(RelAggPushDownUtil.trimExplainInfo(joinRel), true);
        }
    }

    public static synchronized boolean isUnmatchedJoinRel(OlapJoinRel joinRel) {
        boolean unmatched;
        boolean bl = unmatched = QueryContext.current().getUnmatchedJoinDigest().get(RelAggPushDownUtil.trimExplainInfo(joinRel)) != null;
        if (unmatched) {
            QueryContext.current().getUnmatchedJoinDigest().clear();
            QueryContext.current().getUnmatchedJoinDigest().put(RelAggPushDownUtil.trimExplainInfo(joinRel), true);
        }
        return unmatched;
    }

    private static String trimExplainInfo(OlapJoinRel rel) {
        return CTX_REMOVER.matcher(rel.explain()).replaceAll("");
    }

    public static OlapJoinRel collectFirstJoinRel(RelNode relNode) {
        if (relNode == null || CollectionUtils.isEmpty((Collection)relNode.getInputs())) {
            return null;
        }
        if (relNode instanceof OlapJoinRel) {
            return (OlapJoinRel)relNode;
        }
        return RelAggPushDownUtil.collectFirstJoinRel(relNode.getInput(0));
    }

    public static void collectAllJoinRel(RelNode relNode) {
        if (relNode instanceof OlapJoinRel) {
            QueryContext.current().getUnmatchedJoinDigest().put(RelAggPushDownUtil.trimExplainInfo((OlapJoinRel)relNode), true);
        }
        for (RelNode rel : relNode.getInputs()) {
            RelAggPushDownUtil.collectAllJoinRel(rel);
        }
    }

    public static void clearCtxRelNode(RelNode relNode) {
        List relNodes = relNode.getInputs();
        for (RelNode childNode : relNodes) {
            OlapRel olapRel = (OlapRel)childNode;
            if (olapRel.getContext() != null) {
                olapRel.setContext(null);
            }
            RelAggPushDownUtil.clearCtxRelNode(childNode);
        }
    }
}

