/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.calcite.adapter.enumerable.EnumerableCalc;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlLikeOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableSet;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.query.calcite.KylinRelDataTypeSystem;
import org.apache.kylin.query.relnode.ColumnRowType;
import org.apache.kylin.query.relnode.ContextUtil;
import org.apache.kylin.query.relnode.OlapContext;
import org.apache.kylin.query.relnode.OlapRel;
import org.apache.kylin.query.relnode.OlapTableScan;
import org.apache.kylin.query.relnode.TableColRefWithRel;
import org.apache.kylin.query.util.ICutContextStrategy;
import org.apache.kylin.query.util.RexToTblColRefTranslator;
import org.apache.kylin.query.util.RexUtils;

public class OlapFilterRel
extends Filter
implements OlapRel {
    private static final Map<SqlKind, SqlKind> REVERSE_OP_MAP = Maps.newHashMap();
    private ColumnRowType columnRowType;
    private OlapContext context;
    private Set<OlapContext> subContexts = Sets.newHashSet();
    private boolean belongToPreAggContext = false;

    public OlapFilterRel(RelOptCluster cluster, RelTraitSet traits, RelNode child, RexNode condition) {
        super(cluster, traits, child, condition);
        Preconditions.checkArgument((this.getConvention() == CONVENTION ? 1 : 0) != 0);
        this.rowType = this.getRowType();
    }

    private ColumnRowType buildColumnRowType() {
        OlapRel olapChild = (OlapRel)this.getInput();
        return olapChild.getColumnRowType();
    }

    @Override
    public EnumerableRel implementEnumerable(List<EnumerableRel> inputs) {
        RexBuilder rexBuilder = this.getCluster().getRexBuilder();
        RelDataType inputRowType = this.getInput().getRowType();
        RexProgramBuilder programBuilder = new RexProgramBuilder(inputRowType, rexBuilder);
        programBuilder.addIdentity();
        programBuilder.addCondition(this.condition);
        RexProgram program = programBuilder.getProgram();
        return new EnumerableCalc(this.getCluster(), this.getCluster().traitSetOf((RelTrait)EnumerableConvention.INSTANCE), (RelNode)OlapFilterRel.sole(inputs), program);
    }

    @Override
    public boolean hasSubQuery() {
        OlapRel olapChild = (OlapRel)this.getInput();
        return olapChild.hasSubQuery();
    }

    @Override
    public RelTraitSet replaceTraitSet(RelTrait trait) {
        RelTraitSet oldTraitSet = this.traitSet;
        this.traitSet = this.traitSet.replace(trait);
        return oldTraitSet;
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("ctx", (Object)this.displayCtxId(this.context));
    }

    public Filter copy(RelTraitSet traitSet, RelNode input, RexNode condition) {
        return new OlapFilterRel(this.getCluster(), traitSet, input, condition);
    }

    @Override
    public void implementCutContext(ICutContextStrategy.ContextCutImpl contextCutImpl) {
        this.context = null;
        this.columnRowType = null;
        this.belongToPreAggContext = false;
        contextCutImpl.visitChild(this.getInput());
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return Objects.requireNonNull(super.computeSelfCost(planner, mq)).multiplyBy(0.05).multiplyBy(this.calcComplexity());
    }

    private double calcComplexity() {
        int complexity = 1 + this.getCondition().toString().length();
        return Math.exp(-1.0 / (double)complexity);
    }

    @Override
    public void setContext(OlapContext context) {
        this.context = context;
        ((OlapRel)this.getInput()).setContext(context);
        this.subContexts.addAll(ContextUtil.collectSubContext(this.getInput()));
    }

    @Override
    public boolean pushRelInfoToContext(OlapContext context) {
        if (this.context == null && ((OlapRel)this.getInput()).pushRelInfoToContext(context)) {
            this.context = context;
            this.belongToPreAggContext = true;
            return true;
        }
        return false;
    }

    @Override
    public void implementContext(OlapRel.ContextImpl contextImpl, OlapRel.ContextVisitorState state) {
        contextImpl.fixSharedOlapTableScan((SingleRel)this);
        OlapRel.ContextVisitorState tempState = OlapRel.ContextVisitorState.init();
        contextImpl.visitChild(this.getInput(), this, tempState);
        state.merge(OlapRel.ContextVisitorState.of(true, false)).merge(tempState);
        this.subContexts.addAll(ContextUtil.collectSubContext(this.getInput()));
    }

    @Override
    public void implementOlap(OlapRel.OlapImpl olapImpl) {
        olapImpl.visitChild(this.getInput(), this);
        if (RexUtils.countOperatorCall(this.condition, SqlLikeOperator.class) > 0) {
            QueryContext.current().getQueryTagInfo().setHasLike(true);
        }
        this.columnRowType = this.buildColumnRowType();
        if (this.context != null) {
            if (!this.context.isAfterAggregate()) {
                this.collectContextFilter();
            } else {
                this.context.setAfterHavingClauseFilter(true);
            }
            if (this == this.context.getTopNode() && !this.context.isHasAgg()) {
                ContextUtil.amendAllColsIfNoAgg(this);
            }
        } else {
            this.pushDownColsInfo(this.subContexts);
        }
    }

    private boolean isHeterogeneousSegmentOrMultiPartEnabled(OlapContext context) {
        if (context.getOlapSchema() == null) {
            return false;
        }
        KylinConfig kylinConfig = context.getOlapSchema().getConfig();
        return kylinConfig.isHeterogeneousSegmentEnabled() || kylinConfig.isMultiPartitionEnabled();
    }

    private boolean isJoinMatchOptimizationEnabled() {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        if (this.context != null && this.context.getOlapSchema() != null) {
            kylinConfig = this.context.getOlapSchema().getConfig();
        }
        return kylinConfig.isJoinMatchOptimizationEnabled();
    }

    private void collectNotNullTableWithFilterCondition(OlapContext context) {
        if (context == null || CollectionUtils.isEmpty(context.getAllTableScans())) {
            return;
        }
        RexBuilder rexBuilder = new RexBuilder((RelDataTypeFactory)new JavaTypeFactoryImpl((RelDataTypeSystem)new KylinRelDataTypeSystem()));
        RexNode newDnf = RexUtil.toDnf((RexBuilder)rexBuilder, (RexNode)this.condition);
        Set leftOrInnerTables = context.getAllTableScans().stream().map(OlapTableScan::getTableRef).collect(Collectors.toSet());
        HashSet orNotNullTables = Sets.newHashSet();
        MatchWithFilterVisitor visitor = new MatchWithFilterVisitor(this.columnRowType, orNotNullTables);
        if (SqlStdOperatorTable.OR.equals((Object)((RexCall)newDnf).getOperator())) {
            for (RexNode rexNode : ((RexCall)newDnf).getOperands()) {
                rexNode.accept((RexVisitor)visitor);
                leftOrInnerTables.retainAll(orNotNullTables);
                orNotNullTables.clear();
            }
        } else {
            newDnf.accept((RexVisitor)visitor);
            leftOrInnerTables.retainAll(orNotNullTables);
        }
        context.getNotNullTables().addAll(leftOrInnerTables);
    }

    private void collectContextFilter() {
        HashSet filterColumns = Sets.newHashSet();
        FilterVisitor visitor = new FilterVisitor(this.columnRowType, filterColumns);
        this.condition.accept((RexVisitor)visitor);
        if (this.isHeterogeneousSegmentOrMultiPartEnabled(this.context)) {
            this.context.getAllFilterRels().add(this);
        }
        if (this.isJoinMatchOptimizationEnabled()) {
            this.collectNotNullTableWithFilterCondition(this.context);
        }
        for (TblColRef tblColRef : filterColumns) {
            if (tblColRef.isInnerColumn() || !this.context.belongToContextTables(tblColRef)) continue;
            this.context.getAllColumns().add(tblColRef);
            this.context.getFilterColumns().add(tblColRef);
        }
        this.context.getInnerFilterColumns().addAll(this.collectInnerColumnInFilter());
    }

    private Collection<TableColRefWithRel> collectInnerColumnInFilter() {
        HashSet<TableColRefWithRel> resultSet = new HashSet<TableColRefWithRel>();
        if (this.condition instanceof RexCall) {
            for (RexNode childCondition : ((RexCall)this.condition).getOperands()) {
                this.doCollectInnerColumnInFilter(childCondition, resultSet);
            }
        }
        return resultSet;
    }

    private void doCollectInnerColumnInFilter(RexNode rexNode, Collection<TableColRefWithRel> resultSet) {
        if (rexNode instanceof RexCall) {
            RexCall rexCall = (RexCall)rexNode;
            SqlKind sqlKind = rexCall.getOperator().kind;
            if (sqlKind == SqlKind.AND || sqlKind == SqlKind.OR || SqlKind.COMPARISON.contains(sqlKind) || sqlKind == SqlKind.NOT_IN || sqlKind == SqlKind.LIKE || sqlKind == SqlKind.SIMILAR || sqlKind == SqlKind.BETWEEN || sqlKind.name().startsWith("IS_")) {
                rexCall.getOperands().forEach(childRexNode -> this.doCollectInnerColumnInFilter((RexNode)childRexNode, resultSet));
            } else {
                TblColRef colRef;
                try {
                    colRef = RexToTblColRefTranslator.translateRexNode((RexNode)rexCall, ((OlapRel)this.input).getColumnRowType());
                }
                catch (IllegalStateException e) {
                    return;
                }
                if (colRef.isInnerColumn() && !colRef.getSourceColumns().isEmpty()) {
                    resultSet.add(new TableColRefWithRel(this, colRef));
                }
            }
        }
    }

    @Override
    public void implementRewrite(OlapRel.RewriteImpl rewriteImpl) {
        rewriteImpl.visitChild(this, this.getInput());
        if (this.context != null) {
            this.rowType = this.deriveRowType();
            this.columnRowType = this.buildColumnRowType();
        }
    }

    private void pushDownColsInfo(Set<OlapContext> subContexts) {
        for (OlapContext subCtx : subContexts) {
            if (this.condition == null) {
                return;
            }
            HashSet filterColumns = Sets.newHashSet();
            FilterVisitor visitor = new FilterVisitor(this.columnRowType, filterColumns);
            this.condition.accept((RexVisitor)visitor);
            if (this.isHeterogeneousSegmentOrMultiPartEnabled(subCtx)) {
                subCtx.getAllFilterRels().add(this);
            }
            if (this.isJoinMatchOptimizationEnabled()) {
                this.collectNotNullTableWithFilterCondition(subCtx);
            }
            for (TblColRef tblColRef : filterColumns) {
                if (tblColRef.isInnerColumn() || !subCtx.belongToContextTables(tblColRef)) continue;
                subCtx.getAllColumns().add(tblColRef);
                subCtx.getFilterColumns().add(tblColRef);
                if (!this.belongToPreAggContext) continue;
                subCtx.getGroupByColumns().add(tblColRef);
            }
        }
    }

    @Override
    public void setSubContexts(Set<OlapContext> contexts) {
        this.subContexts = contexts;
    }

    @Override
    @Generated
    public ColumnRowType getColumnRowType() {
        return this.columnRowType;
    }

    @Override
    @Generated
    public OlapContext getContext() {
        return this.context;
    }

    @Override
    @Generated
    public Set<OlapContext> getSubContexts() {
        return this.subContexts;
    }

    @Generated
    private boolean isBelongToPreAggContext() {
        return this.belongToPreAggContext;
    }

    static {
        REVERSE_OP_MAP.put(SqlKind.EQUALS, SqlKind.NOT_EQUALS);
        REVERSE_OP_MAP.put(SqlKind.NOT_EQUALS, SqlKind.EQUALS);
        REVERSE_OP_MAP.put(SqlKind.GREATER_THAN, SqlKind.LESS_THAN_OR_EQUAL);
        REVERSE_OP_MAP.put(SqlKind.LESS_THAN_OR_EQUAL, SqlKind.GREATER_THAN);
        REVERSE_OP_MAP.put(SqlKind.LESS_THAN, SqlKind.GREATER_THAN_OR_EQUAL);
        REVERSE_OP_MAP.put(SqlKind.GREATER_THAN_OR_EQUAL, SqlKind.LESS_THAN);
        REVERSE_OP_MAP.put(SqlKind.IS_NULL, SqlKind.IS_NOT_NULL);
        REVERSE_OP_MAP.put(SqlKind.IS_NOT_NULL, SqlKind.IS_NULL);
        REVERSE_OP_MAP.put(SqlKind.AND, SqlKind.OR);
        REVERSE_OP_MAP.put(SqlKind.OR, SqlKind.AND);
    }

    private static class MatchWithFilterVisitor
    extends RexVisitorImpl<RexNode> {
        static final Set<SqlOperator> NULL_OPERATORS = ImmutableSet.of((Object)SqlStdOperatorTable.IS_NULL, (Object)SqlStdOperatorTable.IS_NOT_TRUE);
        private final ColumnRowType columnRowType;
        private final Set<TableRef> notNullTables;

        protected MatchWithFilterVisitor(ColumnRowType columnRowType, Set<TableRef> notNullTables) {
            super(true);
            this.columnRowType = columnRowType;
            this.notNullTables = notNullTables;
        }

        public RexCall visitCall(RexCall call) {
            if (!this.deep) {
                return null;
            }
            RexCall r = null;
            if (SqlStdOperatorTable.CASE.equals((Object)call.getOperator())) {
                List rexNodes = call.getOperands();
                boolean isOpNull = SqlStdOperatorTable.IS_NULL.equals((Object)((RexCall)rexNodes.get(0)).getOperator());
                boolean isSecondFalse = ((RexNode)call.getOperands().get(1)).isAlwaysFalse();
                if (isOpNull && isSecondFalse) {
                    r = (RexCall)((RexNode)call.getOperands().get(2)).accept((RexVisitor)this);
                    return r;
                }
                return null;
            }
            if (NULL_OPERATORS.contains(call.getOperator())) {
                return null;
            }
            for (RexNode operand : call.operands) {
                r = (RexCall)operand.accept((RexVisitor)this);
            }
            return r;
        }

        public RexCall visitInputRef(RexInputRef inputRef) {
            TableRef notNullTable = this.columnRowType.getColumnByIndex(inputRef.getIndex()).getTableRef();
            this.notNullTables.add(notNullTable);
            return null;
        }
    }

    private static class FilterVisitor
    extends RexVisitorImpl<Void> {
        final ColumnRowType inputRowType;
        final Set<TblColRef> filterColumns;
        final Deque<TblColRef.FilterColEnum> tmpLevels;
        final Deque<Boolean> reverses;

        public FilterVisitor(ColumnRowType inputRowType, Set<TblColRef> filterColumns) {
            super(true);
            this.inputRowType = inputRowType;
            this.filterColumns = filterColumns;
            this.tmpLevels = new ArrayDeque<TblColRef.FilterColEnum>();
            this.tmpLevels.offerLast(TblColRef.FilterColEnum.NONE);
            this.reverses = new ArrayDeque<Boolean>();
            this.reverses.offerLast(false);
        }

        public Void visitCall(RexCall call) {
            SqlOperator op = call.getOperator();
            SqlKind kind = op.getKind();
            if (kind == SqlKind.CAST || kind == SqlKind.REINTERPRET) {
                for (RexNode operand2 : call.operands) {
                    operand2.accept((RexVisitor)this);
                }
                return null;
            }
            if (op.getKind() == SqlKind.NOT) {
                this.reverses.offerLast(Boolean.FALSE.equals(this.reverses.peekLast()));
            } else {
                assert (this.reverses.peekLast() != null);
                if (this.reverses.peekLast().booleanValue()) {
                    kind = (SqlKind)REVERSE_OP_MAP.get(kind);
                    this.reverses.offerLast(kind == SqlKind.AND || kind == SqlKind.OR);
                } else {
                    this.reverses.offerLast(false);
                }
            }
            TblColRef.FilterColEnum tmpLevel = this.getFilterColEnum(kind);
            this.tmpLevels.offerLast(tmpLevel);
            call.operands.forEach(operand -> {
                Void cfr_ignored_0 = (Void)operand.accept((RexVisitor)this);
            });
            this.tmpLevels.pollLast();
            this.reverses.pollLast();
            return null;
        }

        private TblColRef.FilterColEnum getFilterColEnum(SqlKind kind) {
            TblColRef.FilterColEnum tmpLevel = kind == SqlKind.EQUALS ? TblColRef.FilterColEnum.EQUAL_FILTER : (kind == SqlKind.IS_NULL ? TblColRef.FilterColEnum.INFERIOR_EQUAL_FILTER : (this.isRangeFilter(kind) ? TblColRef.FilterColEnum.RANGE_FILTER : (kind == SqlKind.LIKE ? TblColRef.FilterColEnum.LIKE_FILTER : TblColRef.FilterColEnum.OTHER_FILTER)));
            return tmpLevel;
        }

        boolean isRangeFilter(SqlKind sqlKind) {
            return sqlKind == SqlKind.NOT_EQUALS || sqlKind == SqlKind.GREATER_THAN || sqlKind == SqlKind.LESS_THAN || sqlKind == SqlKind.GREATER_THAN_OR_EQUAL || sqlKind == SqlKind.LESS_THAN_OR_EQUAL || sqlKind == SqlKind.IS_NOT_NULL;
        }

        public Void visitInputRef(RexInputRef inputRef) {
            TblColRef column = this.inputRowType.getColumnByIndex(inputRef.getIndex());
            TblColRef.FilterColEnum tmpLevel = this.tmpLevels.peekLast();
            this.collect(column, tmpLevel);
            return null;
        }

        private void collect(TblColRef column, TblColRef.FilterColEnum tmpLevel) {
            if (!column.isInnerColumn()) {
                this.filterColumns.add(column);
                if (tmpLevel.getPriority() > column.getFilterLevel().getPriority()) {
                    column.setFilterLevel(tmpLevel);
                }
                return;
            }
            if (column.isAggregationColumn()) {
                return;
            }
            List children = column.getOperands();
            if (children == null) {
                return;
            }
            for (TblColRef child : children) {
                this.collect(child, tmpLevel);
            }
        }
    }
}

