/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.config.initialize;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.metadata.asynctask.AbstractAsyncTask;
import org.apache.kylin.metadata.asynctask.MetadataRestoreTask;
import org.apache.kylin.metadata.favorite.AsyncTaskManager;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.rest.reponse.MetadataBackupResponse;
import org.apache.kylin.rest.service.OpsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;

@Configuration
public class OpsAppInitializer {
    public final Logger log = LoggerFactory.getLogger(OpsAppInitializer.class);

    @EventListener(value={ApplicationReadyEvent.class})
    public void beforeStarted() throws IOException {
        this.checkMetadataRestoreTaskStatus();
        this.checkMetadataBackupTaskStatus();
    }

    public void checkMetadataRestoreTaskStatus() {
        this.log.info("start to check metadata restore task status.");
        long startTime = System.currentTimeMillis();
        AsyncTaskManager manger = AsyncTaskManager.getInstance((String)"");
        List asyncTask = manger.getAllAsyncTaskByType("metadata_recover_task");
        for (AbstractAsyncTask abstractAsyncTask : asyncTask) {
            MetadataRestoreTask task = MetadataRestoreTask.copyFromAbstractTask((AbstractAsyncTask)abstractAsyncTask);
            if (MetadataRestoreTask.MetadataRestoreStatus.IN_PROGRESS != task.getStatus()) continue;
            this.log.info("mark in progress metadata restore task {} as failed.", (Object)task.getTaskKey());
            task.setStatus(MetadataRestoreTask.MetadataRestoreStatus.FAILED);
            manger.save((AbstractAsyncTask)task);
        }
        this.log.info("finished check metadata restore task status in {} ms", (Object)(System.currentTimeMillis() - startTime));
    }

    public void checkMetadataBackupTaskStatus() throws IOException {
        this.log.info("start to check metadata backup status");
        long startTime = System.currentTimeMillis();
        List projectList = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).listAllProjects().stream().map(ProjectInstance::toString).collect(Collectors.toList());
        projectList.add("_global");
        for (String project : projectList) {
            for (MetadataBackupResponse metadataBackup : OpsService.getMetadataBackupList((String)project)) {
                if (OpsService.MetadataBackupStatus.IN_PROGRESS != metadataBackup.getStatus()) continue;
                OpsService.MetadataBackup operator = new OpsService.MetadataBackup(metadataBackup, project);
                operator.markFail();
            }
        }
        this.log.info("finished check metadata backup status in {} ms", (Object)(System.currentTimeMillis() - startTime));
    }
}

