/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.bisync.tableau.datasource;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.kylin.tool.bisync.tableau.datasource.Aliases;
import org.apache.kylin.tool.bisync.tableau.datasource.DrillPaths;
import org.apache.kylin.tool.bisync.tableau.datasource.Layout;
import org.apache.kylin.tool.bisync.tableau.datasource.SemanticValueList;
import org.apache.kylin.tool.bisync.tableau.datasource.TableauConnection;
import org.apache.kylin.tool.bisync.tableau.datasource.column.Column;

@JacksonXmlRootElement(localName="datasource")
public class TableauDatasource
implements Serializable {
    @JacksonXmlProperty(localName="formatted-name", isAttribute=true)
    private String formattedName;
    @JacksonXmlProperty(localName="inline", isAttribute=true)
    private String inline;
    @JacksonXmlProperty(localName="source-platform", isAttribute=true)
    private String sourcePlatform;
    @JacksonXmlProperty(localName="version", isAttribute=true)
    private String version;
    @JacksonXmlProperty(localName="connection")
    private TableauConnection tableauConnection;
    @JacksonXmlProperty(localName="aliases")
    private Aliases aliases;
    @JacksonXmlProperty(localName="column")
    @JacksonXmlElementWrapper(useWrapping=false)
    private List<Column> columns;
    @JacksonXmlProperty(localName="drill-paths")
    private DrillPaths drillPaths;
    @JacksonXmlProperty(localName="layout")
    private Layout layout;
    @JacksonXmlProperty(localName="semantic-values")
    private SemanticValueList semanticValues;

    public String getFormattedName() {
        return this.formattedName;
    }

    public void setFormattedName(String formattedName) {
        this.formattedName = formattedName;
    }

    public String getInline() {
        return this.inline;
    }

    public void setInline(String inline) {
        this.inline = inline;
    }

    public String getSourcePlatform() {
        return this.sourcePlatform;
    }

    public void setSourcePlatform(String sourcePlatform) {
        this.sourcePlatform = sourcePlatform;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public TableauConnection getTableauConnection() {
        return this.tableauConnection;
    }

    public void setTableauConnection(TableauConnection tableauConnection) {
        this.tableauConnection = tableauConnection;
    }

    public Aliases getAliases() {
        return this.aliases;
    }

    public void setAliases(Aliases aliases) {
        this.aliases = aliases;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public void setColumns(List<Column> columns) {
        this.columns = columns;
    }

    public Layout getLayout() {
        return this.layout;
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    public SemanticValueList getSemanticValues() {
        return this.semanticValues;
    }

    public void setSemanticValues(SemanticValueList semanticValues) {
        this.semanticValues = semanticValues;
    }

    public DrillPaths getDrillPaths() {
        return this.drillPaths;
    }

    public void setDrillPaths(DrillPaths drillPaths) {
        this.drillPaths = drillPaths;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TableauDatasource)) {
            return false;
        }
        TableauDatasource that = (TableauDatasource)o;
        return Objects.equals(this.getTableauConnection(), that.getTableauConnection()) && this.columnListEquals(that.getColumns()) && Objects.equals(this.getDrillPaths(), that.getDrillPaths());
    }

    public int hashCode() {
        return Objects.hash(this.getTableauConnection(), this.getColumns(), this.getDrillPaths());
    }

    private boolean columnListEquals(List<Column> thatColumnList) {
        if (this.getColumns() == thatColumnList) {
            return true;
        }
        if (this.getColumns() != null && thatColumnList != null && this.getColumns().size() == thatColumnList.size()) {
            Comparator columnComparator = (o1, o2) -> o1.getName().compareTo(o2.getName());
            Collections.sort(this.getColumns(), columnComparator);
            Collections.sort(thatColumnList, columnComparator);
            boolean flag = true;
            for (int i = 0; i < this.getColumns().size() && flag; ++i) {
                flag = Objects.equals(this.getColumns().get(i), thatColumnList.get(i));
            }
            return flag;
        }
        return false;
    }
}

