/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.PartitionDesc;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.rest.response.FusionModelResponse;
import org.apache.kylin.rest.response.NDataModelResponse;
import org.apache.kylin.rest.response.NDataSegmentResponse;
import org.apache.kylin.rest.response.SimplifiedMeasure;
import org.apache.kylin.rest.response.SimplifiedTableResponse;
import org.springframework.beans.BeanUtils;

public class NDataModelLiteResponse
extends NDataModelResponse {
    @JsonProperty(value="empty_model")
    private boolean emptyModel;
    @JsonProperty(value="partition_column_in_dims")
    private boolean partitionColumnInDims;
    @JsonProperty(value="batch_id")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String batchId;
    @JsonProperty(value="streaming_indexes")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Long streamingIndexes;
    @JsonProperty(value="batch_partition_desc")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private PartitionDesc batchPartitionDesc;
    @JsonProperty(value="batch_segment_holes")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<SegmentRange> batchSegmentHoles;
    @JsonProperty(value="batch_segments")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<NDataSegmentResponse> batchSegments = new ArrayList<NDataSegmentResponse>();

    public NDataModelLiteResponse(NDataModelResponse response, NDataModel dataModel) {
        super(dataModel);
        if (dataModel.isFusionModel()) {
            FusionModelResponse fusionModelResponse = (FusionModelResponse)response;
            this.setBatchId(fusionModelResponse.getBatchId());
            this.setBatchPartitionDesc(fusionModelResponse.getBatchPartitionDesc());
            this.setStreamingIndexes(fusionModelResponse.getStreamingIndexes());
            this.setBatchSegmentHoles(fusionModelResponse.getBatchSegmentHoles());
        }
        BeanUtils.copyProperties((Object)((Object)response), (Object)((Object)this));
    }

    @Override
    @JsonProperty(value="simplified_tables")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<SimplifiedTableResponse> getSimpleTables() {
        return Collections.emptyList();
    }

    @Override
    @JsonProperty(value="selected_columns")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<NDataModelResponse.SimplifiedNamedColumn> getSelectedColumns() {
        return Collections.emptyList();
    }

    @Override
    @JsonProperty(value="simplified_dimensions")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<NDataModelResponse.SimplifiedNamedColumn> getNamedColumns() {
        return Collections.emptyList();
    }

    @JsonProperty(value="all_named_columns")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<NDataModel.NamedColumn> getAllNamedColumns() {
        return Collections.emptyList();
    }

    @Override
    @JsonProperty(value="all_measures")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<NDataModel.Measure> getMeasures() {
        return Collections.emptyList();
    }

    @Override
    @JsonProperty(value="simplified_measures")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<SimplifiedMeasure> getSimplifiedMeasures() {
        return Collections.emptyList();
    }

    @Override
    @JsonProperty(value="segments")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<NDataSegmentResponse> getSegments() {
        return Collections.emptyList();
    }

    @JsonIgnore
    public List<NDataSegmentResponse> getRealSegments() {
        return super.getSegments();
    }

    @Override
    @Generated
    public boolean isEmptyModel() {
        return this.emptyModel;
    }

    @Override
    @Generated
    public boolean isPartitionColumnInDims() {
        return this.partitionColumnInDims;
    }

    @Generated
    public String getBatchId() {
        return this.batchId;
    }

    @Generated
    public Long getStreamingIndexes() {
        return this.streamingIndexes;
    }

    @Generated
    public PartitionDesc getBatchPartitionDesc() {
        return this.batchPartitionDesc;
    }

    @Generated
    public List<SegmentRange> getBatchSegmentHoles() {
        return this.batchSegmentHoles;
    }

    @Generated
    public List<NDataSegmentResponse> getBatchSegments() {
        return this.batchSegments;
    }

    @Generated
    public void setEmptyModel(boolean emptyModel) {
        this.emptyModel = emptyModel;
    }

    @Generated
    public void setPartitionColumnInDims(boolean partitionColumnInDims) {
        this.partitionColumnInDims = partitionColumnInDims;
    }

    @Generated
    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    @Generated
    public void setStreamingIndexes(Long streamingIndexes) {
        this.streamingIndexes = streamingIndexes;
    }

    @Generated
    public void setBatchPartitionDesc(PartitionDesc batchPartitionDesc) {
        this.batchPartitionDesc = batchPartitionDesc;
    }

    @Generated
    public void setBatchSegmentHoles(List<SegmentRange> batchSegmentHoles) {
        this.batchSegmentHoles = batchSegmentHoles;
    }

    @Generated
    public void setBatchSegments(List<NDataSegmentResponse> batchSegments) {
        this.batchSegments = batchSegments;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NDataModelLiteResponse)) {
            return false;
        }
        NDataModelLiteResponse other = (NDataModelLiteResponse)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isEmptyModel() != other.isEmptyModel()) {
            return false;
        }
        if (this.isPartitionColumnInDims() != other.isPartitionColumnInDims()) {
            return false;
        }
        String this$batchId = this.getBatchId();
        String other$batchId = other.getBatchId();
        if (this$batchId == null ? other$batchId != null : !this$batchId.equals(other$batchId)) {
            return false;
        }
        Long this$streamingIndexes = this.getStreamingIndexes();
        Long other$streamingIndexes = other.getStreamingIndexes();
        if (this$streamingIndexes == null ? other$streamingIndexes != null : !((Object)this$streamingIndexes).equals(other$streamingIndexes)) {
            return false;
        }
        PartitionDesc this$batchPartitionDesc = this.getBatchPartitionDesc();
        PartitionDesc other$batchPartitionDesc = other.getBatchPartitionDesc();
        if (this$batchPartitionDesc == null ? other$batchPartitionDesc != null : !this$batchPartitionDesc.equals(other$batchPartitionDesc)) {
            return false;
        }
        List<SegmentRange> this$batchSegmentHoles = this.getBatchSegmentHoles();
        List<SegmentRange> other$batchSegmentHoles = other.getBatchSegmentHoles();
        if (this$batchSegmentHoles == null ? other$batchSegmentHoles != null : !((Object)this$batchSegmentHoles).equals(other$batchSegmentHoles)) {
            return false;
        }
        List<NDataSegmentResponse> this$batchSegments = this.getBatchSegments();
        List<NDataSegmentResponse> other$batchSegments = other.getBatchSegments();
        return !(this$batchSegments == null ? other$batchSegments != null : !((Object)this$batchSegments).equals(other$batchSegments));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof NDataModelLiteResponse;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isEmptyModel() ? 79 : 97);
        result = result * 59 + (this.isPartitionColumnInDims() ? 79 : 97);
        String $batchId = this.getBatchId();
        result = result * 59 + ($batchId == null ? 43 : $batchId.hashCode());
        Long $streamingIndexes = this.getStreamingIndexes();
        result = result * 59 + ($streamingIndexes == null ? 43 : ((Object)$streamingIndexes).hashCode());
        PartitionDesc $batchPartitionDesc = this.getBatchPartitionDesc();
        result = result * 59 + ($batchPartitionDesc == null ? 43 : $batchPartitionDesc.hashCode());
        List<SegmentRange> $batchSegmentHoles = this.getBatchSegmentHoles();
        result = result * 59 + ($batchSegmentHoles == null ? 43 : ((Object)$batchSegmentHoles).hashCode());
        List<NDataSegmentResponse> $batchSegments = this.getBatchSegments();
        result = result * 59 + ($batchSegments == null ? 43 : ((Object)$batchSegments).hashCode());
        return result;
    }
}

