/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.metadata.table.InternalTablePartitionDetail;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.request.InternalTableBuildRequest;
import org.apache.kylin.rest.request.InternalTableRequest;
import org.apache.kylin.rest.response.DataResult;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.response.InternalTableDescResponse;
import org.apache.kylin.rest.response.InternalTableLoadingJobResponse;
import org.apache.kylin.rest.service.InternalTableService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/internal_tables"}, produces={"application/vnd.apache.kylin-v4+json"})
public class InternalTableController
extends NBasicController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InternalTableController.class);
    @Autowired
    @Qualifier(value="internalTableService")
    private InternalTableService internalTableService;

    @ApiOperation(value="create_internal_table", tags={"AI"})
    @PostMapping(value={"/{database:.+}/{table:.+}"}, produces={"application/vnd.apache.kylin-v4+json"})
    @ResponseBody
    public EnvelopeResponse<String> createInternalTable(@RequestParam(value="project") String project, @PathVariable(value="database") String database, @PathVariable(value="table") String table, @RequestBody InternalTableRequest request) throws Exception {
        project = this.checkProjectName(project);
        if (StringUtils.isBlank((CharSequence)table) || StringUtils.isBlank((CharSequence)database)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_PARAMETER, "Table or database can not be null, please check again.");
        }
        this.internalTableService.createInternalTable(project, table, database, request.getPartitionCols(), request.getDatePartitionFormat(), request.getTblProperties(), request.getStorageType());
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="drop_internal_table", tags={"AI"})
    @DeleteMapping(value={"/{database:.+}/{table:.+}"}, produces={"application/vnd.apache.kylin-v4+json"})
    @ResponseBody
    public EnvelopeResponse<String> dropInternalTable(@RequestParam(value="project") String project, @PathVariable(value="database") String database, @PathVariable(value="table") String table) throws Exception {
        project = this.checkProjectName(project);
        String dbTblName = database + "." + table;
        this.internalTableService.dropInternalTable(project, dbTblName);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="truncate_internal_table", tags={"AI"})
    @DeleteMapping(value={"/truncate_internal_table"}, produces={"application/vnd.apache.kylin-v4+json"})
    @ResponseBody
    public EnvelopeResponse<String> truncateInternalTable(@RequestParam(value="project") String project, @RequestParam(value="database") String database, @RequestParam(value="table") String table) throws Exception {
        project = this.checkProjectName(project);
        if (StringUtils.isBlank((CharSequence)table) || StringUtils.isBlank((CharSequence)database)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_TABLE_NAME, MsgPicker.getMsg().getTableOrDatabaseNameCannotEmpty());
        }
        String tableIdentity = database + "." + table;
        this.internalTableService.truncateInternalTable(project, tableIdentity);
        return new EnvelopeResponse("000", null, "");
    }

    @ApiOperation(value="drop_table_partitions", tags={"AI"})
    @DeleteMapping(value={"/partitions"}, produces={"application/vnd.apache.kylin-v4+json"})
    @ResponseBody
    public EnvelopeResponse<String> dropPartitions(@RequestParam(value="project") String project, @RequestParam(value="database") String database, @RequestParam(value="table") String table, @RequestParam(value="partitions") String[] partitionValues) throws Exception {
        project = this.checkProjectName(project);
        if (StringUtils.isBlank((CharSequence)table) || StringUtils.isBlank((CharSequence)database)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_TABLE_NAME, MsgPicker.getMsg().getTableOrDatabaseNameCannotEmpty());
        }
        String tableIdentity = database + "." + table;
        this.internalTableService.dropPartitionsOnDeltaTable(project, tableIdentity, partitionValues, null);
        return new EnvelopeResponse("000", null, "");
    }

    @ApiOperation(value="load_into_internal", tags={"AI"})
    @PostMapping(value={"/{project:.+}/{database:.+}/{table:.+}"}, produces={"application/vnd.apache.kylin-v4+json"})
    @ResponseBody
    public EnvelopeResponse<InternalTableLoadingJobResponse> loadIntoInternalTable(@PathVariable(value="project") String project, @PathVariable(value="database") String database, @PathVariable(value="table") String table, @RequestBody InternalTableBuildRequest request) throws Exception {
        project = this.checkProjectName(project);
        if (StringUtils.isBlank((CharSequence)table) || StringUtils.isBlank((CharSequence)database)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_TABLE_NAME, MsgPicker.getMsg().getTableNameCannotEmpty());
        }
        InternalTableLoadingJobResponse response = this.internalTableService.loadIntoInternalTable(project, table, database, request.isIncremental(), request.isRefresh(), request.getStartDate(), request.getEndDate(), request.getPartitions(), request.getYarnQueue());
        return new EnvelopeResponse("000", (Object)response, "");
    }

    @ApiOperation(value="update_table", tags={"AI"})
    @PutMapping(value={"/{database:.+}/{table:.+}"}, produces={"application/vnd.apache.kylin-v4+json"})
    @ResponseBody
    public EnvelopeResponse<String> updateTable(@RequestParam(value="project") String project, @PathVariable(value="database") String database, @PathVariable(value="table") String table, @RequestBody InternalTableRequest request) throws Exception {
        project = this.checkProjectName(project);
        if (StringUtils.isBlank((CharSequence)table) || StringUtils.isBlank((CharSequence)database)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_PARAMETER, "Table or database can not be null, please check again.");
        }
        if (table.isEmpty()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_TABLE_NAME, MsgPicker.getMsg().getTableNameCannotEmpty());
        }
        this.internalTableService.updateInternalTable(project, table, database, request.getPartitionCols(), request.getDatePartitionFormat(), request.getTblProperties(), request.getStorageType());
        return new EnvelopeResponse("000", null, "");
    }

    @ApiOperation(value="get_tables", tags={"AI"})
    @GetMapping(value={""}, produces={"application/vnd.apache.kylin-v4+json"})
    @ResponseBody
    public EnvelopeResponse<DataResult<List<InternalTableDescResponse>>> getTableList(@RequestParam(value="project") String project, @RequestParam(value="need_details", required=false, defaultValue="false") boolean needDetails, @RequestParam(value="is_fuzzy", required=false, defaultValue="false") boolean isFuzzy, @RequestParam(value="database", required=false) String database, @RequestParam(value="table", required=false) String table, @RequestParam(value="page_offset", required=false, defaultValue="0") Integer offset, @RequestParam(value="page_size", required=false, defaultValue="10") Integer limit) {
        project = this.checkProjectName(project);
        List rep = this.internalTableService.getTableList(project, isFuzzy, needDetails, database, table);
        return new EnvelopeResponse("000", (Object)DataResult.get((List)rep, (int)offset, (int)limit), "");
    }

    @ApiOperation(value="get_table_detail", tags={"AI"})
    @GetMapping(value={"/{database:.+}/{table:.+}"}, produces={"application/vnd.apache.kylin-v4+json"})
    @ResponseBody
    public EnvelopeResponse<DataResult<List<InternalTablePartitionDetail>>> getTableDetail(@RequestParam(value="project") String project, @PathVariable(value="database") String database, @PathVariable(value="table") String table, @RequestParam(value="page_offset", required=false, defaultValue="0") Integer offset, @RequestParam(value="page_size", required=false, defaultValue="10") Integer limit) {
        project = this.checkProjectName(project);
        List rep = this.internalTableService.getTableDetail(project, database, table);
        return new EnvelopeResponse("000", (Object)DataResult.get((List)rep, (int)offset, (int)limit), "");
    }
}

