/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.utils;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.kylin.guava30.shaded.common.util.concurrent.ThreadFactoryBuilder;

public final class ThreadUtils$ {
    public static ThreadUtils$ MODULE$;
    private final String NAME_SUFFIX;

    static {
        new ThreadUtils$();
    }

    private String NAME_SUFFIX() {
        return this.NAME_SUFFIX;
    }

    public ThreadFactory newDaemonThreadFactory(String nameFormat) {
        return new ThreadFactoryBuilder().setDaemon(true).setNameFormat(nameFormat).build();
    }

    public ThreadPoolExecutor newDaemonScalableThreadPool(String prefix, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit) {
        LinkedTransferQueue<Runnable> queue = new LinkedTransferQueue<Runnable>(){

            public boolean offer(Runnable r) {
                return this.tryTransfer(r);
            }
        };
        ThreadFactory factory = this.newDaemonThreadFactory(new StringBuilder(0).append(prefix).append(this.NAME_SUFFIX()).toString());
        ThreadPoolExecutor threadPool = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, (BlockingQueue<Runnable>)queue, factory);
        threadPool.setRejectedExecutionHandler(new RejectedExecutionHandler(){

            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                try {
                    executor.getQueue().put(r);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
        });
        return threadPool;
    }

    /*
     * WARNING - void declaration
     */
    public ScheduledExecutorService newDaemonSingleThreadScheduledExecutor(String threadName) {
        void var3_3;
        ThreadFactory factory = this.newDaemonThreadFactory(threadName);
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, factory);
        executor.setRemoveOnCancelPolicy(true);
        return var3_3;
    }

    public ScheduledExecutorService newDaemonThreadScheduledExecutor(int corePoolSize, String threadName) {
        ThreadFactory factory = this.newDaemonThreadFactory(threadName);
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(corePoolSize, factory);
        executor.setRemoveOnCancelPolicy(true);
        return executor;
    }

    private ThreadUtils$() {
        MODULE$ = this;
        this.NAME_SUFFIX = "-%d";
    }
}

