/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.engine.spark.application.SparkApplication;
import org.apache.kylin.engine.spark.job.NSparkCubingUtil;
import org.apache.kylin.engine.spark.scheduler.JobRuntime;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.job.execution.ExecutableParams;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.NIndexPlanManager;
import org.apache.kylin.metadata.cube.model.RuleBasedIndex;
import org.apache.kylin.metadata.job.JobBucket;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.Segments;
import org.apache.spark.tracker.AppStatusContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SegmentJob
extends SparkApplication {
    private static final Logger logger = LoggerFactory.getLogger(SegmentJob.class);
    private static final String COMMA = ",";
    protected IndexPlan indexPlan;
    protected String dataflowId;
    protected Set<LayoutEntity> readOnlyLayouts;
    protected Set<NDataSegment> readOnlySegments;
    protected Path rdSharedPath;
    protected JobRuntime runtime;
    private boolean partialBuild = false;
    protected AppStatusContext appStatusContext;
    private Set<List<Integer>> recommendAggColOrders = new HashSet<List<Integer>>();

    public boolean isPartialBuild() {
        return this.partialBuild;
    }

    public Set<LayoutEntity> getReadOnlyLayouts() {
        return this.readOnlyLayouts;
    }

    public void setRecommendAggColOrders(Set<List<Integer>> recommendAggColOrders) {
        this.recommendAggColOrders = recommendAggColOrders;
    }

    public Set<List<Integer>> getRecommendAggColOrders() {
        return this.recommendAggColOrders;
    }

    public boolean updateIndexPlanIfNeed() {
        if (!this.getRecommendAggColOrders().isEmpty()) {
            UnitOfWork.doInTransactionWithRetry(() -> {
                ArrayList recommendAggLayouts = Lists.newArrayList(this.getRecommendAggColOrders());
                NIndexPlanManager indexPlanManager = NIndexPlanManager.getInstance((KylinConfig)this.config, (String)this.project);
                logger.debug("Update the index plan and add recommended agg index {}", (Object)recommendAggLayouts);
                indexPlanManager.updateIndexPlan(this.dataflowId, copyForWrite -> {
                    Set allRuleLayouts = copyForWrite.getRuleBasedIndex().genCuboidLayouts();
                    HashMap colOrder2Id = Maps.newHashMap();
                    allRuleLayouts.forEach(layoutEntity -> colOrder2Id.put(layoutEntity.getColOrder(), layoutEntity.getId()));
                    logger.debug("All rule base layouts {}", (Object)allRuleLayouts);
                    HashSet costBasedResult = Sets.newHashSet();
                    for (List colOrder : recommendAggLayouts) {
                        if (colOrder2Id.containsKey(colOrder)) {
                            costBasedResult.add(colOrder2Id.get(colOrder));
                            continue;
                        }
                        logger.debug("Can't find the layout {} in the rule base index", (Object)colOrder);
                    }
                    logger.debug("Set the rule pruning cost based list layouts {}", (Object)costBasedResult);
                    RuleBasedIndex ruleBaseIndex = copyForWrite.getRuleBasedIndex();
                    ruleBaseIndex.setLayoutsOfCostBasedList((Set)costBasedResult);
                    copyForWrite.setRuleBasedIndex(ruleBaseIndex);
                });
                return null;
            }, (String)this.project);
            this.updateJobLayoutsIfNeed();
            return true;
        }
        logger.info("There is no recommended agg index");
        return false;
    }

    private void updateJobLayoutsIfNeed() {
        NDataflowManager dataflowManager = NDataflowManager.getInstance((KylinConfig)this.config, (String)this.project);
        this.indexPlan = dataflowManager.getDataflow(this.dataflowId).getIndexPlan();
        List newJobLayouts = this.indexPlan.getAllLayouts();
        logger.debug("Update Job layouts count from {} to {}", (Object)this.readOnlyLayouts.size(), (Object)newJobLayouts.size());
        this.readOnlyLayouts = new HashSet<LayoutEntity>(newJobLayouts);
        this.setParam("layoutIds", NSparkCubingUtil.ids2Str((Set)NSparkCubingUtil.toLayoutIds(this.readOnlyLayouts)));
    }

    @Override
    protected void extraInit() {
        super.extraInit();
        this.partialBuild = Boolean.parseBoolean(this.getParam("partialBuild"));
        Set segmentIDs = Arrays.stream(this.getParam("segmentIds").split(COMMA)).collect(Collectors.toCollection(LinkedHashSet::new));
        this.dataflowId = this.getParam("dataflowId");
        Set layoutIDs = NSparkCubingUtil.str2Longs((String)this.getParam("layoutIds"));
        NDataflowManager dataflowManager = NDataflowManager.getInstance((KylinConfig)this.config, (String)this.project);
        this.rdSharedPath = this.config.getJobTmpShareDir(this.project, this.jobId);
        this.indexPlan = dataflowManager.getDataflow(this.dataflowId).getIndexPlan();
        this.readOnlyLayouts = Collections.unmodifiableSet(NSparkCubingUtil.toLayouts((IndexPlan)this.indexPlan, (Set)layoutIDs));
        Predicate<NDataSegment> notSkip = dataSegment -> !this.needSkipSegment((NDataSegment)dataSegment);
        this.readOnlySegments = Collections.unmodifiableSet(segmentIDs.stream().map(this::getSegment).filter(notSkip).collect(Collectors.toCollection(LinkedHashSet::new)));
        this.runtime = new JobRuntime(this.config.getSegmentExecMaxThreads());
    }

    @Override
    public void extraDestroy() {
        super.extraDestroy();
        if (Objects.nonNull(this.runtime)) {
            this.runtime.shutdown();
        }
        if (Objects.nonNull(this.appStatusContext)) {
            this.appStatusContext.stop();
        }
    }

    public String getDataflowId() {
        return this.dataflowId;
    }

    protected Path getRdSharedPath() {
        return this.rdSharedPath;
    }

    public Set<JobBucket> getReadOnlyBuckets() {
        return Collections.unmodifiableSet(ExecutableParams.getBuckets((String)this.getParam("buckets")));
    }

    public NDataflow getDataflow(String dataflowId) {
        return this.getDataflowManager().getDataflow(dataflowId);
    }

    public NDataSegment getSegment(String segmentId) {
        return this.getDataflowManager().getDataflow(this.dataflowId).getSegment(segmentId);
    }

    public final List<NDataSegment> getUnmergedSegments(NDataSegment merged) {
        Segments unmerged = this.getDataflowManager().getDataflow(this.dataflowId).getMergingSegments(merged);
        Preconditions.checkNotNull((Object)unmerged);
        Preconditions.checkState((!unmerged.isEmpty() ? 1 : 0) != 0);
        Collections.sort(unmerged);
        return unmerged;
    }

    public boolean needBuildSnapshots() {
        String s = this.getParam("needBuildSnapshots");
        if (StringUtils.isBlank((CharSequence)s)) {
            return true;
        }
        return Boolean.parseBoolean(s);
    }

    public boolean isPartitioned() {
        return Objects.nonNull(this.indexPlan.getModel().getPartitionDesc()) && Objects.nonNull(this.indexPlan.getModel().getMultiPartitionDesc());
    }

    private boolean needSkipSegment(NDataSegment dataSegment) {
        if (Objects.isNull(dataSegment)) {
            logger.info("Skip segment: NULL.");
            return true;
        }
        if (Objects.isNull(dataSegment.getSegRange()) || Objects.isNull(dataSegment.getModel()) || Objects.isNull(dataSegment.getIndexPlan())) {
            logger.info("Skip segment: {}, range: {}, model: {}, index plan: {}", new Object[]{dataSegment.getId(), dataSegment.getSegRange(), dataSegment.getModel(), dataSegment.getIndexPlan()});
            return true;
        }
        return false;
    }

    private NDataflowManager getDataflowManager() {
        return NDataflowManager.getInstance((KylinConfig)this.config, (String)this.project);
    }

    public NDataModelManager getNDataModelManager() {
        return NDataModelManager.getInstance((KylinConfig)this.config, (String)this.project);
    }

    public NDataModel getModel() {
        return this.getNDataModelManager().getDataModelDesc(this.dataflowId);
    }

    public JobRuntime getRuntime() {
        return this.runtime;
    }

    public AppStatusContext getAppStatusContext() {
        return this.appStatusContext;
    }

    public IndexPlan getIndexPlan() {
        return this.indexPlan;
    }
}

