/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.spark.job.NSparkExecutable;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.Segments;
import org.apache.spark.sql.datasource.storage.StorageStore;
import org.apache.spark.sql.datasource.storage.StorageStoreFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSparkMergingStep
extends NSparkExecutable {
    private static final Logger logger = LoggerFactory.getLogger(NSparkMergingStep.class);

    public NSparkMergingStep(String sparkSubmitClassName) {
        this.setSparkSubmitClassName(sparkSubmitClassName);
        this.setName("Merge Segment Data");
    }

    public NSparkMergingStep(Object notSetId) {
        super(notSetId);
    }

    @Override
    protected Set<String> getMetadataDumpList(KylinConfig config) {
        LinkedHashSet<String> dumpList = new LinkedHashSet<String>();
        NDataflow df = NDataflowManager.getInstance((KylinConfig)config, (String)this.getProject()).getDataflow(this.getDataflowId());
        dumpList.addAll(df.collectPrecalculationResource());
        dumpList.addAll(this.getLogicalViewMetaDumpList(config));
        return dumpList;
    }

    @Override
    public boolean needMergeMetadata() {
        return true;
    }

    public Set<String> getDependencies(KylinConfig config) {
        String dataflowId = this.getDataflowId();
        String segmentId = this.getParam("segmentIds");
        NDataflowManager dfMgr = NDataflowManager.getInstance((KylinConfig)config, (String)this.getProject());
        NDataflow dataflow = dfMgr.getDataflow(dataflowId);
        IndexPlan indexPlan = dataflow.getIndexPlan();
        NDataSegment mergedSeg = dataflow.getSegment(segmentId);
        Segments mergingSegments = dataflow.getMergingSegments(mergedSeg);
        HashSet result = Sets.newHashSet();
        ArrayList allSegments = Lists.newArrayList((Iterable)mergingSegments);
        StorageStore storageStore = StorageStoreFactory.create((NDataModel.DataStorageType)dataflow.getModel().getStorageType());
        allSegments.add(mergedSeg);
        for (NDataSegment seg : allSegments) {
            for (LayoutEntity layout : indexPlan.getAllLayouts()) {
                String path = "/" + storageStore.getStoragePathWithoutPrefix(this.project, dataflowId, seg.getId(), layout.getId());
                result.add(new Path(path).getParent().toString());
            }
        }
        return result;
    }

    @Generated
    public NSparkMergingStep() {
    }

    public static class Mockup {
        public static void main(String[] args) {
            logger.info(Mockup.class + ".main() invoked, args: " + Arrays.toString(args));
        }
    }
}

