/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cluster.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.List;
import org.apache.kylin.cluster.AvailableResource;
import org.apache.kylin.cluster.ResourceInfo;
import org.apache.kylin.cluster.parser.SchedulerParser;
import org.apache.kylin.engine.spark.job.KylinBuildEnv$;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001e3Aa\u0002\u0005\u0001'!)a\u0004\u0001C\u0001?!)\u0011\u0005\u0001C!E!)A\u0007\u0001C\u0005k!)!\b\u0001C\u0005w!)Q\n\u0001C\u0005\u001d\")1\u000b\u0001C\u0005)\n92)\u00199bG&$\u0018pU2iK\u0012,H.\u001a:QCJ\u001cXM\u001d\u0006\u0003\u0013)\ta\u0001]1sg\u0016\u0014(BA\u0006\r\u0003\u001d\u0019G.^:uKJT!!\u0004\b\u0002\u000b-LH.\u001b8\u000b\u0005=\u0001\u0012AB1qC\u000eDWMC\u0001\u0012\u0003\ry'oZ\u0002\u0001'\r\u0001AC\u0007\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0005maR\"\u0001\u0005\n\u0005uA!aD*dQ\u0016$W\u000f\\3s!\u0006\u00148/\u001a:\u0002\rqJg.\u001b;?)\u0005\u0001\u0003CA\u000e\u0001\u0003E\tg/Y5mC\ndWMU3t_V\u00148-\u001a\u000b\u0003G\u001d\u0002\"\u0001J\u0013\u000e\u0003)I!A\n\u0006\u0003#\u00053\u0018-\u001b7bE2,'+Z:pkJ\u001cW\rC\u0003)\u0005\u0001\u0007\u0011&A\u0005rk\u0016,XMT1nKB\u0011!&\r\b\u0003W=\u0002\"\u0001\f\f\u000e\u00035R!A\f\n\u0002\rq\u0012xn\u001c;?\u0013\t\u0001d#\u0001\u0004Qe\u0016$WMZ\u0005\u0003eM\u0012aa\u0015;sS:<'B\u0001\u0019\u0017\u0003i\u0019\u0007.Z2l\u000b2\f7\u000f^5d%\u0016\u001cx.\u001e:dK\u0016s\u0017M\u00197f)\r\u0019c\u0007\u000f\u0005\u0006o\r\u0001\raI\u0001\u0010K2\f7\u000f^5d%\u0016\u001cx.\u001e:dK\")\u0011h\u0001a\u0001G\u0005A!/Z:pkJ\u001cW-\u0001\rdYV\u001cH/\u001a:Bm\u0006LG.\u00192mK\u000e\u000b\u0007/Y2jif$\"\u0001P \u0011\u0005Ui\u0014B\u0001 \u0017\u0005\u0019!u.\u001e2mK\")\u0001\t\u0002a\u0001\u0003\u0006!an\u001c3f!\t\u00115*D\u0001D\u0015\t!U)\u0001\u0005eCR\f'-\u001b8e\u0015\t1u)A\u0004kC\u000e\\7o\u001c8\u000b\u0005!K\u0015!\u00034bgR,'\u000f_7m\u0015\u0005Q\u0015aA2p[&\u0011Aj\u0011\u0002\t\u0015N|gNT8eK\u0006i\u0011/^3vK\u000e\u000b\u0007/Y2jif$\"a\u0014*\u0011\tU\u0001F\bP\u0005\u0003#Z\u0011a\u0001V;qY\u0016\u0014\u0004\"\u0002!\u0006\u0001\u0004\t\u0015\u0001E2bYR{G/\u00197SKN|WO]2f)\t)\u0006\f\u0005\u0002%-&\u0011qK\u0003\u0002\r%\u0016\u001cx.\u001e:dK&sgm\u001c\u0005\u0006\u0001\u001a\u0001\r!\u0011")
public class CapacitySchedulerParser
implements SchedulerParser {
    private JsonNode root;
    private ObjectMapper mapper;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    @Override
    public void parse(String schedulerInfo) {
        SchedulerParser.parse$(this, schedulerInfo);
    }

    @Override
    public String parseValue(JsonNode node) {
        return SchedulerParser.parseValue$(this, node);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public JsonNode root() {
        return this.root;
    }

    @Override
    public void root_$eq(JsonNode x$1) {
        this.root = x$1;
    }

    private ObjectMapper mapper$lzycompute() {
        CapacitySchedulerParser capacitySchedulerParser = this;
        synchronized (capacitySchedulerParser) {
            if (!this.bitmap$0) {
                this.mapper = SchedulerParser.mapper$(this);
                this.bitmap$0 = true;
            }
        }
        return this.mapper;
    }

    @Override
    public ObjectMapper mapper() {
        return !this.bitmap$0 ? this.mapper$lzycompute() : this.mapper;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public AvailableResource availableResource(String queueName) {
        None$ none$;
        List queues = this.root().findParents("queueName");
        Buffer nodes = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(queues).asScala()).filter((Function1 & Serializable & scala.Serializable)queue -> BoxesRunTime.boxToBoolean((boolean)CapacitySchedulerParser.$anonfun$availableResource$1(this, queueName, queue)));
        Predef$.MODULE$.require(nodes.size() == 1);
        Tuple2<Object, Object> tuple2 = this.queueCapacity((JsonNode)nodes.head());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        double queueAvailable = tuple2._1$mcD$sp();
        double queueMax = tuple2._2$mcD$sp();
        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(queueAvailable, queueMax);
        Tuple2.mcDD.sp sp3 = sp2;
        DoubleRef queueAvailable2 = DoubleRef.create((double)sp3._1$mcD$sp());
        DoubleRef queueMax2 = DoubleRef.create((double)sp3._2$mcD$sp());
        ResourceInfo totalResource = this.calTotalResource((JsonNode)nodes.head());
        JsonNode clusterNode = this.root().findValue("schedulerInfo");
        double cluster = this.clusterAvailableCapacity(clusterNode);
        DoubleRef min = DoubleRef.create((double)Math.min(queueAvailable2.elem, cluster));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("queueAvailable is ").append(queueAvailable$1.elem).append(", min is ").append(min$1.elem).append(", queueMax is ").append(queueMax$1.elem).toString());
        if (KylinBuildEnv$.MODULE$.get().kylinConfig().useDynamicResourcePlan() && queueMax2.elem == 0.0) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "configure yarn queue using dynamic resource plan in capacity scheduler");
            queueMax2.elem = 1.0;
        }
        if (KylinBuildEnv$.MODULE$.get().kylinConfig().useDynamicResourcePlan() && min.elem == 0.0) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "configure yarn queue using dynamic resource plan in capacity scheduler");
            min.elem = 1.0;
        }
        AvailableResource elasticResource = new AvailableResource(totalResource.percentage(min.elem), totalResource.percentage(queueMax2.elem));
        ObjectRef resource = ObjectRef.create((Object)elasticResource);
        try {
            ResourceInfo queueAvailableRes = KylinBuildEnv$.MODULE$.get().clusterManager().fetchQueueStatistics(queueName);
            resource.elem = new AvailableResource(queueAvailableRes, totalResource.percentage(queueMax2.elem));
            none$ = BoxedUnit.UNIT;
        }
        catch (Error e) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "The current hadoop version does not support QueueInfo.getQueueStatistics method.");
            none$ = None$.MODULE$;
        }
        resource.elem = this.checkElasticResourceEnable(elasticResource, (AvailableResource)resource.elem);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Capacity actual available resource: ").append((AvailableResource)resource$1.elem).append(".").toString());
        return (AvailableResource)resource.elem;
    }

    private AvailableResource checkElasticResourceEnable(AvailableResource elasticResource, AvailableResource resource) {
        AvailableResource availableResource;
        if (KylinBuildEnv$.MODULE$.get().kylinConfig().useQueueElasticResource()) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "use elastically available resource");
            availableResource = elasticResource;
        } else {
            availableResource = resource;
        }
        return availableResource;
    }

    private double clusterAvailableCapacity(JsonNode node) {
        double max = new StringOps(Predef$.MODULE$.augmentString(this.parseValue(node.get("capacity")))).toDouble();
        double used = new StringOps(Predef$.MODULE$.augmentString(this.parseValue(node.get("usedCapacity")))).toDouble();
        double capacity = (max - used) / (double)100;
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Cluster available capacity: ").append(capacity).append(".").toString());
        return capacity;
    }

    private Tuple2<Object, Object> queueCapacity(JsonNode node) {
        double max = new StringOps(Predef$.MODULE$.augmentString(this.parseValue(node.get("absoluteMaxCapacity")))).toDouble();
        double used = new StringOps(Predef$.MODULE$.augmentString(this.parseValue(node.get("absoluteUsedCapacity")))).toDouble();
        double available = (max - used) / (double)100;
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Queue available capacity: ").append(available).append(".").toString());
        return new Tuple2.mcDD.sp(available, max / (double)100);
    }

    private ResourceInfo calTotalResource(JsonNode node) {
        ResourceInfo resourceInfo;
        int usedMemory = new StringOps(Predef$.MODULE$.augmentString(this.parseValue(node.get("resourcesUsed").get("memory")))).toInt();
        if (usedMemory != 0) {
            double usedCapacity = new StringOps(Predef$.MODULE$.augmentString(this.parseValue(node.get("absoluteUsedCapacity")))).toDouble() / (double)100;
            ResourceInfo resource = new ResourceInfo((int)Math.floor((double)usedMemory / usedCapacity), Integer.MAX_VALUE);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Estimate total cluster resource is ").append(resource).append(".").toString());
            resourceInfo = resource;
        } else {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Current queue used memory is 0, seem available resource as infinite.");
            resourceInfo = new ResourceInfo(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
        return resourceInfo;
    }

    public static final /* synthetic */ boolean $anonfun$availableResource$1(CapacitySchedulerParser $this, String queueName$1, JsonNode queue) {
        return $this.parseValue(queue.get("queueName")).equals(queueName$1);
    }

    public CapacitySchedulerParser() {
        Logging.$init$((Logging)this);
        SchedulerParser.$init$(this);
    }
}

