/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.streaming;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.dict.DictionaryGenerator;
import org.apache.kylin.dict.DictionaryInfo;
import org.apache.kylin.dict.DictionaryInfoSerializer;
import org.apache.kylin.dict.DictionarySerializer;
import org.apache.kylin.dict.IDictionaryValueEnumerator;
import org.apache.kylin.dict.MultipleDictionaryValueEnumerator;
import org.apache.kylin.engine.mr.KylinReducer;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.source.IReadableTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeDictReducer
extends KylinReducer<Text, Text, Text, Text> {
    private static final Logger logger = LoggerFactory.getLogger(MergeDictReducer.class);
    private String cubeName;
    private String segmentName;
    private CubeInstance cube;
    private CubeSegment segment;
    private Map<String, TblColRef> colNeedDictMap;

    @Override
    protected void doSetup(Reducer.Context context) throws IOException, InterruptedException {
        super.bindCurrentConfiguration(context.getConfiguration());
        KylinConfig config = AbstractHadoopJob.loadKylinPropsAndMetadata();
        this.cubeName = context.getConfiguration().get("cube.name").toUpperCase(Locale.ROOT);
        this.segmentName = context.getConfiguration().get("cube.segment.name");
        this.cube = CubeManager.getInstance((KylinConfig)config).getCube(this.cubeName);
        this.segment = this.cube.getSegment(this.segmentName, SegmentStatusEnum.NEW);
        if (this.segment == null) {
            logger.debug("segment {} is null during setup!", (Object)this.segmentName);
            throw new IllegalArgumentException("Segment is null, job quit!");
        }
        this.colNeedDictMap = Maps.newHashMap();
        Set columnsNeedDict = this.cube.getDescriptor().getAllColumnsNeedDictionaryBuilt();
        for (TblColRef column : columnsNeedDict) {
            this.colNeedDictMap.put(column.getName(), column);
        }
    }

    @Override
    protected void doReduce(Text key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
        Dictionary mergedDict;
        String col = key.toString();
        logger.info("merge dictionary for column:{}", (Object)col);
        TblColRef tblColRef = this.colNeedDictMap.get(col);
        if (tblColRef == null) {
            logger.warn("column:{} not found in the columns need dictionary map: {}", (Object)col, this.colNeedDictMap.keySet());
            return;
        }
        DataType dataType = tblColRef.getType();
        LinkedList dicts = Lists.newLinkedList();
        for (Text value : values) {
            ByteArray byteArray = new ByteArray(value.getBytes());
            Dictionary dict = DictionarySerializer.deserialize((ByteArray)byteArray);
            dicts.add(dict);
        }
        if (dicts.size() > 1) {
            MultipleDictionaryValueEnumerator multipleDictionaryValueEnumerator = new MultipleDictionaryValueEnumerator(dataType, (List)dicts);
            mergedDict = DictionaryGenerator.buildDictionary((DataType)dataType, (IDictionaryValueEnumerator)multipleDictionaryValueEnumerator);
        } else if (dicts.size() == 1) {
            mergedDict = (Dictionary)dicts.get(0);
        } else {
            throw new IllegalArgumentException("Dictionary missing for column " + col);
        }
        if (mergedDict == null) {
            throw new IllegalArgumentException("Merge dictionaries error for column " + col);
        }
        TableDesc tableDesc = tblColRef.getColumnDesc().getTable();
        IReadableTable.TableSignature signature = new IReadableTable.TableSignature();
        signature.setLastModifiedTime(System.currentTimeMillis());
        signature.setPath(tableDesc.getResourcePath());
        DictionaryInfo dictionaryInfo = new DictionaryInfo(tblColRef.getTable(), tblColRef.getName(), tblColRef.getColumnDesc().getZeroBasedIndex(), tblColRef.getDatatype(), signature);
        dictionaryInfo.setDictionaryObject(mergedDict);
        dictionaryInfo.setDictionaryClass(mergedDict.getClass().getName());
        dictionaryInfo.setCardinality(mergedDict.getSize());
        ByteArrayOutputStream fulBuf = new ByteArrayOutputStream();
        DataOutputStream fulDout = new DataOutputStream(fulBuf);
        DictionaryInfoSerializer.FULL_SERIALIZER.serialize(dictionaryInfo, fulDout);
        Text outValue = new Text(fulBuf.toByteArray());
        context.write((Object)key, (Object)outValue);
        logger.debug("output dict info of column {} to path: {}", (Object)col, (Object)context.getConfiguration().get("mapreduce.output.fileoutputformat.outputdir"));
    }
}

