/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.streaming;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.kv.AbstractRowKeyEncoder;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.engine.mr.streaming.ColumnarSplitReader;
import org.apache.kylin.engine.mr.streaming.RowRecord;
import org.apache.kylin.engine.mr.streaming.RowRecordReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnarSplitDataReader
extends ColumnarSplitReader {
    private static final Logger logger = LoggerFactory.getLogger(ColumnarSplitDataReader.class);
    private Cuboid baseCuboid;
    private AbstractRowKeyEncoder rowKeyEncoder;
    private ByteBuffer metricsValuesBuffer;
    private Text currentKey;
    private Text currentValue;
    private AtomicInteger rowCount;
    private RowRecordReader rowRecordReader;

    public ColumnarSplitDataReader(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        super(inputSplit, context);
        this.init(inputSplit, context);
    }

    public void init(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        this.baseCuboid = Cuboid.getBaseCuboid((CubeDesc)this.cubeDesc);
        this.rowKeyEncoder = AbstractRowKeyEncoder.createInstance((CubeSegment)this.cubeSegment, (Cuboid)this.baseCuboid);
        FileSystem fs = FileSystem.get((Configuration)context.getConfiguration());
        FileSplit fSplit = (FileSplit)split;
        Path path = fSplit.getPath();
        this.rowRecordReader = new RowRecordReader(this.cubeDesc, path, fs);
        this.metricsValuesBuffer = ByteBuffer.allocate(0x100000);
        this.rowCount = new AtomicInteger(0);
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (this.rowRecordReader.hasNextRow()) {
            this.rowCount.getAndIncrement();
            RowRecord rowRecord = this.rowRecordReader.nextRow();
            String[] dimensionsValues = rowRecord.getDimensions();
            byte[] key = this.rowKeyEncoder.encode(dimensionsValues);
            this.currentKey = new Text();
            this.currentKey.set(key, 0, key.length);
            byte[][] metricsValues = rowRecord.getMetrics();
            this.currentValue = new Text();
            this.metricsValuesBuffer.clear();
            for (int i = 0; i < metricsValues.length; ++i) {
                this.metricsValuesBuffer.put(metricsValues[i], 0, metricsValues[i].length);
            }
            this.currentValue.set(this.metricsValuesBuffer.array(), 0, this.metricsValuesBuffer.position());
            return true;
        }
        return false;
    }

    public Text getCurrentValue() throws IOException, InterruptedException {
        return this.currentValue;
    }

    public float getProgress() throws IOException, InterruptedException {
        return -1.0f;
    }

    public Text getCurrentKey() throws IOException, InterruptedException {
        return this.currentKey;
    }

    public void close() throws IOException {
        this.rowRecordReader.close();
    }
}

