/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps.lookup;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.engine.mr.LookupMaterializeContext;
import org.apache.kylin.engine.mr.steps.lookup.LookupExecutableUtil;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecuteResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateCubeAfterSnapshotStep
extends AbstractExecutable {
    private static final Logger logger = LoggerFactory.getLogger(UpdateCubeAfterSnapshotStep.class);

    protected ExecuteResult doWork(ExecutableContext context) throws ExecuteException {
        KylinConfig kylinConfig = context.getConfig();
        CubeManager cubeManager = CubeManager.getInstance((KylinConfig)kylinConfig);
        CubeInstance cube = cubeManager.getCube(LookupExecutableUtil.getCubeName(this.getParams()));
        List<String> segmentIDs = LookupExecutableUtil.getSegments(this.getParams());
        String lookupTableName = LookupExecutableUtil.getLookupTableName(this.getParams());
        String extLookupSnapshotStr = this.getParam("extlookupsnapshots");
        if (extLookupSnapshotStr == null || extLookupSnapshotStr.isEmpty()) {
            return new ExecuteResult();
        }
        Map<String, String> extLookupSnapshotMap = LookupMaterializeContext.parseLookupSnapshots(extLookupSnapshotStr);
        String snapshotResPath = extLookupSnapshotMap.get(lookupTableName);
        if (snapshotResPath == null) {
            logger.info("no snapshot path exist in the context, so no need to update snapshot path");
            return new ExecuteResult();
        }
        CubeDesc cubeDesc = cube.getDescriptor();
        try {
            logger.info("update snapshot path:{} to cube:{}", (Object)snapshotResPath, (Object)cube.getName());
            if (cubeDesc.isGlobalSnapshotTable(lookupTableName)) {
                if (!snapshotResPath.equals(cube.getSnapshotResPath(lookupTableName))) {
                    LookupExecutableUtil.updateSnapshotPathToCube(cubeManager, cube, lookupTableName, snapshotResPath);
                }
            } else {
                LookupExecutableUtil.updateSnapshotPathToSegments(cubeManager, cube, segmentIDs, lookupTableName, snapshotResPath);
            }
            return new ExecuteResult();
        }
        catch (IOException e) {
            logger.error("fail to save cuboid statistics", (Throwable)e);
            return ExecuteResult.createError((Throwable)e);
        }
    }
}

