/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.io.IOException;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.engine.mr.steps.CubingExecutableUtil;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecuteResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateCubeInfoAfterOptimizeStep
extends AbstractExecutable {
    private static final Logger logger = LoggerFactory.getLogger(UpdateCubeInfoAfterOptimizeStep.class);

    protected ExecuteResult doWork(ExecutableContext context) throws ExecuteException {
        CubeManager cubeManager = CubeManager.getInstance((KylinConfig)context.getConfig());
        CubeInstance cube = cubeManager.getCube(CubingExecutableUtil.getCubeName(this.getParams()));
        CubeSegment segment = cube.getSegmentById(CubingExecutableUtil.getSegmentId(this.getParams()));
        CubeSegment originalSegment = cube.getOriginalSegmentToOptimize(segment);
        long sourceCount = originalSegment.getInputRecords();
        long sourceSizeBytes = originalSegment.getInputRecordsSize();
        CubingJob cubingJob = (CubingJob)this.getManager().getJob(CubingExecutableUtil.getCubingJobId(this.getParams()));
        long cubeSizeBytes = cubingJob.findCubeSizeBytes();
        segment.setLastBuildJobID(CubingExecutableUtil.getCubingJobId(this.getParams()));
        segment.setLastBuildTime(System.currentTimeMillis());
        segment.setSizeKB(cubeSizeBytes / 1024L);
        segment.setInputRecords(sourceCount);
        segment.setInputRecordsSize(sourceSizeBytes);
        segment.setDimensionRangeInfoMap(originalSegment.getDimensionRangeInfoMap());
        try {
            cubeManager.promoteNewlyOptimizeSegments(cube, new CubeSegment[]{segment});
            return new ExecuteResult();
        }
        catch (IOException e) {
            logger.error("fail to update cube after build", (Throwable)e);
            return ExecuteResult.createError((Throwable)e);
        }
    }
}

