/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.DimensionRangeInfo;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.engine.mr.exception.SegmentNotFoundException;
import org.apache.kylin.engine.mr.steps.CubingExecutableUtil;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.SegmentRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateCubeInfoAfterMergeStep
extends AbstractExecutable {
    private static final Logger logger = LoggerFactory.getLogger(UpdateCubeInfoAfterMergeStep.class);

    protected ExecuteResult doWork(ExecutableContext context) throws ExecuteException {
        CubeManager cubeManager = CubeManager.getInstance((KylinConfig)context.getConfig());
        CubeInstance cube = cubeManager.getCube(CubingExecutableUtil.getCubeName(this.getParams())).latestCopyForWrite();
        CubeSegment mergedSegment = cube.getSegmentById(CubingExecutableUtil.getSegmentId(this.getParams()));
        if (mergedSegment == null) {
            return ExecuteResult.createFailed((Throwable)new SegmentNotFoundException("there is no segment with id:" + CubingExecutableUtil.getSegmentId(this.getParams())));
        }
        CubingJob cubingJob = (CubingJob)this.getManager().getJob(CubingExecutableUtil.getCubingJobId(this.getParams()));
        long cubeSizeBytes = cubingJob.findCubeSizeBytes();
        List<String> mergingSegmentIds = CubingExecutableUtil.getMergingSegmentIds(this.getParams());
        if (mergingSegmentIds.isEmpty()) {
            return ExecuteResult.createFailed((Throwable)new SegmentNotFoundException("there are no merging segments"));
        }
        long sourceCount = 0L;
        long sourceSize = 0L;
        boolean isOffsetCube = mergedSegment.isOffsetCube();
        Long tsStartMin = Long.MAX_VALUE;
        Long tsEndMax = 0L;
        CubeSegment lastMergedSegment = null;
        for (String string : mergingSegmentIds) {
            CubeSegment segment = cube.getSegmentById(string);
            if (lastMergedSegment == null || (Long)lastMergedSegment.getTSRange().end.v < (Long)segment.getTSRange().end.v) {
                lastMergedSegment = segment;
            }
            sourceCount += segment.getInputRecords();
            sourceSize += segment.getInputRecordsSize();
            tsStartMin = Math.min(tsStartMin, (Long)segment.getTSRange().start.v);
            tsEndMax = Math.max(tsEndMax, (Long)segment.getTSRange().end.v);
        }
        Map mergedSegDimRangeMap = null;
        for (String id : mergingSegmentIds) {
            CubeSegment segment = cube.getSegmentById(id);
            Map segDimRangeMap = segment.getDimensionRangeInfoMap();
            if (mergedSegDimRangeMap == null) {
                mergedSegDimRangeMap = segDimRangeMap;
                continue;
            }
            mergedSegDimRangeMap = DimensionRangeInfo.mergeRangeMap((DataModelDesc)cube.getModel(), (Map)segDimRangeMap, (Map)mergedSegDimRangeMap);
        }
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        List<Double> cuboidEstimateRatio = cubingJob.findEstimateRatio(mergedSegment, kylinConfig);
        mergedSegment.setSizeKB(cubeSizeBytes / 1024L);
        mergedSegment.setInputRecords(sourceCount);
        mergedSegment.setInputRecordsSize(sourceSize);
        mergedSegment.setLastBuildJobID(CubingExecutableUtil.getCubingJobId(this.getParams()));
        mergedSegment.setLastBuildTime(System.currentTimeMillis());
        mergedSegment.setDimensionRangeInfoMap(mergedSegDimRangeMap);
        mergedSegment.setStreamSourceCheckpoint(lastMergedSegment != null ? lastMergedSegment.getStreamSourceCheckpoint() : null);
        mergedSegment.setEstimateRatio(cuboidEstimateRatio);
        if (isOffsetCube) {
            SegmentRange.TSRange tsRange = new SegmentRange.TSRange(tsStartMin, tsEndMax);
            mergedSegment.setTSRange(tsRange);
        }
        try {
            cubeManager.promoteNewlyBuiltSegments(cube, mergedSegment);
            return new ExecuteResult(ExecuteResult.State.SUCCEED);
        }
        catch (IOException e) {
            logger.error("fail to update cube after merge", (Throwable)e);
            return ExecuteResult.createError((Throwable)e);
        }
    }
}

