/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.common.RowKeySplitter;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.cuboid.CuboidScheduler;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.engine.mr.KylinMapper;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.engine.mr.common.CuboidSchedulerUtil;
import org.apache.kylin.engine.mr.common.NDCuboidBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NDCuboidMapper
extends KylinMapper<Text, Text, Text, Text> {
    private static final Logger logger = LoggerFactory.getLogger(NDCuboidMapper.class);
    private Text outputKey = new Text();
    private String cubeName;
    private String segmentID;
    private CubeDesc cubeDesc;
    private CubeSegment cubeSegment;
    private CuboidScheduler cuboidScheduler;
    private int handleCounter;
    private int skipCounter;
    private RowKeySplitter rowKeySplitter;
    private NDCuboidBuilder ndCuboidBuilder;

    @Override
    protected void doSetup(Mapper.Context context) throws IOException {
        super.bindCurrentConfiguration(context.getConfiguration());
        this.cubeName = context.getConfiguration().get("cube.name");
        this.segmentID = context.getConfiguration().get("cube.segment.id");
        String cuboidModeName = context.getConfiguration().get("cuboid.mode");
        KylinConfig config = AbstractHadoopJob.loadKylinPropsAndMetadata();
        CubeInstance cube = CubeManager.getInstance((KylinConfig)config).getCube(this.cubeName);
        this.cubeDesc = cube.getDescriptor();
        this.cubeSegment = cube.getSegmentById(this.segmentID);
        this.ndCuboidBuilder = new NDCuboidBuilder(this.cubeSegment);
        this.cuboidScheduler = CuboidSchedulerUtil.getCuboidSchedulerByMode(this.cubeSegment, cuboidModeName);
        this.rowKeySplitter = new RowKeySplitter(this.cubeSegment);
    }

    @Override
    public void doMap(Text key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        long cuboidId = this.rowKeySplitter.split(key.getBytes());
        Cuboid parentCuboid = Cuboid.findForMandatory((CubeDesc)this.cubeDesc, (long)cuboidId);
        List myChildren = this.cuboidScheduler.getSpanningCuboid(cuboidId);
        if (myChildren == null || myChildren.size() == 0) {
            context.getCounter("Cube Builder", "Skipped records").increment(1L);
            if (this.skipCounter++ % 100000 == 0) {
                logger.info("Skipping record with ordinal: " + this.skipCounter);
            }
            return;
        }
        context.getCounter("Cube Builder", "Processed records").increment(1L);
        if (this.handleCounter++ % 100000 == 0) {
            logger.info("Handling record with ordinal: " + this.handleCounter);
            logger.info("Parent cuboid: " + parentCuboid.getId() + "; Children: " + myChildren);
        }
        for (Long child : myChildren) {
            Cuboid childCuboid = Cuboid.findForMandatory((CubeDesc)this.cubeDesc, (long)child);
            Pair<Integer, ByteArray> result = this.ndCuboidBuilder.buildKey(parentCuboid, childCuboid, this.rowKeySplitter.getSplitBuffers());
            this.outputKey.set(((ByteArray)result.getSecond()).array(), 0, ((Integer)result.getFirst()).intValue());
            context.write((Object)this.outputKey, (Object)value);
        }
    }
}

