/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.io.IOException;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.engine.mr.KylinReducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeDictionaryReducer
extends KylinReducer<IntWritable, Text, Text, Text> {
    private static final Logger logger = LoggerFactory.getLogger(MergeDictionaryReducer.class);

    @Override
    protected void doReduce(IntWritable key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
        for (Text text : values) {
            String value = text.toString();
            String[] splited = StringUtil.split((String)value, (String)"=");
            if (splited == null || splited.length != 2) continue;
            logger.info("Dictionary for col {}, save at {}", (Object)splited[0], (Object)splited[1]);
            context.write((Object)new Text(splited[0]), (Object)new Text(splited[1]));
        }
    }
}

