/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.util.Locale;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.mr.ByteArrayWritable;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.engine.mr.IMRInput;
import org.apache.kylin.engine.mr.IMROutput2;
import org.apache.kylin.engine.mr.MRUtil;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.engine.mr.steps.InMemCuboidMapper;
import org.apache.kylin.engine.mr.steps.InMemCuboidReducer;
import org.apache.kylin.job.execution.ExecutableManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemCuboidJob
extends AbstractHadoopJob {
    protected static final Logger logger = LoggerFactory.getLogger(InMemCuboidJob.class);
    private boolean skipped = false;

    @Override
    public boolean isSkipped() {
        return this.skipped;
    }

    private boolean checkSkip(String cubingJobId) {
        if (cubingJobId == null) {
            return false;
        }
        ExecutableManager execMgr = ExecutableManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        CubingJob cubingJob = (CubingJob)execMgr.getJob(cubingJobId);
        this.skipped = !cubingJob.isInMemCubing();
        return this.skipped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws Exception {
        Options options = new Options();
        try {
            options.addOption(OPTION_JOB_NAME);
            options.addOption(OPTION_CUBE_NAME);
            options.addOption(OPTION_SEGMENT_ID);
            options.addOption(OPTION_OUTPUT_PATH);
            options.addOption(OPTION_CUBING_JOB_ID);
            options.addOption(OPTION_DICTIONARY_SHRUNKEN_PATH);
            this.parseOptions(options, args);
            String cubeName = this.getOptionValue(OPTION_CUBE_NAME).toUpperCase(Locale.ROOT);
            String segmentID = this.getOptionValue(OPTION_SEGMENT_ID);
            String output = this.getOptionValue(OPTION_OUTPUT_PATH);
            CubeManager cubeMgr = CubeManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
            CubeInstance cube = cubeMgr.getCube(cubeName);
            CubeSegment segment = cube.getSegmentById(segmentID);
            String cubingJobId = this.getOptionValue(OPTION_CUBING_JOB_ID);
            if (this.checkSkip(cubingJobId)) {
                logger.info("Skip job " + this.getOptionValue(OPTION_JOB_NAME) + " for " + segment);
                int n = 0;
                return n;
            }
            this.job = Job.getInstance((Configuration)this.getConf(), (String)this.getOptionValue(OPTION_JOB_NAME));
            this.job.getConfiguration().set("cubingJobId", cubingJobId);
            String shrunkenDictPath = this.getOptionValue(OPTION_DICTIONARY_SHRUNKEN_PATH);
            if (shrunkenDictPath != null) {
                this.job.getConfiguration().set("shrunkenDictPath", shrunkenDictPath);
            }
            logger.info("Starting: " + this.job.getJobName());
            this.setJobClasspath(this.job, cube.getConfig());
            this.attachSegmentMetadataWithAll(segment, this.job.getConfiguration());
            this.job.getConfiguration().set("cube.name", cubeName);
            this.job.getConfiguration().set("cube.segment.id", segmentID);
            this.job.setMapperClass(InMemCuboidMapper.class);
            this.job.setMapOutputKeyClass(ByteArrayWritable.class);
            this.job.setMapOutputValueClass(ByteArrayWritable.class);
            this.job.setReducerClass(InMemCuboidReducer.class);
            this.job.setOutputKeyClass(Text.class);
            this.job.setOutputValueClass(Text.class);
            IMRInput.IMRTableInputFormat flatTableInputFormat = MRUtil.getBatchCubingInputSide(segment).getFlatTableInputFormat();
            flatTableInputFormat.configureJob(this.job);
            IMROutput2.IMROutputFormat outputFormat = MRUtil.getBatchCubingOutputSide2(segment).getOutputFormat();
            outputFormat.configureJobOutput(this.job, output, segment, segment.getCuboidScheduler(), 0);
            int n = this.waitForCompletion(this.job);
            return n;
        }
        finally {
            if (this.job != null) {
                this.cleanupTempConfFile(this.job.getConfiguration());
            }
        }
    }

    public static void main(String[] args) throws Exception {
        InMemCuboidJob job = new InMemCuboidJob();
        int exitCode = ToolRunner.run((Tool)job, (String[])args);
        System.exit(exitCode);
    }
}

