/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.hadoop.io.ArrayPrimitiveWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinVersion;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.DimensionRangeInfo;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.cuboid.CuboidUtil;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.CubeJoinedFlatTableEnrich;
import org.apache.kylin.dict.DictionaryGenerator;
import org.apache.kylin.dict.IDictionaryBuilder;
import org.apache.kylin.engine.EngineFactory;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.engine.mr.common.SerializableConfiguration;
import org.apache.kylin.engine.mr.common.StatisticsDecisionUtil;
import org.apache.kylin.engine.mr.steps.FactDistinctColumnsMapper;
import org.apache.kylin.engine.mr.steps.FactDistinctColumnsReducerMapping;
import org.apache.kylin.engine.mr.steps.SelfDefineSortableKey;
import org.apache.kylin.measure.hllc.HLLCounter;
import org.apache.kylin.measure.hllc.RegisterType;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.TblColRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FactDistinctColumnsBase {
    private static final Logger logger = LoggerFactory.getLogger(FactDistinctColumnsBase.class);
    private String cubeName;
    private String segmentId;
    private int samplingPercentage;
    private KylinConfig envConfig;
    protected CubeInstance cube;
    protected CubeSegment cubeSeg;
    protected CubeDesc cubeDesc;
    protected long baseCuboidId;
    protected List<TblColRef> allCols;
    protected CubeJoinedFlatTableEnrich intermediateTableDesc;
    protected int[] columnIndex;
    protected FactDistinctColumnsReducerMapping reducerMapping;
    protected int nRowKey;
    private Integer[][] allCuboidsBitSet = null;
    private HLLCounter[] allCuboidsHLL = null;
    private Long[] cuboidIds;
    private int rowCount = 0;
    private FactDistinctColumnsMapper.DictColDeduper dictColDeduper;
    private Map<Integer, DimensionRangeInfo> dimensionRangeInfoMap = Maps.newHashMap();
    private FactDistinctColumnsMapper.CuboidStatCalculator[] cuboidStatCalculators;
    private SelfDefineSortableKey sortableKey = new SelfDefineSortableKey();
    private ByteBuffer tmpbuf;
    private Text outputKey;
    private Text outputValue;
    private Text emptyText;
    public static final String DICT_FILE_POSTFIX = ".rldict";
    public static final String DIMENSION_COL_INFO_FILE_POSTFIX = ".dci";
    private int taskId;
    private boolean isStatistics = false;
    private List<Long> baseCuboidRowCountInMappers;
    protected Map<Long, HLLCounter> cuboidHLLMap = null;
    private TblColRef col = null;
    private long totalRowsBeforeMerge = 0L;
    private boolean buildDictInReducer;
    private IDictionaryBuilder builder;
    private String maxValue = null;
    private String minValue = null;

    public FactDistinctColumnsBase(String cubeName, String segmentId, String metaUrl, SerializableConfiguration conf, int samplingPercentage) {
        this.cubeName = cubeName;
        this.segmentId = segmentId;
        this.samplingPercentage = samplingPercentage;
        this.envConfig = AbstractHadoopJob.loadKylinConfigFromHdfs(conf, metaUrl);
    }

    public void setupMap() {
        this.outputKey = new Text();
        this.outputValue = new Text();
        this.emptyText = new Text();
        try (KylinConfig.SetAndUnsetThreadLocalConfig autoUnset = KylinConfig.setAndUnsetThreadLocalConfig((KylinConfig)this.envConfig);){
            int start;
            boolean isUsePutRowKeyToHllNewAlgorithm;
            this.cube = CubeManager.getInstance((KylinConfig)this.envConfig).getCube(this.cubeName);
            this.cubeSeg = this.cube.getSegmentById(this.segmentId);
            this.cubeDesc = this.cube.getDescriptor();
            this.baseCuboidId = Cuboid.getBaseCuboidId((CubeDesc)this.cubeDesc);
            this.reducerMapping = new FactDistinctColumnsReducerMapping(this.cube);
            this.allCols = this.reducerMapping.getAllDimDictCols();
            this.intermediateTableDesc = new CubeJoinedFlatTableEnrich(EngineFactory.getJoinedFlatTableDesc((CubeSegment)this.cubeSeg), this.cubeDesc);
            this.columnIndex = new int[this.allCols.size()];
            for (int i = 0; i < this.allCols.size(); ++i) {
                int columnIndexOnFlatTbl;
                TblColRef colRef = this.allCols.get(i);
                this.columnIndex[i] = columnIndexOnFlatTbl = this.intermediateTableDesc.getColumnIndex(colRef);
            }
            this.tmpbuf = ByteBuffer.allocate(4096);
            this.nRowKey = this.cubeDesc.getRowkey().getRowKeyColumns().length;
            HashSet cuboidIdSet = Sets.newHashSet((Iterable)this.cubeSeg.getCuboidScheduler().getAllCuboidIds());
            if (StatisticsDecisionUtil.isAbleToOptimizeCubingPlan(this.cubeSeg)) {
                cuboidIdSet.addAll(this.cubeSeg.getCubeDesc().getMandatoryCuboids());
            }
            this.cuboidIds = cuboidIdSet.toArray(new Long[cuboidIdSet.size()]);
            this.allCuboidsBitSet = CuboidUtil.getCuboidBitSet((Long[])this.cuboidIds, (int)this.nRowKey);
            this.allCuboidsHLL = new HLLCounter[this.cuboidIds.length];
            for (int i = 0; i < this.cuboidIds.length; ++i) {
                this.allCuboidsHLL[i] = new HLLCounter(this.cubeDesc.getConfig().getCubeStatsHLLPrecision(), RegisterType.DENSE);
            }
            if (KylinVersion.isBefore200((String)this.cubeDesc.getVersion())) {
                isUsePutRowKeyToHllNewAlgorithm = false;
                logger.info("Found KylinVersion : {}. Use old algorithm for cuboid sampling.", (Object)this.cubeDesc.getVersion());
            } else {
                isUsePutRowKeyToHllNewAlgorithm = true;
                logger.info("Found KylinVersion : {}. Use new algorithm for cuboid sampling. About the details of the new algorithm, please refer to KYLIN-2518", (Object)this.cubeDesc.getVersion());
            }
            int calculatorNum = this.getStatsThreadNum(this.cuboidIds.length);
            this.cuboidStatCalculators = new FactDistinctColumnsMapper.CuboidStatCalculator[calculatorNum];
            int splitSize = this.cuboidIds.length / calculatorNum;
            if (splitSize <= 0) {
                splitSize = 1;
            }
            for (int i = 0; i < calculatorNum && (start = i * splitSize) < this.cuboidIds.length; ++i) {
                FactDistinctColumnsMapper.CuboidStatCalculator calculator;
                int end = (i + 1) * splitSize;
                if (i == calculatorNum - 1) {
                    end = this.cuboidIds.length;
                }
                HLLCounter[] cuboidsHLLSplit = Arrays.copyOfRange(this.allCuboidsHLL, start, end);
                Integer[][] cuboidsBitSetSplit = (Integer[][])Arrays.copyOfRange(this.allCuboidsBitSet, start, end);
                Long[] cuboidIdSplit = Arrays.copyOfRange(this.cuboidIds, start, end);
                this.cuboidStatCalculators[i] = calculator = new FactDistinctColumnsMapper.CuboidStatCalculator(i, this.intermediateTableDesc.getRowKeyColumnIndexes(), cuboidIdSplit, cuboidsBitSetSplit, isUsePutRowKeyToHllNewAlgorithm, cuboidsHLLSplit);
                calculator.start();
            }
            this.dictColDeduper = new FactDistinctColumnsMapper.DictColDeduper();
            Set dictCols = this.cubeDesc.getAllColumnsNeedDictionaryBuilt();
            for (int i = 0; i < this.allCols.size(); ++i) {
                if (!dictCols.contains(this.allCols.get(i))) continue;
                this.dictColDeduper.setIsDictCol(i);
            }
        }
    }

    private int getStatsThreadNum(int cuboidNum) {
        int unitNum = this.cubeDesc.getConfig().getCuboidNumberPerStatsCalculator();
        if (unitNum <= 0) {
            logger.warn("config from getCuboidNumberPerStatsCalculator() " + unitNum + " is should larger than 0");
            logger.info("Will use single thread for cuboid statistics calculation");
            return 1;
        }
        int calculatorNum = (cuboidNum - 1) / unitNum + 1;
        int maxCalculatorNum = this.cubeDesc.getConfig().getCuboidStatsCalculatorMaxNumber();
        if (calculatorNum > maxCalculatorNum) {
            calculatorNum = maxCalculatorNum;
        }
        return calculatorNum;
    }

    private int countNewSize(int oldSize, int dataSize) {
        int newSize;
        for (newSize = oldSize * 2; newSize < dataSize; newSize *= 2) {
        }
        return newSize;
    }

    private void writeFieldValue(DataType type, Integer colIndex, String value, Visitor visitor) {
        int reducerIndex = this.reducerMapping.getReducerIdForCol(colIndex, value);
        this.tmpbuf.clear();
        byte[] valueBytes = Bytes.toBytes((String)value);
        int size = valueBytes.length + 1;
        if (size >= this.tmpbuf.capacity()) {
            this.tmpbuf = ByteBuffer.allocate(this.countNewSize(this.tmpbuf.capacity(), size));
        }
        this.tmpbuf.put(Bytes.toBytes((int)reducerIndex)[3]);
        this.tmpbuf.put(valueBytes);
        this.outputKey.set(this.tmpbuf.array(), 0, this.tmpbuf.position());
        this.sortableKey.init(this.outputKey, type);
        visitor.collect(null, this.sortableKey, this.emptyText, null);
        if (this.rowCount < 10) {
            logger.info("Sample output: " + this.allCols.get(colIndex) + " '" + value + "' => reducer " + reducerIndex);
        }
    }

    private void putRowKeyToHLL(String[] row) {
        for (FactDistinctColumnsMapper.CuboidStatCalculator cuboidStatCalculator : this.cuboidStatCalculators) {
            cuboidStatCalculator.putRow(row);
        }
    }

    public long countSizeInBytes(String[] row) {
        int size = 0;
        for (String s : row) {
            size += s == null ? 1 : StringUtil.utf8Length((CharSequence)s);
            ++size;
        }
        return size;
    }

    public void map(String[] row, Visitor visitor) {
        for (int i = 0; i < this.allCols.size(); ++i) {
            int colIndex = this.columnIndex[i];
            int rowSize = row.length;
            String fieldValue = " ";
            if (colIndex <= rowSize - 1) {
                fieldValue = row[colIndex];
            } else {
                logger.debug("colIndex:" + colIndex + " is more than rowSize: " + rowSize + " -1, so set empty value.");
            }
            if (fieldValue == null) continue;
            DataType type = this.allCols.get(i).getType();
            if (this.dictColDeduper.isDictCol(i)) {
                if (this.dictColDeduper.add(i, fieldValue)) {
                    this.writeFieldValue(type, i, fieldValue, visitor);
                }
            } else {
                DimensionRangeInfo old = this.dimensionRangeInfoMap.get(i);
                if (old == null) {
                    old = new DimensionRangeInfo(fieldValue, fieldValue);
                    this.dimensionRangeInfoMap.put(i, old);
                } else {
                    old.setMax(type.getOrder().max(old.getMax(), fieldValue));
                    old.setMin(type.getOrder().min(old.getMin(), fieldValue));
                }
            }
            if (this.rowCount % 100 < this.samplingPercentage) {
                this.putRowKeyToHLL(row);
            }
            if (this.rowCount % 100 == 0) {
                this.dictColDeduper.resetIfShortOfMem();
            }
            ++this.rowCount;
        }
    }

    public void postMap(Visitor visitor) throws IOException {
        ByteBuffer hllBuf = ByteBuffer.allocate(0x100000);
        for (FactDistinctColumnsMapper.CuboidStatCalculator cuboidStatCalculator : this.cuboidStatCalculators) {
            cuboidStatCalculator.waitForCompletion();
        }
        for (FactDistinctColumnsMapper.CuboidStatCalculator cuboidStatCalculator : this.cuboidStatCalculators) {
            Long[] cuboidIds = cuboidStatCalculator.getCuboidIds();
            HLLCounter[] cuboidsHLL = cuboidStatCalculator.getHLLCounters();
            for (int i = 0; i < cuboidIds.length; ++i) {
                HLLCounter hll = cuboidsHLL[i];
                this.tmpbuf.clear();
                this.tmpbuf.put((byte)-1);
                this.tmpbuf.putLong(cuboidIds[i]);
                this.outputKey.set(this.tmpbuf.array(), 0, this.tmpbuf.position());
                hllBuf.clear();
                hll.writeRegisters(hllBuf);
                this.outputValue.set(hllBuf.array(), 0, hllBuf.position());
                this.sortableKey.init(this.outputKey, (byte)0);
                visitor.collect(null, this.sortableKey, this.outputValue, null);
            }
        }
        for (Integer colIndex : this.dimensionRangeInfoMap.keySet()) {
            DimensionRangeInfo rangeInfo = this.dimensionRangeInfoMap.get(colIndex);
            DataType dataType = this.allCols.get(colIndex).getType();
            this.writeFieldValue(dataType, colIndex, rangeInfo.getMin(), visitor);
            this.writeFieldValue(dataType, colIndex, rangeInfo.getMax(), visitor);
        }
    }

    public void setupReduce(int taskId) throws IOException {
        this.taskId = taskId;
        try (KylinConfig.SetAndUnsetThreadLocalConfig autoUnset = KylinConfig.setAndUnsetThreadLocalConfig((KylinConfig)this.envConfig);){
            this.cube = CubeManager.getInstance((KylinConfig)this.envConfig).getCube(this.cubeName);
            this.cubeDesc = this.cube.getDescriptor();
            this.reducerMapping = new FactDistinctColumnsReducerMapping(this.cube);
            logger.info("reducer no " + taskId + ", role play " + this.reducerMapping.getRolePlayOfReducer(taskId));
            if (this.reducerMapping.isCuboidRowCounterReducer(taskId)) {
                this.isStatistics = true;
                this.baseCuboidId = this.cube.getCuboidScheduler().getBaseCuboidId();
                this.baseCuboidRowCountInMappers = Lists.newArrayList();
                this.cuboidHLLMap = Maps.newHashMap();
                logger.info("Reducer " + taskId + " handling stats");
            } else {
                this.col = this.reducerMapping.getColForReducer(taskId);
                Preconditions.checkNotNull((Object)this.col);
                this.buildDictInReducer = this.envConfig.isBuildDictInReducerEnabled();
                if (this.cubeDesc.getDictionaryBuilderClass(this.col) != null) {
                    this.buildDictInReducer = false;
                }
                if (this.reducerMapping.getReducerNumForDimCol(this.col) > 1) {
                    this.buildDictInReducer = false;
                }
                if (this.buildDictInReducer) {
                    this.builder = DictionaryGenerator.newDictionaryBuilder((DataType)this.col.getType());
                    this.builder.init(null, 0, null);
                }
                logger.info("Reducer " + taskId + " handling column " + this.col + ", buildDictInReducer=" + this.buildDictInReducer);
            }
        }
    }

    public void reduce(Pair<SelfDefineSortableKey, Text> kv, Visitor visitor) throws IOException {
        if (this.isStatistics) {
            long cuboidId = Bytes.toLong((byte[])((SelfDefineSortableKey)kv.getFirst()).getText().getBytes(), (int)1, (int)8);
            HLLCounter hll = new HLLCounter(this.cubeDesc.getConfig().getCubeStatsHLLPrecision());
            ByteBuffer bf = ByteBuffer.wrap(((Text)kv.getSecond()).getBytes(), 0, ((Text)kv.getSecond()).getLength());
            hll.readRegisters(bf);
            this.totalRowsBeforeMerge += hll.getCountEstimate();
            if (cuboidId == this.baseCuboidId) {
                this.baseCuboidRowCountInMappers.add(hll.getCountEstimate());
            }
            if (this.cuboidHLLMap.get(cuboidId) != null) {
                this.cuboidHLLMap.get(cuboidId).merge(hll);
            } else {
                this.cuboidHLLMap.put(cuboidId, hll);
            }
        } else {
            String value = Bytes.toString((byte[])((SelfDefineSortableKey)kv.getFirst()).getText().getBytes(), (int)1, (int)(((SelfDefineSortableKey)kv.getFirst()).getText().getLength() - 1));
            this.logAFewRows(value);
            if (this.cubeDesc.listDimensionColumnsExcludingDerived(true).contains(this.col) && this.col.getType().needCompare()) {
                if (this.minValue == null || this.col.getType().compare(this.minValue, value) > 0) {
                    this.minValue = value;
                }
                if (this.maxValue == null || this.col.getType().compare(this.maxValue, value) < 0) {
                    this.maxValue = value;
                }
            }
            if (this.cubeDesc.getAllColumnsNeedDictionaryBuilt().contains(this.col)) {
                if (this.buildDictInReducer) {
                    this.builder.addValue(value);
                } else {
                    byte[] keyBytes = Bytes.copy((byte[])((SelfDefineSortableKey)kv.getFirst()).getText().getBytes(), (int)1, (int)(((SelfDefineSortableKey)kv.getFirst()).getText().getLength() - 1));
                    String fileName = this.col.getIdentity() + "/";
                    visitor.collect("column", NullWritable.get(), new Text(keyBytes), fileName);
                }
            }
            ++this.rowCount;
        }
    }

    public void postReduce(Visitor visitor) throws IOException {
        if (this.isStatistics) {
            ArrayList allCuboids = Lists.newArrayList();
            allCuboids.addAll(this.cuboidHLLMap.keySet());
            Collections.sort(allCuboids);
            this.logMapperAndCuboidStatistics(allCuboids);
            this.outputStatistics(allCuboids, visitor);
        } else {
            if (this.cubeDesc.listDimensionColumnsExcludingDerived(true).contains(this.col)) {
                this.outputDimRangeInfo(visitor);
            }
            if (this.buildDictInReducer) {
                try (KylinConfig.SetAndUnsetThreadLocalConfig autoUnset = KylinConfig.setAndUnsetThreadLocalConfig((KylinConfig)this.envConfig);){
                    Dictionary dict = this.builder.build();
                    this.outputDict(this.col, (Dictionary<String>)dict, visitor);
                }
            }
        }
    }

    private void logAFewRows(String value) {
        if (this.rowCount < 10) {
            logger.info("Received value: " + value);
        }
    }

    private void outputDimRangeInfo(Visitor visitor) throws IOException {
        if (this.col != null && this.minValue != null) {
            String dimRangeFileName = this.col.getIdentity() + "/" + this.col.getName() + DIMENSION_COL_INFO_FILE_POSTFIX;
            visitor.collect("partition", NullWritable.get(), new Text(this.minValue.getBytes(StandardCharsets.UTF_8)), dimRangeFileName);
            visitor.collect("partition", NullWritable.get(), new Text(this.maxValue.getBytes(StandardCharsets.UTF_8)), dimRangeFileName);
            logger.info("write dimension range info for col : " + this.col.getName() + "  minValue:" + this.minValue + " maxValue:" + this.maxValue);
        }
    }

    private void outputDict(TblColRef col, Dictionary<String> dict, Visitor visitor) throws IOException {
        String dictFileName = col.getIdentity() + "/" + col.getName() + DICT_FILE_POSTFIX;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             DataOutputStream outputStream = new DataOutputStream((OutputStream)baos);){
            outputStream.writeUTF(dict.getClass().getName());
            dict.write((DataOutput)outputStream);
            visitor.collect("dict", NullWritable.get(), new ArrayPrimitiveWritable((Object)baos.toByteArray()), dictFileName);
        }
    }

    private void outputStatistics(List<Long> allCuboids, Visitor visitor) throws IOException {
        String statisticsFileName = "statistics/statistics";
        ByteBuffer valueBuf = ByteBuffer.allocate(0x100000);
        long grandTotal = 0L;
        for (HLLCounter hll : this.cuboidHLLMap.values()) {
            grandTotal += hll.getCountEstimate();
        }
        double mapperOverlapRatio = grandTotal == 0L ? 0.0 : (double)this.totalRowsBeforeMerge / (double)grandTotal;
        visitor.collect("statistics", new LongWritable(-1L), new BytesWritable(Bytes.toBytes((double)mapperOverlapRatio)), statisticsFileName);
        visitor.collect("statistics", new LongWritable(-2L), new BytesWritable(Bytes.toBytes((int)this.baseCuboidRowCountInMappers.size())), statisticsFileName);
        visitor.collect("statistics", new LongWritable(0L), new BytesWritable(Bytes.toBytes((int)this.samplingPercentage)), statisticsFileName);
        for (long i : allCuboids) {
            valueBuf.clear();
            this.cuboidHLLMap.get(i).writeRegisters(valueBuf);
            valueBuf.flip();
            visitor.collect("statistics", new LongWritable(i), new BytesWritable(valueBuf.array(), valueBuf.limit()), statisticsFileName);
        }
    }

    private void logMapperAndCuboidStatistics(List<Long> allCuboids) throws IOException {
        logger.info("Cuboid number for task: " + this.taskId + "\t" + allCuboids.size());
        logger.info("Samping percentage: \t" + this.samplingPercentage);
        logger.info("The following statistics are collected based on sampling data.");
        logger.info("Number of Mappers: " + this.baseCuboidRowCountInMappers.size());
        for (int i = 0; i < this.baseCuboidRowCountInMappers.size(); ++i) {
            if (this.baseCuboidRowCountInMappers.get(i) <= 0L) continue;
            logger.info("Base Cuboid in Mapper " + i + " row count: \t " + this.baseCuboidRowCountInMappers.get(i));
        }
        long grantTotal = 0L;
        for (long i : allCuboids) {
            grantTotal += this.cuboidHLLMap.get(i).getCountEstimate();
            logger.info("Cuboid " + i + " row count is: \t " + this.cuboidHLLMap.get(i).getCountEstimate());
        }
        logger.info("Sum of row counts (before merge) is: \t " + this.totalRowsBeforeMerge);
        logger.info("After merge, the row count: \t " + grantTotal);
    }

    public static abstract class Visitor<K, V> {
        public abstract void collect(String var1, K var2, V var3, String var4);
    }
}

