/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.io.IOException;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;

public class BuildGlobalHiveDictPartPartitioner
extends Partitioner<Text, NullWritable>
implements Configurable {
    private Configuration conf;
    private Integer[] reduceNumArr;

    public void setConf(Configuration configuration) {
        KylinConfig config;
        this.conf = configuration;
        try {
            config = AbstractHadoopJob.loadKylinPropsAndMetadata();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.reduceNumArr = config.getMrHiveDictColumnsReduceNumExcludeRefCols();
    }

    public int getPartition(Text key, NullWritable value, int numReduceTasks) {
        int colIndex = key.getBytes()[0];
        int colReduceNum = this.reduceNumArr[colIndex];
        int colReduceNumOffset = 0;
        for (int i = 0; i < colIndex; ++i) {
            colReduceNumOffset += this.reduceNumArr[i].intValue();
        }
        byte[] keyBytes = Bytes.copy((byte[])key.getBytes(), (int)1, (int)(key.getLength() - 1));
        int hashCode = new Text(keyBytes).hashCode() & Integer.MAX_VALUE;
        return hashCode % colReduceNum + colReduceNumOffset;
    }

    public Configuration getConf() {
        return this.conf;
    }
}

