/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.engine.mr.KylinMapper;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildGlobalHiveDictPartBuildMapper<KEYIN, Object>
extends KylinMapper<KEYIN, Object, Text, NullWritable> {
    private static final Logger logger = LoggerFactory.getLogger(BuildGlobalHiveDictPartBuildMapper.class);
    private Integer colIndex;
    private ByteBuffer tmpbuf;
    private Text outputKey = new Text();
    private long count = 0L;

    @Override
    protected void doSetup(Mapper.Context context) throws IOException, InterruptedException {
        KylinConfig config;
        this.tmpbuf = ByteBuffer.allocate(64);
        try {
            config = AbstractHadoopJob.loadKylinPropsAndMetadata();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Object[] dicCols = config.getMrHiveDictColumnsExcludeRefColumns();
        logger.info("kylin.dictionary.mr-hive.columns: exclude ref cols {}", dicCols);
        FileSplit fileSplit = (FileSplit)context.getInputSplit();
        String name = fileSplit.getPath().getParent().getName();
        logger.info("this map file name :{}", (Object)name);
        String colName = name.split("=")[1];
        logger.info("this map build col name :{}", (Object)colName);
        for (int i = 0; i < dicCols.length; ++i) {
            if (!((String)dicCols[i]).equalsIgnoreCase(colName)) continue;
            this.colIndex = i;
        }
        if (this.colIndex < 0 || this.colIndex > 127) {
            logger.error("kylin.dictionary.mr-hive.columns colIndex :{} error ", (Object)this.colIndex);
            logger.error("kylin.dictionary.mr-hive.columns set error,mr-hive columns's count should less than 128");
        }
        logger.info("this map build col index :{}", (Object)this.colIndex);
    }

    @Override
    public void doMap(KEYIN key, Object record, Mapper.Context context) throws IOException, InterruptedException {
        ++this.count;
        this.writeFieldValue(context, key.toString());
    }

    private void writeFieldValue(Mapper.Context context, String value) throws IOException, InterruptedException {
        this.tmpbuf.clear();
        byte[] valueBytes = Bytes.toBytes((String)value);
        int size = valueBytes.length + 1;
        if (size >= this.tmpbuf.capacity()) {
            this.tmpbuf = ByteBuffer.allocate(this.countNewSize(this.tmpbuf.capacity(), size));
        }
        this.tmpbuf.put(this.colIndex.byteValue());
        this.tmpbuf.put(valueBytes);
        this.outputKey.set(this.tmpbuf.array(), 0, this.tmpbuf.position());
        context.write((Object)this.outputKey, (Object)NullWritable.get());
        if (this.count < 10L) {
            logger.info("colIndex:{},input key:{}", (Object)this.colIndex, (Object)value);
        }
    }

    private int countNewSize(int oldSize, int dataSize) {
        int newSize;
        for (newSize = oldSize * 2; newSize < dataSize; newSize *= 2) {
        }
        return newSize;
    }
}

