/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.CubeJoinedFlatTableEnrich;
import org.apache.kylin.engine.EngineFactory;
import org.apache.kylin.engine.mr.KylinMapper;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.engine.mr.common.BaseCuboidBuilder;
import org.apache.kylin.engine.mr.common.DictionaryGetterUtil;
import org.apache.kylin.metadata.model.TblColRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseCuboidMapperBase<KEYIN, VALUEIN>
extends KylinMapper<KEYIN, VALUEIN, Text, Text> {
    protected static final Logger logger = LoggerFactory.getLogger(BaseCuboidMapperBase.class);
    public static final byte[] ONE = Bytes.toBytes((String)"1");
    protected String cubeName;
    protected String segmentID;
    protected CubeInstance cube;
    protected CubeDesc cubeDesc;
    protected CubeSegment cubeSegment;
    protected int counter;
    protected Object[] measures;
    private int errorRecordCounter;
    protected Text outputKey = new Text();
    protected Text outputValue = new Text();
    private BaseCuboidBuilder baseCuboidBuilder;

    @Override
    protected void doSetup(Mapper.Context context) throws IOException {
        super.bindCurrentConfiguration(context.getConfiguration());
        this.cubeName = context.getConfiguration().get("cube.name");
        this.segmentID = context.getConfiguration().get("cube.segment.id");
        KylinConfig kylinConfig = AbstractHadoopJob.loadKylinPropsAndMetadata();
        this.cube = CubeManager.getInstance((KylinConfig)kylinConfig).getCube(this.cubeName);
        this.cubeDesc = this.cube.getDescriptor();
        this.cubeSegment = this.cube.getSegmentById(this.segmentID);
        CubeJoinedFlatTableEnrich intermediateTableDesc = new CubeJoinedFlatTableEnrich(EngineFactory.getJoinedFlatTableDesc((CubeSegment)this.cubeSegment), this.cubeDesc);
        Map<TblColRef, Dictionary<String>> dictionaryMap = DictionaryGetterUtil.getDictionaryMap(this.cubeSegment, context.getInputSplit(), context.getConfiguration());
        this.baseCuboidBuilder = new BaseCuboidBuilder(kylinConfig, this.cubeDesc, this.cubeSegment, intermediateTableDesc, dictionaryMap);
    }

    protected void outputKV(String[] flatRow, Mapper.Context context) throws IOException, InterruptedException {
        byte[] rowKey = this.baseCuboidBuilder.buildKey(flatRow);
        this.outputKey.set(rowKey, 0, rowKey.length);
        ByteBuffer valueBuf = this.baseCuboidBuilder.buildValue(flatRow);
        this.outputValue.set(valueBuf.array(), 0, valueBuf.position());
        context.write((Object)this.outputKey, (Object)this.outputValue);
    }

    protected void handleErrorRecord(String[] flatRow, Exception ex) throws IOException {
        logger.error("Insane record: " + Arrays.toString(flatRow), (Throwable)ex);
        ++this.errorRecordCounter;
        if (this.errorRecordCounter > this.cubeSegment.getConfig().getErrorRecordThreshold()) {
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException("", ex);
        }
    }
}

