/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.common;

import java.io.Serializable;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.common.RowKeySplitter;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.kv.RowKeyEncoder;
import org.apache.kylin.cube.kv.RowKeyEncoderProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NDCuboidBuilder
implements Serializable {
    protected static final Logger logger = LoggerFactory.getLogger(NDCuboidBuilder.class);
    protected String cubeName;
    protected String segmentID;
    protected CubeSegment cubeSegment;
    private RowKeySplitter rowKeySplitter;
    private RowKeyEncoderProvider rowKeyEncoderProvider;
    private ByteArray newKeyBodyBuf = null;

    public NDCuboidBuilder(CubeSegment cubeSegment) {
        this(cubeSegment, new RowKeyEncoderProvider(cubeSegment));
    }

    public NDCuboidBuilder(CubeSegment cubeSegment, RowKeyEncoderProvider rowKeyEncoderProvider) {
        this.cubeSegment = cubeSegment;
        this.rowKeyEncoderProvider = rowKeyEncoderProvider;
        this.rowKeySplitter = new RowKeySplitter(cubeSegment);
    }

    public Pair<Integer, ByteArray> buildKey(Cuboid parentCuboid, Cuboid childCuboid, ByteArray[] splitBuffers) {
        RowKeyEncoder rowkeyEncoder = this.rowKeyEncoderProvider.getRowkeyEncoder(childCuboid);
        int fullKeySize = rowkeyEncoder.getBytesLength();
        if (this.newKeyBodyBuf == null || this.newKeyBodyBuf.length() < fullKeySize) {
            this.newKeyBodyBuf = new ByteArray(fullKeySize);
        }
        this.buildKeyInternal(parentCuboid, childCuboid, splitBuffers, this.newKeyBodyBuf);
        return new Pair((Object)fullKeySize, (Object)this.newKeyBodyBuf);
    }

    public ByteArray buildKey2(Cuboid parentCuboid, Cuboid childCuboid, ByteArray[] splitBuffers) {
        RowKeyEncoder rowkeyEncoder = this.rowKeyEncoderProvider.getRowkeyEncoder(childCuboid);
        int fullKeySize = rowkeyEncoder.getBytesLength();
        ByteArray newKey = new ByteArray(fullKeySize);
        this.buildKeyInternal(parentCuboid, childCuboid, splitBuffers, newKey);
        return newKey;
    }

    private void buildKeyInternal(Cuboid parentCuboid, Cuboid childCuboid, ByteArray[] splitBuffers, ByteArray newKeyBodyBuf) {
        RowKeyEncoder rowkeyEncoder = this.rowKeyEncoderProvider.getRowkeyEncoder(childCuboid);
        long mask = Long.highestOneBit(parentCuboid.getId());
        long parentCuboidId = parentCuboid.getId();
        long childCuboidId = childCuboid.getId();
        long parentCuboidIdActualLength = 64L - (long)Long.numberOfLeadingZeros(parentCuboid.getId());
        int index = this.rowKeySplitter.getBodySplitOffset();
        int offset = 10;
        int i = 0;
        while ((long)i < parentCuboidIdActualLength) {
            if ((mask & parentCuboidId) > 0L) {
                if ((mask & childCuboidId) > 0L) {
                    System.arraycopy(splitBuffers[index].array(), splitBuffers[index].offset(), newKeyBodyBuf.array(), offset, splitBuffers[index].length());
                    offset += splitBuffers[index].length();
                }
                ++index;
            }
            mask >>= 1;
            ++i;
        }
        rowkeyEncoder.fillHeader(newKeyBodyBuf.array());
    }
}

