/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.common;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.CuboidScheduler;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.engine.mr.common.CubeStatsReader;
import org.apache.kylin.engine.mr.common.CuboidStatsReaderUtil;
import org.apache.kylin.job.exception.JobException;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapReduceUtil {
    private static final Logger logger = LoggerFactory.getLogger(MapReduceUtil.class);

    public static int getCuboidHLLCounterReducerNum(CubeInstance cube) {
        int hllMaxReducerNumber;
        int nCuboids = cube.getCuboidScheduler().getAllCuboidIds().size();
        int shardBase = (nCuboids - 1) / cube.getConfig().getHadoopJobPerReducerHLLCuboidNumber() + 1;
        if (shardBase > (hllMaxReducerNumber = cube.getConfig().getHadoopJobHLLMaxReducerNumber())) {
            shardBase = hllMaxReducerNumber;
        }
        return shardBase;
    }

    public static int getLayeredCubingReduceTaskNum(CubeSegment cubeSegment, CuboidScheduler cuboidScheduler, double totalMapInputMB, int level) throws ClassNotFoundException, IOException, InterruptedException, JobException {
        double adjustedCurrentLayerSizeEst;
        CubeDesc cubeDesc = cubeSegment.getCubeDesc();
        KylinConfig kylinConfig = cubeDesc.getConfig();
        double perReduceInputMB = kylinConfig.getDefaultHadoopJobReducerInputMB();
        double reduceCountRatio = kylinConfig.getDefaultHadoopJobReducerCountRatio();
        logger.info("Having per reduce MB " + perReduceInputMB + ", reduce count ratio " + reduceCountRatio + ", level " + level);
        CubeStatsReader cubeStatsReader = new CubeStatsReader(cubeSegment, cuboidScheduler, kylinConfig);
        if (level == -1) {
            double estimatedSize = cubeStatsReader.estimateCubeSize();
            adjustedCurrentLayerSizeEst = estimatedSize > totalMapInputMB ? totalMapInputMB : estimatedSize;
            logger.debug("estimated size {}, input size {}, adjustedCurrentLayerSizeEst: {}", new Object[]{estimatedSize, totalMapInputMB, adjustedCurrentLayerSizeEst});
        } else if (level == 0) {
            adjustedCurrentLayerSizeEst = cubeStatsReader.estimateLayerSize(0);
            logger.debug("adjustedCurrentLayerSizeEst: {}", (Object)adjustedCurrentLayerSizeEst);
        } else {
            double parentLayerSizeEst = cubeStatsReader.estimateLayerSize(level - 1);
            double currentLayerSizeEst = cubeStatsReader.estimateLayerSize(level);
            adjustedCurrentLayerSizeEst = totalMapInputMB / parentLayerSizeEst * currentLayerSizeEst;
            logger.debug("totalMapInputMB: {}, parentLayerSizeEst: {}, currentLayerSizeEst: {}, adjustedCurrentLayerSizeEst: {}", new Object[]{totalMapInputMB, parentLayerSizeEst, currentLayerSizeEst, adjustedCurrentLayerSizeEst});
        }
        int numReduceTasks = (int)Math.round(adjustedCurrentLayerSizeEst / perReduceInputMB * reduceCountRatio + 0.99);
        if (cubeDesc.hasMemoryHungryMeasures()) {
            logger.debug("Multiply reducer num by 4 to boost performance for memory hungry measures");
            numReduceTasks *= 4;
        }
        numReduceTasks = Math.max(kylinConfig.getHadoopJobMinReducerNumber(), numReduceTasks);
        numReduceTasks = Math.min(kylinConfig.getHadoopJobMaxReducerNumber(), numReduceTasks);
        return numReduceTasks;
    }

    public static int getInmemCubingReduceTaskNum(CubeSegment cubeSeg, CuboidScheduler cuboidScheduler) throws IOException {
        KylinConfig kylinConfig = cubeSeg.getConfig();
        Map<Long, Double> cubeSizeMap = new CubeStatsReader(cubeSeg, cuboidScheduler, kylinConfig).getCuboidSizeMap();
        double totalSizeInM = 0.0;
        for (Double cuboidSize : cubeSizeMap.values()) {
            totalSizeInM += cuboidSize.doubleValue();
        }
        return MapReduceUtil.getReduceTaskNum(totalSizeInM, kylinConfig);
    }

    public static Pair<Integer, Integer> getConvergeCuboidDataReduceTaskNums(CubeSegment cubeSeg) throws IOException {
        long baseCuboidId = cubeSeg.getCuboidScheduler().getBaseCuboidId();
        HashSet overlapCuboids = Sets.newHashSet((Iterable)cubeSeg.getCuboidScheduler().getAllCuboidIds());
        overlapCuboids.retainAll(cubeSeg.getCubeInstance().getCuboidsRecommend());
        overlapCuboids.add(baseCuboidId);
        Pair<Map<Long, Long>, Long> cuboidStats = CuboidStatsReaderUtil.readCuboidStatsWithSourceFromSegment(overlapCuboids, cubeSeg);
        Map<Long, Double> cubeSizeMap = CubeStatsReader.getCuboidSizeMapFromRowCount(cubeSeg, (Map)cuboidStats.getFirst(), (Long)cuboidStats.getSecond());
        double totalSizeInM = 0.0;
        for (Double cuboidSize : cubeSizeMap.values()) {
            totalSizeInM += cuboidSize.doubleValue();
        }
        double baseSizeInM = cubeSizeMap.get(baseCuboidId);
        KylinConfig kylinConfig = cubeSeg.getConfig();
        int nBase = MapReduceUtil.getReduceTaskNum(baseSizeInM, kylinConfig);
        int nOther = MapReduceUtil.getReduceTaskNum(totalSizeInM - baseSizeInM, kylinConfig);
        return new Pair((Object)(nBase + nOther), (Object)nBase);
    }

    private static int getReduceTaskNum(double totalSizeInM, KylinConfig kylinConfig) {
        double perReduceInputMB = kylinConfig.getDefaultHadoopJobReducerInputMB();
        double reduceCountRatio = kylinConfig.getDefaultHadoopJobReducerCountRatio();
        int numReduceTasks = (int)Math.round(totalSizeInM / perReduceInputMB * reduceCountRatio);
        numReduceTasks = Math.max(kylinConfig.getHadoopJobMinReducerNumber(), numReduceTasks);
        numReduceTasks = Math.min(kylinConfig.getHadoopJobMaxReducerNumber(), numReduceTasks);
        logger.info("Having total map input MB " + Math.round(totalSizeInM));
        logger.info("Having per reduce MB " + perReduceInputMB);
        logger.info("Setting mapreduce.job.reduces=" + numReduceTasks);
        return numReduceTasks;
    }
}

