/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.common;

import java.io.DataInput;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.dict.ShrunkenDictionary;
import org.apache.kylin.engine.mr.MRUtil;
import org.apache.kylin.metadata.model.TblColRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictionaryGetterUtil {
    private static final Logger logger = LoggerFactory.getLogger(DictionaryGetterUtil.class);

    public static String getInputSplitSignature(CubeSegment cubeSegment, InputSplit inputSplit) {
        return MRUtil.getBatchCubingInputSide(cubeSegment).getFlatTableInputFormat().getInputSplitSignature(inputSplit);
    }

    public static Map<TblColRef, Dictionary<String>> getDictionaryMap(CubeSegment cubeSegment, InputSplit inputSplit, Configuration configuration) throws IOException {
        Map dictionaryMap = cubeSegment.buildDictionaryMap();
        String shrunkenDictPath = configuration.get("shrunkenDictPath");
        if (shrunkenDictPath == null) {
            return dictionaryMap;
        }
        String inputSplitSignature = DictionaryGetterUtil.getInputSplitSignature(cubeSegment, inputSplit);
        FileSystem fs = FileSystem.get((Configuration)configuration);
        ShrunkenDictionary.StringValueSerializer valueSerializer = new ShrunkenDictionary.StringValueSerializer();
        for (TblColRef colRef : cubeSegment.getCubeDesc().getAllGlobalDictColumns()) {
            Path colShrunkenDictDir = new Path(shrunkenDictPath, colRef.getIdentity());
            Path colShrunkenDictPath = new Path(colShrunkenDictDir, inputSplitSignature);
            if (!fs.exists(colShrunkenDictPath)) {
                logger.warn("Shrunken dictionary for column " + colRef.getIdentity() + " in split " + inputSplitSignature + " does not exist!!!");
                continue;
            }
            FSDataInputStream dis = fs.open(colShrunkenDictPath);
            Throwable throwable = null;
            try {
                ShrunkenDictionary shrunkenDict = new ShrunkenDictionary((ShrunkenDictionary.ValueSerializer)valueSerializer);
                shrunkenDict.readFields((DataInput)dis);
                dictionaryMap.put(colRef, shrunkenDict);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dis == null) continue;
                if (throwable != null) {
                    try {
                        dis.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dis.close();
            }
        }
        return dictionaryMap;
    }
}

