/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.CuboidModeEnum;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.engine.EngineFactory;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.engine.mr.ILookupMaterializer;
import org.apache.kylin.engine.mr.LookupMaterializeContext;
import org.apache.kylin.engine.mr.MRUtil;
import org.apache.kylin.engine.mr.common.HadoopShellExecutable;
import org.apache.kylin.engine.mr.common.MapReduceExecutable;
import org.apache.kylin.engine.mr.steps.BuildGlobalHiveDictPartBuildJob;
import org.apache.kylin.engine.mr.steps.BuildGlobalHiveDictTotalBuildJob;
import org.apache.kylin.engine.mr.steps.CalculateStatsFromBaseCuboidJob;
import org.apache.kylin.engine.mr.steps.CreateDictionaryJob;
import org.apache.kylin.engine.mr.steps.CubingExecutableUtil;
import org.apache.kylin.engine.mr.steps.ExtractDictionaryFromGlobalJob;
import org.apache.kylin.engine.mr.steps.FactDistinctColumnsJob;
import org.apache.kylin.engine.mr.steps.MergeDictionaryStep;
import org.apache.kylin.engine.mr.steps.MergeStatisticsStep;
import org.apache.kylin.engine.mr.steps.SaveStatisticsStep;
import org.apache.kylin.engine.mr.steps.UHCDictionaryJob;
import org.apache.kylin.engine.mr.steps.UpdateCubeInfoAfterBuildStep;
import org.apache.kylin.engine.mr.steps.UpdateCubeInfoAfterMergeStep;
import org.apache.kylin.engine.mr.steps.UpdateDictionaryStep;
import org.apache.kylin.job.engine.JobEngineConfig;
import org.apache.kylin.metadata.model.IJoinedFlatTableDesc;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.kylin.shaded.com.google.common.collect.Lists;

public class JobBuilderSupport {
    protected final JobEngineConfig config;
    protected final CubeSegment seg;
    protected final String submitter;
    protected final Integer priorityOffset;
    public static final String LayeredCuboidFolderPrefix = "level_";
    public static final String PathNameCuboidBase = "base_cuboid";
    public static final String PathNameCuboidOld = "old";
    public static final String PathNameCuboidInMem = "in_memory";
    public static final Pattern JOB_NAME_PATTERN = Pattern.compile("kylin-([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})");

    public JobBuilderSupport(CubeSegment seg, String submitter) {
        this(seg, submitter, 0);
    }

    public JobBuilderSupport(CubeSegment seg, String submitter, Integer priorityOffset) {
        Preconditions.checkNotNull((Object)seg, (Object)"segment cannot be null");
        this.config = new JobEngineConfig(seg.getConfig());
        this.seg = seg;
        this.submitter = submitter;
        this.priorityOffset = priorityOffset;
    }

    public MapReduceExecutable createFactDistinctColumnsStep(String jobId) {
        MapReduceExecutable result = new MapReduceExecutable();
        result.setName("Extract Fact Table Distinct Columns");
        result.setMapReduceJobClass(FactDistinctColumnsJob.class);
        StringBuilder cmd = new StringBuilder();
        this.appendMapReduceParameters(cmd);
        JobBuilderSupport.appendExecCmdParameters(cmd, "cubename", this.seg.getRealization().getName());
        JobBuilderSupport.appendExecCmdParameters(cmd, "output", this.getFactDistinctColumnsPath(jobId));
        JobBuilderSupport.appendExecCmdParameters(cmd, "segmentid", this.seg.getUuid());
        JobBuilderSupport.appendExecCmdParameters(cmd, "statisticsoutput", this.getStatisticsPath(jobId));
        JobBuilderSupport.appendExecCmdParameters(cmd, "statisticssamplingpercent", String.valueOf(this.config.getConfig().getCubingInMemSamplingPercent()));
        JobBuilderSupport.appendExecCmdParameters(cmd, "jobname", "Kylin_Fact_Distinct_Columns_" + this.seg.getRealization().getName() + "_Step");
        JobBuilderSupport.appendExecCmdParameters(cmd, "cubingJobId", jobId);
        result.setMapReduceParams(cmd.toString());
        result.setCounterSaveAs("sourceRecordCount,sourceSizeBytes");
        return result;
    }

    public MergeStatisticsStep createMergeStatisticsStep(CubeSegment seg, List<String> mergingSegmentIds, String mergedStatisticsFolder) {
        MergeStatisticsStep result = new MergeStatisticsStep();
        result.setName("Merge Cuboid Statistics");
        CubingExecutableUtil.setCubeName(seg.getRealization().getName(), result.getParams());
        CubingExecutableUtil.setSegmentId(seg.getUuid(), result.getParams());
        CubingExecutableUtil.setMergingSegmentIds(mergingSegmentIds, result.getParams());
        CubingExecutableUtil.setMergedStatisticsPath(mergedStatisticsFolder, result.getParams());
        return result;
    }

    public UpdateDictionaryStep createUpdateDictionaryStep(CubeSegment seg, String jobId, List<String> mergingSegmentIds) {
        UpdateDictionaryStep result = new UpdateDictionaryStep();
        result.setName("Update Dictionary Data");
        CubingExecutableUtil.setCubeName(seg.getRealization().getName(), result.getParams());
        CubingExecutableUtil.setSegmentId(seg.getUuid(), result.getParams());
        CubingExecutableUtil.setMergingSegmentIds(mergingSegmentIds, result.getParams());
        result.getParams().put("dictPath", this.getDictInfoPath(jobId));
        result.getParams().put("metadataUrl", this.getSegmentMetadataUrl(seg.getConfig(), jobId));
        return result;
    }

    public MapReduceExecutable createBuildUHCDictStep(String jobId) {
        MapReduceExecutable result = new MapReduceExecutable();
        result.setName("Build UHC Dictionary");
        result.setMapReduceJobClass(UHCDictionaryJob.class);
        StringBuilder cmd = new StringBuilder();
        this.appendMapReduceParameters(cmd);
        JobBuilderSupport.appendExecCmdParameters(cmd, "cubename", this.seg.getRealization().getName());
        JobBuilderSupport.appendExecCmdParameters(cmd, "output", this.getDictRootPath(jobId));
        JobBuilderSupport.appendExecCmdParameters(cmd, "input", this.getFactDistinctColumnsPath(jobId));
        JobBuilderSupport.appendExecCmdParameters(cmd, "jobname", "Kylin_Build_UHC_Dict" + this.seg.getRealization().getName());
        JobBuilderSupport.appendExecCmdParameters(cmd, "cubingJobId", jobId);
        result.setMapReduceParams(cmd.toString());
        result.setCounterSaveAs("sourceRecordCount,sourceSizeBytes");
        return result;
    }

    public MapReduceExecutable createCalculateStatsFromBaseCuboid(String inputPath, String outputPath) {
        return this.createCalculateStatsFromBaseCuboid(inputPath, outputPath, CuboidModeEnum.CURRENT);
    }

    public MapReduceExecutable createCalculateStatsFromBaseCuboid(String inputPath, String outputPath, CuboidModeEnum cuboidMode) {
        MapReduceExecutable result = new MapReduceExecutable();
        result.setName("Calculate Statistics from Base Cuboid");
        result.setMapReduceJobClass(CalculateStatsFromBaseCuboidJob.class);
        StringBuilder cmd = new StringBuilder();
        this.appendMapReduceParameters(cmd);
        JobBuilderSupport.appendExecCmdParameters(cmd, "cubename", this.seg.getRealization().getName());
        JobBuilderSupport.appendExecCmdParameters(cmd, "segmentid", this.seg.getUuid());
        JobBuilderSupport.appendExecCmdParameters(cmd, "input", inputPath);
        JobBuilderSupport.appendExecCmdParameters(cmd, "output", outputPath);
        JobBuilderSupport.appendExecCmdParameters(cmd, "statisticssamplingpercent", String.valueOf(this.config.getConfig().getCubingInMemSamplingPercent()));
        JobBuilderSupport.appendExecCmdParameters(cmd, "jobname", "Calculate_Stats_For_Segment_" + this.seg.getRealization().getName() + "_Step");
        JobBuilderSupport.appendExecCmdParameters(cmd, "cuboidMode", cuboidMode.toString());
        result.setMapReduceParams(cmd.toString());
        return result;
    }

    public HadoopShellExecutable createBuildDictionaryStep(String jobId) {
        HadoopShellExecutable buildDictionaryStep = new HadoopShellExecutable();
        buildDictionaryStep.setName("Build Dimension Dictionary");
        StringBuilder cmd = new StringBuilder();
        JobBuilderSupport.appendExecCmdParameters(cmd, "cubename", this.seg.getRealization().getName());
        JobBuilderSupport.appendExecCmdParameters(cmd, "segmentid", this.seg.getUuid());
        JobBuilderSupport.appendExecCmdParameters(cmd, "input", this.getFactDistinctColumnsPath(jobId));
        JobBuilderSupport.appendExecCmdParameters(cmd, "dictPath", this.getDictRootPath(jobId));
        JobBuilderSupport.appendExecCmdParameters(cmd, "cubingJobId", jobId);
        buildDictionaryStep.setJobParams(cmd.toString());
        buildDictionaryStep.setJobClass(CreateDictionaryJob.class);
        return buildDictionaryStep;
    }

    public MapReduceExecutable createExtractDictionaryFromGlobalJob(String jobId) {
        MapReduceExecutable result = new MapReduceExecutable();
        result.setName("Extract Dictionary from Global Dictionary");
        result.setMapReduceJobClass(ExtractDictionaryFromGlobalJob.class);
        StringBuilder cmd = new StringBuilder();
        this.appendMapReduceParameters(cmd);
        JobBuilderSupport.appendExecCmdParameters(cmd, "cubename", this.seg.getRealization().getName());
        JobBuilderSupport.appendExecCmdParameters(cmd, "segmentid", this.seg.getUuid());
        JobBuilderSupport.appendExecCmdParameters(cmd, "jobname", "Kylin_Extract_Dictionary_from_Global_" + this.seg.getRealization().getName() + "_Step");
        JobBuilderSupport.appendExecCmdParameters(cmd, "cubingJobId", jobId);
        JobBuilderSupport.appendExecCmdParameters(cmd, "output", this.getShrunkenDictionaryPath(jobId));
        result.setMapReduceParams(cmd.toString());
        return result;
    }

    public MapReduceExecutable createBuildGlobalHiveDictPartBuildJob(String jobId) {
        MapReduceExecutable result = new MapReduceExecutable();
        result.setName("Build Hive Global Dict - parallel part build");
        result.setMapReduceJobClass(BuildGlobalHiveDictPartBuildJob.class);
        StringBuilder cmd = new StringBuilder();
        this.appendMapReduceParameters(cmd);
        JobBuilderSupport.appendExecCmdParameters(cmd, "cubename", this.seg.getRealization().getName());
        JobBuilderSupport.appendExecCmdParameters(cmd, "segmentid", this.seg.getUuid());
        JobBuilderSupport.appendExecCmdParameters(cmd, "jobname", "Build Hive Global Dict - parallel part build" + this.seg.getRealization().getName() + "_Step");
        JobBuilderSupport.appendExecCmdParameters(cmd, "output", this.getBuildGlobalDictionaryBasePath(jobId));
        result.setMapReduceParams(cmd.toString());
        return result;
    }

    public MapReduceExecutable createBuildGlobalHiveDictTotalBuildJob(String jobId) {
        MapReduceExecutable result = new MapReduceExecutable();
        result.setName("Build Hive Global Dict - parallel total build");
        result.setMapReduceJobClass(BuildGlobalHiveDictTotalBuildJob.class);
        StringBuilder cmd = new StringBuilder();
        this.appendMapReduceParameters(cmd);
        JobBuilderSupport.appendExecCmdParameters(cmd, "cubename", this.seg.getRealization().getName());
        JobBuilderSupport.appendExecCmdParameters(cmd, "segmentid", this.seg.getUuid());
        JobBuilderSupport.appendExecCmdParameters(cmd, "jobname", "Build Hive Global Dict - parallel total build" + this.seg.getRealization().getName() + "_Step");
        JobBuilderSupport.appendExecCmdParameters(cmd, "input", this.getBuildGlobalHiveDicTotalBuildJobInputPath(jobId));
        JobBuilderSupport.appendExecCmdParameters(cmd, "output", this.getBuildGlobalDictionaryTotalOutput(this.seg.getConfig()));
        JobBuilderSupport.appendExecCmdParameters(cmd, "global_dict_part_reduce_stats", this.getBuildGlobalDictionaryPartReduceStatsPathV2(jobId));
        JobBuilderSupport.appendExecCmdParameters(cmd, "global_dict_max_distinct_count", this.getBuildGlobalDictionaryMaxDistinctCountPath(jobId));
        result.setMapReduceParams(cmd.toString());
        return result;
    }

    public UpdateCubeInfoAfterBuildStep createUpdateCubeInfoAfterBuildStep(String jobId, LookupMaterializeContext lookupMaterializeContext) {
        UpdateCubeInfoAfterBuildStep result = new UpdateCubeInfoAfterBuildStep();
        result.setName("Update Cube Info");
        result.getParams().put("output.path", this.getFactDistinctColumnsPath(jobId));
        if (lookupMaterializeContext != null) {
            result.getParams().put("extlookupsnapshots", lookupMaterializeContext.getAllLookupSnapshotsInString());
        }
        CubingExecutableUtil.setCubeName(this.seg.getRealization().getName(), result.getParams());
        CubingExecutableUtil.setSegmentId(this.seg.getUuid(), result.getParams());
        CubingExecutableUtil.setCubingJobId(jobId, result.getParams());
        return result;
    }

    public MergeDictionaryStep createMergeDictionaryStep(List<String> mergingSegmentIds) {
        MergeDictionaryStep result = new MergeDictionaryStep();
        result.setName("Merge Cuboid Dictionary");
        CubingExecutableUtil.setCubeName(this.seg.getRealization().getName(), result.getParams());
        CubingExecutableUtil.setSegmentId(this.seg.getUuid(), result.getParams());
        CubingExecutableUtil.setMergingSegmentIds(mergingSegmentIds, result.getParams());
        return result;
    }

    public UpdateCubeInfoAfterMergeStep createUpdateCubeInfoAfterMergeStep(List<String> mergingSegmentIds, String jobId) {
        UpdateCubeInfoAfterMergeStep result = new UpdateCubeInfoAfterMergeStep();
        result.setName("Update Cube Info");
        CubingExecutableUtil.setCubeName(this.seg.getRealization().getName(), result.getParams());
        CubingExecutableUtil.setSegmentId(this.seg.getUuid(), result.getParams());
        CubingExecutableUtil.setCubingJobId(jobId, result.getParams());
        CubingExecutableUtil.setMergingSegmentIds(mergingSegmentIds, result.getParams());
        return result;
    }

    public boolean isEnableUHCDictStep() {
        if (!this.config.getConfig().isBuildUHCDictWithMREnabled()) {
            return false;
        }
        List uhcColumns = this.seg.getCubeDesc().getAllUHCColumns();
        return uhcColumns.size() != 0;
    }

    public boolean isEnabledSparkDimensionDictionary() {
        return this.config.getConfig().isSparkDimensionDictionaryEnabled();
    }

    public boolean isEnableUHCDictSparkStep() {
        if (!this.config.getConfig().isSparkUHCDictionaryEnable()) {
            return false;
        }
        List uhcColumns = this.seg.getCubeDesc().getAllUHCColumns();
        return uhcColumns.size() != 0;
    }

    public LookupMaterializeContext addMaterializeLookupTableSteps(CubingJob result) {
        LookupMaterializeContext lookupMaterializeContext = new LookupMaterializeContext(result);
        CubeDesc cubeDesc = this.seg.getCubeDesc();
        List allSnapshotTypes = cubeDesc.getAllExtLookupSnapshotTypes();
        if (allSnapshotTypes.isEmpty()) {
            return null;
        }
        for (String snapshotType : allSnapshotTypes) {
            ILookupMaterializer materializer = MRUtil.getExtLookupMaterializer(snapshotType);
            materializer.materializeLookupTablesForCube(lookupMaterializeContext, this.seg.getCubeInstance());
        }
        return lookupMaterializeContext;
    }

    public SaveStatisticsStep createSaveStatisticsStep(String jobId) {
        SaveStatisticsStep result = new SaveStatisticsStep();
        result.setName("Save Cuboid Statistics");
        CubingExecutableUtil.setCubeName(this.seg.getRealization().getName(), result.getParams());
        CubingExecutableUtil.setSegmentId(this.seg.getUuid(), result.getParams());
        CubingExecutableUtil.setStatisticsPath(this.getStatisticsPath(jobId), result.getParams());
        CubingExecutableUtil.setCubingJobId(jobId, result.getParams());
        return result;
    }

    public String getJobWorkingDir(String jobId) {
        return JobBuilderSupport.getJobWorkingDir(this.config, jobId);
    }

    public String getRealizationRootPath(String jobId) {
        return this.getJobWorkingDir(jobId) + "/" + this.seg.getRealization().getName();
    }

    public String getCuboidRootPath(String jobId) {
        return this.getRealizationRootPath(jobId) + "/cuboid/";
    }

    public String getCuboidRootPath(CubeSegment seg) {
        return this.getCuboidRootPath(seg.getLastBuildJobID());
    }

    public void appendMapReduceParameters(StringBuilder buf) {
        this.appendMapReduceParameters(buf, "");
    }

    public void appendMapReduceParameters(StringBuilder buf, String jobType) {
        try {
            String jobConf = this.config.getHadoopJobConfFilePath(jobType);
            if (jobConf != null && jobConf.length() > 0) {
                buf.append(" -conf ").append(jobConf);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getFactDistinctColumnsPath(String jobId) {
        return this.getRealizationRootPath(jobId) + "/fact_distinct_columns";
    }

    public String getStatisticsPath(String jobId) {
        return this.getRealizationRootPath(jobId) + "/fact_distinct_columns/" + "statistics";
    }

    public String getShrunkenDictionaryPath(String jobId) {
        return this.getRealizationRootPath(jobId) + "/dictionary_shrunken";
    }

    public String getBuildGlobalDictionaryBasePath(String jobId) {
        return this.getRealizationRootPath(jobId) + "/global_dic";
    }

    public String getBuildGlobalHiveDicTotalBuildJobInputPath(String jobId) {
        return this.getBuildGlobalDictionaryBasePath(jobId) + "/part_sort";
    }

    public String getBuildGlobalDictionaryMaxDistinctCountPath(String jobId) {
        KylinConfig conf = this.seg.getConfig();
        String dbDir = conf.getHiveDatabaseDir();
        IJoinedFlatTableDesc flatDesc = EngineFactory.getJoinedFlatTableDesc((CubeSegment)this.seg);
        String tableName = flatDesc.getTableName() + conf.getMrHiveDistinctValueTableSuffix();
        String outPut = dbDir + "/" + tableName + "/dict_column=" + "KYLIN_MAX_DISTINCT_COUNT";
        return outPut;
    }

    public String getBuildGlobalDictionaryPartReduceStatsPathV2(String jobId) {
        return this.getBuildGlobalDictionaryBasePath(jobId) + "/reduce_stats";
    }

    public String getBuildGlobalDictionaryTotalOutput(KylinConfig config) {
        String dbDir = config.getHiveDatabaseDir();
        String tableName = EngineFactory.getJoinedFlatTableDesc((CubeSegment)this.seg).getTableName() + config.getMrHiveDictTableSuffix();
        String path = dbDir + "/" + tableName;
        return path;
    }

    public String getDictRootPath(String jobId) {
        return this.getRealizationRootPath(jobId) + "/dict";
    }

    public String getDictInfoPath(String jobId) {
        return this.getRealizationRootPath(jobId) + "/dict_info";
    }

    public String getOptimizationRootPath(String jobId) {
        return this.getRealizationRootPath(jobId) + "/optimize";
    }

    public String getOptimizationStatisticsPath(String jobId) {
        return this.getOptimizationRootPath(jobId) + "/statistics";
    }

    public String getOptimizationCuboidPath(String jobId) {
        return this.getOptimizationRootPath(jobId) + "/cuboid/";
    }

    public String getHBaseConfFilePath(String jobId) {
        return this.getJobWorkingDir(jobId) + "/hbase-conf.xml";
    }

    public String getCounterOutputPath(String jobId) {
        return this.getRealizationRootPath(jobId) + "/counter";
    }

    public static String getJobWorkingDir(JobEngineConfig conf, String jobId) {
        return JobBuilderSupport.getJobWorkingDir(conf.getHdfsWorkingDirectory(), jobId);
    }

    public static String getJobWorkingDir(String hdfsDir, String jobId) {
        if (!hdfsDir.endsWith("/")) {
            hdfsDir = hdfsDir + "/";
        }
        return hdfsDir + "kylin-" + jobId;
    }

    public static StringBuilder appendExecCmdParameters(StringBuilder buf, String paraName, String paraValue) {
        return buf.append(" -").append(paraName).append(" ").append(paraValue);
    }

    public static String getCuboidOutputPathsByLevel(String cuboidRootPath, int level) {
        if (level == 0) {
            return cuboidRootPath + LayeredCuboidFolderPrefix + PathNameCuboidBase;
        }
        return cuboidRootPath + LayeredCuboidFolderPrefix + level + "_cuboid";
    }

    public static String getBaseCuboidPath(String cuboidRootPath) {
        return cuboidRootPath + PathNameCuboidBase;
    }

    public static String getInMemCuboidPath(String cuboidRootPath) {
        return cuboidRootPath + PathNameCuboidInMem;
    }

    public String getDumpMetadataPath(String jobId) {
        return this.getRealizationRootPath(jobId) + "/metadata";
    }

    public static String extractJobIDFromPath(String path) {
        Matcher matcher = JOB_NAME_PATTERN.matcher(path);
        if (matcher.find()) {
            return matcher.group(1);
        }
        throw new IllegalStateException("Can not extract job ID from file path : " + path);
    }

    public String getSegmentMetadataUrl(KylinConfig kylinConfig, String jobId) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("path", this.getDumpMetadataPath(jobId));
        return new StorageURL(kylinConfig.getMetadataUrl().getIdentifier(), "hdfs", param).toString();
    }

    public static void scanFiles(String input, FileSystem fs, List<FileStatus> outputs) throws IOException {
        FileStatus[] fileStatuses;
        Path path = new Path(input);
        if (!fs.exists(path)) {
            return;
        }
        for (FileStatus stat : fileStatuses = fs.listStatus(path, p -> !p.getName().startsWith("_"))) {
            if (stat.isDirectory()) {
                JobBuilderSupport.scanFiles(stat.getPath().toString(), fs, outputs);
                continue;
            }
            outputs.add(stat);
        }
    }

    public static long getFileSize(String input, FileSystem fs) throws IOException {
        ArrayList outputs = Lists.newArrayList();
        JobBuilderSupport.scanFiles(input, fs, outputs);
        long size = 0L;
        for (FileStatus stat : outputs) {
            size += stat.getLen();
        }
        return size;
    }
}

