/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.engine.mr.IMROutput2;
import org.apache.kylin.engine.mr.MRUtil;
import org.apache.kylin.engine.mr.steps.CubingExecutableUtil;
import org.apache.kylin.engine.mr.steps.UpdateCubeInfoAfterCheckpointStep;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.CheckpointExecutable;
import org.apache.kylin.job.execution.DefaultChainedExecutable;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;

public class BatchOptimizeJobCheckpointBuilder {
    protected SimpleDateFormat format = new SimpleDateFormat("z yyyy-MM-dd HH:mm:ss", Locale.ROOT);
    protected final CubeInstance cube;
    protected final String submitter;
    private final IMROutput2.IMRBatchOptimizeOutputSide2 outputSide;

    public BatchOptimizeJobCheckpointBuilder(CubeInstance cube, String submitter) {
        this.cube = cube;
        this.submitter = submitter;
        Preconditions.checkNotNull((Object)cube.getFirstSegment(), (Object)("Cube " + cube + " is empty!!!"));
        this.outputSide = MRUtil.getBatchOptimizeOutputSide2(cube.getFirstSegment());
    }

    public CheckpointExecutable build() {
        KylinConfig kylinConfig = this.cube.getConfig();
        List projList = ProjectManager.getInstance((KylinConfig)kylinConfig).findProjects(this.cube.getType(), this.cube.getName());
        if (projList == null || projList.size() == 0) {
            throw new RuntimeException("Cannot find the project containing the cube " + this.cube.getName() + "!!!");
        }
        if (projList.size() >= 2) {
            throw new RuntimeException("Find more than one project containing the cube " + this.cube.getName() + ". It does't meet the uniqueness requirement!!! ");
        }
        CheckpointExecutable checkpointJob = new CheckpointExecutable();
        checkpointJob.setSubmitter(this.submitter);
        CubingExecutableUtil.setCubeName(this.cube.getName(), checkpointJob.getParams());
        checkpointJob.setName(this.cube.getName() + " - OPTIMIZE CHECKPOINT - " + this.format.format(new Date(System.currentTimeMillis())));
        checkpointJob.setDeployEnvName(kylinConfig.getDeployEnv());
        checkpointJob.setProjectName(((ProjectInstance)projList.get(0)).getName());
        checkpointJob.addTask((AbstractExecutable)this.createUpdateCubeInfoAfterCheckpointStep());
        this.outputSide.addStepPhase5_Cleanup((DefaultChainedExecutable)checkpointJob);
        return checkpointJob;
    }

    private UpdateCubeInfoAfterCheckpointStep createUpdateCubeInfoAfterCheckpointStep() {
        UpdateCubeInfoAfterCheckpointStep result = new UpdateCubeInfoAfterCheckpointStep();
        result.setName("Update Cube Info");
        CubingExecutableUtil.setCubeName(this.cube.getName(), result.getParams());
        return result;
    }
}

