/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.CubeUpdate;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.dict.DictionaryInfo;
import org.apache.kylin.dict.DictionaryManager;
import org.apache.kylin.engine.mr.steps.CubingExecutableUtil;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeDictionaryStep
extends AbstractExecutable {
    private static final Logger logger = LoggerFactory.getLogger(MergeDictionaryStep.class);

    protected ExecuteResult doWork(ExecutableContext context) throws ExecuteException {
        CubeManager mgr = CubeManager.getInstance((KylinConfig)context.getConfig());
        CubeInstance cube = mgr.getCube(CubingExecutableUtil.getCubeName(this.getParams()));
        CubeSegment newSegment = cube.getSegmentById(CubingExecutableUtil.getSegmentId(this.getParams()));
        List<CubeSegment> mergingSegments = this.getMergingSegments(cube);
        KylinConfig conf = cube.getConfig();
        Collections.sort(mergingSegments);
        try {
            this.checkLookupSnapshotsMustIncremental(mergingSegments);
            this.makeDictForNewSegment(conf, cube, newSegment, mergingSegments);
            this.makeSnapshotForNewSegment(cube, newSegment, mergingSegments);
            CubeUpdate cubeBuilder = new CubeUpdate(cube);
            cubeBuilder.setToUpdateSegs(new CubeSegment[]{newSegment});
            mgr.updateCube(cubeBuilder);
            return new ExecuteResult(ExecuteResult.State.SUCCEED, "succeed");
        }
        catch (IOException e) {
            logger.error("fail to merge dictionary or lookup snapshots", (Throwable)e);
            return new ExecuteResult(ExecuteResult.State.ERROR, e.getLocalizedMessage());
        }
    }

    private List<CubeSegment> getMergingSegments(CubeInstance cube) {
        List<String> mergingSegmentIds = CubingExecutableUtil.getMergingSegmentIds(this.getParams());
        ArrayList result = Lists.newArrayListWithCapacity((int)mergingSegmentIds.size());
        for (String id : mergingSegmentIds) {
            result.add(cube.getSegmentById(id));
        }
        return result;
    }

    private void checkLookupSnapshotsMustIncremental(List<CubeSegment> mergingSegments) {
    }

    private void makeDictForNewSegment(KylinConfig conf, CubeInstance cube, CubeSegment newSeg, List<CubeSegment> mergingSegments) throws IOException {
        HashSet<TblColRef> colsNeedMeringDict = new HashSet<TblColRef>();
        HashSet<TblColRef> colsNeedCopyDict = new HashSet<TblColRef>();
        DictionaryManager dictMgr = DictionaryManager.getInstance((KylinConfig)conf);
        CubeDesc cubeDesc = cube.getDescriptor();
        for (TblColRef col : cubeDesc.getAllColumnsNeedDictionaryBuilt()) {
            TableRef srcTable = dictMgr.decideSourceData(cubeDesc.getModel(), col).getTableRef();
            if (cubeDesc.getModel().isFactTable(srcTable)) {
                colsNeedMeringDict.add(col);
                continue;
            }
            colsNeedCopyDict.add(col);
        }
        for (TblColRef col : colsNeedMeringDict) {
            logger.info("Merging fact table dictionary on : " + col);
            ArrayList<DictionaryInfo> dictInfos = new ArrayList<DictionaryInfo>();
            for (CubeSegment segment : mergingSegments) {
                logger.info("Including fact table dictionary of segment : " + segment);
                if (segment.getDictResPath(col) == null) continue;
                DictionaryInfo dictInfo = dictMgr.getDictionaryInfo(segment.getDictResPath(col));
                if (dictInfo != null && !dictInfos.contains(dictInfo)) {
                    dictInfos.add(dictInfo);
                    continue;
                }
                logger.warn("Failed to load DictionaryInfo from " + segment.getDictResPath(col));
            }
            this.mergeDictionaries(dictMgr, newSeg, dictInfos, col);
        }
        CubeSegment lastSeg = mergingSegments.get(mergingSegments.size() - 1);
        for (TblColRef col : colsNeedCopyDict) {
            String path = lastSeg.getDictResPath(col);
            newSeg.putDictResPath(col, path);
        }
    }

    private DictionaryInfo mergeDictionaries(DictionaryManager dictMgr, CubeSegment cubeSeg, List<DictionaryInfo> dicts, TblColRef col) throws IOException {
        DictionaryInfo dictInfo = dictMgr.mergeDictionary(dicts);
        if (dictInfo != null) {
            cubeSeg.putDictResPath(col, dictInfo.getResourcePath());
        }
        return dictInfo;
    }

    private void makeSnapshotForNewSegment(CubeInstance cube, CubeSegment newSeg, List<CubeSegment> mergingSegments) {
        CubeSegment lastSeg = mergingSegments.get(mergingSegments.size() - 1);
        for (Map.Entry entry : lastSeg.getSnapshots().entrySet()) {
            newSeg.putSnapshotResPath((String)entry.getKey(), (String)entry.getValue());
        }
    }
}

