/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.SplittedBytes;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.common.RowKeySplitter;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.kv.RowKeyEncoder;
import org.apache.kylin.cube.kv.RowKeyEncoderProvider;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.dict.DictionaryManager;
import org.apache.kylin.engine.mr.KylinMapper;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.measure.BufferedMeasureCodec;
import org.apache.kylin.measure.MeasureIngester;
import org.apache.kylin.measure.MeasureType;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;

public class MergeCuboidMapper
extends KylinMapper<Text, Text, Text, Text> {
    private KylinConfig config;
    private String cubeName;
    private String segmentID;
    private CubeManager cubeManager;
    private CubeInstance cube;
    private CubeDesc cubeDesc;
    private CubeSegment mergedCubeSegment;
    private CubeSegment sourceCubeSegment;
    private Text outputKey = new Text();
    private byte[] newKeyBodyBuf;
    private ByteArray newKeyBuf;
    private RowKeySplitter rowKeySplitter;
    private RowKeyEncoderProvider rowKeyEncoderProvider;
    private HashMap<TblColRef, Boolean> dimensionsNeedDict = new HashMap();
    private List<Pair<Integer, MeasureIngester>> dictMeasures;
    private Map<TblColRef, Dictionary<String>> oldDicts;
    private Map<TblColRef, Dictionary<String>> newDicts;
    private List<MeasureDesc> measureDescs;
    private BufferedMeasureCodec codec;
    private Object[] measureObjs;
    private Text outputValue;
    private static final Pattern JOB_NAME_PATTERN = Pattern.compile("kylin-([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})");

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.bindCurrentConfiguration(context.getConfiguration());
        this.cubeName = context.getConfiguration().get("cube.name").toUpperCase();
        this.segmentID = context.getConfiguration().get("cube.segment.id");
        this.config = AbstractHadoopJob.loadKylinPropsAndMetadata();
        this.cubeManager = CubeManager.getInstance((KylinConfig)this.config);
        this.cube = this.cubeManager.getCube(this.cubeName);
        this.cubeDesc = this.cube.getDescriptor();
        this.mergedCubeSegment = this.cube.getSegmentById(this.segmentID);
        this.newKeyBodyBuf = new byte[16640];
        this.newKeyBuf = ByteArray.allocate((int)16640);
        FileSplit fileSplit = (FileSplit)context.getInputSplit();
        this.sourceCubeSegment = this.findSourceSegment(fileSplit, this.cube);
        this.rowKeySplitter = new RowKeySplitter(this.sourceCubeSegment, 65, 255);
        this.rowKeyEncoderProvider = new RowKeyEncoderProvider(this.mergedCubeSegment);
        this.measureDescs = this.cubeDesc.getMeasures();
        this.codec = new BufferedMeasureCodec(this.measureDescs);
        this.measureObjs = new Object[this.measureDescs.size()];
        this.outputValue = new Text();
        this.dictMeasures = Lists.newArrayList();
        this.oldDicts = Maps.newHashMap();
        this.newDicts = Maps.newHashMap();
        for (int i = 0; i < this.measureDescs.size(); ++i) {
            MeasureDesc measureDesc = this.measureDescs.get(i);
            MeasureType measureType = measureDesc.getFunction().getMeasureType();
            List columns = measureType.getColumnsNeedDictionary(measureDesc.getFunction());
            boolean needReEncode = false;
            for (TblColRef col : columns) {
                if (this.sourceCubeSegment.getDictionary(col) == null || this.sourceCubeSegment.getDictionary(col).equals(this.mergedCubeSegment.getDictionary(col))) continue;
                this.oldDicts.put(col, (Dictionary<String>)this.sourceCubeSegment.getDictionary(col));
                this.newDicts.put(col, (Dictionary<String>)this.mergedCubeSegment.getDictionary(col));
                needReEncode = true;
            }
            if (!needReEncode) continue;
            this.dictMeasures.add((Pair<Integer, MeasureIngester>)Pair.newPair((Object)i, (Object)measureType.newIngester()));
        }
    }

    public CubeSegment findSourceSegment(FileSplit fileSplit, CubeInstance cube) {
        String filePath = fileSplit.getPath().toString();
        String jobID = MergeCuboidMapper.extractJobIDFromPath(filePath);
        return MergeCuboidMapper.findSegmentWithUuid(jobID, cube);
    }

    private static String extractJobIDFromPath(String path) {
        Matcher matcher = JOB_NAME_PATTERN.matcher(path);
        if (matcher.find()) {
            return matcher.group(1);
        }
        throw new IllegalStateException("Can not extract job ID from file path : " + path);
    }

    private static CubeSegment findSegmentWithUuid(String jobID, CubeInstance cubeInstance) {
        for (CubeSegment segment : cubeInstance.getSegments()) {
            String lastBuildJobID = segment.getLastBuildJobID();
            if (lastBuildJobID == null || !lastBuildJobID.equalsIgnoreCase(jobID)) continue;
            return segment;
        }
        throw new IllegalStateException("No merging segment's last build job ID equals " + jobID);
    }

    @Override
    public void doMap(Text key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        long cuboidID = this.rowKeySplitter.split(key.getBytes());
        Cuboid cuboid = Cuboid.findById((CubeDesc)this.cubeDesc, (long)cuboidID);
        RowKeyEncoder rowkeyEncoder = this.rowKeyEncoderProvider.getRowkeyEncoder(cuboid);
        SplittedBytes[] splittedByteses = this.rowKeySplitter.getSplitBuffers();
        int bufOffset = 0;
        int bodySplitOffset = this.rowKeySplitter.getBodySplitOffset();
        for (int i = 0; i < cuboid.getColumns().size(); ++i) {
            int useSplit = i + bodySplitOffset;
            TblColRef col = (TblColRef)cuboid.getColumns().get(i);
            if (this.checkNeedMerging(col).booleanValue()) {
                DictionaryManager dictMgr = DictionaryManager.getInstance((KylinConfig)this.config);
                Dictionary mergedDict = dictMgr.getDictionary(this.mergedCubeSegment.getDictResPath(col));
                if (this.sourceCubeSegment.getDictionary(col) == null) {
                    BytesUtil.writeUnsigned((int)mergedDict.nullId(), (byte[])this.newKeyBodyBuf, (int)bufOffset, (int)mergedDict.getSizeOfId());
                    bufOffset += mergedDict.getSizeOfId();
                    continue;
                }
                Dictionary sourceDict = dictMgr.getDictionary(this.sourceCubeSegment.getDictResPath(col));
                while (sourceDict.getSizeOfValue() > this.newKeyBodyBuf.length - bufOffset || mergedDict.getSizeOfValue() > this.newKeyBodyBuf.length - bufOffset || mergedDict.getSizeOfId() > this.newKeyBodyBuf.length - bufOffset) {
                    byte[] oldBuf = this.newKeyBodyBuf;
                    this.newKeyBodyBuf = new byte[2 * this.newKeyBodyBuf.length];
                    System.arraycopy(oldBuf, 0, this.newKeyBodyBuf, 0, oldBuf.length);
                }
                int idInSourceDict = BytesUtil.readUnsigned((byte[])splittedByteses[useSplit].value, (int)0, (int)splittedByteses[useSplit].length);
                String v = (String)sourceDict.getValueFromId(idInSourceDict);
                int idInMergedDict = v == null ? mergedDict.nullId() : mergedDict.getIdFromValue((Object)v);
                BytesUtil.writeUnsigned((int)idInMergedDict, (byte[])this.newKeyBodyBuf, (int)bufOffset, (int)mergedDict.getSizeOfId());
                bufOffset += mergedDict.getSizeOfId();
                continue;
            }
            while (splittedByteses[useSplit].length > this.newKeyBodyBuf.length - bufOffset) {
                byte[] oldBuf = this.newKeyBodyBuf;
                this.newKeyBodyBuf = new byte[2 * this.newKeyBodyBuf.length];
                System.arraycopy(oldBuf, 0, this.newKeyBodyBuf, 0, oldBuf.length);
            }
            System.arraycopy(splittedByteses[useSplit].value, 0, this.newKeyBodyBuf, bufOffset, splittedByteses[useSplit].length);
            bufOffset += splittedByteses[useSplit].length;
        }
        int fullKeySize = rowkeyEncoder.getBytesLength();
        while (this.newKeyBuf.array().length < fullKeySize) {
            this.newKeyBuf.set(new byte[this.newKeyBuf.length() * 2]);
        }
        this.newKeyBuf.set(0, fullKeySize);
        rowkeyEncoder.encode(new ByteArray(this.newKeyBodyBuf, 0, bufOffset), this.newKeyBuf);
        this.outputKey.set(this.newKeyBuf.array(), 0, fullKeySize);
        if (this.dictMeasures.size() > 0) {
            this.codec.decode(ByteBuffer.wrap(value.getBytes(), 0, value.getLength()), this.measureObjs);
            for (Pair<Integer, MeasureIngester> pair : this.dictMeasures) {
                int i = (Integer)pair.getFirst();
                MeasureIngester ingester = (MeasureIngester)pair.getSecond();
                this.measureObjs[i] = ingester.reEncodeDictionary(this.measureObjs[i], this.measureDescs.get(i), this.oldDicts, this.newDicts);
            }
            ByteBuffer valueBuf = this.codec.encode(this.measureObjs);
            this.outputValue.set(valueBuf.array(), 0, valueBuf.position());
            value = this.outputValue;
        }
        context.write((Object)this.outputKey, (Object)value);
    }

    private Boolean checkNeedMerging(TblColRef col) throws IOException {
        Boolean ret = this.dimensionsNeedDict.get(col);
        if (ret != null) {
            return ret;
        }
        ret = this.cubeDesc.getRowkey().isUseDictionary(col);
        if (ret.booleanValue()) {
            TableRef srcTable = DictionaryManager.getInstance((KylinConfig)this.config).decideSourceData(this.cubeDesc.getModel(), col).getTableRef();
            ret = this.cubeDesc.getModel().isFactTable(srcTable);
        }
        this.dimensionsNeedDict.put(col, ret);
        return ret;
    }
}

