/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.io.IOException;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.engine.mr.IMRInput;
import org.apache.kylin.engine.mr.MRUtil;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.engine.mr.steps.CuboidReducer;
import org.apache.kylin.engine.mr.steps.LayerReducerNumSizing;
import org.apache.kylin.job.execution.ExecutableManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CuboidJob
extends AbstractHadoopJob {
    protected static final Logger logger = LoggerFactory.getLogger(CuboidJob.class);
    private Class<? extends Mapper> mapperClass;
    private boolean skipped = false;

    @Override
    public boolean isSkipped() {
        return this.skipped;
    }

    private boolean checkSkip(String cubingJobId) {
        if (cubingJobId == null) {
            return false;
        }
        ExecutableManager execMgr = ExecutableManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        CubingJob cubingJob = (CubingJob)execMgr.getJob(cubingJobId);
        this.skipped = !cubingJob.isLayerCubing();
        return this.skipped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws Exception {
        if (this.mapperClass == null) {
            throw new Exception("Mapper class is not set!");
        }
        Options options = new Options();
        try {
            options.addOption(OPTION_JOB_NAME);
            options.addOption(OPTION_CUBE_NAME);
            options.addOption(OPTION_SEGMENT_ID);
            options.addOption(OPTION_INPUT_PATH);
            options.addOption(OPTION_OUTPUT_PATH);
            options.addOption(OPTION_NCUBOID_LEVEL);
            options.addOption(OPTION_INPUT_FORMAT);
            options.addOption(OPTION_CUBING_JOB_ID);
            this.parseOptions(options, args);
            Path output = new Path(this.getOptionValue(OPTION_OUTPUT_PATH));
            String cubeName = this.getOptionValue(OPTION_CUBE_NAME).toUpperCase();
            int nCuboidLevel = Integer.parseInt(this.getOptionValue(OPTION_NCUBOID_LEVEL));
            String segmentID = this.getOptionValue(OPTION_SEGMENT_ID);
            String cubingJobId = this.getOptionValue(OPTION_CUBING_JOB_ID);
            CubeManager cubeMgr = CubeManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
            CubeInstance cube = cubeMgr.getCube(cubeName);
            CubeSegment segment = cube.getSegmentById(segmentID);
            if (this.checkSkip(cubingJobId)) {
                logger.info("Skip job " + this.getOptionValue(OPTION_JOB_NAME) + " for " + segmentID + "[" + segmentID + "]");
                int n = 0;
                return n;
            }
            this.job = Job.getInstance((Configuration)this.getConf(), (String)this.getOptionValue(OPTION_JOB_NAME));
            this.job.getConfiguration().set("cubingJobId", cubingJobId);
            logger.info("Starting: " + this.job.getJobName());
            this.setJobClasspath(this.job, cube.getConfig());
            this.configureMapperInputFormat(segment);
            this.job.setMapperClass(this.mapperClass);
            this.job.setMapOutputKeyClass(Text.class);
            this.job.setMapOutputValueClass(Text.class);
            this.job.setCombinerClass(CuboidReducer.class);
            this.job.setReducerClass(CuboidReducer.class);
            this.job.setOutputFormatClass(SequenceFileOutputFormat.class);
            this.job.setOutputKeyClass(Text.class);
            this.job.setOutputValueClass(Text.class);
            FileOutputFormat.setOutputPath((Job)this.job, (Path)output);
            this.job.getConfiguration().set("cube.name", cubeName);
            this.job.getConfiguration().set("cube.segment.id", segmentID);
            this.job.getConfiguration().setInt("cube.cuboid.level", nCuboidLevel);
            this.attachSegmentMetadataWithDict(segment, this.job.getConfiguration());
            this.job.setNumReduceTasks(LayerReducerNumSizing.getReduceTaskNum(segment, this.getTotalMapInputMB(), nCuboidLevel));
            this.deletePath(this.job.getConfiguration(), output);
            int n = this.waitForCompletion(this.job);
            return n;
        }
        finally {
            if (this.job != null) {
                this.cleanupTempConfFile(this.job.getConfiguration());
            }
        }
    }

    private void configureMapperInputFormat(CubeSegment cubeSeg) throws IOException {
        String input = this.getOptionValue(OPTION_INPUT_PATH);
        if ("FLAT_TABLE".equals(input)) {
            IMRInput.IMRTableInputFormat flatTableInputFormat = MRUtil.getBatchCubingInputSide(cubeSeg).getFlatTableInputFormat();
            flatTableInputFormat.configureJob(this.job);
        } else {
            FileInputFormat.setInputPaths((Job)this.job, (Path[])new Path[]{new Path(input)});
            if (this.hasOption(OPTION_INPUT_FORMAT) && "textinputformat".equalsIgnoreCase(this.getOptionValue(OPTION_INPUT_FORMAT))) {
                this.job.setInputFormatClass(TextInputFormat.class);
            } else {
                this.job.setInputFormatClass(SequenceFileInputFormat.class);
            }
        }
    }

    public void setMapperClass(Class<? extends Mapper> mapperClass) {
        this.mapperClass = mapperClass;
    }
}

