/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.common;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.engine.mr.MRUtil;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.engine.mr.common.HadoopCmdOutput;
import org.apache.kylin.engine.mr.common.HadoopJobStatusChecker;
import org.apache.kylin.job.constant.JobStepStatusEnum;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.job.execution.Output;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapReduceExecutable
extends AbstractExecutable {
    public static final String MAP_REDUCE_WAIT_TIME = "mapReduceWaitTime";
    private static final String KEY_MR_JOB = "MR_JOB_CLASS";
    private static final String KEY_PARAMS = "MR_JOB_PARAMS";
    private static final String KEY_COUNTER_SAVEAS = "MR_COUNTER_SAVEAS";
    protected static final Logger logger = LoggerFactory.getLogger(MapReduceExecutable.class);

    protected void onExecuteStart(ExecutableContext executableContext) {
        block7: {
            Output output = this.getOutput();
            if (output.getExtra().containsKey("startTime")) {
                String mrJobId = (String)output.getExtra().get("mr_job_id");
                if (mrJobId == null) {
                    this.getManager().updateJobOutput(this.getId(), ExecutableState.RUNNING, null, null);
                    return;
                }
                try {
                    Configuration conf = HadoopUtil.getCurrentConfiguration();
                    Job job = new Cluster(conf).getJob(JobID.forName((String)mrJobId));
                    if (job == null || job.getJobState() == JobStatus.State.FAILED) {
                        super.onExecuteStart(executableContext);
                        break block7;
                    }
                    this.getManager().updateJobOutput(this.getId(), ExecutableState.RUNNING, null, null);
                }
                catch (IOException e) {
                    logger.warn("error get hadoop status");
                    super.onExecuteStart(executableContext);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.warn("error get hadoop status");
                    super.onExecuteStart(executableContext);
                }
            } else {
                super.onExecuteStart(executableContext);
            }
        }
    }

    protected ExecuteResult doWork(ExecutableContext context) throws ExecuteException {
        String mapReduceJobClass = this.getMapReduceJobClass();
        String params = this.getMapReduceParams();
        Preconditions.checkNotNull((Object)mapReduceJobClass);
        Preconditions.checkNotNull((Object)params);
        try {
            Job job;
            ExecutableManager mgr = this.getManager();
            Map extra = mgr.getOutput(this.getId()).getExtra();
            if (extra.containsKey("mr_job_id")) {
                Configuration conf = HadoopUtil.getCurrentConfiguration();
                job = new Cluster(conf).getJob(JobID.forName((String)((String)extra.get("mr_job_id"))));
                logger.info("mr_job_id:" + (String)extra.get("mr_job_id") + " resumed");
            } else {
                Constructor constructor = ClassUtil.forName((String)mapReduceJobClass, AbstractHadoopJob.class).getConstructor(new Class[0]);
                AbstractHadoopJob hadoopJob = (AbstractHadoopJob)((Object)constructor.newInstance(new Object[0]));
                hadoopJob.setConf(HadoopUtil.getCurrentConfiguration());
                hadoopJob.setAsync(true);
                logger.info("parameters of the MapReduceExecutable:");
                logger.info(params);
                String[] args = params.trim().split("\\s+");
                try {
                    MRUtil.runMRJob(hadoopJob, args);
                    if (hadoopJob.isSkipped()) {
                        return new ExecuteResult(ExecuteResult.State.SUCCEED, "skipped");
                    }
                }
                catch (Exception ex) {
                    StringBuilder log = new StringBuilder();
                    logger.error("error execute " + this.toString(), (Throwable)ex);
                    StringWriter stringWriter = new StringWriter();
                    ex.printStackTrace(new PrintWriter(stringWriter));
                    log.append(stringWriter.toString()).append("\n");
                    log.append("result code:").append(2);
                    return new ExecuteResult(ExecuteResult.State.ERROR, log.toString());
                }
                job = hadoopJob.getJob();
            }
            StringBuilder output = new StringBuilder();
            HadoopCmdOutput hadoopCmdOutput = new HadoopCmdOutput(job, output);
            JobStepStatusEnum status = JobStepStatusEnum.NEW;
            while (!this.isDiscarded() && !this.isPaused()) {
                JobStepStatusEnum newStatus = HadoopJobStatusChecker.checkStatus(job, output);
                if (status == JobStepStatusEnum.KILLED) {
                    mgr.updateJobOutput(this.getId(), ExecutableState.ERROR, hadoopCmdOutput.getInfo(), "killed by admin");
                    return new ExecuteResult(ExecuteResult.State.FAILED, "killed by admin");
                }
                if (status == JobStepStatusEnum.WAITING && (newStatus == JobStepStatusEnum.FINISHED || newStatus == JobStepStatusEnum.ERROR || newStatus == JobStepStatusEnum.RUNNING)) {
                    long waitTime = System.currentTimeMillis() - this.getStartTime();
                    this.setMapReduceWaitTime(waitTime);
                }
                mgr.addJobInfo(this.getId(), hadoopCmdOutput.getInfo());
                status = newStatus;
                if (status.isComplete()) {
                    Map<String, String> info = hadoopCmdOutput.getInfo();
                    this.readCounters(hadoopCmdOutput, info);
                    mgr.addJobInfo(this.getId(), info);
                    if (status == JobStepStatusEnum.FINISHED) {
                        return new ExecuteResult(ExecuteResult.State.SUCCEED, output.toString());
                    }
                    return new ExecuteResult(ExecuteResult.State.FAILED, output.toString());
                }
                Thread.sleep((long)context.getConfig().getYarnStatusCheckIntervalSeconds() * 1000L);
            }
            if (job != null) {
                try {
                    job.killJob();
                }
                catch (Exception e) {
                    logger.warn("failed to kill hadoop job: " + job.getJobID(), (Throwable)e);
                }
            }
            if (this.isDiscarded()) {
                return new ExecuteResult(ExecuteResult.State.DISCARDED, output.toString());
            }
            return new ExecuteResult(ExecuteResult.State.STOPPED, output.toString());
        }
        catch (ReflectiveOperationException e) {
            logger.error("error getMapReduceJobClass, class name:" + this.getParam(KEY_MR_JOB), (Throwable)e);
            return new ExecuteResult(ExecuteResult.State.ERROR, e.getLocalizedMessage());
        }
        catch (Exception e) {
            logger.error("error execute " + this.toString(), (Throwable)e);
            return new ExecuteResult(ExecuteResult.State.ERROR, e.getLocalizedMessage());
        }
    }

    private void readCounters(HadoopCmdOutput hadoopCmdOutput, Map<String, String> info) {
        hadoopCmdOutput.updateJobCounter();
        info.put("source_records_count", hadoopCmdOutput.getMapInputRecords());
        info.put("source_records_size", hadoopCmdOutput.getRawInputBytesRead());
        info.put("hdfs_bytes_written", hadoopCmdOutput.getHdfsBytesWritten());
        String saveAs = this.getParam(KEY_COUNTER_SAVEAS);
        if (saveAs != null) {
            String[] saveAsNames = saveAs.split(",");
            this.saveCounterAs(hadoopCmdOutput.getMapInputRecords(), saveAsNames, 0, info);
            this.saveCounterAs(hadoopCmdOutput.getRawInputBytesRead(), saveAsNames, 1, info);
            this.saveCounterAs(hadoopCmdOutput.getHdfsBytesWritten(), saveAsNames, 2, info);
        }
    }

    private void saveCounterAs(String counter, String[] saveAsNames, int i, Map<String, String> info) {
        if (saveAsNames.length > i && !StringUtils.isBlank((String)saveAsNames[i])) {
            info.put(saveAsNames[i].trim(), counter);
        }
    }

    public long getMapReduceWaitTime() {
        return this.getExtraInfoAsLong(MAP_REDUCE_WAIT_TIME, 0L);
    }

    public void setMapReduceWaitTime(long t) {
        this.addExtraInfo(MAP_REDUCE_WAIT_TIME, t + "");
    }

    public String getMapReduceJobClass() throws ExecuteException {
        return this.getParam(KEY_MR_JOB);
    }

    public void setMapReduceJobClass(Class<? extends AbstractHadoopJob> clazzName) {
        this.setParam(KEY_MR_JOB, clazzName.getName());
    }

    public String getMapReduceParams() {
        return this.getParam(KEY_PARAMS);
    }

    public void setMapReduceParams(String param) {
        this.setParam(KEY_PARAMS, param);
    }

    public void setCounterSaveAs(String value) {
        this.setParam(KEY_COUNTER_SAVEAS, value);
    }
}

