/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.common;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.kylin.cube.model.CubeBuildTypeEnum;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.engine.mr.common.HadoopShellExecutable;
import org.apache.kylin.engine.mr.common.MapReduceExecutable;
import org.apache.kylin.engine.mr.steps.CubingExecutableUtil;
import org.apache.kylin.job.JobInstance;
import org.apache.kylin.job.common.ShellExecutable;
import org.apache.kylin.job.constant.JobStatusEnum;
import org.apache.kylin.job.constant.JobStepStatusEnum;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.Output;

public class JobInfoConverter {
    public static JobInstance parseToJobInstance(AbstractExecutable job, Map<String, Output> outputs) {
        if (job == null) {
            return null;
        }
        Preconditions.checkState((boolean)(job instanceof CubingJob), (Object)("illegal job type, id:" + job.getId()));
        CubingJob cubeJob = (CubingJob)job;
        Output output = outputs.get(job.getId());
        JobInstance result = new JobInstance();
        result.setName(job.getName());
        result.setRelatedCube(CubingExecutableUtil.getCubeName(cubeJob.getParams()));
        result.setRelatedSegment(CubingExecutableUtil.getSegmentId(cubeJob.getParams()));
        result.setLastModified(output.getLastModified());
        result.setSubmitter(cubeJob.getSubmitter());
        result.setUuid(cubeJob.getId());
        result.setType(CubeBuildTypeEnum.BUILD);
        result.setStatus(JobInfoConverter.parseToJobStatus(output.getState()));
        result.setMrWaiting(AbstractExecutable.getExtraInfoAsLong((Output)output, (String)"mapReduceWaitTime", (long)0L) / 1000L);
        result.setExecStartTime(AbstractExecutable.getStartTime((Output)output));
        result.setExecEndTime(AbstractExecutable.getEndTime((Output)output));
        result.setDuration(AbstractExecutable.getDuration((long)result.getExecStartTime(), (long)result.getExecEndTime()) / 1000L);
        for (int i = 0; i < cubeJob.getTasks().size(); ++i) {
            AbstractExecutable task = (AbstractExecutable)cubeJob.getTasks().get(i);
            result.addStep(JobInfoConverter.parseToJobStep(task, i, outputs.get(task.getId())));
        }
        return result;
    }

    public static JobInstance.JobStep parseToJobStep(AbstractExecutable task, int i, Output stepOutput) {
        Preconditions.checkNotNull((Object)stepOutput);
        JobInstance.JobStep result = new JobInstance.JobStep();
        result.setId(task.getId());
        result.setName(task.getName());
        result.setSequenceID(i);
        result.setStatus(JobInfoConverter.parseToJobStepStatus(stepOutput.getState()));
        for (Map.Entry entry : stepOutput.getExtra().entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            result.putInfo((String)entry.getKey(), (String)entry.getValue());
        }
        result.setExecStartTime(AbstractExecutable.getStartTime((Output)stepOutput));
        result.setExecEndTime(AbstractExecutable.getEndTime((Output)stepOutput));
        if (task instanceof ShellExecutable) {
            result.setExecCmd(((ShellExecutable)task).getCmd());
        }
        if (task instanceof MapReduceExecutable) {
            result.setExecCmd(((MapReduceExecutable)task).getMapReduceParams());
            result.setExecWaitTime(AbstractExecutable.getExtraInfoAsLong((Output)stepOutput, (String)"mapReduceWaitTime", (long)0L) / 1000L);
        }
        if (task instanceof HadoopShellExecutable) {
            result.setExecCmd(((HadoopShellExecutable)task).getJobParams());
        }
        return result;
    }

    public static JobStatusEnum parseToJobStatus(ExecutableState state) {
        switch (state) {
            case READY: {
                return JobStatusEnum.PENDING;
            }
            case RUNNING: {
                return JobStatusEnum.RUNNING;
            }
            case ERROR: {
                return JobStatusEnum.ERROR;
            }
            case DISCARDED: {
                return JobStatusEnum.DISCARDED;
            }
            case SUCCEED: {
                return JobStatusEnum.FINISHED;
            }
            case STOPPED: {
                return JobStatusEnum.STOPPED;
            }
        }
        throw new RuntimeException("invalid state:" + state);
    }

    public static JobStepStatusEnum parseToJobStepStatus(ExecutableState state) {
        switch (state) {
            case READY: {
                return JobStepStatusEnum.PENDING;
            }
            case RUNNING: {
                return JobStepStatusEnum.RUNNING;
            }
            case ERROR: {
                return JobStepStatusEnum.ERROR;
            }
            case DISCARDED: {
                return JobStepStatusEnum.DISCARDED;
            }
            case SUCCEED: {
                return JobStepStatusEnum.FINISHED;
            }
            case STOPPED: {
                return JobStepStatusEnum.STOPPED;
            }
        }
        throw new RuntimeException("invalid state:" + state);
    }
}

