/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.Principal;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthSchemeFactory;
import org.apache.http.auth.AuthSchemeRegistry;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.kylin.engine.mr.common.DefaultSslProtocolSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopStatusGetter {
    private final String mrJobId;
    private final String yarnUrl;
    protected static final Logger logger = LoggerFactory.getLogger(HadoopStatusGetter.class);
    private static String DEFAULT_KRB5_CONFIG_LOCATION = "/etc/krb5.conf";
    private static Protocol EASY_HTTPS = null;

    public HadoopStatusGetter(String yarnUrl, String mrJobId) {
        this.yarnUrl = yarnUrl;
        this.mrJobId = mrJobId;
    }

    public Pair<RMAppState, FinalApplicationStatus> get(boolean useKerberosAuth) throws IOException {
        String applicationId = this.mrJobId.replace("job", "application");
        String url = this.yarnUrl.replace("${job_id}", applicationId);
        String response = useKerberosAuth ? this.getHttpResponseWithKerberosAuth(url) : this.getHttpResponse(url);
        logger.debug("Hadoop job " + this.mrJobId + " status : " + response);
        JsonNode root = new ObjectMapper().readTree(response);
        RMAppState state = RMAppState.valueOf((String)root.findValue("state").textValue());
        FinalApplicationStatus finalStatus = FinalApplicationStatus.valueOf((String)root.findValue("finalStatus").textValue());
        return Pair.of((Object)state, (Object)finalStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getHttpResponseWithKerberosAuth(String url) throws IOException {
        String krb5ConfigPath = System.getProperty("java.security.krb5.conf");
        if (krb5ConfigPath == null) {
            krb5ConfigPath = DEFAULT_KRB5_CONFIG_LOCATION;
        }
        boolean skipPortAtKerberosDatabaseLookup = true;
        System.setProperty("java.security.krb5.conf", krb5ConfigPath);
        System.setProperty("sun.security.krb5.debug", "true");
        System.setProperty("javax.security.auth.useSubjectCredsOnly", "false");
        DefaultHttpClient client = new DefaultHttpClient();
        AuthSchemeRegistry authSchemeRegistry = new AuthSchemeRegistry();
        authSchemeRegistry.register("negotiate", (AuthSchemeFactory)new SPNegoSchemeFactory(skipPortAtKerberosDatabaseLookup));
        client.setAuthSchemes(authSchemeRegistry);
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        Credentials useJaasCreds = new Credentials(){

            public String getPassword() {
                return null;
            }

            public Principal getUserPrincipal() {
                return null;
            }
        };
        credentialsProvider.setCredentials(new AuthScope(null, -1, null), useJaasCreds);
        client.setCredentialsProvider((CredentialsProvider)credentialsProvider);
        String response = null;
        while (response == null) {
            if (url.startsWith("https://")) {
                HadoopStatusGetter.registerEasyHttps();
            }
            if (!url.contains("anonymous=true")) {
                url = url + (url.contains("?") ? "&" : "?");
                url = url + "anonymous=true";
            }
            HttpGet httpget = new HttpGet(url);
            httpget.addHeader("accept", "application/json");
            try {
                HttpResponse httpResponse = client.execute((HttpUriRequest)httpget);
                String redirect = null;
                org.apache.http.Header h = httpResponse.getFirstHeader("Location");
                if (h != null) {
                    redirect = h.getValue();
                    if (!HadoopStatusGetter.isValidURL(redirect)) {
                        logger.info("Get invalid redirect url, skip it: " + redirect);
                        Thread.sleep(1000L);
                        continue;
                    }
                } else {
                    String s;
                    int cut;
                    h = httpResponse.getFirstHeader("Refresh");
                    if (h != null && (cut = (s = h.getValue()).indexOf("url=")) >= 0 && !HadoopStatusGetter.isValidURL(redirect = s.substring(cut + 4))) {
                        logger.info("Get invalid redirect url, skip it: " + redirect);
                        Thread.sleep(1000L);
                        continue;
                    }
                }
                if (redirect == null) {
                    response = IOUtils.toString((InputStream)httpResponse.getEntity().getContent(), (Charset)Charset.defaultCharset());
                    logger.debug("Job " + this.mrJobId + " get status check result.\n");
                    continue;
                }
                url = redirect;
                logger.debug("Job " + this.mrJobId + " check redirect url " + url + ".\n");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error(e.getMessage());
            }
            finally {
                httpget.releaseConnection();
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getHttpResponse(String url) throws IOException {
        HttpClient client = new HttpClient();
        String response = null;
        while (response == null) {
            if (url.startsWith("https://")) {
                HadoopStatusGetter.registerEasyHttps();
            }
            if (!url.contains("anonymous=true")) {
                url = url + (url.contains("?") ? "&" : "?");
                url = url + "anonymous=true";
            }
            GetMethod get = new GetMethod(url);
            get.addRequestHeader("accept", "application/json");
            try {
                client.executeMethod((HttpMethod)get);
                String redirect = null;
                Header h = get.getResponseHeader("Location");
                if (h != null) {
                    redirect = h.getValue();
                    if (!HadoopStatusGetter.isValidURL(redirect)) {
                        logger.info("Get invalid redirect url, skip it: " + redirect);
                        Thread.sleep(1000L);
                        continue;
                    }
                } else {
                    String s;
                    int cut;
                    h = get.getResponseHeader("Refresh");
                    if (h != null && (cut = (s = h.getValue()).indexOf("url=")) >= 0 && !HadoopStatusGetter.isValidURL(redirect = s.substring(cut + 4))) {
                        logger.info("Get invalid redirect url, skip it: " + redirect);
                        Thread.sleep(1000L);
                        continue;
                    }
                }
                if (redirect == null) {
                    response = get.getResponseBodyAsString();
                    logger.debug("Job " + this.mrJobId + " get status check result.\n");
                    continue;
                }
                url = redirect;
                logger.debug("Job " + this.mrJobId + " check redirect url " + url + ".\n");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error(e.getMessage());
            }
            finally {
                get.releaseConnection();
            }
        }
        return response;
    }

    private static void registerEasyHttps() {
        if (EASY_HTTPS == null) {
            EASY_HTTPS = new Protocol("https", (ProtocolSocketFactory)new DefaultSslProtocolSocketFactory(), 443);
            Protocol.registerProtocol((String)"https", (Protocol)EASY_HTTPS);
        }
    }

    private static boolean isValidURL(String value) {
        if (StringUtils.isNotEmpty((String)value)) {
            URL url;
            try {
                url = new URL(value);
            }
            catch (MalformedURLException var5) {
                return false;
            }
            return StringUtils.isNotEmpty((String)url.getProtocol()) && StringUtils.isNotEmpty((String)url.getHost());
        }
        return false;
    }
}

