/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.common;

import com.google.common.collect.Sets;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.kv.AbstractRowKeyEncoder;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.CubeJoinedFlatTableEnrich;
import org.apache.kylin.measure.BufferedMeasureCodec;
import org.apache.kylin.measure.MeasureIngester;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseCuboidBuilder
implements Serializable {
    protected static final Logger logger = LoggerFactory.getLogger(BaseCuboidBuilder.class);
    public static final String HIVE_NULL = "\\N";
    protected String cubeName;
    protected Cuboid baseCuboid;
    protected CubeDesc cubeDesc;
    protected CubeSegment cubeSegment;
    protected Set<String> nullStrs;
    protected CubeJoinedFlatTableEnrich intermediateTableDesc;
    protected MeasureIngester<?>[] aggrIngesters;
    protected Map<TblColRef, Dictionary<String>> dictionaryMap;
    protected AbstractRowKeyEncoder rowKeyEncoder;
    protected BufferedMeasureCodec measureCodec;
    protected KylinConfig kylinConfig;

    public BaseCuboidBuilder(KylinConfig kylinConfig, CubeDesc cubeDesc, CubeSegment cubeSegment, CubeJoinedFlatTableEnrich intermediateTableDesc, AbstractRowKeyEncoder rowKeyEncoder, MeasureIngester<?>[] aggrIngesters, Map<TblColRef, Dictionary<String>> dictionaryMap) {
        this.kylinConfig = kylinConfig;
        this.cubeDesc = cubeDesc;
        this.cubeSegment = cubeSegment;
        this.intermediateTableDesc = intermediateTableDesc;
        this.rowKeyEncoder = rowKeyEncoder;
        this.aggrIngesters = aggrIngesters;
        this.dictionaryMap = dictionaryMap;
        this.init();
        this.measureCodec = new BufferedMeasureCodec((Collection)cubeDesc.getMeasures());
    }

    public BaseCuboidBuilder(KylinConfig kylinConfig, CubeDesc cubeDesc, CubeSegment cubeSegment, CubeJoinedFlatTableEnrich intermediateTableDesc) {
        this.kylinConfig = kylinConfig;
        this.cubeDesc = cubeDesc;
        this.cubeSegment = cubeSegment;
        this.intermediateTableDesc = intermediateTableDesc;
        this.init();
        this.rowKeyEncoder = AbstractRowKeyEncoder.createInstance((CubeSegment)cubeSegment, (Cuboid)this.baseCuboid);
        this.measureCodec = new BufferedMeasureCodec((Collection)cubeDesc.getMeasures());
        this.aggrIngesters = MeasureIngester.create((Collection)cubeDesc.getMeasures());
        this.dictionaryMap = cubeSegment.buildDictionaryMap();
    }

    private void init() {
        long baseCuboidId = Cuboid.getBaseCuboidId((CubeDesc)this.cubeDesc);
        this.baseCuboid = Cuboid.findById((CubeDesc)this.cubeDesc, (long)baseCuboidId);
        this.initNullBytes();
    }

    private void initNullBytes() {
        this.nullStrs = Sets.newHashSet();
        this.nullStrs.add(HIVE_NULL);
        String[] nullStrings = this.cubeDesc.getNullStrings();
        if (nullStrings != null) {
            for (String s : nullStrings) {
                this.nullStrs.add(s);
            }
        }
    }

    protected boolean isNull(String v) {
        return this.nullStrs.contains(v);
    }

    public byte[] buildKey(String[] flatRow) {
        int[] rowKeyColumnIndexes = this.intermediateTableDesc.getRowKeyColumnIndexes();
        List columns = this.baseCuboid.getColumns();
        String[] colValues = new String[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            colValues[i] = this.getCell(rowKeyColumnIndexes[i], flatRow);
        }
        return this.rowKeyEncoder.encode(colValues);
    }

    public ByteBuffer buildValue(String[] flatRow) {
        return this.measureCodec.encode(this.buildValueObjects(flatRow));
    }

    public Object[] buildValueObjects(String[] flatRow) {
        Object[] measures = new Object[this.cubeDesc.getMeasures().size()];
        for (int i = 0; i < measures.length; ++i) {
            measures[i] = this.buildValueOf(i, flatRow);
        }
        return measures;
    }

    public void resetAggrs() {
        for (int i = 0; i < this.cubeDesc.getMeasures().size(); ++i) {
            this.aggrIngesters[i].reset();
        }
    }

    private Object buildValueOf(int idxOfMeasure, String[] flatRow) {
        MeasureDesc measure = (MeasureDesc)this.cubeDesc.getMeasures().get(idxOfMeasure);
        FunctionDesc function = measure.getFunction();
        int[] colIdxOnFlatTable = this.intermediateTableDesc.getMeasureColumnIndexes()[idxOfMeasure];
        int paramCount = function.getParameterCount();
        String[] inputToMeasure = new String[paramCount];
        ParameterDesc param = function.getParameter();
        int colParamIdx = 0;
        int i = 0;
        while (i < paramCount) {
            String value = function.isCount() ? "1" : (param.isColumnType() ? this.getCell(colIdxOnFlatTable[colParamIdx++], flatRow) : param.getValue());
            inputToMeasure[i] = value;
            ++i;
            param = param.getNextParameter();
        }
        return this.aggrIngesters[idxOfMeasure].valueOf(inputToMeasure, measure, this.dictionaryMap);
    }

    private String getCell(int i, String[] flatRow) {
        if (this.isNull(flatRow[i])) {
            return null;
        }
        return flatRow[i];
    }
}

