/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.Tool;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.EngineFactory;
import org.apache.kylin.engine.mr.IMRInput;
import org.apache.kylin.engine.mr.IMROutput;
import org.apache.kylin.engine.mr.IMROutput2;
import org.apache.kylin.metadata.MetadataManager;
import org.apache.kylin.metadata.model.IJoinedFlatTableDesc;
import org.apache.kylin.metadata.model.ISegment;
import org.apache.kylin.metadata.model.ISourceAware;
import org.apache.kylin.metadata.model.IStorageAware;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.source.SourceFactory;
import org.apache.kylin.storage.StorageFactory;

public class MRUtil {
    public static IMRInput.IMRBatchCubingInputSide getBatchCubingInputSide(CubeSegment seg) {
        IJoinedFlatTableDesc flatDesc = EngineFactory.getJoinedFlatTableDesc((CubeSegment)seg);
        return ((IMRInput)SourceFactory.createEngineAdapter((ISourceAware)seg, IMRInput.class)).getBatchCubingInputSide(flatDesc);
    }

    @Deprecated
    public static IMRInput.IMRTableInputFormat getTableInputFormat(String tableName) {
        return MRUtil.getTableInputFormat(tableName, true);
    }

    public static IMRInput.IMRTableInputFormat getTableInputFormat(String tableName, boolean isFullTable) {
        return MRUtil.getTableInputFormat(MRUtil.getTableDesc(tableName), isFullTable);
    }

    @Deprecated
    public static IMRInput.IMRTableInputFormat getTableInputFormat(TableDesc tableDesc) {
        return MRUtil.getTableInputFormat(tableDesc, true);
    }

    public static IMRInput.IMRTableInputFormat getTableInputFormat(TableDesc tableDesc, boolean isFullTable) {
        return ((IMRInput)SourceFactory.createEngineAdapter((ISourceAware)tableDesc, IMRInput.class)).getTableInputFormat(tableDesc, isFullTable);
    }

    private static TableDesc getTableDesc(String tableName) {
        return MetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getTableDesc(tableName);
    }

    public static IMROutput.IMRBatchCubingOutputSide getBatchCubingOutputSide(CubeSegment seg) {
        return ((IMROutput)StorageFactory.createEngineAdapter((IStorageAware)seg, IMROutput.class)).getBatchCubingOutputSide(seg);
    }

    public static IMROutput.IMRBatchMergeOutputSide getBatchMergeOutputSide(CubeSegment seg) {
        return ((IMROutput)StorageFactory.createEngineAdapter((IStorageAware)seg, IMROutput.class)).getBatchMergeOutputSide(seg);
    }

    public static IMROutput2.IMRBatchCubingOutputSide2 getBatchCubingOutputSide2(CubeSegment seg) {
        return ((IMROutput2)StorageFactory.createEngineAdapter((IStorageAware)seg, IMROutput2.class)).getBatchCubingOutputSide(seg);
    }

    public static IMROutput2.IMRBatchMergeOutputSide2 getBatchMergeOutputSide2(CubeSegment seg) {
        return ((IMROutput2)StorageFactory.createEngineAdapter((IStorageAware)seg, IMROutput2.class)).getBatchMergeOutputSide(seg);
    }

    public static IMRInput.IMRBatchMergeInputSide getBatchMergeInputSide(CubeSegment seg) {
        return ((IMRInput)SourceFactory.createEngineAdapter((ISourceAware)seg, IMRInput.class)).getBatchMergeInputSide((ISegment)seg);
    }

    public static int runMRJob(Tool tool, String[] args) throws Exception {
        Configuration conf = tool.getConf();
        if (conf == null) {
            conf = new Configuration();
        }
        GenericOptionsParser parser = MRUtil.getParser(conf, args);
        tool.setConf(conf);
        String[] toolArgs = parser.getRemainingArgs();
        return tool.run(toolArgs);
    }

    private static synchronized GenericOptionsParser getParser(Configuration conf, String[] args) throws Exception {
        return new GenericOptionsParser(conf, args);
    }
}

