/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.mr.common.HadoopShellExecutable;
import org.apache.kylin.engine.mr.common.MapReduceExecutable;
import org.apache.kylin.engine.mr.steps.CreateDictionaryJob;
import org.apache.kylin.engine.mr.steps.CubingExecutableUtil;
import org.apache.kylin.engine.mr.steps.FactDistinctColumnsJob;
import org.apache.kylin.engine.mr.steps.MergeDictionaryStep;
import org.apache.kylin.engine.mr.steps.UpdateCubeInfoAfterBuildStep;
import org.apache.kylin.engine.mr.steps.UpdateCubeInfoAfterMergeStep;
import org.apache.kylin.job.engine.JobEngineConfig;

public class JobBuilderSupport {
    protected final JobEngineConfig config;
    protected final CubeSegment seg;
    protected final String submitter;
    public static final String LayeredCuboidFolderPrefix = "level_";

    public JobBuilderSupport(CubeSegment seg, String submitter) {
        Preconditions.checkNotNull((Object)seg, (Object)"segment cannot be null");
        this.config = new JobEngineConfig(seg.getConfig());
        this.seg = seg;
        this.submitter = submitter;
    }

    public MapReduceExecutable createFactDistinctColumnsStep(String jobId) {
        return this.createFactDistinctColumnsStep(jobId, false);
    }

    public MapReduceExecutable createFactDistinctColumnsStepWithStats(String jobId) {
        return this.createFactDistinctColumnsStep(jobId, true);
    }

    private MapReduceExecutable createFactDistinctColumnsStep(String jobId, boolean withStats) {
        MapReduceExecutable result = new MapReduceExecutable();
        result.setName("Extract Fact Table Distinct Columns");
        result.setMapReduceJobClass(FactDistinctColumnsJob.class);
        StringBuilder cmd = new StringBuilder();
        this.appendMapReduceParameters(cmd);
        JobBuilderSupport.appendExecCmdParameters(cmd, "cubename", this.seg.getRealization().getName());
        JobBuilderSupport.appendExecCmdParameters(cmd, "output", this.getFactDistinctColumnsPath(jobId));
        JobBuilderSupport.appendExecCmdParameters(cmd, "segmentid", this.seg.getUuid());
        JobBuilderSupport.appendExecCmdParameters(cmd, "statisticsenabled", String.valueOf(withStats));
        JobBuilderSupport.appendExecCmdParameters(cmd, "statisticsoutput", this.getStatisticsPath(jobId));
        JobBuilderSupport.appendExecCmdParameters(cmd, "statisticssamplingpercent", String.valueOf(this.config.getConfig().getCubingInMemSamplingPercent()));
        JobBuilderSupport.appendExecCmdParameters(cmd, "jobname", "Kylin_Fact_Distinct_Columns_" + this.seg.getRealization().getName() + "_Step");
        JobBuilderSupport.appendExecCmdParameters(cmd, "cubingJobId", jobId);
        result.setMapReduceParams(cmd.toString());
        result.setCounterSaveAs("sourceRecordCount,sourceSizeBytes");
        return result;
    }

    public HadoopShellExecutable createBuildDictionaryStep(String jobId) {
        HadoopShellExecutable buildDictionaryStep = new HadoopShellExecutable();
        buildDictionaryStep.setName("Build Dimension Dictionary");
        StringBuilder cmd = new StringBuilder();
        JobBuilderSupport.appendExecCmdParameters(cmd, "cubename", this.seg.getRealization().getName());
        JobBuilderSupport.appendExecCmdParameters(cmd, "segmentid", this.seg.getUuid());
        JobBuilderSupport.appendExecCmdParameters(cmd, "input", this.getFactDistinctColumnsPath(jobId));
        buildDictionaryStep.setJobParams(cmd.toString());
        buildDictionaryStep.setJobClass(CreateDictionaryJob.class);
        return buildDictionaryStep;
    }

    public UpdateCubeInfoAfterBuildStep createUpdateCubeInfoAfterBuildStep(String jobId) {
        UpdateCubeInfoAfterBuildStep result = new UpdateCubeInfoAfterBuildStep();
        result.setName("Update Cube Info");
        result.getParams().put("output.path", this.getFactDistinctColumnsPath(jobId));
        CubingExecutableUtil.setCubeName(this.seg.getRealization().getName(), result.getParams());
        CubingExecutableUtil.setSegmentId(this.seg.getUuid(), result.getParams());
        CubingExecutableUtil.setCubingJobId(jobId, result.getParams());
        return result;
    }

    public MergeDictionaryStep createMergeDictionaryStep(List<String> mergingSegmentIds) {
        MergeDictionaryStep result = new MergeDictionaryStep();
        result.setName("Merge Cuboid Dictionary");
        CubingExecutableUtil.setCubeName(this.seg.getRealization().getName(), result.getParams());
        CubingExecutableUtil.setSegmentId(this.seg.getUuid(), result.getParams());
        CubingExecutableUtil.setMergingSegmentIds(mergingSegmentIds, result.getParams());
        return result;
    }

    public UpdateCubeInfoAfterMergeStep createUpdateCubeInfoAfterMergeStep(List<String> mergingSegmentIds, String jobId) {
        UpdateCubeInfoAfterMergeStep result = new UpdateCubeInfoAfterMergeStep();
        result.setName("Update Cube Info");
        CubingExecutableUtil.setCubeName(this.seg.getRealization().getName(), result.getParams());
        CubingExecutableUtil.setSegmentId(this.seg.getUuid(), result.getParams());
        CubingExecutableUtil.setCubingJobId(jobId, result.getParams());
        CubingExecutableUtil.setMergingSegmentIds(mergingSegmentIds, result.getParams());
        return result;
    }

    public String getJobWorkingDir(String jobId) {
        return JobBuilderSupport.getJobWorkingDir(this.config, jobId);
    }

    public String getRealizationRootPath(String jobId) {
        return this.getJobWorkingDir(jobId) + "/" + this.seg.getRealization().getName();
    }

    public String getCuboidRootPath(String jobId) {
        return this.getRealizationRootPath(jobId) + "/cuboid/";
    }

    public String getCuboidRootPath(CubeSegment seg) {
        return this.getCuboidRootPath(seg.getLastBuildJobID());
    }

    public String getSecondaryIndexPath(String jobId) {
        return this.getRealizationRootPath(jobId) + "/secondary_index/";
    }

    public void appendMapReduceParameters(StringBuilder buf) {
        this.appendMapReduceParameters(buf, "");
    }

    public void appendMapReduceParameters(StringBuilder buf, String jobType) {
        try {
            String jobConf = this.config.getHadoopJobConfFilePath(jobType);
            if (jobConf != null && jobConf.length() > 0) {
                buf.append(" -conf ").append(jobConf);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getFactDistinctColumnsPath(String jobId) {
        return this.getRealizationRootPath(jobId) + "/fact_distinct_columns";
    }

    public String getStatisticsPath(String jobId) {
        return this.getRealizationRootPath(jobId) + "/fact_distinct_columns/" + "statistics";
    }

    public static String getJobWorkingDir(JobEngineConfig conf, String jobId) {
        return JobBuilderSupport.getJobWorkingDir(conf.getHdfsWorkingDirectory(), jobId);
    }

    public static String getJobWorkingDir(String hdfsDir, String jobId) {
        if (!hdfsDir.endsWith("/")) {
            hdfsDir = hdfsDir + "/";
        }
        return hdfsDir + "kylin-" + jobId;
    }

    public static StringBuilder appendExecCmdParameters(StringBuilder buf, String paraName, String paraValue) {
        return buf.append(" -").append(paraName).append(" ").append(paraValue);
    }

    public static String getCuboidOutputPathsByLevel(String cuboidRootPath, int level) {
        if (level == 0) {
            return cuboidRootPath + LayeredCuboidFolderPrefix + "base_cuboid";
        }
        return cuboidRootPath + LayeredCuboidFolderPrefix + level + "_cuboid";
    }
}

