/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.engine.mr.DFSFileTableReader;
import org.apache.kylin.source.ReadableTable;

public class DFSFileTable
implements ReadableTable {
    public static final String DELIM_AUTO = "auto";
    public static final String DELIM_COMMA = ",";
    String path;
    String delim;
    int nColumns;

    public DFSFileTable(String path, int nColumns) {
        this(path, DELIM_AUTO, nColumns);
    }

    public DFSFileTable(String path, String delim, int nColumns) {
        this.path = path;
        this.delim = delim;
        this.nColumns = nColumns;
    }

    public String getColumnDelimeter() {
        return this.delim;
    }

    public ReadableTable.TableReader getReader() throws IOException {
        return new DFSFileTableReader(this.path, this.delim, this.nColumns);
    }

    public ReadableTable.TableSignature getSignature() throws IOException {
        Pair sizeAndLastModified;
        try {
            sizeAndLastModified = DFSFileTable.getSizeAndLastModified(this.path);
        }
        catch (FileNotFoundException ex) {
            sizeAndLastModified = Pair.newPair((Object)-1L, (Object)0L);
        }
        return new ReadableTable.TableSignature(this.path, ((Long)sizeAndLastModified.getFirst()).longValue(), ((Long)sizeAndLastModified.getSecond()).longValue());
    }

    public boolean exists() throws IOException {
        try {
            DFSFileTable.getSizeAndLastModified(this.path);
            return true;
        }
        catch (FileNotFoundException ex) {
            return false;
        }
    }

    public String toString() {
        return this.path;
    }

    public static Pair<Long, Long> getSizeAndLastModified(String path) throws IOException {
        FileSystem fs = HadoopUtil.getFileSystem((String)path);
        ArrayList<FileStatus> allFiles = new ArrayList<FileStatus>();
        FileStatus status = fs.getFileStatus(new Path(path));
        if (status.isFile()) {
            allFiles.add(status);
        } else {
            FileStatus[] listStatus = fs.listStatus(new Path(path));
            allFiles.addAll(Arrays.asList(listStatus));
        }
        long size = 0L;
        long lastModified = 0L;
        for (FileStatus file : allFiles) {
            size += file.getLen();
            lastModified = Math.max(lastModified, file.getModificationTime());
        }
        return Pair.newPair((Object)size, (Object)lastModified);
    }
}

