/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr;

import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.engine.mr.IMRInput;
import org.apache.kylin.engine.mr.IMROutput2;
import org.apache.kylin.engine.mr.JobBuilderSupport;
import org.apache.kylin.engine.mr.MRUtil;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.engine.mr.common.MapReduceExecutable;
import org.apache.kylin.engine.mr.steps.BaseCuboidJob;
import org.apache.kylin.engine.mr.steps.CubingExecutableUtil;
import org.apache.kylin.engine.mr.steps.InMemCuboidJob;
import org.apache.kylin.engine.mr.steps.NDCuboidJob;
import org.apache.kylin.engine.mr.steps.SaveStatisticsStep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchCubingJobBuilder2
extends JobBuilderSupport {
    private static final Logger logger = LoggerFactory.getLogger(BatchCubingJobBuilder2.class);
    private final IMRInput.IMRBatchCubingInputSide inputSide;
    private final IMROutput2.IMRBatchCubingOutputSide2 outputSide;

    public BatchCubingJobBuilder2(CubeSegment newSegment, String submitter) {
        super(newSegment, submitter);
        this.inputSide = MRUtil.getBatchCubingInputSide(this.seg);
        this.outputSide = MRUtil.getBatchCubingOutputSide2(this.seg);
    }

    public CubingJob build() {
        logger.info("MR_V2 new job to BUILD segment " + this.seg);
        CubingJob result = CubingJob.createBuildJob(this.seg, this.submitter, this.config);
        String jobId = result.getId();
        String cuboidRootPath = this.getCuboidRootPath(jobId);
        this.inputSide.addStepPhase1_CreateFlatTable(result);
        result.addTask(this.createFactDistinctColumnsStepWithStats(jobId));
        result.addTask(this.createBuildDictionaryStep(jobId));
        result.addTask(this.createSaveStatisticsStep(jobId));
        this.outputSide.addStepPhase2_BuildDictionary(result);
        this.addLayerCubingSteps(result, jobId, cuboidRootPath);
        this.addInMemCubingSteps(result, jobId, cuboidRootPath);
        this.outputSide.addStepPhase3_BuildCube(result);
        result.addTask(this.createUpdateCubeInfoAfterBuildStep(jobId));
        this.inputSide.addStepPhase4_Cleanup(result);
        this.outputSide.addStepPhase4_Cleanup(result);
        return result;
    }

    protected void addLayerCubingSteps(CubingJob result, String jobId, String cuboidRootPath) {
        int maxLevel = this.seg.getCubeDesc().getBuildLevel();
        result.addTask(this.createBaseCuboidStep(BatchCubingJobBuilder2.getCuboidOutputPathsByLevel(cuboidRootPath, 0), jobId));
        for (int i = 1; i <= maxLevel; ++i) {
            result.addTask(this.createNDimensionCuboidStep(BatchCubingJobBuilder2.getCuboidOutputPathsByLevel(cuboidRootPath, i - 1), BatchCubingJobBuilder2.getCuboidOutputPathsByLevel(cuboidRootPath, i), i, jobId));
        }
    }

    private SaveStatisticsStep createSaveStatisticsStep(String jobId) {
        SaveStatisticsStep result = new SaveStatisticsStep();
        result.setName("Save Cuboid Statistics");
        CubingExecutableUtil.setCubeName(this.seg.getRealization().getName(), result.getParams());
        CubingExecutableUtil.setSegmentId(this.seg.getUuid(), result.getParams());
        CubingExecutableUtil.setStatisticsPath(this.getStatisticsPath(jobId), result.getParams());
        CubingExecutableUtil.setCubingJobId(jobId, result.getParams());
        return result;
    }

    protected void addInMemCubingSteps(CubingJob result, String jobId, String cuboidRootPath) {
        MapReduceExecutable cubeStep = new MapReduceExecutable();
        StringBuilder cmd = new StringBuilder();
        this.appendMapReduceParameters(cmd, "inmem");
        cubeStep.setName("Build Cube In-Mem");
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "cubename", this.seg.getRealization().getName());
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "segmentid", this.seg.getUuid());
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "output", cuboidRootPath);
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "jobname", "Kylin_Cube_Builder_" + this.seg.getRealization().getName());
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "cubingJobId", jobId);
        cubeStep.setMapReduceParams(cmd.toString());
        cubeStep.setMapReduceJobClass(this.getInMemCuboidJob());
        result.addTask(cubeStep);
    }

    protected Class<? extends AbstractHadoopJob> getInMemCuboidJob() {
        return InMemCuboidJob.class;
    }

    private MapReduceExecutable createBaseCuboidStep(String cuboidOutputPath, String jobId) {
        MapReduceExecutable baseCuboidStep = new MapReduceExecutable();
        StringBuilder cmd = new StringBuilder();
        this.appendMapReduceParameters(cmd);
        baseCuboidStep.setName("Build Base Cuboid");
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "cubename", this.seg.getRealization().getName());
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "segmentid", this.seg.getUuid());
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "input", "FLAT_TABLE");
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "output", cuboidOutputPath);
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "jobname", "Kylin_Base_Cuboid_Builder_" + this.seg.getRealization().getName());
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "level", "0");
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "cubingJobId", jobId);
        baseCuboidStep.setMapReduceParams(cmd.toString());
        baseCuboidStep.setMapReduceJobClass(this.getBaseCuboidJob());
        return baseCuboidStep;
    }

    protected Class<? extends AbstractHadoopJob> getBaseCuboidJob() {
        return BaseCuboidJob.class;
    }

    private MapReduceExecutable createNDimensionCuboidStep(String parentPath, String outputPath, int level, String jobId) {
        MapReduceExecutable ndCuboidStep = new MapReduceExecutable();
        ndCuboidStep.setName("Build N-Dimension Cuboid : level " + level);
        StringBuilder cmd = new StringBuilder();
        this.appendMapReduceParameters(cmd);
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "cubename", this.seg.getRealization().getName());
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "segmentid", this.seg.getUuid());
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "input", parentPath);
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "output", outputPath);
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "jobname", "Kylin_ND-Cuboid_Builder_" + this.seg.getRealization().getName() + "_Step");
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "level", "" + level);
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "cubingJobId", jobId);
        ndCuboidStep.setMapReduceParams(cmd.toString());
        ndCuboidStep.setMapReduceJobClass(this.getNDCuboidJob());
        return ndCuboidStep;
    }

    protected Class<? extends AbstractHadoopJob> getNDCuboidJob() {
        return NDCuboidJob.class;
    }
}

