/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.util.CaseInsensitiveStringSet;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.apache.kylin.rest.aspect.Transaction;
import org.apache.kylin.rest.request.GlobalAccessRequest;
import org.apache.kylin.rest.request.GlobalBatchAccessRequest;
import org.apache.kylin.rest.response.UserAccessEntryResponse;
import org.apache.kylin.rest.security.AclPermission;
import org.apache.kylin.rest.security.AclPermissionFactory;
import org.apache.kylin.rest.security.AdminUserSyncEventNotifier;
import org.apache.kylin.rest.security.ExternalAclProvider;
import org.apache.kylin.rest.security.UserAcl;
import org.apache.kylin.rest.security.UserAclManager;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.service.UserAclServiceSupporter;
import org.apache.kylin.rest.service.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.acls.model.Permission;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Component;

@Component(value="userAclService")
public class UserAclService
extends BasicService
implements UserAclServiceSupporter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserAclService.class);
    @Autowired
    @Qualifier(value="userService")
    protected UserService userService;

    public boolean hasUserAclPermission(String sid, Permission permission) {
        UserAcl userAcl = this.getManager(UserAclManager.class).get(sid);
        return !Objects.isNull(userAcl) && CollectionUtils.isNotEmpty((Collection)userAcl.getPermissionMasks()) && userAcl.getPermissionMasks().contains(permission.getMask());
    }

    @Override
    public boolean hasUserAclPermissionInProject(String project) {
        String userName = this.getLoginUsername();
        return this.userService.isGlobalAdmin(userName) && this.hasUserAclPermissionInProject(userName, project);
    }

    public boolean hasUserAclPermissionInProject(String sid, String project) {
        UserAcl userAcl = this.getManager(UserAclManager.class).get(sid);
        return !Objects.isNull(userAcl) && CollectionUtils.isNotEmpty((Collection)userAcl.getDataQueryProjects()) && userAcl.getDataQueryProjects().contains(project);
    }

    private void checkAclPermission(String sid, String permissionType) {
        Preconditions.checkArgument((boolean)"DATA_QUERY".equalsIgnoreCase(permissionType), (Object)("unknown PermissionType " + permissionType));
        if (this.isSuperAdmin(sid)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PERMISSION_DENIED, MsgPicker.getMsg().getModifyPermissionOfSuperAdminFailed());
        }
        this.checkAdminUser(sid);
        if (sid.equalsIgnoreCase(this.getLoginUsername())) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PERMISSION_DENIED, MsgPicker.getMsg().getModifyOwnPermissionFailed());
        }
    }

    private void checkLoginUserPermission() {
        if (!this.canAdminUserQuery()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PERMISSION_DENIED, MsgPicker.getMsg().getGrantPermissionFailedByIllegalAuthorizingUser());
        }
    }

    private void checkLoginUserPermissionInPrj(String project) {
        if (!this.canAdminUserQuery() && !this.hasUserAclPermissionInProject(project)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PERMISSION_DENIED, MsgPicker.getMsg().getGrantPermissionFailedByIllegalAuthorizingUser());
        }
    }

    @Transaction
    public void grantUserAclPermission(GlobalBatchAccessRequest batchAccessRequest, String permissionType) {
        batchAccessRequest.getUsernameList().forEach(sid -> this.grantUserAclPermission((String)sid, permissionType));
    }

    @Transaction
    public void grantUserAclPermission(GlobalAccessRequest accessRequest, String permissionType) {
        this.grantUserAclPermission(accessRequest.getUsername(), permissionType);
    }

    @Transaction
    public void grantUserAclPermission(String sid, String permissionType) {
        this.checkAclPermission(sid, permissionType);
        this.checkLoginUserPermission();
        this.getManager(UserAclManager.class).addPermission(sid, AclPermissionFactory.getPermission((String)permissionType.toUpperCase(Locale.ROOT)));
    }

    @Transaction
    public void addProjectToUserAcl(GlobalAccessRequest accessRequest, String permissionType) {
        this.checkAclPermission(accessRequest.getUsername(), permissionType);
        this.checkLoginUserPermissionInPrj(accessRequest.getProject());
        this.getManager(UserAclManager.class).addDataQueryProject(accessRequest.getUsername(), accessRequest.getProject());
    }

    @Transaction
    public void revokeUserAclPermission(GlobalBatchAccessRequest batchAccessRequest, String permissionType) {
        batchAccessRequest.getUsernameList().forEach(sid -> this.revokeUserAclPermission((String)sid, permissionType));
    }

    @Transaction
    public void revokeUserAclPermission(GlobalAccessRequest accessRequest, String permissionType) {
        this.revokeUserAclPermission(accessRequest.getUsername(), permissionType);
    }

    @Transaction
    public void revokeUserAclPermission(String sid, String permissionType) {
        this.checkAclPermission(sid, permissionType);
        this.checkLoginUserPermission();
        UserAclManager manager = this.getManager(UserAclManager.class);
        manager.deletePermission(sid, AclPermissionFactory.getPermission((String)permissionType.toUpperCase(Locale.ROOT)));
        if (!manager.exists(sid)) {
            manager.addPermission(sid, Collections.emptySet());
        }
    }

    @Transaction
    public void deleteProjectFromUserAcl(GlobalAccessRequest accessRequest, String permissionType) {
        this.checkAclPermission(accessRequest.getUsername(), permissionType);
        this.checkLoginUserPermissionInPrj(accessRequest.getProject());
        this.getManager(UserAclManager.class).deleteDataQueryProject(accessRequest.getUsername(), accessRequest.getProject());
    }

    public List<UserAccessEntryResponse> listUserAcl() {
        ArrayList<String> adminUsers = new ArrayList<String>();
        try {
            adminUsers.addAll(this.userService.listAdminUsers());
        }
        catch (IOException e) {
            log.error("listAdminUsers error", (Throwable)e);
            return Collections.emptyList();
        }
        List userAclList = this.getManager(UserAclManager.class).listUserAcl().stream().filter(u -> adminUsers.stream().anyMatch(adminUser -> adminUser.equalsIgnoreCase(u.getUsername()))).collect(Collectors.toList());
        Map<String, UserAccessEntryResponse> responseMap = userAclList.stream().collect(Collectors.toMap(UserAcl::getUsername, this::createUserAccessEntryResponse));
        CaseInsensitiveStringSet superAdminUserSet = new CaseInsensitiveStringSet(new HashSet<String>(this.userService.listSuperAdminUsers()));
        superAdminUserSet.forEach(superAdminUser -> responseMap.put((String)superAdminUser, this.createUserAccessEntryResponse(new UserAcl(superAdminUser, (Set)Sets.newHashSet((Object[])new Permission[]{AclPermission.DATA_QUERY})))));
        return responseMap.values().stream().collect(Collectors.toList());
    }

    private UserAccessEntryResponse createUserAccessEntryResponse(UserAcl userAcl) {
        List<String> permissions = CollectionUtils.isEmpty((Collection)userAcl.getPermissionMasks()) ? Collections.emptyList() : userAcl.getPermissionMasks().stream().map(ExternalAclProvider::convertToExternalPermission).collect(Collectors.toList());
        return new UserAccessEntryResponse(userAcl.getUsername(), permissions, userAcl.getDataQueryProjects());
    }

    private void checkAdminUser(String sid) {
        if (StringUtils.isEmpty((CharSequence)sid)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_USER_NAME, MsgPicker.getMsg().getEmptySid());
        }
        if (!this.userService.userExists(sid)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PERMISSION_DENIED, String.format(Locale.ROOT, MsgPicker.getMsg().getOperationFailedByUserNotExist(), sid));
        }
        if (!this.userService.isGlobalAdmin(sid)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PERMISSION_DENIED, MsgPicker.getMsg().getGrantPermissionFailedByNonSystemAdmin());
        }
    }

    @Override
    public boolean isSuperAdmin(String username) {
        List<String> superAdminList = this.userService.listSuperAdminUsers();
        if (CollectionUtils.isEmpty(superAdminList)) {
            return false;
        }
        return superAdminList.stream().anyMatch(superAdmin -> superAdmin.equalsIgnoreCase(username));
    }

    @Override
    public boolean canAdminUserQuery() {
        String username = this.getLoginUsername();
        return this.canAdminUserQuery(username);
    }

    @Override
    public boolean canAdminUserQuery(String username) {
        return this.isSuperAdmin(username) || this.userService.isGlobalAdmin(username) && this.hasUserAclPermission(username, AclPermission.DATA_QUERY);
    }

    private String getLoginUsername() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return authentication.getName();
    }

    @Transaction
    public void updateUserAclPermission(UserDetails user, Permission permission) {
        UserAclManager userAclManager = this.getManager(UserAclManager.class);
        if (!this.isRoleAdmin(user) && userAclManager.exists(user.getUsername())) {
            userAclManager.delete(user.getUsername());
            return;
        }
        if (this.isRoleAdmin(user) && !userAclManager.exists(user.getUsername())) {
            HashSet permissions = KylinConfig.getInstanceFromEnv().isDataPermissionDefaultEnabled() ? Sets.newHashSet((Object[])new Permission[]{permission}) : Collections.emptySet();
            userAclManager.addPermission(user.getUsername(), (Set)permissions);
        }
    }

    private boolean isRoleAdmin(UserDetails user) {
        return user.getAuthorities().contains(new SimpleGrantedAuthority("ROLE_ADMIN"));
    }

    @Transaction
    public void deleteUserAcl(String userName) {
        this.getManager(UserAclManager.class).delete(userName);
    }

    public void remoteSyncAdminUserAcl(AdminUserSyncEventNotifier eventNotifier) {
        eventNotifier.setProject("_global");
        this.remoteRequest(eventNotifier);
    }

    private static boolean isCustomProfile() {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        return "custom".equals(kylinConfig.getSecurityProfile());
    }

    public void syncAdminUserAcl() {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        if (UserAclService.isCustomProfile()) {
            this.userService.listAdminUsers();
        } else if ("ldap".equals(config.getSecurityProfile())) {
            this.syncSuperAdminUserAcl();
            this.syncAdminUserAcl(this.userService.listAdminUsers(), true);
        } else {
            this.syncSuperAdminUserAcl();
        }
    }

    public void syncSuperAdminUserAcl() {
        List<String> superAdminUserList = this.userService.listSuperAdminUsers();
        if (CollectionUtils.isEmpty(superAdminUserList)) {
            return;
        }
        if (superAdminUserList.stream().allMatch(su -> this.hasUserAclPermission((String)su, AclPermission.DATA_QUERY))) {
            return;
        }
        if (CollectionUtils.isNotEmpty(superAdminUserList)) {
            EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
                KylinConfig config = KylinConfig.getInstanceFromEnv();
                UserAclManager manager = UserAclManager.getInstance((KylinConfig)config);
                superAdminUserList.stream().filter(su -> !this.hasUserAclPermission((String)su, AclPermission.DATA_QUERY)).forEach(arg_0 -> ((UserAclManager)manager).add(arg_0));
                return null;
            }, (String)"_global", (int)1);
        }
    }

    public void syncAdminUserAcl(List<String> apiAdminUserList, boolean useEmptyPermission) {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        UserAclManager userAclManager = UserAclManager.getInstance((KylinConfig)kylinConfig);
        List dbAdminUserList = userAclManager.listAclUsernames();
        if (CollectionUtils.isEmpty(apiAdminUserList)) {
            return;
        }
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            List<String> adminUserAclRemoveList;
            UserAclManager manager;
            List<String> adminUserAclAddList = this.getIntersect(apiAdminUserList, dbAdminUserList);
            if (CollectionUtils.isNotEmpty(adminUserAclAddList)) {
                KylinConfig config = KylinConfig.getInstanceFromEnv();
                manager = UserAclManager.getInstance((KylinConfig)config);
                log.info("adminUserAclAddList:{}", adminUserAclAddList);
                adminUserAclAddList.stream().filter(adminUser -> !manager.exists(adminUser)).forEach(adminUser -> {
                    if (this.isSuperAdmin((String)adminUser) || !useEmptyPermission || config.isDataPermissionDefaultEnabled()) {
                        manager.add(adminUser);
                    } else {
                        manager.addPermission(adminUser, Collections.emptySet());
                    }
                });
            }
            if (CollectionUtils.isNotEmpty(adminUserAclRemoveList = this.getIntersect(dbAdminUserList, apiAdminUserList))) {
                manager = UserAclManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
                log.info("adminUserAclRemoveList:{}", adminUserAclRemoveList);
                adminUserAclRemoveList.forEach(adminUser -> manager.delete(adminUser));
            }
            return null;
        }, (String)"_global", (int)1);
    }

    private List<String> getIntersect(List<String> sourceList, List<String> destList) {
        ArrayList<String> copyOfSourceList = new ArrayList<String>();
        copyOfSourceList.addAll(sourceList);
        copyOfSourceList.removeAll(destList);
        return copyOfSourceList;
    }
}

