/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.common.KylinVersion;
import org.apache.kylin.common.constant.NonCustomProjectLevelConfig;
import org.apache.kylin.common.event.ProjectCleanOldQueryResultEvent;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.msg.Message;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.common.scheduler.EventBusFactory;
import org.apache.kylin.common.scheduler.SchedulerEventNotifier;
import org.apache.kylin.common.scheduler.SourceUsageUpdateNotifier;
import org.apache.kylin.common.util.EncryptUtil;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.SetThreadName;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.base.Strings;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.guava30.shaded.common.primitives.Ints;
import org.apache.kylin.job.constant.JobStatusEnum;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.metadata.cube.storage.ProjectStorageInfoCollector;
import org.apache.kylin.metadata.cube.storage.StorageInfoEnum;
import org.apache.kylin.metadata.cube.storage.StorageVolumeInfo;
import org.apache.kylin.metadata.favorite.FavoriteRuleManager;
import org.apache.kylin.metadata.favorite.ModelFavoriteRuleManager;
import org.apache.kylin.metadata.favorite.QueryHistoryIdOffsetManager;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.realization.RealizationStatusEnum;
import org.apache.kylin.metadata.recommendation.candidate.RawRecManager;
import org.apache.kylin.rest.aspect.Transaction;
import org.apache.kylin.rest.config.initialize.ProjectDropListener;
import org.apache.kylin.rest.request.ComputedColumnConfigRequest;
import org.apache.kylin.rest.request.GarbageCleanUpConfigRequest;
import org.apache.kylin.rest.request.JdbcRequest;
import org.apache.kylin.rest.request.JdbcSourceInfoRequest;
import org.apache.kylin.rest.request.JobNotificationConfigRequest;
import org.apache.kylin.rest.request.MultiPartitionConfigRequest;
import org.apache.kylin.rest.request.OwnerChangeRequest;
import org.apache.kylin.rest.request.ProjectAutoSemiUpdateRequest;
import org.apache.kylin.rest.request.ProjectExclusionRequest;
import org.apache.kylin.rest.request.ProjectGeneralInfoRequest;
import org.apache.kylin.rest.request.ProjectInternalTableConfigRequest;
import org.apache.kylin.rest.request.ProjectKerberosInfoRequest;
import org.apache.kylin.rest.request.PushDownConfigRequest;
import org.apache.kylin.rest.request.PushDownProjectConfigRequest;
import org.apache.kylin.rest.request.SCD2ConfigRequest;
import org.apache.kylin.rest.request.SegmentConfigRequest;
import org.apache.kylin.rest.request.ShardNumConfigRequest;
import org.apache.kylin.rest.request.SnapshotConfigRequest;
import org.apache.kylin.rest.response.FavoriteQueryThresholdResponse;
import org.apache.kylin.rest.response.ProjectConfigResponse;
import org.apache.kylin.rest.response.StorageVolumeInfoResponse;
import org.apache.kylin.rest.response.UserProjectPermissionResponse;
import org.apache.kylin.rest.security.AclManager;
import org.apache.kylin.rest.security.AclPermissionEnum;
import org.apache.kylin.rest.security.AclRecord;
import org.apache.kylin.rest.security.KerberosLoginManager;
import org.apache.kylin.rest.service.AccessService;
import org.apache.kylin.rest.service.AsyncTaskServiceSupporter;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.service.MetadataBackupService;
import org.apache.kylin.rest.service.ProjectModelSupporter;
import org.apache.kylin.rest.service.ProjectSmartServiceSupporter;
import org.apache.kylin.rest.service.UserService;
import org.apache.kylin.rest.service.task.QueryHistoryMetaUpdateScheduler;
import org.apache.kylin.rest.util.AclEvaluate;
import org.apache.kylin.sdk.datasource.framework.utils.JdbcUtils;
import org.apache.kylin.streaming.manager.StreamingJobManager;
import org.apache.kylin.tool.garbage.MetadataCleaner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.scheduling.support.CronExpression;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component(value="projectService")
public class ProjectService
extends BasicService {
    private static final Logger logger = LoggerFactory.getLogger(ProjectService.class);
    private static final String SNAPSHOT_AUTO_REFRESH_TIME_MODE = "snapshot_automatic_refresh_time_mode";
    private static final String SNAPSHOT_AUTO_REFRESH_TIME_MODE_DAY = "DAY";
    private static final String SNAPSHOT_AUTO_REFRESH_TIME_MODE_HOURS = "HOURS";
    private static final String SNAPSHOT_AUTO_REFRESH_TIME_MODE_MINUTE = "MINUTE";
    private static final String SNAPSHOT_AUTO_REFRESH_TIME_MODES = "DAY, HOURS, MINUTE";
    private static final String KYLIN_QUERY_PUSHDOWN_RUNNER_CLASS_NAME = "kylin.query.pushdown.runner-class-name";
    private static final String DEFAULT_VAL = "default";
    private static final Pattern INVALID_FILENAME_CHARS = Pattern.compile("[\\\\/:*?\"'<>|\\u0000-\\u001F\\s]|^[.]+$|[.]$");
    @Autowired
    UserService userService;
    @Autowired
    private AclEvaluate aclEvaluate;
    @Autowired
    private MetadataBackupService metadataBackupService;
    @Autowired(required=false)
    @Qualifier(value="asyncTaskService")
    private AsyncTaskServiceSupporter asyncTaskService;
    @Autowired
    private AccessService accessService;
    @Autowired(required=false)
    private ProjectModelSupporter projectModelSupporter;
    @Autowired(required=false)
    private ProjectSmartServiceSupporter projectSmartService;

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @Transaction(project=-1)
    public ProjectInstance createProject(String projectName, ProjectInstance newProject) {
        Message msg = MsgPicker.getMsg();
        String description = newProject.getDescription();
        LinkedHashMap overrideProps = newProject.getOverrideKylinProps();
        if (overrideProps == null) {
            overrideProps = Maps.newLinkedHashMap();
        }
        overrideProps.put("kylin.metadata.semi-automatic-mode", String.valueOf(this.getConfig().isSemiAutoMode()));
        overrideProps.put("kylin.query.metadata.expose-computed-column", "true");
        this.encryptJdbcPassInOverrideKylinProps(overrideProps);
        ProjectInstance currentProject = this.getManager(NProjectManager.class).getProject(projectName);
        if (currentProject != null) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.DUPLICATE_PROJECT_NAME, String.format(Locale.ROOT, msg.getProjectAlreadyExist(), projectName));
        }
        String owner = SecurityContextHolder.getContext().getAuthentication().getName();
        ProjectInstance createdProject = this.getManager(NProjectManager.class).createProject(projectName, owner, description, overrideProps);
        logger.debug("New project created.");
        return createdProject;
    }

    public List<ProjectInstance> getReadableProjects() {
        return this.getProjectsFilterByExactMatchAndPermission(null, false, AclPermissionEnum.READ);
    }

    public List<ProjectInstance> getAdminProjects() {
        return this.getProjectsFilterByExactMatchAndPermission(null, false, AclPermissionEnum.ADMINISTRATION);
    }

    public List<ProjectInstance> getReadableProjects(String projectName, boolean exactMatch) {
        return this.getProjectsFilterByExactMatchAndPermission(projectName, exactMatch, AclPermissionEnum.READ);
    }

    public List<String> getOwnedProjects() {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        return NProjectManager.getInstance((KylinConfig)config).listAllProjects().stream().map(ProjectInstance::getName).collect(Collectors.toList());
    }

    private Predicate<ProjectInstance> getRequestFilter(String projectName, boolean exactMatch, AclPermissionEnum permission) {
        Predicate<ProjectInstance> filter;
        switch (permission) {
            case READ: {
                filter = projectInstance -> this.aclEvaluate.hasProjectReadPermission((ProjectInstance)projectInstance);
                break;
            }
            case OPERATION: {
                filter = projectInstance -> this.aclEvaluate.hasProjectOperationPermission((ProjectInstance)projectInstance);
                break;
            }
            case MANAGEMENT: {
                filter = projectInstance -> this.aclEvaluate.hasProjectWritePermission((ProjectInstance)projectInstance);
                break;
            }
            case ADMINISTRATION: {
                filter = projectInstance -> this.aclEvaluate.hasProjectAdminPermission((ProjectInstance)projectInstance);
                break;
            }
            default: {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PERMISSION_DENIED, "Operation failed, unknown permission:" + permission);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)projectName)) {
            Predicate<ProjectInstance> exactMatchFilter = projectInstance -> exactMatch && projectInstance.getName().equals(projectName) || !exactMatch && projectInstance.getName().toUpperCase(Locale.ROOT).contains(projectName.toUpperCase(Locale.ROOT));
            filter = filter.and(exactMatchFilter);
        }
        return filter;
    }

    public List<ProjectInstance> getProjectsFilterByExactMatchAndPermission(String projectName, boolean exactMatch, AclPermissionEnum permission) {
        Predicate<ProjectInstance> filter = this.getRequestFilter(projectName, exactMatch, permission);
        return this.getProjectsWithFilter(filter);
    }

    public List<UserProjectPermissionResponse> getProjectsFilterByExactMatchAndPermissionWrapperUserPermission(String projectName, boolean exactMatch, AclPermissionEnum permission) throws IOException {
        Predicate<ProjectInstance> filter = this.getRequestFilter(projectName, exactMatch, permission);
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            return Collections.emptyList();
        }
        UserDetails user = null;
        AtomicBoolean isGlobalAdmin = new AtomicBoolean(false);
        try {
            user = this.userService.loadUserByUsername(authentication.getName());
        }
        catch (Exception e) {
            logger.warn("Cat not load user by username {}", (Object)authentication.getName(), (Object)e);
            return Collections.emptyList();
        }
        if (this.userService.isGlobalAdmin(user)) {
            isGlobalAdmin.set(true);
        }
        UserDetails finalUser = user;
        return this.getProjectsWithFilter(filter).parallelStream().map(projectInstance -> {
            this.clearJdbcPassInOverrideKylinProps(projectInstance.getOverrideKylinProps());
            String userPermission = isGlobalAdmin.get() ? AclPermissionEnum.ADMINISTRATION.name() : AclPermissionEnum.convertToAclPermission((String)((String)this.accessService.getUserNormalPermission(projectInstance.getName(), finalUser).getFirst()));
            return new UserProjectPermissionResponse((ProjectInstance)projectInstance, userPermission);
        }).collect(Collectors.toList());
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#project, 'ADMINISTRATION')")
    @Transaction(project=0)
    public void updateQueryAccelerateThresholdConfig(String project, Integer threshold, boolean tipsEnabled) {
        HashMap overrideKylinProps = Maps.newHashMap();
        if (threshold != null) {
            if (threshold <= 0) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, "No valid value for 'threshold'. Please set an integer 'x' greater than 0 to 'threshold'. The system will notify you whenever there are more then 'x' queries waiting to accelerate.");
            }
            overrideKylinProps.put("kylin.favorite.query-accelerate-threshold", String.valueOf(threshold));
        }
        overrideKylinProps.put("kylin.favorite.query-accelerate-tips-enable", String.valueOf(tipsEnabled));
        this.updateProjectOverrideKylinProps(project, overrideKylinProps);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#project, 'ADMINISTRATION')")
    public FavoriteQueryThresholdResponse getQueryAccelerateThresholdConfig(String project) {
        ProjectInstance projectInstance = this.getManager(NProjectManager.class).getProject(project);
        FavoriteQueryThresholdResponse thresholdResponse = new FavoriteQueryThresholdResponse();
        KylinConfigExt config = projectInstance.getConfig();
        thresholdResponse.setThreshold(config.getFavoriteQueryAccelerateThreshold());
        thresholdResponse.setTipsEnabled(config.getFavoriteQueryAccelerateTipsEnabled());
        return thresholdResponse;
    }

    public StorageVolumeInfoResponse getStorageVolumeInfoResponse(String project) {
        StorageVolumeInfoResponse response = new StorageVolumeInfoResponse();
        ProjectStorageInfoCollector collector = new ProjectStorageInfoCollector((List)Lists.newArrayList((Object[])new StorageInfoEnum[]{StorageInfoEnum.GARBAGE_STORAGE, StorageInfoEnum.STORAGE_QUOTA, StorageInfoEnum.TOTAL_STORAGE}));
        StorageVolumeInfo storageVolumeInfo = collector.getStorageVolumeInfo(this.getConfig(), project);
        response.setGarbageStorageSize(storageVolumeInfo.getGarbageStorageSize());
        response.setStorageQuotaSize(storageVolumeInfo.getStorageQuotaSize());
        response.setTotalStorageSize(storageVolumeInfo.getTotalStorageSize());
        return response;
    }

    public void garbageCleanup(String projectName, long remainingTime) {
        try (SetThreadName ignored = new SetThreadName("GarbageCleanupWorker", new Object[0]);){
            KylinConfig config = KylinConfig.getInstanceFromEnv();
            NProjectManager projectManager = NProjectManager.getInstance((KylinConfig)config);
            ProjectInstance project = projectManager.getProject(projectName);
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException("Thread is interrupted: " + Thread.currentThread().getName());
            }
            logger.info("Start to cleanup garbage for project<{}>", (Object)project.getName());
            try {
                this.updateStatMetaImmediately(project.getName(), remainingTime);
                boolean needAggressiveOpt = Arrays.stream(config.getProjectsAggressiveOptimizationIndex()).map(StringUtils::lowerCase).collect(Collectors.toList()).contains(StringUtils.toRootLowerCase((String)project.getName()));
                MetadataCleaner.clean((String)project.getName(), (boolean)needAggressiveOpt);
                EventBusFactory.getInstance().callService((Object)new ProjectCleanOldQueryResultEvent(project.getName()));
            }
            catch (Exception e) {
                logger.warn("clean project<" + project.getName() + "> failed", (Throwable)e);
            }
            logger.info("Garbage cleanup for project<{}> finished", (Object)project.getName());
        }
    }

    public void cleanRawRecForDeletedProject() {
        if (!KylinConfig.getInstanceFromEnv().isUTEnv()) {
            return;
        }
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        NProjectManager projectManager = NProjectManager.getInstance((KylinConfig)config);
        RawRecManager.getInstance((String)"_global").cleanForDeletedProject(projectManager.listAllProjects().stream().map(ProjectInstance::getName).collect(Collectors.toList()));
    }

    public void cleanupAcl() {
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            NProjectManager prjManager = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
            Set projects = prjManager.listAllProjects().stream().map(RootPersistentEntity::getUuid).collect(Collectors.toSet());
            AclManager aclManager = AclManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
            for (AclRecord acl : aclManager.listAll()) {
                String id = acl.getDomainObjectInfo().getId();
                if (!projects.contains(id)) {
                    aclManager.delete(id);
                    continue;
                }
                List aceList = acl.getEntries();
                aceList.forEach(ace -> {
                    if (this.accessService.isPrincipalSidNotExists(ace.getSid())) {
                        this.accessService.revokeProjectPermission(AccessService.getName(ace.getSid()), "user");
                    }
                    if (this.accessService.isGrantedAuthoritySidNotExists(ace.getSid())) {
                        this.accessService.revokeProjectPermission(AccessService.getName(ace.getSid()), "group");
                    }
                });
            }
            return 0;
        }, (String)"_global");
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#project, 'ADMINISTRATION')")
    public void cleanupGarbage(String project, boolean needAggressiveOpt) throws Exception {
        this.updateStatMetaImmediately(project);
        MetadataCleaner.clean((String)project, (boolean)needAggressiveOpt);
        this.asyncTaskService.cleanupStorage();
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#project, 'ADMINISTRATION')")
    @Transaction(project=0)
    public void updateStorageQuotaConfig(String project, long storageQuotaSize) {
        if (storageQuotaSize < 0x10000000000L) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, "No valid storage quota size, Please set an integer greater than or equal to 1TB to 'storage_quota_size', unit byte.");
        }
        HashMap overrideKylinProps = Maps.newHashMap();
        double storageQuotaSizeGB = 1.0 * (double)storageQuotaSize / 1.073741824E9;
        overrideKylinProps.put("kylin.storage.quota-in-giga-bytes", Double.toString(storageQuotaSizeGB));
        this.updateProjectOverrideKylinProps(project, overrideKylinProps);
    }

    private void updateProjectOverrideKylinProps(String project, Map<String, String> overrideKylinProps) {
        Integer maxConcurrentJobs;
        NProjectManager projectManager = this.getManager(NProjectManager.class);
        ProjectInstance projectInstance = projectManager.getProject(project);
        if (projectInstance == null) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.PROJECT_NOT_EXIST, new Object[]{project});
        }
        if (overrideKylinProps.containsKey("kylin.job.max-concurrent-jobs") && (Objects.isNull(maxConcurrentJobs = Ints.tryParse((String)overrideKylinProps.get("kylin.job.max-concurrent-jobs"))) || maxConcurrentJobs < 0)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, MsgPicker.getMsg().getIllegalNegative("kylin.job.max-concurrent-jobs"));
        }
        if (overrideKylinProps.containsKey("kylin.source.jdbc.connection-url")) {
            String url = overrideKylinProps.get("kylin.source.jdbc.connection-url");
            if (KylinConfig.getInstanceFromEnv().isSourceJdbcWhiteListEnabled() && !JdbcUtils.validateUrlByWhiteList((String)url)) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_JDBC_SOURCE_CONFIG, MsgPicker.getMsg().getJdbcConnectionInfoWrong());
            }
        }
        this.encryptJdbcPassInOverrideKylinProps(overrideKylinProps);
        projectManager.updateProject(project, copyForWrite -> copyForWrite.getOverrideKylinProps().putAll(KylinConfig.trimKVFromMap((Map)overrideKylinProps)));
    }

    private void encryptJdbcPassInOverrideKylinProps(Map<String, String> overrideKylinProps) {
        if (overrideKylinProps.containsKey("kylin.source.jdbc.pass")) {
            overrideKylinProps.computeIfPresent("kylin.source.jdbc.pass", (k, v) -> EncryptUtil.encryptWithPrefix((String)((String)overrideKylinProps.get("kylin.source.jdbc.pass"))));
        }
    }

    private void clearJdbcPassInOverrideKylinProps(Map<String, String> overrideKylinProps) {
        overrideKylinProps.computeIfPresent("kylin.source.jdbc.pass", (k, v) -> "*****");
    }

    @Transaction(project=0)
    public void updateJobNotificationConfig(String project, JobNotificationConfigRequest request) {
        this.aclEvaluate.checkProjectAdminPermission(project);
        HashMap overrideKylinProps = Maps.newHashMap();
        if (request.getJobStatesNotification() != null) {
            overrideKylinProps.put("kylin.job.notification-enable-states", String.join((CharSequence)",", Sets.newHashSet(request.getJobStatesNotification())));
            overrideKylinProps.put("kylin.job.notification-on-job-error", "false");
        } else {
            overrideKylinProps.put("kylin.job.notification-on-job-error", String.valueOf(request.getJobErrorNotificationEnabled()));
        }
        overrideKylinProps.put("kylin.job.notification-on-empty-data-load", String.valueOf(request.getDataLoadEmptyNotificationEnabled()));
        overrideKylinProps.put("kylin.job.notification-admin-emails", this.convertToString(request.getJobNotificationEmails()));
        this.updateProjectOverrideKylinProps(project, overrideKylinProps);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @Transaction(project=0)
    public void updateYarnQueue(String project, String queueName) {
        HashMap overrideKylinProps = Maps.newHashMap();
        overrideKylinProps.put(KylinConfig.getInstanceFromEnv().getQueueKey(), queueName);
        this.updateProjectOverrideKylinProps(project, overrideKylinProps);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @Transaction(project=0)
    public void updateJdbcInfo(String project, JdbcSourceInfoRequest jdbcSourceInfoRequest) {
        if (Boolean.TRUE.equals(jdbcSourceInfoRequest.getJdbcSourceEnable())) {
            this.validateJdbcConfig(project, jdbcSourceInfoRequest);
        }
        HashMap overrideKylinProps = Maps.newHashMap();
        if (jdbcSourceInfoRequest.getJdbcSourceDriver() != null) {
            overrideKylinProps.put("kylin.source.jdbc.driver", jdbcSourceInfoRequest.getJdbcSourceDriver());
        }
        if (jdbcSourceInfoRequest.getJdbcSourceEnable() != null) {
            overrideKylinProps.put("kylin.source.jdbc.source.enable", jdbcSourceInfoRequest.getJdbcSourceEnable().toString());
        }
        if (jdbcSourceInfoRequest.getJdbcSourceName() != null) {
            overrideKylinProps.put("kylin.source.jdbc.source.name", jdbcSourceInfoRequest.getJdbcSourceName());
        }
        if (jdbcSourceInfoRequest.getJdbcSourceConnectionUrl() != null) {
            overrideKylinProps.put("kylin.source.jdbc.connection-url", jdbcSourceInfoRequest.getJdbcSourceConnectionUrl());
        }
        if (jdbcSourceInfoRequest.getJdbcSourceUser() != null) {
            overrideKylinProps.put("kylin.source.jdbc.user", jdbcSourceInfoRequest.getJdbcSourceUser());
        }
        if (jdbcSourceInfoRequest.getJdbcSourcePass() != null) {
            overrideKylinProps.put("kylin.source.jdbc.pass", jdbcSourceInfoRequest.getJdbcSourcePass());
        }
        this.updateProjectOverrideKylinProps(project, overrideKylinProps);
    }

    private void validateJdbcConfig(String project, JdbcSourceInfoRequest jdbcSourceInfoRequest) {
        String password;
        String username;
        String url;
        ProjectInstance projectInstance = this.getManager(NProjectManager.class).getProject(project);
        KylinConfigExt config = projectInstance.getConfig();
        String driver = jdbcSourceInfoRequest.getJdbcSourceDriver();
        if (driver == null) {
            driver = config.getJdbcDriver();
        }
        if ((url = jdbcSourceInfoRequest.getJdbcSourceConnectionUrl()) == null) {
            url = config.getJdbcConnectionUrl();
        }
        if ((username = jdbcSourceInfoRequest.getJdbcSourceUser()) == null) {
            username = config.getJdbcUser();
        }
        if ((password = jdbcSourceInfoRequest.getJdbcSourcePass()) == null) {
            password = config.getJdbcPass();
        }
        Preconditions.checkNotNull((Object)driver, (Object)"driver can not be null");
        Preconditions.checkNotNull((Object)url, (Object)"url can not be null");
        Preconditions.checkNotNull((Object)username, (Object)"username can not be null");
        Preconditions.checkNotNull((Object)password, (Object)"password can not be null");
        if (!JdbcUtils.checkConnectionParameter((String)driver, (String)url, (String)username, (String)password)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_JDBC_SOURCE_CONFIG, MsgPicker.getMsg().getJdbcConnectionInfoWrong());
        }
    }

    private String convertToString(List<String> stringList) {
        if (CollectionUtils.isEmpty(stringList)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_EMAIL, "Please enter at least one email address.");
        }
        HashSet notEmails = Sets.newHashSet();
        for (String email : Sets.newHashSet(stringList)) {
            Pattern pattern = Pattern.compile("^[a-zA-Z0-9_.-]+@[a-zA-Z0-9-]+(\\.[a-zA-Z0-9-]+)*\\.[a-zA-Z0-9]{2,6}$");
            Matcher matcher = pattern.matcher(email);
            if (matcher.find()) continue;
            notEmails.add(email);
        }
        if (!notEmails.isEmpty()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, "No valid value " + notEmails + " for 'job_notification_email'. Please enter valid email address.");
        }
        return String.join((CharSequence)",", Sets.newHashSet(stringList));
    }

    public ProjectConfigResponse getProjectConfig0(String project) {
        Map<String, Object> favoriteRules;
        ProjectConfigResponse response = new ProjectConfigResponse();
        ProjectInstance projectInstance = this.getManager(NProjectManager.class).getProject(project);
        KylinConfigExt config = projectInstance.getConfig();
        response.setProject(project);
        response.setDescription(projectInstance.getDescription());
        response.setDefaultDatabase(projectInstance.getDefaultDatabase());
        response.setSemiAutomaticMode(config.isSemiAutoMode());
        response.setTableExclusionEnabled(config.isTableExclusionEnabled());
        response.setStorageQuotaSize(config.getStorageQuotaSize());
        response.setPushDownEnabled(config.isPushDownEnabled());
        response.setRunnerClassName(config.getPushDownRunnerClassName());
        response.setConverterClassNames(String.join((CharSequence)",", config.getPushDownConverterClassNames()));
        response.setAutoMergeEnabled(projectInstance.getSegmentConfig().getAutoMergeEnabled());
        response.setAutoMergeTimeRanges(projectInstance.getSegmentConfig().getAutoMergeTimeRanges());
        response.setVolatileRange(projectInstance.getSegmentConfig().getVolatileRange());
        response.setRetentionRange(projectInstance.getSegmentConfig().getRetentionRange());
        response.setCreateEmptySegmentEnabled(projectInstance.getSegmentConfig().getCreateEmptySegmentEnabled());
        response.setFavoriteQueryThreshold(config.getFavoriteQueryAccelerateThreshold());
        response.setFavoriteQueryTipsEnabled(config.getFavoriteQueryAccelerateTipsEnabled());
        response.setDataLoadEmptyNotificationEnabled(config.getJobDataLoadEmptyNotificationEnabled());
        response.setJobErrorNotificationEnabled(config.getJobErrorNotificationEnabled());
        ArrayList jobStatesNotification = config.getJobNotificationStates() == null ? Lists.newArrayList() : Arrays.stream(config.getJobNotificationStates()).map(StringUtils::lowerCase).collect(Collectors.toList());
        boolean jobErrorNotificationEnabled = config.getJobErrorNotificationEnabled();
        if (jobErrorNotificationEnabled && !jobStatesNotification.contains("error")) {
            jobStatesNotification.add("error");
        }
        response.setJobStatesNotification(jobStatesNotification);
        response.setJobNotificationEmails(Lists.newArrayList((Object[])config.getAdminDls()));
        response.setYarnQueue(config.getOptional(config.getQueueKey(), DEFAULT_VAL));
        response.setExposeComputedColumn(config.exposeComputedColumn());
        response.setKerberosProjectLevelEnabled(config.getKerberosProjectLevelEnable());
        response.setPrincipal(projectInstance.getPrincipal());
        if (this.projectSmartService != null && !(favoriteRules = this.projectSmartService.getFavoriteRules(project)).isEmpty()) {
            response.setFrequencyTimeWindow(Objects.toString(favoriteRules.get("frequency_time_window")));
            response.setLowFrequencyThreshold(Integer.parseInt(Objects.toString(favoriteRules.get("low_frequency_threshold"))));
            response.setFavoriteRules(favoriteRules);
            this.setAutoIndexPlanRule(response, this.projectSmartService.getAutoIndexPlanRule(project));
        }
        response.setScd2Enabled(config.isQueryNonEquiJoinModelEnabled());
        response.setSnapshotManualManagementEnabled(config.isSnapshotManualManagementEnabled());
        response.setSnapshotAutoRefreshEnabled(config.isSnapshotAutoRefreshEnabled());
        this.setSnapshotAutoRefreshParams(response, config.getSnapshotAutoRefreshCron());
        response.setMultiPartitionEnabled(config.isMultiPartitionEnabled());
        response.setQueryHistoryDownloadMaxSize(config.getQueryHistoryDownloadMaxSize());
        response.setQueryHistoryDownloadMaxSize(config.getQueryHistoryDownloadMaxSize());
        response.setJdbcSourceName(config.getJdbcSourceName());
        response.setJdbcSourceUser(config.getJdbcUser());
        response.setJdbcSourcePass("*****");
        response.setJdbcSourceConnectionUrl(config.getJdbcConnectionUrl());
        response.setJdbcSourceEnable(config.getJdbcEnable());
        response.setJdbcSourceDriver(config.getJdbcDriver());
        response.setOverrideKylinProps(projectInstance.getOverrideKylinProps());
        Pair infos = KylinVersion.getGitCommitInfo();
        response.setGitCommit((String)infos.getFirst());
        response.setPackageVersion(KylinVersion.getCurrentVersion().toString());
        response.setPackageTimestamp((String)infos.getSecond());
        return response;
    }

    private void setAutoIndexPlanRule(ProjectConfigResponse response, Map<String, Object> autoIndexRule) {
        response.setIndexPlannerEnable(Boolean.parseBoolean(Objects.toString(autoIndexRule.get("index_planner_enable"))));
        response.setIndexPlannerMaxIndexCount(Integer.parseInt(Objects.toString(autoIndexRule.get("index_planner_max_index_count"))));
        response.setIndexPlannerMaxChangeCount(Integer.parseInt(Objects.toString(autoIndexRule.get("index_planner_max_change_count"))));
        response.setIndexPlannerLevel(Objects.toString(autoIndexRule.get("index_planner_level")));
        response.setAutoIndexPlanAutoChangeIndexEnable(Boolean.parseBoolean(Objects.toString(autoIndexRule.get("auto_index_plan_auto_change_index_enable"))));
        response.setAutoIndexPlanAutoCompleteMode(Objects.toString(autoIndexRule.get("auto_index_plan_auto_complete_mode")));
        response.setAutoIndexPlanAbsoluteBeginDate(Objects.toString(autoIndexRule.get("auto_index_plan_absolute_begin_date"), null));
        response.setAutoIndexPlanRelativeTimeUnit(Objects.toString(autoIndexRule.get("auto_index_plan_relative_time_unit"), null));
        Object timeInterval = autoIndexRule.get("auto_index_plan_relative_time_interval");
        if (timeInterval != null) {
            response.setAutoIndexPlanRelativeTimeInterval(Integer.parseInt(Objects.toString(timeInterval)));
        }
        response.setAutoIndexPlanSegmentJobEnable(Boolean.parseBoolean(Objects.toString(autoIndexRule.get("auto_index_plan_segment_job_enable"))));
    }

    public void setSnapshotAutoRefreshParams(ProjectConfigResponse response, String cron) {
        if (!response.isSnapshotAutoRefreshEnabled()) {
            return;
        }
        String[] fields = org.springframework.util.StringUtils.tokenizeToStringArray((String)cron, (String)" ");
        if (fields.length != 6) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Cron expression must consist of 6 fields (found %d in \"%s\")", fields.length, cron));
        }
        if (StringUtils.contains((CharSequence)fields[1], (CharSequence)"*/")) {
            response.setSnapshotAutoRefreshTimeMode(SNAPSHOT_AUTO_REFRESH_TIME_MODE_MINUTE);
            response.setSnapshotAutoRefreshTimeInterval(StringUtils.substring((String)fields[1], (int)2));
            return;
        }
        if (StringUtils.contains((CharSequence)fields[2], (CharSequence)"*/")) {
            response.setSnapshotAutoRefreshTimeMode(SNAPSHOT_AUTO_REFRESH_TIME_MODE_HOURS);
            response.setSnapshotAutoRefreshTimeInterval(StringUtils.substring((String)fields[2], (int)2));
            return;
        }
        if (StringUtils.contains((CharSequence)fields[3], (CharSequence)"*/")) {
            response.setSnapshotAutoRefreshTimeMode(SNAPSHOT_AUTO_REFRESH_TIME_MODE_DAY);
            response.setSnapshotAutoRefreshTimeInterval(StringUtils.substring((String)fields[3], (int)2));
            response.setSnapshotAutoRefreshTriggerSecond(fields[0]);
            response.setSnapshotAutoRefreshTriggerMinute(fields[1]);
            response.setSnapshotAutoRefreshTriggerHours(fields[2]);
        }
    }

    public ProjectConfigResponse getProjectConfig(String project) {
        this.aclEvaluate.checkProjectReadPermission(project);
        return this.getProjectConfig0(project);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#project, 'ADMINISTRATION')")
    @Transaction(project=0)
    public void updateShardNumConfig(String project, ShardNumConfigRequest req) {
        this.getManager(NProjectManager.class).updateProject(project, copyForWrite -> {
            try {
                copyForWrite.putOverrideKylinProps("kylin.engine.shard-num-json", JsonUtil.writeValueAsString((Object)req.getColToNum()));
            }
            catch (JsonProcessingException e) {
                logger.error("Can not write obj to json.", (Throwable)e);
            }
        });
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#project, 'ADMINISTRATION')")
    public String getShardNumConfig(String project) {
        return this.getManager(NProjectManager.class).getProject(project).getConfig().getExtendedOverrides().getOrDefault("kylin.engine.shard-num-json", "");
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#project, 'ADMINISTRATION')")
    @Transaction(project=0)
    public void updatePushDownConfig(String project, PushDownConfigRequest pushDownConfigRequest) {
        this.getManager(NProjectManager.class).updateProject(project, copyForWrite -> {
            if (Boolean.TRUE.equals(pushDownConfigRequest.getPushDownEnabled())) {
                String runnerClassName = copyForWrite.getConfig().getPushDownRunnerClassName();
                if (StringUtils.isEmpty((CharSequence)runnerClassName)) {
                    String defaultPushDownRunner = this.getConfig().getPushDownRunnerClassNameWithDefaultValue();
                    copyForWrite.putOverrideKylinProps(KYLIN_QUERY_PUSHDOWN_RUNNER_CLASS_NAME, defaultPushDownRunner);
                }
                copyForWrite.putOverrideKylinProps("kylin.query.pushdown-enabled", "true");
            } else {
                copyForWrite.putOverrideKylinProps("kylin.query.pushdown-enabled", "false");
            }
        });
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#project, 'ADMINISTRATION')")
    @Transaction(project=0)
    public void updateSnapshotConfig(String project, SnapshotConfigRequest snapshotConfigRequest) {
        this.checkSnapshotAutoRefreshConfig(snapshotConfigRequest);
        NProjectManager projectManager = this.getManager(NProjectManager.class);
        projectManager.updateProject(project, copyForWrite -> {
            copyForWrite.putOverrideKylinProps("kylin.snapshot.manual-management-enabled", snapshotConfigRequest.getSnapshotManualManagementEnabled().toString());
            if (Boolean.TRUE.equals(snapshotConfigRequest.getSnapshotManualManagementEnabled())) {
                copyForWrite.putOverrideKylinProps("kylin.snapshot.auto-refresh-enabled", snapshotConfigRequest.getSnapshotAutoRefreshEnabled().toString());
                Optional.ofNullable(this.createSnapshotAutoRefreshCron(snapshotConfigRequest)).ifPresent(cron -> copyForWrite.putOverrideKylinProps("kylin.snapshot.auto-refresh-cron", cron));
            }
        });
    }

    public String createSnapshotAutoRefreshCron(SnapshotConfigRequest snapshotConfigRequest) {
        String cron;
        if (Boolean.FALSE.equals(snapshotConfigRequest.getSnapshotAutoRefreshEnabled())) {
            return null;
        }
        switch (snapshotConfigRequest.getSnapshotAutoRefreshTimeMode()) {
            case "DAY": {
                cron = String.format(Locale.ROOT, "%s %s %s */%s * ?", snapshotConfigRequest.getSnapshotAutoRefreshTriggerSecond(), snapshotConfigRequest.getSnapshotAutoRefreshTriggerMinute(), snapshotConfigRequest.getSnapshotAutoRefreshTriggerHours(), snapshotConfigRequest.getSnapshotAutoRefreshTimeInterval());
                break;
            }
            case "HOURS": {
                cron = String.format(Locale.ROOT, "0 0 */%s * * ?", snapshotConfigRequest.getSnapshotAutoRefreshTimeInterval());
                break;
            }
            case "MINUTE": {
                cron = String.format(Locale.ROOT, "0 */%s * * * ?", snapshotConfigRequest.getSnapshotAutoRefreshTimeInterval());
                break;
            }
            default: {
                throw new KylinException((ErrorCodeProducer)ErrorCodeServer.PARAMETER_INVALID_SUPPORT_LIST, new Object[]{SNAPSHOT_AUTO_REFRESH_TIME_MODE, SNAPSHOT_AUTO_REFRESH_TIME_MODES});
            }
        }
        if (!CronExpression.isValidExpression((String)cron)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.CONFIG_NOT_SUPPORT_EDIT, new Object[]{"kylin.snapshot.automatic_refresh_cron"});
        }
        return cron;
    }

    public void checkSnapshotAutoRefreshConfig(SnapshotConfigRequest snapshotConfigRequest) {
        if (Boolean.FALSE.equals(snapshotConfigRequest.getSnapshotManualManagementEnabled()) || Boolean.FALSE.equals(snapshotConfigRequest.getSnapshotAutoRefreshEnabled())) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)snapshotConfigRequest.getSnapshotAutoRefreshTimeMode())) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.PARAMETER_INVALID_SUPPORT_LIST, new Object[]{SNAPSHOT_AUTO_REFRESH_TIME_MODE, SNAPSHOT_AUTO_REFRESH_TIME_MODES});
        }
        String autoRefreshTimeInterval = "snapshot_automatic_refresh_time_interval";
        String autoRefreshTimeIntervalValue = snapshotConfigRequest.getSnapshotAutoRefreshTimeInterval();
        switch (snapshotConfigRequest.getSnapshotAutoRefreshTimeMode()) {
            case "DAY": {
                this.checkSnapshotAutoParam("snapshot_automatic_refresh_time_interval", autoRefreshTimeIntervalValue, 1, null, "> 1");
                this.checkSnapshotAutoTriggerTime(snapshotConfigRequest);
                break;
            }
            case "HOURS": {
                this.checkSnapshotAutoParam("snapshot_automatic_refresh_time_interval", autoRefreshTimeIntervalValue, 1, 23, "1 ~ 23");
                break;
            }
            case "MINUTE": {
                this.checkSnapshotAutoParam("snapshot_automatic_refresh_time_interval", autoRefreshTimeIntervalValue, 1, 59, "1 ~ 59");
                break;
            }
            default: {
                throw new KylinException((ErrorCodeProducer)ErrorCodeServer.PARAMETER_INVALID_SUPPORT_LIST, new Object[]{SNAPSHOT_AUTO_REFRESH_TIME_MODE, SNAPSHOT_AUTO_REFRESH_TIME_MODES});
            }
        }
    }

    public void checkSnapshotAutoParam(String name, String value, Integer minValue, Integer maxValue, String message) {
        if (StringUtils.isBlank((CharSequence)value) || !StringUtils.isNumeric((CharSequence)value) || Integer.parseInt(value) < minValue) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.PARAMETER_INVALID_SUPPORT_LIST, new Object[]{name, message});
        }
        if (null != maxValue && Integer.parseInt(value) > maxValue) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.PARAMETER_INVALID_SUPPORT_LIST, new Object[]{name, message});
        }
    }

    public void checkSnapshotAutoTriggerTime(SnapshotConfigRequest snapshotConfigRequest) {
        this.checkSnapshotAutoParam("snapshot_automatic_refresh_trigger_hours", snapshotConfigRequest.getSnapshotAutoRefreshTriggerHours(), 0, 23, "0 ~ 23");
        this.checkSnapshotAutoParam("snapshot_automatic_refresh_trigger_minute", snapshotConfigRequest.getSnapshotAutoRefreshTriggerMinute(), 0, 59, "0 ~ 59");
        this.checkSnapshotAutoParam("snapshot_automatic_refresh_trigger_second", snapshotConfigRequest.getSnapshotAutoRefreshTriggerSecond(), 0, 59, "0 ~ 59");
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#project, 'ADMINISTRATION')")
    @Transaction(project=0)
    public void updateSCD2Config(String project, SCD2ConfigRequest scd2ConfigRequest, ProjectModelSupporter modelService) {
        this.getManager(NProjectManager.class).updateProject(project, copyForWrite -> copyForWrite.putOverrideKylinProps("kylin.query.non-equi-join-model-enabled", scd2ConfigRequest.getScd2Enabled().toString()));
        if (Boolean.TRUE.equals(scd2ConfigRequest.getScd2Enabled())) {
            modelService.onUpdateSCD2ModelStatus(project, RealizationStatusEnum.ONLINE);
        } else {
            modelService.onUpdateSCD2ModelStatus(project, RealizationStatusEnum.OFFLINE);
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#project, 'ADMINISTRATION')")
    @Transaction(project=0)
    public void updateMultiPartitionConfig(String project, MultiPartitionConfigRequest request, ProjectModelSupporter modelService) {
        this.getManager(NProjectManager.class).updateProject(project, copyForWrite -> {
            if (Boolean.TRUE.equals(request.getMultiPartitionEnabled())) {
                copyForWrite.getOverrideKylinProps().put("kylin.model.multi-partition-enabled", "true");
            } else {
                copyForWrite.getOverrideKylinProps().put("kylin.model.multi-partition-enabled", "false");
                modelService.onOfflineMultiPartitionModels(project);
            }
        });
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#project, 'ADMINISTRATION')")
    @Transaction(project=0)
    public void updatePushDownProjectConfig(String project, PushDownProjectConfigRequest pushDownProjectConfigRequest) {
        this.getManager(NProjectManager.class).updateProject(project, copyForWrite -> {
            copyForWrite.putOverrideKylinProps(KYLIN_QUERY_PUSHDOWN_RUNNER_CLASS_NAME, pushDownProjectConfigRequest.getRunnerClassName());
            copyForWrite.putOverrideKylinProps("kylin.query.pushdown.converter-class-names", pushDownProjectConfigRequest.getConverterClassNames());
        });
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#project, 'ADMINISTRATION')")
    @Transaction(project=0)
    public void updateComputedColumnConfig(String project, ComputedColumnConfigRequest computedColumnConfigRequest) {
        this.getManager(NProjectManager.class).updateProject(project, copyForWrite -> copyForWrite.putOverrideKylinProps("kylin.query.metadata.expose-computed-column", String.valueOf(computedColumnConfigRequest.getExposeComputedColumn())));
    }

    @Transaction(project=0)
    public void updateSegmentConfig(String project, SegmentConfigRequest segmentConfigRequest) {
        this.aclEvaluate.checkProjectAdminPermission(project);
        segmentConfigRequest.getVolatileRange().setVolatileRangeEnabled(true);
        if (segmentConfigRequest.getVolatileRange().getVolatileRangeNumber() < 0L) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, "No valid value. Please set an integer 'x' to 'volatile_range_number'. The 'Auto-Merge' will not merge latest 'x' period(day/week/month/etc..) segments.");
        }
        if (segmentConfigRequest.getRetentionRange().getRetentionRangeNumber() < 0L) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, "No valid value for 'retention_range_number'. Please set an integer 'x' to specify the retention threshold. The system will only retain the segments in the retention threshold (x years before the last data time). ");
        }
        if (segmentConfigRequest.getAutoMergeTimeRanges().isEmpty()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, "No valid value for 'auto_merge_time_ranges'. Please set {'DAY', 'WEEK', 'MONTH', 'QUARTER', 'YEAR'} to specify the period of auto-merge. ");
        }
        if (null == segmentConfigRequest.getRetentionRange().getRetentionRangeType()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, "No valid value for 'retention_range_type', Please set {'DAY', 'MONTH', 'YEAR'} to specify the period of retention. ");
        }
        this.getManager(NProjectManager.class).updateProject(project, copyForWrite -> {
            copyForWrite.getSegmentConfig().setAutoMergeEnabled(segmentConfigRequest.getAutoMergeEnabled());
            copyForWrite.getSegmentConfig().setAutoMergeTimeRanges(segmentConfigRequest.getAutoMergeTimeRanges());
            copyForWrite.getSegmentConfig().setVolatileRange(segmentConfigRequest.getVolatileRange());
            copyForWrite.getSegmentConfig().setRetentionRange(segmentConfigRequest.getRetentionRange());
            copyForWrite.getSegmentConfig().setCreateEmptySegmentEnabled(segmentConfigRequest.getCreateEmptySegmentEnabled());
        });
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#project, 'ADMINISTRATION')")
    @Transaction(project=0)
    public void updateProjectGeneralInfo(String project, ProjectGeneralInfoRequest projectGeneralInfoRequest) {
        this.getManager(NProjectManager.class).updateProject(project, copyForWrite -> {
            copyForWrite.setDescription(projectGeneralInfoRequest.getDescription());
            if (projectGeneralInfoRequest.getIsSemiAutoMode() != null) {
                copyForWrite.putOverrideKylinProps("kylin.metadata.semi-automatic-mode", String.valueOf(projectGeneralInfoRequest.getIsSemiAutoMode()));
            }
        });
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#project, 'ADMINISTRATION')")
    @Transaction(project=0)
    public void updateAutoSemiConfig(String project, ProjectAutoSemiUpdateRequest projectAutoSemiUpdateRequest) {
        this.getManager(NProjectManager.class).updateProject(project, copyForWrite -> copyForWrite.putOverrideKylinProps("kylin.metadata.semi-automatic-mode", String.valueOf(projectAutoSemiUpdateRequest.isSemiAutoMode())));
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#project, 'ADMINISTRATION')")
    @Transaction(project=0)
    public void updateProjectKerberosInfo(String project, ProjectKerberosInfoRequest projectKerberosInfoRequest) throws Exception {
        KerberosLoginManager.getInstance().checkAndReplaceProjectKerberosInfo(project, projectKerberosInfoRequest.getPrincipal());
        this.getManager(NProjectManager.class).updateProject(project, copyForWrite -> {
            copyForWrite.setPrincipal(projectKerberosInfoRequest.getPrincipal());
            copyForWrite.setKeytab(projectKerberosInfoRequest.getKeytab());
        });
        this.backupAndDeleteKeytab(projectKerberosInfoRequest.getPrincipal());
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @Transaction(project=0)
    public void dropProject(String project) {
        this.dropProject(project, null);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @Transaction(project=0)
    public void dropProject(String project, HttpHeaders headers) {
        ExecutableManager executableManager = ExecutableManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
        List jobIds = executableManager.getExecutablePOsByStatus((List)Lists.newArrayList((Object[])new ExecutableState[]{ExecutableState.RUNNING, ExecutableState.PENDING, ExecutableState.READY, ExecutableState.PAUSED})).stream().filter(executablePO -> !executablePO.getJobType().getCategory().equals("CRON")).map(RootPersistentEntity::getId).collect(Collectors.toList());
        List<JobStatusEnum> streamingJobStatusList = Arrays.asList(JobStatusEnum.STARTING, JobStatusEnum.RUNNING, JobStatusEnum.STOPPING);
        List streamingJobList = this.getManager(StreamingJobManager.class, project).listAllStreamingJobMeta().stream().filter(meta -> streamingJobStatusList.contains(meta.getCurrentStatus())).map(RootPersistentEntity::getUuid).collect(Collectors.toList());
        if (!jobIds.isEmpty() || !streamingJobList.isEmpty()) {
            logger.warn("The following jobs are in running or pending status and should be killed before dropping the project {} : {}", (Object)project, jobIds);
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PROJECT_DROP_FAILED, String.format(Locale.ROOT, MsgPicker.getMsg().getProjectDropFailedJobsNotKilled(), project));
        }
        NProjectManager prjManager = this.getManager(NProjectManager.class);
        prjManager.forceDropProject(project);
        UnitOfWork.get().doAfterUpdate(() -> this.deleteProjectRelatedMeta(project));
        UnitOfWork.get().doAfterUnit(() -> new ProjectDropListener().onDelete(project, this.clusterManager, headers));
        EventBusFactory.getInstance().postAsync((SchedulerEventNotifier)new SourceUsageUpdateNotifier());
    }

    private void deleteProjectRelatedMeta(String project) {
        QueryHistoryIdOffsetManager.getInstance((String)project).delete();
        FavoriteRuleManager.getInstance((String)project).deleteByProject();
        ModelFavoriteRuleManager.getInstance((String)project).deleteByProject();
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#project, 'ADMINISTRATION')")
    @Transaction(project=0)
    public void updateDefaultDatabase(String project, String defaultDatabase) {
        Preconditions.checkNotNull((Object)project);
        Preconditions.checkNotNull((Object)defaultDatabase);
        String uppderDB = defaultDatabase.toUpperCase(Locale.ROOT);
        NProjectManager prjManager = this.getManager(NProjectManager.class);
        NTableMetadataManager tableManager = this.getManager(NTableMetadataManager.class, project);
        if ("DEFAULT".equals(uppderDB) || tableManager.dbToTablesMap(this.getConfig().isStreamingEnabled()).containsKey(uppderDB)) {
            ProjectInstance projectInstance = prjManager.getProject(project);
            if (uppderDB.equals(projectInstance.getDefaultDatabase())) {
                return;
            }
        } else {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.DATABASE_NOT_EXIST, String.format(Locale.ROOT, MsgPicker.getMsg().getDatabaseNotExist(), defaultDatabase));
        }
        prjManager.updateProject(project, copyForWrite -> copyForWrite.setDefaultDatabase(uppderDB));
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#project, 'ADMINISTRATION')")
    public String backupProject(String project) throws Exception {
        return this.metadataBackupService.backupProject(project);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#project, 'ADMINISTRATION')")
    public void clearManagerCache(String project) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        config.clearManagersByProject(project);
        config.clearManagersByClz(NProjectManager.class);
    }

    @Transaction(project=0)
    public void setDataSourceType(String project, String sourceType) {
        this.getManager(NProjectManager.class).updateProject(project, copyForWrite -> copyForWrite.putOverrideKylinProps(NonCustomProjectLevelConfig.DATASOURCE_TYPE.getValue(), sourceType));
    }

    public String getDataSourceType(String project) {
        return (String)this.getManager(NProjectManager.class).getProject(project).getOverrideKylinProps().get(NonCustomProjectLevelConfig.DATASOURCE_TYPE.getValue());
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#project, 'ADMINISTRATION')")
    @Transaction(project=0)
    public void updateGarbageCleanupConfig(String project, GarbageCleanUpConfigRequest garbageCleanUpConfigRequest) {
        if (garbageCleanUpConfigRequest.getLowFrequencyThreshold() < 0L) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, "No valid value for 'low_frequency_threshold'. Please set an integer 'x' greater than or equal to 0 to specify the low usage storage calculation time. When index usage is lower than 'x' times, it would be regarded as low usage storage.");
        }
        HashMap overrideKylinProps = Maps.newHashMap();
        overrideKylinProps.put("kylin.cube.low-frequency-threshold", String.valueOf(garbageCleanUpConfigRequest.getLowFrequencyThreshold()));
        overrideKylinProps.put("kylin.cube.frequency-time-window", String.valueOf(garbageCleanUpConfigRequest.getFrequencyTimeWindow()));
        this.updateProjectOverrideKylinProps(project, overrideKylinProps);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#project, 'ADMINISTRATION')")
    @Transaction(project=0)
    public ProjectConfigResponse resetProjectConfig(String project, String resetItem) {
        Preconditions.checkNotNull((Object)resetItem);
        switch (resetItem) {
            case "job_notification_config": {
                this.resetJobNotificationConfig(project);
                break;
            }
            case "query_accelerate_threshold": {
                this.resetQueryAccelerateThreshold(project);
                break;
            }
            case "garbage_cleanup_config": {
                this.resetGarbageCleanupConfig(project);
                break;
            }
            case "segment_config": {
                this.resetSegmentConfig(project);
                break;
            }
            case "kerberos_project_level_config": {
                this.resetProjectKerberosConfig(project);
                break;
            }
            case "storage_quota_config": {
                this.resetProjectStorageQuotaConfig(project);
                break;
            }
            case "favorite_rule_config": {
                this.resetProjectRecommendationConfig(project);
                break;
            }
            case "table_exclusion_config": {
                this.resetTableExclusionConfig(project);
                break;
            }
            case "auto_index_plan_rule": {
                this.resetAutoIndexPlanConfig(project);
                break;
            }
            default: {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, "No valid value for 'reset_item'. Please enter a project setting type which needs to be reset {'job_notification_config'\uff0c'query_accelerate_threshold'\uff0c'garbage_cleanup_config'\uff0c'segment_config', 'storage_quota_config'} to 'reset_item'.");
            }
        }
        return this.getProjectConfig(project);
    }

    @Transaction(project=0)
    public void updateProjectOwner(String project, OwnerChangeRequest ownerChangeRequest) {
        try {
            this.aclEvaluate.checkIsGlobalAdmin();
            this.checkTargetOwnerPermission(project, ownerChangeRequest.getOwner());
        }
        catch (AccessDeniedException e) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PERMISSION_DENIED, MsgPicker.getMsg().getProjectChangePermission());
        }
        catch (IOException e) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PERMISSION_DENIED, MsgPicker.getMsg().getOwnerChangeError());
        }
        this.getManager(NProjectManager.class).updateProject(project, copyForWrite -> copyForWrite.setOwner(ownerChangeRequest.getOwner()));
    }

    private void checkTargetOwnerPermission(String project, String owner) throws IOException {
        Set<String> projectAdminUsers = this.accessService.getProjectAdminUsers(project);
        projectAdminUsers.remove(this.getManager(NProjectManager.class).getProject(project).getOwner());
        if (CollectionUtils.isEmpty(projectAdminUsers) || !projectAdminUsers.contains(owner)) {
            Message msg = MsgPicker.getMsg();
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PERMISSION_DENIED, msg.getProjectOwnerChangeInvalidUser());
        }
    }

    private void resetJobNotificationConfig(String project) {
        HashSet toBeRemovedProps = Sets.newHashSet();
        toBeRemovedProps.add("kylin.job.notification-on-empty-data-load");
        toBeRemovedProps.add("kylin.job.notification-on-job-error");
        toBeRemovedProps.add("kylin.job.notification-enable-states");
        toBeRemovedProps.add("kylin.job.notification-admin-emails");
        this.removeProjectOverrideProps(project, toBeRemovedProps);
    }

    private void resetQueryAccelerateThreshold(String project) {
        HashSet toBeRemovedProps = Sets.newHashSet();
        toBeRemovedProps.add("kylin.favorite.query-accelerate-threshold");
        toBeRemovedProps.add("kylin.favorite.query-accelerate-tips-enable");
        this.removeProjectOverrideProps(project, toBeRemovedProps);
    }

    private void resetProjectRecommendationConfig(String project) {
        FavoriteRuleManager.getInstance((String)project).resetRecommendRule();
        NDataModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project).listAllModels().forEach(model -> this.projectModelSupporter.onModelUpdate(project, model.getUuid()));
    }

    private void resetGarbageCleanupConfig(String project) {
        HashSet toBeRemovedProps = Sets.newHashSet();
        toBeRemovedProps.add("kylin.cube.low-frequency-threshold");
        toBeRemovedProps.add("kylin.cube.frequency-time-window");
        this.removeProjectOverrideProps(project, toBeRemovedProps);
    }

    private void resetTableExclusionConfig(String project) {
        HashSet toBeRemovedProps = Sets.newHashSet();
        toBeRemovedProps.add("kylin.metadata.table-exclusion-enabled");
        this.removeProjectOverrideProps(project, toBeRemovedProps);
    }

    private void resetAutoIndexPlanConfig(String project) {
        FavoriteRuleManager.getInstance((String)project).resetAutoIndexPlanRule();
        NDataModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project).listAllModels().forEach(model -> this.projectModelSupporter.onModelUpdate(project, model.getUuid()));
    }

    private void resetSegmentConfig(String project) {
        this.getManager(NProjectManager.class).updateProject(project, copyForWrite -> {
            ProjectInstance projectInstance = new ProjectInstance();
            copyForWrite.getSegmentConfig().setAutoMergeEnabled(projectInstance.getSegmentConfig().getAutoMergeEnabled());
            copyForWrite.getSegmentConfig().setAutoMergeTimeRanges(projectInstance.getSegmentConfig().getAutoMergeTimeRanges());
            copyForWrite.getSegmentConfig().setVolatileRange(projectInstance.getSegmentConfig().getVolatileRange());
            copyForWrite.getSegmentConfig().setRetentionRange(projectInstance.getSegmentConfig().getRetentionRange());
        });
    }

    private void removeProjectOverrideProps(String project, Set<String> toBeRemovedProps) {
        NProjectManager projectManager = this.getManager(NProjectManager.class);
        ProjectInstance projectInstance = projectManager.getProject(project);
        if (projectInstance == null) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.PROJECT_NOT_EXIST, new Object[]{project});
        }
        projectManager.updateProject(project, copyForWrite -> toBeRemovedProps.forEach(copyForWrite.getOverrideKylinProps()::remove));
    }

    private void resetProjectKerberosConfig(String project) {
        NProjectManager projectManager = this.getManager(NProjectManager.class);
        ProjectInstance projectInstance = projectManager.getProject(project);
        if (projectInstance == null) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.PROJECT_NOT_EXIST, new Object[]{project});
        }
        this.getManager(NProjectManager.class).updateProject(project, copyForWrite -> {
            copyForWrite.setKeytab(null);
            copyForWrite.setPrincipal(null);
        });
    }

    private void resetProjectStorageQuotaConfig(String project) {
        HashSet toBeRemovedProps = Sets.newHashSet();
        toBeRemovedProps.add("kylin.storage.quota-in-giga-bytes");
        this.removeProjectOverrideProps(project, toBeRemovedProps);
    }

    private List<ProjectInstance> getProjectsWithFilter(Predicate<ProjectInstance> filter) {
        List allProjects = this.getManager(NProjectManager.class).listAllProjects();
        return allProjects.stream().filter(filter).collect(Collectors.toList());
    }

    public File backupAndDeleteKeytab(String principal) throws IOException {
        String kylinConfHome = KapConfig.getKylinConfDirAtBestEffort();
        File kTempFile = new File(kylinConfHome, principal + "_tmp.keytab");
        File kFile = new File(kylinConfHome, principal + ".keytab");
        if (kTempFile.exists()) {
            FileUtils.copyFile((File)kTempFile, (File)kFile);
            FileUtils.forceDelete((File)kTempFile);
        }
        return kFile;
    }

    public static void checkPrincipal(String principal, Message msg) {
        if (null == principal || principal.isEmpty()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_PARAMETER, msg.getPrincipalEmpty());
        }
        if (principal.length() > 255 - "_tmp.keytab".length()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_KERBEROS_FILE, msg.getKerberosInfoError());
        }
        if (INVALID_FILENAME_CHARS.matcher(principal).find()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_KERBEROS_FILE, msg.getKerberosInfoError());
        }
    }

    public File generateTempKeytab(String principal, MultipartFile keytabFile) throws IOException {
        Message msg = MsgPicker.getMsg();
        ProjectService.checkPrincipal(principal, msg);
        String originalFilename = keytabFile.getOriginalFilename();
        if (originalFilename == null || !originalFilename.endsWith(".keytab")) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FILE_TYPE_MISMATCH, msg.getKeytabFileTypeMismatch());
        }
        String kylinConfHome = KapConfig.getKylinConfDirAtBestEffort();
        File kFile = new File(kylinConfHome, principal + "_tmp.keytab");
        FileUtils.copyInputStreamToFile((InputStream)keytabFile.getInputStream(), (File)kFile);
        return kFile;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#project, 'ADMINISTRATION')")
    @Transaction(project=0)
    public void updateProjectConfig(String project, Map<String, String> overrides) {
        if (MapUtils.isEmpty(overrides)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_PARAMETER, "config map is required");
        }
        this.updateProjectOverrideKylinProps(project, overrides);
    }

    @Transaction(project=0)
    public void deleteProjectConfig(String project, String configName) {
        this.aclEvaluate.checkProjectAdminPermission(project);
        NProjectManager projectManager = this.getManager(NProjectManager.class);
        projectManager.updateProject(project, copyForWrite -> {
            String cfr_ignored_0 = (String)copyForWrite.getOverrideKylinProps().remove(configName);
        });
    }

    @Transaction(project=0)
    public void updateJdbcConfig(String project, JdbcRequest jdbcRequest) {
        LinkedHashMap overrideKylinProps = Maps.newLinkedHashMap();
        overrideKylinProps.put("kylin.source.jdbc.connection-url", jdbcRequest.getUrl());
        overrideKylinProps.put("kylin.source.jdbc.driver", jdbcRequest.getDriver());
        overrideKylinProps.put("kylin.source.jdbc.user", jdbcRequest.getUser());
        overrideKylinProps.put("kylin.source.jdbc.pass", jdbcRequest.getPass());
        overrideKylinProps.put("kylin.source.jdbc.dialect", jdbcRequest.getDialect());
        overrideKylinProps.put("kylin.source.jdbc.adaptor", jdbcRequest.getAdaptor());
        if (!Strings.isNullOrEmpty((String)jdbcRequest.getPushdownClass())) {
            overrideKylinProps.put(KYLIN_QUERY_PUSHDOWN_RUNNER_CLASS_NAME, jdbcRequest.getPushdownClass());
            overrideKylinProps.put("kylin.query.pushdown.partition-check.runner-class-name", jdbcRequest.getPushdownClass());
        }
        if (!Strings.isNullOrEmpty((String)jdbcRequest.getSourceConnector())) {
            overrideKylinProps.put("kylin.source.jdbc.connector-class-name", jdbcRequest.getSourceConnector());
        }
        overrideKylinProps.put("kylin.source.default", String.valueOf(8));
        this.updateProjectOverrideKylinProps(project, overrideKylinProps);
    }

    public void updateStatMetaImmediately(String project) {
        QueryHistoryMetaUpdateScheduler scheduler;
        QueryHistoryMetaUpdateScheduler queryHistoryMetaUpdateScheduler = scheduler = QueryHistoryMetaUpdateScheduler.getInstance();
        queryHistoryMetaUpdateScheduler.getClass();
        Future future = scheduler.scheduleImmediately(new QueryHistoryMetaUpdateScheduler.QueryHistoryMetaUpdateRunner(queryHistoryMetaUpdateScheduler, project));
        try {
            future.get();
        }
        catch (InterruptedException e) {
            logger.error("updateStatMeta failed with interruption", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            logger.error("updateStatMeta failed", (Throwable)e);
        }
    }

    public void updateStatMetaImmediately(String project, long remainingTime) {
        QueryHistoryMetaUpdateScheduler scheduler = QueryHistoryMetaUpdateScheduler.getInstance();
        if (scheduler.hasStarted()) {
            QueryHistoryMetaUpdateScheduler queryHistoryMetaUpdateScheduler = scheduler;
            queryHistoryMetaUpdateScheduler.getClass();
            Future future = scheduler.scheduleImmediately(new QueryHistoryMetaUpdateScheduler.QueryHistoryMetaUpdateRunner(queryHistoryMetaUpdateScheduler, project));
            this.waitFuture(future, remainingTime, "updateStatMeta");
        }
    }

    public void waitFuture(Future<?> future, long remainingTime, String msg) {
        try {
            if (remainingTime == 0L) {
                future.get();
            } else {
                future.get(remainingTime, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException e) {
            logger.error("{} failed with interruption", (Object)msg, (Object)e);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException | TimeoutException e) {
            logger.error("{} failed with exception", (Object)msg, (Object)e);
            future.cancel(true);
        }
        catch (Exception e) {
            logger.error("{} failed", (Object)msg, (Object)e);
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#project, 'ADMINISTRATION')")
    @Transaction(project=0)
    public void updateTableExclusionRule(String project, ProjectExclusionRequest request) {
        this.getManager(NProjectManager.class).updateProject(project, copyForWrite -> {
            boolean exclusionEnabled = request.isTableExclusionEnabled();
            copyForWrite.putOverrideKylinProps("kylin.metadata.table-exclusion-enabled", String.valueOf(exclusionEnabled));
        });
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#project, 'ADMINISTRATION')")
    @Transaction(project=0)
    public void updateInternalTableConfig(String project, ProjectInternalTableConfigRequest request) {
        this.getManager(NProjectManager.class).updateProject(project, copyForWrite -> {
            boolean internalTableEnabled = request.isInternalTableEnabled();
            copyForWrite.putOverrideKylinProps("kylin.internal-table-enabled", String.valueOf(internalTableEnabled));
        });
    }
}

