/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.security;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.kylin.rest.util.SecurityLoggerUtils;
import org.springframework.core.annotation.Order;
import org.springframework.session.web.http.SaveSessionException;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
@Order(value=-2147483647)
public class LoginLogFilter
extends OncePerRequestFilter {
    private ThreadLocal<LoginInfo> loginInfoThreadLocal = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        try {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return;
        }
        catch (SaveSessionException e) {
            LoginInfo loginInfo = this.getLoginInfoThreadLocal().get();
            if (null == loginInfo) {
                loginInfo = new LoginInfo();
                loginInfo.setUserName("anonymous");
                this.getLoginInfoThreadLocal().set(loginInfo);
            }
            loginInfo.setLoginSuccess(Boolean.FALSE);
            loginInfo.setException((Exception)((Object)e));
            throw e;
        }
        finally {
            LoginInfo loginInfo = this.getLoginInfoThreadLocal().get();
            if (null != loginInfo) {
                try {
                    if (loginInfo.getLoginSuccess().booleanValue()) {
                        SecurityLoggerUtils.recordLoginSuccess((String)loginInfo.getUserName());
                    } else {
                        SecurityLoggerUtils.recordLoginFailed((String)loginInfo.getUserName(), (Exception)loginInfo.getException());
                    }
                }
                catch (Exception e) {
                    this.logger.error((Object)"Failed to log the login status!", (Throwable)e);
                }
                finally {
                    this.getLoginInfoThreadLocal().remove();
                }
            }
        }
    }

    @Generated
    public ThreadLocal<LoginInfo> getLoginInfoThreadLocal() {
        return this.loginInfoThreadLocal;
    }

    public static class LoginInfo {
        private String userName;
        private Boolean loginSuccess;
        private Exception exception;

        @Generated
        public String getUserName() {
            return this.userName;
        }

        @Generated
        public Boolean getLoginSuccess() {
            return this.loginSuccess;
        }

        @Generated
        public Exception getException() {
            return this.exception;
        }

        @Generated
        public void setUserName(String userName) {
            this.userName = userName;
        }

        @Generated
        public void setLoginSuccess(Boolean loginSuccess) {
            this.loginSuccess = loginSuccess;
        }

        @Generated
        public void setException(Exception exception) {
            this.exception = exception;
        }

        @Generated
        public LoginInfo(String userName, Boolean loginSuccess, Exception exception) {
            this.userName = userName;
            this.loginSuccess = loginSuccess;
            this.exception = exception;
        }

        @Generated
        public LoginInfo() {
        }
    }
}

