/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.security;

import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.cache.CacheBuilder;
import org.apache.kylin.guava30.shaded.common.cache.CacheLoader;
import org.apache.kylin.guava30.shaded.common.cache.LoadingCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.crypto.bcrypt.BCrypt;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

public class CachedBCryptPasswordEncoder
extends BCryptPasswordEncoder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CachedBCryptPasswordEncoder.class);
    private final Pattern BCRYPT_PATTERN = Pattern.compile("\\A\\$2a?\\$\\d\\d\\$[./0-9A-Za-z]{53}");
    private final LoadingCache<Pair<String, String>, String> cached = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(15L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Pair<String, String>, String>(){

        public String load(Pair<String, String> key) {
            String plaintext = (String)key.getFirst();
            String hashed = (String)key.getSecond();
            return BCrypt.hashpw((String)plaintext, (String)hashed);
        }
    });

    static boolean equalsNoEarlyReturn(String a, String b) {
        char[] cab;
        char[] caa = a.toCharArray();
        if (caa.length != (cab = b.toCharArray()).length) {
            return false;
        }
        int ret = 0;
        for (int i = 0; i < caa.length; ++i) {
            ret = (byte)(ret | caa[i] ^ cab[i]);
        }
        return ret == 0;
    }

    public boolean matches(CharSequence rawPassword, String encodedPassword) {
        if (rawPassword == null) {
            throw new IllegalArgumentException("rawPassword cannot be null");
        }
        if (encodedPassword == null || encodedPassword.length() == 0) {
            log.warn("Empty encoded password");
            return false;
        }
        if (!this.BCRYPT_PATTERN.matcher(encodedPassword).matches()) {
            log.warn("Encoded password does not look like BCrypt");
            return false;
        }
        return CachedBCryptPasswordEncoder.equalsNoEarlyReturn(encodedPassword, (String)this.cached.get((Object)Pair.newPair((Object)rawPassword.toString(), (Object)encodedPassword)));
    }
}

