/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.config.initialize;

import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.rest.source.DataSourceState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.stereotype.Component;

@Component
public class DataSourceAppInitializer
implements InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataSourceAppInitializer.class);
    @Autowired
    TaskScheduler taskScheduler;

    public void afterPropertiesSet() throws Exception {
        boolean needDataSourceInitializer;
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        boolean bl = needDataSourceInitializer = (kylinConfig.isJobNode() || kylinConfig.isMetadataNode() || kylinConfig.isSmartNode()) && kylinConfig.getLoadHiveTablenameEnabled();
        if (needDataSourceInitializer) {
            this.taskScheduler.scheduleWithFixedDelay((Runnable)DataSourceState.getInstance(), kylinConfig.getLoadHiveTablenameIntervals() * 1000L);
        }
    }
}

