/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import org.apache.kudu.client.Bytes;
import org.apache.kudu.client.NonRecoverableException;
import org.apache.kudu.client.Status;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class NonCoveredRangeException
extends NonRecoverableException {
    private final byte[] nonCoveredRangeStart;
    private final byte[] nonCoveredRangeEnd;

    public NonCoveredRangeException(byte[] nonCoveredRangeStart, byte[] nonCoveredRangeEnd) {
        super(Status.NotFound(NonCoveredRangeException.getMessage(nonCoveredRangeStart, nonCoveredRangeEnd)));
        this.nonCoveredRangeStart = nonCoveredRangeStart;
        this.nonCoveredRangeEnd = nonCoveredRangeEnd;
    }

    private static String getMessage(byte[] rangeStart, byte[] rangeEnd) {
        return String.format("accessed range partition ([%s, %s)) does not exist in table", rangeStart.length == 0 ? "<start>" : Bytes.hex(rangeStart), rangeEnd.length == 0 ? "<end>" : Bytes.hex(rangeEnd));
    }

    @Override
    public String getMessage() {
        return NonCoveredRangeException.getMessage(this.nonCoveredRangeStart, this.nonCoveredRangeEnd);
    }

    byte[] getNonCoveredRangeStart() {
        return this.nonCoveredRangeStart;
    }

    byte[] getNonCoveredRangeEnd() {
        return this.nonCoveredRangeEnd;
    }
}

