/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.Schema;
import org.apache.kudu.Type;
import org.apache.kudu.client.Bytes;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.client.PartitionSchema;
import org.apache.kudu.shaded.com.google.common.primitives.Ints;
import org.apache.kudu.shaded.com.google.common.primitives.UnsignedLongs;
import org.apache.kudu.shaded.com.sangupta.murmur.Murmur2;
import org.apache.kudu.util.ByteVec;
import org.apache.kudu.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class KeyEncoder {
    private static final BigInteger MIN_VALUE_128 = BigInteger.valueOf(-2L).pow(127);

    private KeyEncoder() {
    }

    public static byte[] encodePrimaryKey(PartialRow row) {
        ByteVec buf = ByteVec.create();
        Schema schema = row.getSchema();
        for (int columnIdx = 0; columnIdx < schema.getPrimaryKeyColumnCount(); ++columnIdx) {
            boolean isLast = columnIdx + 1 == schema.getPrimaryKeyColumnCount();
            KeyEncoder.encodeColumn(row, columnIdx, isLast, buf);
        }
        return buf.toArray();
    }

    public static int getHashBucket(PartialRow row, PartitionSchema.HashBucketSchema hashSchema) {
        ByteVec buf = ByteVec.create();
        KeyEncoder.encodeColumns(row, hashSchema.getColumnIds(), buf);
        long hash = Murmur2.hash64(buf.data(), buf.len(), hashSchema.getSeed());
        return (int)UnsignedLongs.remainder(hash, hashSchema.getNumBuckets());
    }

    public static byte[] encodePartitionKey(PartialRow row, PartitionSchema partitionSchema) {
        ByteVec buf = ByteVec.create();
        if (!partitionSchema.getHashBucketSchemas().isEmpty()) {
            for (PartitionSchema.HashBucketSchema hashSchema : partitionSchema.getHashBucketSchemas()) {
                KeyEncoder.encodeHashBucket(KeyEncoder.getHashBucket(row, hashSchema), buf);
            }
        }
        KeyEncoder.encodeColumns(row, partitionSchema.getRangeSchema().getColumns(), buf);
        return buf.toArray();
    }

    public static byte[] encodeRangePartitionKey(PartialRow row, PartitionSchema.RangeSchema rangeSchema) {
        ByteVec buf = ByteVec.create();
        KeyEncoder.encodeColumns(row, rangeSchema.getColumns(), buf);
        return buf.toArray();
    }

    private static void encodeColumns(PartialRow row, List<Integer> columnIds, ByteVec buf) {
        for (int i = 0; i < columnIds.size(); ++i) {
            boolean isLast = i + 1 == columnIds.size();
            KeyEncoder.encodeColumn(row, row.getSchema().getColumnIndex(columnIds.get(i)), isLast, buf);
        }
    }

    private static void encodeColumn(PartialRow row, int columnIdx, boolean isLast, ByteVec buf) {
        Schema schema = row.getSchema();
        ColumnSchema column = schema.getColumnByIndex(columnIdx);
        if (!row.isSet(columnIdx)) {
            throw new IllegalStateException(String.format("Primary key column %s is not set", column.getName()));
        }
        Type type = column.getType();
        if (type == Type.STRING || type == Type.BINARY) {
            KeyEncoder.encodeBinary(row.getVarLengthData().get(columnIdx), isLast, buf);
        } else {
            KeyEncoder.encodeSignedInt(row.getRowAlloc(), schema.getColumnOffset(columnIdx), column.getTypeSize(), buf);
        }
    }

    private static void encodeBinary(ByteBuffer value, boolean isLast, ByteVec buf) {
        value.reset();
        while (value.hasRemaining()) {
            byte currentByte = value.get();
            buf.push(currentByte);
            if (isLast || currentByte != 0) continue;
            buf.push((byte)1);
        }
        if (!isLast) {
            buf.push((byte)0);
            buf.push((byte)0);
        }
    }

    private static void encodeSignedInt(byte[] value, int offset, int len, ByteVec buf) {
        byte lastByte = value[offset + (len - 1)];
        lastByte = Bytes.xorLeftMostBit(lastByte);
        buf.push(lastByte);
        for (int i = len - 2; i >= 0; --i) {
            buf.push(value[offset + i]);
        }
    }

    public static void encodeHashBucket(int bucket, ByteVec buf) {
        buf.append(Ints.toByteArray(bucket));
    }

    public static PartialRow decodePrimaryKey(Schema schema, byte[] key) {
        PartialRow row = schema.newPartialRow();
        ByteBuffer buf = ByteBuffer.wrap(key);
        buf.order(ByteOrder.BIG_ENDIAN);
        for (int idx = 0; idx < schema.getPrimaryKeyColumnCount(); ++idx) {
            KeyEncoder.decodeColumn(buf, row, idx, idx + 1 == schema.getPrimaryKeyColumnCount());
        }
        if (buf.hasRemaining()) {
            throw new IllegalArgumentException("Unable to decode all primary key bytes");
        }
        return row;
    }

    public static Pair<List<Integer>, PartialRow> decodePartitionKey(Schema schema, PartitionSchema partitionSchema, byte[] key) {
        ByteBuffer buf = ByteBuffer.wrap(key);
        buf.order(ByteOrder.BIG_ENDIAN);
        ArrayList<Integer> buckets = new ArrayList<Integer>();
        for (PartitionSchema.HashBucketSchema hashSchema : partitionSchema.getHashBucketSchemas()) {
            if (buf.hasRemaining()) {
                buckets.add(buf.getInt());
                continue;
            }
            buckets.add(0);
        }
        return new Pair<List<Integer>, PartialRow>(buckets, KeyEncoder.decodeRangePartitionKey(schema, partitionSchema, buf));
    }

    public static PartialRow decodeRangePartitionKey(Schema schema, PartitionSchema partitionSchema, byte[] key) {
        ByteBuffer buf = ByteBuffer.wrap(key);
        buf.order(ByteOrder.BIG_ENDIAN);
        return KeyEncoder.decodeRangePartitionKey(schema, partitionSchema, buf);
    }

    private static PartialRow decodeRangePartitionKey(Schema schema, PartitionSchema partitionSchema, ByteBuffer buf) {
        PartialRow row = schema.newPartialRow();
        Iterator<Integer> rangeIds = partitionSchema.getRangeSchema().getColumns().iterator();
        while (rangeIds.hasNext()) {
            int idx = schema.getColumnIndex(rangeIds.next());
            if (buf.hasRemaining()) {
                KeyEncoder.decodeColumn(buf, row, idx, !rangeIds.hasNext());
                continue;
            }
            row.setMin(idx);
        }
        if (buf.hasRemaining()) {
            throw new IllegalArgumentException("Unable to decode all partition key bytes");
        }
        return row;
    }

    private static void decodeColumn(ByteBuffer buf, PartialRow row, int idx, boolean isLast) {
        Schema schema = row.getSchema();
        ColumnSchema column = schema.getColumnByIndex(idx);
        block0 : switch (column.getType()) {
            case INT8: {
                row.addByte(idx, (byte)(buf.get() ^ 0xFFFFFF80));
                break;
            }
            case INT16: {
                row.addShort(idx, (short)(buf.getShort() ^ Short.MIN_VALUE));
                break;
            }
            case INT32: {
                row.addInt(idx, buf.getInt() ^ Integer.MIN_VALUE);
                break;
            }
            case INT64: 
            case UNIXTIME_MICROS: {
                row.addLong(idx, buf.getLong() ^ Long.MIN_VALUE);
                break;
            }
            case BINARY: {
                byte[] binary = KeyEncoder.decodeBinaryColumn(buf, isLast);
                row.addBinary(idx, binary);
                break;
            }
            case STRING: {
                byte[] binary = KeyEncoder.decodeBinaryColumn(buf, isLast);
                row.addStringUtf8(idx, binary);
                break;
            }
            case DECIMAL: {
                int scale = column.getTypeAttributes().getScale();
                int size = column.getTypeSize();
                switch (size) {
                    case 4: {
                        int intVal = buf.getInt() ^ Integer.MIN_VALUE;
                        row.addDecimal(idx, BigDecimal.valueOf(intVal, scale));
                        break block0;
                    }
                    case 8: {
                        long longVal = buf.getLong() ^ Long.MIN_VALUE;
                        row.addDecimal(idx, BigDecimal.valueOf(longVal, scale));
                        break block0;
                    }
                    case 16: {
                        byte[] bytes = new byte[size];
                        buf.get(bytes);
                        BigInteger bigIntVal = new BigInteger(bytes).xor(MIN_VALUE_128);
                        row.addDecimal(idx, new BigDecimal(bigIntVal, scale));
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Unsupported decimal type size: " + size);
            }
            default: {
                throw new IllegalArgumentException(String.format("The column type %s is not a valid key component type", new Object[]{schema.getColumnByIndex(idx).getType()}));
            }
        }
    }

    private static byte[] decodeBinaryColumn(ByteBuffer key, boolean isLast) {
        if (isLast) {
            byte[] bytes = Arrays.copyOfRange(key.array(), key.arrayOffset() + key.position(), key.arrayOffset() + key.limit());
            key.position(key.limit());
            return bytes;
        }
        ByteVec buf = ByteVec.withCapacity(key.remaining());
        block4: for (int i = key.position(); i < key.limit(); ++i) {
            if (key.get(i) != 0) continue;
            switch (key.get(i + 1)) {
                case 0: {
                    buf.append(key.array(), key.arrayOffset() + key.position(), i - key.position());
                    key.position(i + 2);
                    return buf.toArray();
                }
                case 1: {
                    buf.append(key.array(), key.arrayOffset() + key.position(), i + 1 - key.position());
                    key.position(++i + 1);
                    continue block4;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected binary sequence");
                }
            }
        }
        buf.append(key.array(), key.arrayOffset() + key.position(), key.remaining());
        key.position(key.limit());
        return buf.toArray();
    }

    public static String formatPartitionKeyRange(Schema schema, PartitionSchema partitionSchema, byte[] lowerBound, byte[] upperBound) {
        if (partitionSchema.getRangeSchema().getColumns().isEmpty() && partitionSchema.getHashBucketSchemas().isEmpty()) {
            assert (lowerBound.length == 0 && upperBound.length == 0);
            return "<no-partitioning>";
        }
        Pair<List<Integer>, PartialRow> lower = KeyEncoder.decodePartitionKey(schema, partitionSchema, lowerBound);
        Pair<List<Integer>, PartialRow> upper = KeyEncoder.decodePartitionKey(schema, partitionSchema, upperBound);
        StringBuilder sb = new StringBuilder();
        List<Integer> hashBuckets = lower.getFirst();
        if (!hashBuckets.isEmpty()) {
            sb.append("hash-partition-buckets: ");
            sb.append(hashBuckets);
        }
        if (partitionSchema.getRangeSchema().getColumns().size() > 0) {
            if (!hashBuckets.isEmpty()) {
                sb.append(", ");
            }
            ArrayList<Integer> idxs = new ArrayList<Integer>();
            for (int id : partitionSchema.getRangeSchema().getColumns()) {
                idxs.add(schema.getColumnIndex(id));
            }
            sb.append("range-partition: [");
            if (lowerBound.length > 4 * hashBuckets.size()) {
                sb.append('(');
                lower.getSecond().appendDebugString(idxs, sb);
                sb.append(')');
            } else {
                sb.append("<start>");
            }
            sb.append(", ");
            if (upperBound.length > 4 * hashBuckets.size()) {
                sb.append('(');
                upper.getSecond().appendDebugString(idxs, sb);
                sb.append(')');
            } else {
                sb.append("<end>");
            }
            sb.append(')');
        }
        return sb.toString();
    }
}

